/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef rsa_oaep_2048_sha256_mgf1sha1_vectors_h__
#define rsa_oaep_2048_sha256_mgf1sha1_vectors_h__

#include "testvectors_base/test-structs.h"

static const std::vector<uint8_t> priv_key_1{
    0x30, 0x82, 0x04, 0xbd, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x04, 0x82,
    0x04, 0xa7, 0x30, 0x82, 0x04, 0xa3, 0x02, 0x01, 0x00, 0x02, 0x82, 0x01,
    0x01, 0x00, 0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45,
    0x56, 0x71, 0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe,
    0xf7, 0x17, 0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9,
    0x74, 0x6d, 0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6,
    0xef, 0x5a, 0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89,
    0xd6, 0xea, 0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb,
    0x92, 0x51, 0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20,
    0xf7, 0x9c, 0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48,
    0xc9, 0x8e, 0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff,
    0x8f, 0x17, 0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce,
    0x26, 0xf4, 0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22,
    0xda, 0x61, 0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66,
    0xf5, 0xc0, 0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe,
    0x82, 0xde, 0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34,
    0x95, 0xd4, 0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a,
    0xfc, 0x3e, 0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97,
    0x5a, 0x19, 0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d,
    0x9c, 0xae, 0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00,
    0x5d, 0x9b, 0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12,
    0x56, 0x9a, 0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7,
    0x73, 0x06, 0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82,
    0x02, 0x83, 0xf7, 0x42, 0xb9, 0xd5, 0x02, 0x03, 0x01, 0x00, 0x01, 0x02,
    0x82, 0x01, 0x00, 0x76, 0x27, 0xee, 0xf3, 0x56, 0x7b, 0x2a, 0x27, 0x26,
    0x8e, 0x52, 0x05, 0x3e, 0xcd, 0x31, 0xc3, 0xa7, 0x17, 0x2c, 0xcb, 0x9d,
    0xdc, 0xee, 0x81, 0x9b, 0x30, 0x6a, 0x5b, 0x3c, 0x66, 0xb7, 0x57, 0x3c,
    0xa4, 0xfa, 0x88, 0xef, 0xc6, 0xf3, 0xc4, 0xa0, 0x0b, 0xfa, 0x0a, 0xe7,
    0x13, 0x9f, 0x64, 0x54, 0x3a, 0x4d, 0xac, 0x3d, 0x05, 0x82, 0x3f, 0x6f,
    0xf4, 0x77, 0xcf, 0xce, 0xc8, 0x4f, 0xe2, 0xac, 0x7a, 0x68, 0xb1, 0x72,
    0x04, 0xb3, 0x90, 0x23, 0x2e, 0x11, 0x03, 0x10, 0xc4, 0xe8, 0x99, 0xc4,
    0xe7, 0xc1, 0x09, 0x67, 0xdb, 0x4a, 0xcd, 0xe0, 0x42, 0xdb, 0xbf, 0x19,
    0xdb, 0xe0, 0x0b, 0x4b, 0x47, 0x41, 0xde, 0x10, 0x20, 0xaa, 0xaa, 0xff,
    0xb5, 0x05, 0x4c, 0x79, 0x7c, 0x9f, 0x13, 0x6f, 0x7d, 0x93, 0xac, 0x3f,
    0xc8, 0xca, 0xff, 0x66, 0x54, 0x24, 0x2d, 0x78, 0x21, 0xeb, 0xee, 0x51,
    0x7b, 0xf5, 0x37, 0xf4, 0x43, 0x66, 0xa0, 0xfd, 0xd4, 0x5a, 0xe0, 0x5b,
    0x99, 0x09, 0xc2, 0xe6, 0xcc, 0x1e, 0xd9, 0x28, 0x1e, 0xff, 0x43, 0x99,
    0xf7, 0x6c, 0x96, 0xb9, 0x62, 0x33, 0xec, 0x29, 0xae, 0x0b, 0xbf, 0x0d,
    0x75, 0x2b, 0x23, 0x4f, 0xc1, 0x97, 0x38, 0x9f, 0x51, 0x05, 0x0a, 0xa1,
    0xac, 0xd0, 0x1c, 0x07, 0x4c, 0x3a, 0xc8, 0xfb, 0xdb, 0x9e, 0xa8, 0xb6,
    0x51, 0xa9, 0x59, 0x95, 0xe8, 0xdb, 0x4a, 0xd5, 0xc4, 0x3b, 0x6c, 0x86,
    0x73, 0xe5, 0xa1, 0x26, 0xe7, 0xee, 0x94, 0xb8, 0xdf, 0xf4, 0xc5, 0xaf,
    0xc0, 0x12, 0x59, 0xbc, 0x8d, 0xa7, 0x69, 0x50, 0xba, 0xe6, 0xf8, 0xba,
    0xe7, 0x15, 0xf5, 0x09, 0x85, 0xb0, 0xd6, 0xf6, 0x6d, 0x04, 0xc6, 0xfe,
    0xf3, 0xb7, 0x00, 0x72, 0x0e, 0xec, 0xdc, 0xdf, 0x17, 0x1b, 0xb7, 0xb1,
    0xec, 0xbe, 0x72, 0x89, 0xc4, 0x67, 0xc1, 0x02, 0x81, 0x81, 0x00, 0xdc,
    0x43, 0x10, 0x50, 0xf7, 0x82, 0xe8, 0x94, 0xfb, 0x52, 0x48, 0x24, 0x7d,
    0x98, 0xcb, 0x7d, 0x58, 0xb8, 0xd1, 0xe2, 0x4f, 0x3b, 0x55, 0xd0, 0x41,
    0xc5, 0x6e, 0x4d, 0xe0, 0x86, 0xb0, 0xd5, 0xbb, 0x02, 0x8b, 0xda, 0x42,
    0xee, 0xb5, 0xd2, 0x34, 0xd5, 0x68, 0x1e, 0x58, 0x09, 0xd4, 0x15, 0xe6,
    0xa2, 0x89, 0xad, 0x4c, 0xfb, 0xf7, 0x8f, 0x97, 0x8f, 0x6c, 0x35, 0x81,
    0x4f, 0x50, 0xee, 0xbf, 0xf1, 0xc5, 0xb8, 0x0a, 0x69, 0xf7, 0x88, 0xe8,
    0x1e, 0x6b, 0xab, 0x5d, 0xda, 0xa7, 0x83, 0x69, 0xd6, 0x59, 0xd1, 0x43,
    0xec, 0x6f, 0x17, 0xe7, 0x98, 0x13, 0xa5, 0x75, 0xcf, 0xad, 0x9c, 0x56,
    0x91, 0x56, 0xb9, 0x01, 0x13, 0xe2, 0xe9, 0x11, 0x0a, 0xd9, 0xe7, 0xb4,
    0x8a, 0x1c, 0x93, 0x48, 0xa6, 0xe6, 0x53, 0x32, 0x11, 0x91, 0x29, 0x0e,
    0xa3, 0x6c, 0xfb, 0x3a, 0x5b, 0x18, 0xf1, 0x02, 0x81, 0x81, 0x00, 0xbd,
    0x1a, 0x81, 0xe7, 0x97, 0x7f, 0x98, 0x98, 0x12, 0x22, 0x73, 0xae, 0x32,
    0x22, 0xb5, 0x98, 0xea, 0x5f, 0xb1, 0x9e, 0xb4, 0xea, 0xbc, 0x38, 0x30,
    0x8a, 0x5e, 0x32, 0x19, 0x66, 0x03, 0xb2, 0xe5, 0x00, 0xff, 0xb7, 0x9f,
    0x5b, 0x88, 0x68, 0x16, 0x61, 0x1d, 0xeb, 0xc4, 0x72, 0xfa, 0xc4, 0x55,
    0x44, 0x07, 0x0b, 0xeb, 0x05, 0x7c, 0x94, 0x13, 0x78, 0xa6, 0x86, 0x8a,
    0xf3, 0xb7, 0xa0, 0x3d, 0x3f, 0x98, 0x80, 0xec, 0x47, 0xd5, 0xe0, 0x89,
    0xb9, 0x4f, 0xbd, 0xe5, 0x42, 0xab, 0xa9, 0xae, 0x8d, 0x72, 0xc5, 0x70,
    0x88, 0xd7, 0xab, 0xf5, 0xb1, 0x31, 0xf3, 0x90, 0x98, 0xf7, 0xbc, 0x16,
    0x0f, 0x90, 0x53, 0x6a, 0xbc, 0x94, 0x92, 0xfd, 0x4e, 0x06, 0xf3, 0xed,
    0x72, 0x99, 0xd4, 0xb9, 0x7b, 0xb0, 0x36, 0x77, 0x20, 0x7d, 0x95, 0x66,
    0x9f, 0x14, 0x0c, 0xfb, 0xc2, 0x0f, 0x25, 0x02, 0x81, 0x81, 0x00, 0xa9,
    0x4b, 0x52, 0x8b, 0x28, 0xf2, 0x91, 0x59, 0x91, 0x21, 0xd9, 0x19, 0x52,
    0xff, 0xd1, 0xc7, 0xf2, 0x1d, 0x7c, 0x14, 0x79, 0xd9, 0x9d, 0x47, 0x88,
    0x85, 0xfb, 0x16, 0x18, 0x70, 0xee, 0x12, 0x18, 0xbf, 0x08, 0x47, 0x26,
    0x12, 0xdb, 0xe5, 0x49, 0x7e, 0x8d, 0x9c, 0x65, 0x06, 0x88, 0xe0, 0x9c,
    0x78, 0x69, 0x61, 0xae, 0x3e, 0x2c, 0x35, 0x4d, 0xc4, 0x8a, 0xe3, 0x45,
    0x14, 0x75, 0x9c, 0x4c, 0x23, 0xc4, 0x58, 0x84, 0x88, 0x96, 0x1d, 0xc0,
    0x6b, 0x41, 0x4e, 0x61, 0xc0, 0xe1, 0xe7, 0xfb, 0xbd, 0x29, 0x23, 0xd3,
    0x15, 0x32, 0xfe, 0x28, 0x9f, 0x96, 0xda, 0x22, 0x07, 0x11, 0xe5, 0x8c,
    0x14, 0x01, 0x98, 0x08, 0xe0, 0x04, 0x14, 0x27, 0x69, 0x33, 0xbb, 0x07,
    0xe4, 0xef, 0xb9, 0xb4, 0xa9, 0xb3, 0x76, 0x56, 0x91, 0x72, 0x05, 0x20,
    0x9f, 0x33, 0xf0, 0x95, 0x15, 0xd7, 0xc1, 0x02, 0x81, 0x80, 0x3a, 0xf0,
    0xe7, 0x2a, 0x93, 0x3a, 0xef, 0x09, 0xff, 0x25, 0x03, 0xdf, 0x78, 0xba,
    0xfe, 0xd5, 0x31, 0xc0, 0x2f, 0xf1, 0xa2, 0xbc, 0x43, 0x7c, 0x54, 0x0c,
    0xdc, 0xbd, 0x4a, 0xd3, 0x54, 0x35, 0xcf, 0x51, 0x17, 0x63, 0x59, 0x65,
    0x43, 0x48, 0x06, 0x29, 0xb1, 0x14, 0xca, 0x7f, 0x78, 0x0f, 0xf7, 0xef,
    0xa3, 0x2e, 0xa0, 0xcb, 0x6e, 0x00, 0x0d, 0x6d, 0x9e, 0xa1, 0xf2, 0xef,
    0x71, 0xfd, 0x9c, 0xf9, 0x94, 0x84, 0x22, 0xa1, 0x65, 0x55, 0x7e, 0x37,
    0xe7, 0x55, 0xed, 0xfe, 0x70, 0xd9, 0x0b, 0x92, 0x05, 0x02, 0xeb, 0x47,
    0x8b, 0xc9, 0x8a, 0x63, 0xf7, 0x88, 0xce, 0x3a, 0x0f, 0x85, 0x6d, 0x6e,
    0xde, 0x72, 0x51, 0xa3, 0x83, 0xbf, 0xa8, 0xfa, 0x48, 0x0a, 0x81, 0xa9,
    0x25, 0xaf, 0x7b, 0x3c, 0xc5, 0x38, 0xc4, 0xba, 0xb8, 0xc9, 0xf7, 0x59,
    0x7f, 0xfb, 0x68, 0x01, 0x1d, 0x8d, 0x02, 0x81, 0x80, 0x26, 0x40, 0xfb,
    0xfb, 0xcf, 0xef, 0xb1, 0x63, 0xee, 0x7a, 0x87, 0xb6, 0x48, 0x3a, 0x66,
    0xee, 0x41, 0xf9, 0x56, 0xd9, 0x0f, 0xa8, 0xa7, 0x93, 0x9b, 0xfc, 0x04,
    0x2e, 0xe0, 0x92, 0x4b, 0x1b, 0x79, 0x93, 0xd0, 0x44, 0x5f, 0x75, 0x8d,
    0x51, 0x93, 0x3e, 0x85, 0x17, 0x9c, 0x03, 0x20, 0xb0, 0xc9, 0x68, 0xb4,
    0x8a, 0x91, 0xc3, 0x8b, 0x5b, 0xe9, 0x23, 0xe1, 0x09, 0x7c, 0x0c, 0x56,
    0x2f, 0x88, 0xd4, 0x22, 0x94, 0xb6, 0xa2, 0x75, 0x9b, 0xaf, 0xa5, 0x42,
    0x8a, 0x74, 0xf1, 0x27, 0x08, 0x74, 0xe4, 0x5f, 0x6f, 0xcc, 0x60, 0xf2,
    0x16, 0x02, 0xde, 0x5e, 0xcc, 0xd1, 0x43, 0xcf, 0x31, 0x24, 0x1f, 0x59,
    0x21, 0xb5, 0xad, 0x39, 0x83, 0xfb, 0x54, 0xef, 0x17, 0xbe, 0x3b, 0x28,
    0x53, 0x67, 0xe5, 0x0c, 0x99, 0x9c, 0x67, 0x24, 0x7b, 0x55, 0x2f, 0xe4,
    0xbf, 0xce, 0x94, 0x5f, 0x7b};

const RsaOaepTestVector kRsaOaep2048Sha256Mgf1Sha1WycheproofVectors[] = {

    // Comment:
    // tcID: 1
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     1,
     {},
     {0x8e, 0x6f, 0x12, 0x7b, 0x86, 0xed, 0x4c, 0xe0, 0x3b, 0xea, 0x02, 0x42,
      0x75, 0x9d, 0xec, 0x56, 0x2f, 0x3c, 0x0e, 0x47, 0x5d, 0x70, 0xc9, 0x50,
      0xbb, 0x98, 0x65, 0xc5, 0xa0, 0x0c, 0x19, 0x18, 0x64, 0x87, 0xf6, 0xda,
      0xd2, 0x5e, 0x6e, 0xd4, 0x60, 0x05, 0x10, 0xe0, 0x67, 0xa8, 0x67, 0x9c,
      0xdd, 0x63, 0xf7, 0x71, 0x8a, 0xf9, 0x2e, 0x5c, 0xc2, 0x97, 0xd7, 0x4d,
      0x5c, 0xe7, 0x24, 0x72, 0xc4, 0x04, 0x08, 0x3b, 0x15, 0x69, 0x24, 0xc3,
      0x98, 0x52, 0xb0, 0x3f, 0xad, 0x90, 0xbe, 0xcc, 0x3d, 0xa0, 0xcb, 0xb1,
      0xe8, 0x05, 0x56, 0xb4, 0x01, 0x0e, 0x95, 0x69, 0xc6, 0x1e, 0x3b, 0x18,
      0x8b, 0x9d, 0xbb, 0xf5, 0x8f, 0x77, 0x9d, 0x3b, 0xe5, 0xa9, 0xa7, 0xd0,
      0x00, 0xab, 0x59, 0x6d, 0x69, 0xc9, 0xaa, 0x48, 0xfa, 0x6c, 0x1f, 0x1f,
      0xbc, 0x5b, 0xe7, 0x9e, 0xc3, 0x9e, 0x27, 0xb7, 0xa7, 0x61, 0x91, 0xb6,
      0x81, 0xa0, 0x2d, 0x61, 0xcb, 0xc5, 0x92, 0x46, 0x51, 0x19, 0x8b, 0xdf,
      0x9b, 0xb7, 0x74, 0x9a, 0xb4, 0xa5, 0x15, 0xd1, 0xea, 0x1d, 0x9d, 0x32,
      0xda, 0xd3, 0x8d, 0xc7, 0x03, 0x22, 0x89, 0x85, 0x98, 0x50, 0x43, 0xc1,
      0x52, 0xe2, 0xd8, 0xe9, 0x18, 0xb6, 0x52, 0xd6, 0x7a, 0x40, 0xc2, 0xbe,
      0x1e, 0x2c, 0x6c, 0xc2, 0xfc, 0xe1, 0x1f, 0x6c, 0x92, 0x37, 0x14, 0xb1,
      0x17, 0x32, 0xd8, 0xfd, 0xb1, 0x61, 0x3c, 0x46, 0xbf, 0xce, 0xca, 0xfd,
      0x64, 0xf9, 0x53, 0x6f, 0xb7, 0xb4, 0x18, 0x16, 0x73, 0x6e, 0x3e, 0x4b,
      0x62, 0xa1, 0xdd, 0x6e, 0x4c, 0x26, 0xe8, 0xa8, 0xf6, 0x6d, 0x99, 0xcc,
      0xed, 0x30, 0x81, 0x27, 0xa3, 0x9e, 0xa1, 0xf2, 0x1a, 0x6d, 0x78, 0x86,
      0xe2, 0x2a, 0xab, 0xf3, 0xca, 0x6d, 0x64, 0x64, 0x27, 0x8d, 0x93, 0x0b,
      0xf6, 0x0f, 0x27, 0x7f},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 2
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     2,
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     {0x7a, 0x89, 0x67, 0x25, 0xe0, 0x94, 0x4d, 0xb7, 0x89, 0xd4, 0xca, 0xa9,
      0x6b, 0xd8, 0x70, 0x1f, 0xdc, 0x10, 0x0a, 0x26, 0xca, 0x12, 0xe4, 0x5d,
      0x7d, 0x9a, 0x5f, 0x55, 0x99, 0xfd, 0xec, 0x0a, 0x8c, 0xa5, 0xba, 0x9e,
      0x2e, 0x0a, 0x5c, 0x74, 0x3d, 0x2e, 0x82, 0xa0, 0x00, 0x6b, 0x91, 0x5e,
      0x65, 0x72, 0xe0, 0x66, 0xc3, 0x0b, 0xd7, 0x94, 0xe9, 0x8f, 0xe0, 0x95,
      0x95, 0x19, 0xf4, 0x18, 0xd5, 0x58, 0x7a, 0x50, 0x12, 0xff, 0x9b, 0x0c,
      0x54, 0x59, 0x30, 0xe3, 0x06, 0x5c, 0xf8, 0xde, 0xac, 0x44, 0x0e, 0xf6,
      0x07, 0x15, 0xec, 0xb8, 0xde, 0x63, 0xf2, 0xbe, 0xa7, 0xfb, 0x80, 0xbc,
      0x81, 0xce, 0xfd, 0x2f, 0x5b, 0x97, 0x9b, 0xf0, 0xd3, 0x2e, 0x07, 0xe6,
      0x15, 0xdb, 0x6a, 0x36, 0x3f, 0x04, 0x47, 0xbe, 0xc0, 0x68, 0xdb, 0x90,
      0xa9, 0xe8, 0x6b, 0xb4, 0x70, 0x30, 0x98, 0xb3, 0xdd, 0xf1, 0xbc, 0x34,
      0xb2, 0x80, 0x39, 0x30, 0xb5, 0x6f, 0xbb, 0x8e, 0x02, 0x6b, 0x86, 0x91,
      0x24, 0x8d, 0x8e, 0x47, 0x1e, 0xd6, 0xdc, 0x0a, 0x90, 0x90, 0x5f, 0x96,
      0x41, 0x24, 0x70, 0xf1, 0x00, 0x2a, 0xb2, 0xa7, 0x54, 0xcd, 0xa6, 0xde,
      0xad, 0x97, 0xc5, 0xa0, 0x5f, 0xbc, 0xec, 0x5d, 0x03, 0x98, 0xc1, 0x56,
      0x18, 0x76, 0xba, 0xc0, 0x21, 0xec, 0x4c, 0xdc, 0x69, 0x15, 0xd9, 0x29,
      0xeb, 0xb6, 0xfa, 0x5f, 0xfa, 0x1d, 0x6e, 0x37, 0xdb, 0x99, 0x95, 0x1f,
      0xa1, 0x96, 0x70, 0xae, 0x0f, 0x8b, 0xbe, 0x18, 0xba, 0xca, 0xb5, 0x4b,
      0xeb, 0xeb, 0x5e, 0xc2, 0xdf, 0xb4, 0xa0, 0xcf, 0x69, 0xdd, 0x70, 0x77,
      0xb3, 0x22, 0x9f, 0xd0, 0xcd, 0x85, 0x80, 0xfb, 0x56, 0xfa, 0x13, 0xc3,
      0x99, 0x36, 0x4e, 0x2b, 0xde, 0xcc, 0x1a, 0x0b, 0xfc, 0x6e, 0xb6, 0x7f,
      0x01, 0xa1, 0x7f, 0xcc},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 3
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     3,
     {0x54, 0x65, 0x73, 0x74},
     {0x83, 0x5a, 0x8d, 0x5a, 0xb3, 0x36, 0xe2, 0x13, 0x3a, 0xde, 0x3b, 0x35,
      0x37, 0xdb, 0xcd, 0x90, 0x8a, 0x49, 0xd3, 0x93, 0x3d, 0x07, 0x47, 0xe6,
      0xc5, 0x67, 0xe6, 0xe4, 0x93, 0x83, 0x46, 0xb4, 0x0a, 0x20, 0x83, 0x21,
      0x66, 0x9f, 0x82, 0xac, 0x6f, 0xe7, 0x05, 0x5b, 0x4c, 0x43, 0x5c, 0x45,
      0x57, 0x72, 0xad, 0x9b, 0x38, 0x09, 0xac, 0x65, 0xb5, 0x22, 0x3c, 0x04,
      0x32, 0x9f, 0x23, 0x2a, 0xae, 0xd6, 0x41, 0x2b, 0xc6, 0xf0, 0x24, 0x57,
      0x5f, 0xa9, 0xee, 0xe9, 0xd5, 0xf8, 0x13, 0xe3, 0x84, 0xa0, 0x72, 0x89,
      0xb9, 0xb2, 0x03, 0xcf, 0x8c, 0xd7, 0xe2, 0xbf, 0xad, 0xf9, 0x49, 0xae,
      0xdf, 0xac, 0x4e, 0x08, 0x70, 0x5a, 0x17, 0xe4, 0xdb, 0x71, 0x9e, 0xce,
      0x09, 0x1d, 0x46, 0xb2, 0x64, 0xeb, 0x40, 0xbe, 0xfa, 0x19, 0x9c, 0xb2,
      0x7d, 0xe1, 0xa7, 0x44, 0xc9, 0x61, 0x82, 0x48, 0x3c, 0xe8, 0x48, 0x08,
      0x68, 0x6a, 0xfc, 0x56, 0xe4, 0x14, 0xcc, 0xbc, 0x2f, 0x21, 0x90, 0x57,
      0xaf, 0x1d, 0x7e, 0x23, 0x54, 0x9f, 0x44, 0xf7, 0xba, 0xe7, 0x4f, 0x13,
      0x52, 0x54, 0xcc, 0x96, 0x52, 0x27, 0xac, 0xa4, 0xec, 0xd7, 0xb4, 0x57,
      0x1c, 0xd0, 0x5c, 0xb2, 0xc9, 0x9b, 0x6f, 0xa5, 0x5c, 0xf7, 0xec, 0x9c,
      0x4c, 0xc0, 0x85, 0xcd, 0x0a, 0xd0, 0xce, 0x90, 0xe3, 0xe7, 0xf6, 0x8a,
      0xf2, 0xea, 0x3e, 0x2a, 0x60, 0x97, 0xb8, 0x1a, 0x5c, 0x50, 0x91, 0xc3,
      0x10, 0x26, 0x26, 0x1a, 0x47, 0x9d, 0x46, 0xf0, 0x5c, 0x45, 0xae, 0x01,
      0x6e, 0x86, 0x02, 0x9d, 0xae, 0x86, 0xc6, 0x7a, 0xfb, 0xa8, 0xb8, 0xb6,
      0xe8, 0xe6, 0x46, 0xa9, 0x4d, 0x07, 0xd0, 0x7f, 0x3e, 0xaf, 0x8c, 0xa1,
      0x77, 0xc6, 0xc0, 0xed, 0x05, 0x89, 0x69, 0x71, 0xc0, 0xa9, 0x11, 0xc8,
      0x46, 0xff, 0xbd, 0xac},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 4
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     4,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x82, 0x2e, 0x88, 0x70, 0xc0, 0x09, 0x08, 0xcb, 0xf5, 0x03, 0x22, 0x26,
      0x54, 0x7d, 0x38, 0xe4, 0x23, 0xde, 0xb9, 0x12, 0xc4, 0x9c, 0x9f, 0xcb,
      0xee, 0x66, 0x92, 0x0c, 0xd2, 0xe9, 0xe3, 0x19, 0x7b, 0x3f, 0xd7, 0x42,
      0x8c, 0xbb, 0xc5, 0xe9, 0x0e, 0x66, 0x05, 0x45, 0x72, 0x0f, 0x18, 0x0a,
      0xc0, 0xce, 0x06, 0x20, 0x5c, 0xef, 0x87, 0x35, 0x44, 0x6d, 0xe3, 0x0d,
      0xf3, 0x2c, 0x87, 0x97, 0x38, 0x0c, 0xcc, 0xe9, 0xc0, 0x51, 0x2e, 0xb2,
      0x85, 0xb7, 0xbf, 0xfd, 0x88, 0x3e, 0xf0, 0x0f, 0xe1, 0x18, 0xf0, 0x27,
      0xbd, 0xc7, 0x57, 0x00, 0xe5, 0x11, 0x22, 0x6e, 0xc4, 0xda, 0x35, 0xf4,
      0x06, 0xe4, 0x60, 0xfb, 0x88, 0xf9, 0xaf, 0x2e, 0x9c, 0x4e, 0xc2, 0x19,
      0x38, 0x76, 0x76, 0xae, 0x21, 0xca, 0xdf, 0xad, 0x0f, 0xb1, 0xd7, 0x04,
      0xbe, 0x69, 0xd0, 0xeb, 0xcd, 0xda, 0x90, 0xdf, 0xf7, 0xe1, 0x72, 0x61,
      0x2c, 0x97, 0x2c, 0x6a, 0x97, 0x4b, 0x82, 0x8a, 0xce, 0xe6, 0xca, 0x18,
      0x6c, 0x71, 0xb5, 0x03, 0x76, 0xd1, 0xed, 0x5e, 0xb6, 0xc1, 0x07, 0x40,
      0x80, 0x65, 0x47, 0x3d, 0x53, 0xa2, 0xeb, 0xed, 0xc8, 0x33, 0xf0, 0x7f,
      0x60, 0xf9, 0x09, 0xa6, 0xc4, 0x24, 0x64, 0xd7, 0x9d, 0x76, 0xf9, 0x45,
      0x31, 0xa0, 0xd3, 0x86, 0x21, 0x3f, 0xce, 0x5e, 0xfc, 0x2e, 0x66, 0xf3,
      0x11, 0xe7, 0x3b, 0x06, 0x14, 0x2f, 0x82, 0x45, 0xb0, 0x63, 0xb9, 0xe3,
      0x95, 0x72, 0x2d, 0xbe, 0xa0, 0x29, 0xda, 0xbe, 0x5e, 0xd1, 0xc1, 0x27,
      0x88, 0xb8, 0x90, 0x97, 0x4b, 0xa1, 0xd2, 0x84, 0x92, 0xcc, 0xe2, 0xc9,
      0x0e, 0x0a, 0x30, 0x26, 0xc2, 0x82, 0x96, 0x47, 0x63, 0xa0, 0x30, 0xa7,
      0xf7, 0xf3, 0xf7, 0x6a, 0x72, 0x84, 0x3a, 0x97, 0xd9, 0xee, 0xe1, 0x7c,
      0xdb, 0xbb, 0x00, 0xf4},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 5
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     5,
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     {0x94, 0x71, 0x23, 0x59, 0xa9, 0x45, 0xbb, 0x47, 0x11, 0xca, 0xbb, 0x40,
      0xb9, 0x50, 0x20, 0x09, 0x2c, 0x43, 0x42, 0x87, 0x48, 0xb1, 0x0e, 0x0f,
      0x11, 0x18, 0x91, 0x72, 0xd7, 0x05, 0x2b, 0x28, 0x40, 0x1d, 0x96, 0xff,
      0xba, 0x51, 0x6a, 0x9d, 0x49, 0x18, 0x95, 0xe9, 0xe9, 0x53, 0x08, 0x56,
      0x2c, 0xdf, 0x17, 0x95, 0x3a, 0x4e, 0x05, 0xbb, 0xae, 0x8c, 0x8c, 0xf3,
      0x91, 0xe7, 0xc3, 0x63, 0x50, 0x6a, 0xc8, 0x6d, 0x46, 0x93, 0x2b, 0x37,
      0x39, 0x63, 0xe9, 0xe6, 0x61, 0xe9, 0xde, 0x2d, 0xf3, 0x22, 0x71, 0x9e,
      0x63, 0x69, 0xf3, 0xba, 0x68, 0xf4, 0x2b, 0xba, 0x78, 0xac, 0x93, 0x2f,
      0x7d, 0x23, 0x33, 0x75, 0x9a, 0x53, 0xd4, 0xd1, 0x8f, 0x59, 0x90, 0xb1,
      0x8a, 0x6d, 0x4d, 0x0a, 0xf9, 0x6d, 0x9a, 0x94, 0x51, 0xb2, 0xd5, 0xa8,
      0xc3, 0xf4, 0x27, 0xf6, 0x07, 0x38, 0x09, 0x97, 0xb5, 0xb2, 0x02, 0x9f,
      0x58, 0xf0, 0x43, 0x01, 0xb5, 0x2c, 0x18, 0xcf, 0x57, 0xc2, 0xa7, 0x63,
      0xb5, 0x46, 0xa2, 0x1b, 0x8d, 0xa9, 0x62, 0x70, 0x70, 0xa1, 0xcc, 0x30,
      0xbe, 0xe0, 0xc7, 0x58, 0x63, 0xb1, 0x96, 0x12, 0x89, 0x88, 0xff, 0xea,
      0x68, 0x3a, 0x4d, 0xa5, 0x20, 0x39, 0x24, 0xdb, 0x47, 0x0a, 0x53, 0xda,
      0xc3, 0x6a, 0x3f, 0xbe, 0xc3, 0xdb, 0xd9, 0x71, 0x0f, 0x85, 0xff, 0x6b,
      0x07, 0x28, 0xa6, 0x92, 0xd6, 0x40, 0xed, 0x7b, 0xa6, 0x7b, 0x7e, 0x49,
      0x3a, 0x7b, 0x95, 0x86, 0x4a, 0x21, 0x91, 0xf6, 0x17, 0x96, 0x8e, 0xe1,
      0xef, 0xdc, 0xdb, 0x5b, 0x01, 0x5e, 0x45, 0xda, 0x55, 0x08, 0x6b, 0x2b,
      0x38, 0x2a, 0x38, 0x0c, 0xf6, 0x6b, 0xc6, 0x15, 0x21, 0xb2, 0x32, 0x7a,
      0x6b, 0xbf, 0x24, 0x7a, 0xb7, 0x63, 0x5d, 0xa9, 0xa4, 0x8a, 0xcc, 0x11,
      0x9e, 0x86, 0x74, 0x67},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 6
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     6,
     {0x61},
     {0x61, 0x0a, 0xa2, 0x97, 0x3b, 0xb0, 0xd6, 0x7e, 0xfc, 0x72, 0x52, 0x04,
      0xa0, 0xaf, 0x7d, 0xb8, 0x52, 0xbc, 0xdd, 0x82, 0x27, 0xe3, 0x09, 0xe6,
      0xa5, 0x23, 0xef, 0x62, 0x75, 0x55, 0xb7, 0xae, 0xb7, 0x83, 0xde, 0xe3,
      0x96, 0x93, 0x4b, 0x61, 0x14, 0x15, 0x90, 0x95, 0x28, 0x01, 0xc0, 0x27,
      0xa5, 0x59, 0xa3, 0xb7, 0x38, 0x0a, 0xbb, 0x67, 0x24, 0x22, 0x4c, 0xf8,
      0x25, 0xa9, 0xc7, 0x4d, 0xcc, 0xfa, 0xe2, 0x78, 0x71, 0x95, 0x51, 0xbb,
      0xf0, 0xe6, 0xa8, 0x12, 0x5d, 0x64, 0xbb, 0x43, 0x7e, 0xf7, 0x8c, 0x24,
      0xcc, 0x00, 0xa5, 0x2f, 0xd9, 0xa7, 0x16, 0xac, 0x20, 0x10, 0x2b, 0x5a,
      0x1d, 0x8f, 0xbd, 0x44, 0x5d, 0x9a, 0x2d, 0x4c, 0xe2, 0xc5, 0x5a, 0x2f,
      0x54, 0x9c, 0x2f, 0xed, 0x8e, 0x59, 0x32, 0xcb, 0xdf, 0xc8, 0xde, 0xb9,
      0x07, 0xd9, 0x73, 0x83, 0x4c, 0x29, 0x63, 0x72, 0x05, 0x57, 0x66, 0x8d,
      0x61, 0xe3, 0xf2, 0xe5, 0x35, 0x64, 0xd6, 0xdb, 0x7b, 0x41, 0x89, 0x98,
      0x73, 0xe3, 0xca, 0x66, 0xa1, 0xb5, 0x18, 0x6a, 0x8a, 0x54, 0x5d, 0x27,
      0x91, 0x5a, 0xa4, 0x66, 0xdf, 0x12, 0xca, 0x71, 0x63, 0xa7, 0xd8, 0x13,
      0x7e, 0xea, 0x71, 0xef, 0x80, 0x69, 0x0d, 0x22, 0x9d, 0xeb, 0x08, 0x95,
      0x10, 0x56, 0x7f, 0x24, 0x75, 0x6f, 0x0f, 0x70, 0xa1, 0xda, 0xc6, 0x09,
      0xa5, 0x7a, 0x11, 0xdd, 0xc4, 0x00, 0xaf, 0x94, 0x31, 0x26, 0xe5, 0xc5,
      0xb1, 0x18, 0xb7, 0x6b, 0x76, 0x9d, 0xfc, 0x1a, 0x7a, 0x6e, 0xc7, 0x48,
      0xb5, 0xb9, 0x06, 0xba, 0xa0, 0xf0, 0xe1, 0x88, 0xb1, 0xc6, 0xfd, 0xbd,
      0x6b, 0xc3, 0x07, 0xaf, 0x0f, 0xd9, 0xb4, 0x60, 0x2e, 0xa6, 0x25, 0x13,
      0x43, 0x0b, 0x32, 0x08, 0xe3, 0xd6, 0x90, 0x70, 0x7f, 0xc2, 0xd2, 0x8e,
      0xbc, 0x43, 0x23, 0x88},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 7
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     7,
     {0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea,
      0xeb, 0xec, 0xed, 0xee, 0xef, 0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5,
      0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff},
     {0x76, 0xf7, 0xb6, 0xe1, 0xcf, 0x45, 0xb0, 0x05, 0xad, 0x58, 0xb5, 0x35,
      0x4c, 0xfc, 0x57, 0x99, 0xf7, 0x4e, 0xdf, 0xb2, 0x7f, 0x27, 0xb4, 0x14,
      0xb4, 0xd2, 0x55, 0x00, 0xa1, 0xec, 0x4b, 0xcd, 0x46, 0xc6, 0xb6, 0x56,
      0x03, 0xb2, 0x04, 0xf6, 0x9a, 0x2a, 0x71, 0xb8, 0xd1, 0x09, 0x9c, 0xe9,
      0x6c, 0x8e, 0xe5, 0x2e, 0x11, 0x9e, 0xd9, 0xb0, 0x80, 0xd8, 0x6d, 0x82,
      0x78, 0x9e, 0x3e, 0x57, 0x77, 0xcc, 0x5f, 0x92, 0x0b, 0x14, 0x71, 0x26,
      0xec, 0x86, 0x12, 0xb2, 0x06, 0xbc, 0x57, 0x34, 0xe8, 0x28, 0xac, 0x81,
      0x9f, 0x90, 0xea, 0x71, 0x91, 0x83, 0x2d, 0x57, 0x0d, 0x37, 0x6d, 0xf2,
      0xc4, 0xe3, 0xeb, 0x50, 0x70, 0xfd, 0x83, 0x82, 0xf8, 0xc0, 0xa9, 0xb8,
      0x9d, 0xa9, 0x28, 0xbf, 0xbd, 0xd2, 0x4b, 0xf1, 0xd1, 0x7e, 0xbc, 0x83,
      0xf9, 0x23, 0x7a, 0x51, 0x35, 0x2f, 0xf0, 0x4b, 0x6b, 0xb3, 0x84, 0x8c,
      0xb6, 0xa9, 0xc1, 0x95, 0xe5, 0x36, 0x9f, 0x4b, 0x6e, 0xd9, 0xb4, 0xcc,
      0x16, 0x63, 0x77, 0xf8, 0x8c, 0x7e, 0x6d, 0xb6, 0xef, 0x78, 0xc0, 0xe1,
      0xbf, 0xba, 0xc5, 0xa3, 0x82, 0x58, 0x67, 0xaf, 0x9b, 0x22, 0x68, 0x9b,
      0x62, 0x7d, 0xcd, 0x8d, 0x14, 0x41, 0xb5, 0x15, 0xb1, 0x5b, 0x78, 0x68,
      0x8b, 0x52, 0xb0, 0x4d, 0xf4, 0x15, 0x7a, 0x88, 0x8a, 0xab, 0xdb, 0x9e,
      0x79, 0x2c, 0x65, 0xfc, 0xbd, 0xcd, 0x03, 0x74, 0x3f, 0xe4, 0x5e, 0x63,
      0x7a, 0xfa, 0x7e, 0x42, 0x27, 0x82, 0xe6, 0xda, 0x58, 0xb9, 0x51, 0x63,
      0xac, 0xd5, 0x93, 0x53, 0xe6, 0x34, 0x33, 0x7a, 0xbb, 0x1c, 0x15, 0xb8,
      0x31, 0xa9, 0xde, 0xc7, 0x9c, 0x51, 0x7a, 0x5b, 0xe0, 0xb4, 0xee, 0x43,
      0xf7, 0x54, 0x4a, 0x2e, 0x9b, 0xf6, 0xaf, 0x2b, 0xc5, 0x3b, 0x08, 0x0c,
      0x60, 0xdc, 0x2b, 0xc6},
     {},
     priv_key_1,
     true},

    // Comment:
    // tcID: 8
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     8,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x33, 0x85, 0x14, 0xdc, 0x5a, 0x9c, 0xe8, 0xf2, 0x0a, 0x50, 0x40, 0xf2,
      0x6a, 0x83, 0x00, 0x18, 0x31, 0x4c, 0x56, 0x92, 0x49, 0xd5, 0x40, 0xe2,
      0xde, 0xc2, 0x47, 0xf4, 0xae, 0x92, 0x5f, 0x6c, 0xda, 0x2d, 0x7a, 0x53,
      0x5e, 0x4e, 0x20, 0xe5, 0x34, 0x8b, 0xf1, 0x4f, 0x6c, 0x87, 0x86, 0x1b,
      0x37, 0xfb, 0xe4, 0x90, 0x17, 0x58, 0xdd, 0x38, 0xda, 0x7c, 0xc7, 0xcc,
      0x05, 0x0e, 0xdd, 0x1e, 0x20, 0x8a, 0xca, 0xf6, 0xab, 0x2d, 0x33, 0x2a,
      0x64, 0x82, 0xc4, 0xe5, 0xaf, 0x4c, 0xd4, 0xc4, 0xf1, 0xf9, 0x95, 0x06,
      0x10, 0xff, 0x56, 0xef, 0x91, 0x0b, 0x28, 0x31, 0xe3, 0xf2, 0x3b, 0x2b,
      0x6d, 0x33, 0x25, 0xe8, 0xa9, 0xf4, 0xfc, 0x50, 0xe0, 0x05, 0x7a, 0x50,
      0xaf, 0x5d, 0xb5, 0x1e, 0xc2, 0xa1, 0xf7, 0x8d, 0x04, 0x65, 0xe5, 0xf5,
      0x40, 0x53, 0x11, 0x3d, 0xf3, 0x00, 0x58, 0x4f, 0x45, 0x8a, 0x1e, 0xbf,
      0x6e, 0x5b, 0x13, 0x58, 0xf2, 0x45, 0x4c, 0xef, 0x3b, 0x3e, 0x4a, 0xec,
      0x9b, 0xcd, 0xfd, 0xcd, 0xf5, 0xd8, 0x82, 0x06, 0xbe, 0xd1, 0xe9, 0xa4,
      0xe7, 0xc7, 0xc8, 0xdc, 0x5f, 0x08, 0x7d, 0x66, 0x10, 0x3b, 0xcd, 0x28,
      0xe9, 0x4c, 0x2c, 0x23, 0x3e, 0xac, 0x17, 0x06, 0x26, 0x1a, 0xa6, 0xaa,
      0x67, 0xf0, 0x44, 0xbb, 0x06, 0x53, 0x29, 0x54, 0xd9, 0x16, 0x53, 0xae,
      0xdc, 0xd5, 0x8e, 0x82, 0x31, 0xa8, 0x1c, 0x52, 0xae, 0xa9, 0x6b, 0xb4,
      0xad, 0x1a, 0xdc, 0x5e, 0x3c, 0x21, 0x83, 0xea, 0x99, 0x24, 0x7a, 0x4a,
      0xf8, 0x01, 0x1b, 0x41, 0x5d, 0x61, 0x8c, 0x67, 0xc9, 0x4f, 0x0b, 0x27,
      0x6b, 0xda, 0xfc, 0xdd, 0xc8, 0xb6, 0x46, 0x18, 0x29, 0x89, 0xc1, 0xdb,
      0x26, 0xda, 0x67, 0x7b, 0xfb, 0xa2, 0x85, 0xc0, 0xab, 0x76, 0xc8, 0x2b,
      0x80, 0xa6, 0x38, 0xa2},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     priv_key_1,
     true},

    // Comment:
    // tcID: 9
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     9,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x31, 0x47, 0x84, 0x24, 0xe4, 0x25, 0x5a, 0xb2, 0x1a, 0x4d, 0x9a, 0x8c,
      0x5a, 0x3d, 0xaa, 0x8f, 0x0d, 0xd5, 0x41, 0x6f, 0x79, 0xc2, 0xba, 0xab,
      0x2f, 0xbe, 0xef, 0x40, 0x6f, 0x76, 0xc4, 0x93, 0xcb, 0x43, 0x6a, 0xcd,
      0x03, 0x0e, 0x0b, 0xc4, 0xd0, 0x94, 0x32, 0xd9, 0x98, 0x38, 0x60, 0xc0,
      0x1b, 0x1c, 0x55, 0x9c, 0xe0, 0x95, 0xb7, 0xd9, 0x17, 0x61, 0xac, 0x2e,
      0x4b, 0xc5, 0x51, 0x3c, 0x68, 0xae, 0x6b, 0xdf, 0x74, 0x7d, 0x55, 0x6a,
      0x84, 0xac, 0x07, 0x13, 0x32, 0x33, 0x36, 0x8f, 0xc9, 0x2d, 0x4f, 0x32,
      0xf9, 0xbc, 0x9f, 0xc4, 0x15, 0xc3, 0xd0, 0xdf, 0xa8, 0x7f, 0x84, 0x85,
      0x3a, 0x82, 0x8f, 0xdd, 0x10, 0x3b, 0x8a, 0xde, 0x88, 0x9a, 0x02, 0x0f,
      0x96, 0x53, 0x04, 0xca, 0xe5, 0x32, 0x4f, 0x78, 0xe3, 0x6c, 0x72, 0xcf,
      0x5d, 0x8b, 0x94, 0x49, 0x6a, 0x6f, 0x48, 0xb0, 0x3a, 0x9e, 0xe3, 0xf3,
      0x2f, 0xb4, 0x35, 0xd4, 0x8d, 0x31, 0x00, 0x2a, 0xce, 0x7d, 0x21, 0x2a,
      0x10, 0x8f, 0xef, 0x64, 0x0f, 0x55, 0xe7, 0x15, 0xa1, 0x48, 0x33, 0x5b,
      0x39, 0x6e, 0x90, 0x0c, 0xa3, 0xfe, 0x96, 0xa0, 0x85, 0x47, 0x64, 0xb5,
      0x4c, 0x31, 0x87, 0xe3, 0x7d, 0x9e, 0xb5, 0xa6, 0x5b, 0x54, 0xce, 0x66,
      0x76, 0xd3, 0x74, 0x7b, 0xfd, 0xa9, 0x1e, 0xd2, 0xf5, 0x36, 0xd7, 0x9a,
      0x69, 0x76, 0xfc, 0xfb, 0xbd, 0x68, 0x3e, 0xce, 0xe3, 0x2c, 0x5a, 0x8d,
      0xc2, 0x96, 0x22, 0xf7, 0x89, 0x57, 0x9a, 0x37, 0x0e, 0xb7, 0xd6, 0x6a,
      0x14, 0x04, 0xa3, 0x76, 0xa4, 0x3e, 0xf5, 0x84, 0xa0, 0xe2, 0xed, 0xde,
      0xa0, 0x6f, 0xe6, 0x0c, 0x28, 0xae, 0x08, 0xb7, 0xd1, 0xa8, 0xaf, 0x26,
      0xb2, 0x0e, 0x50, 0xe9, 0xa8, 0xb3, 0xf8, 0x65, 0x4e, 0x18, 0x32, 0x19,
      0xaf, 0x3d, 0xd5, 0x08},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
      0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13},
     priv_key_1,
     true},

    // Comment:
    // tcID: 10
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     10,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x90, 0x68, 0x9b, 0x19, 0x1d, 0x04, 0x1a, 0x9b, 0xc6, 0x9e, 0xa9, 0x3b,
      0x26, 0xd0, 0x42, 0x36, 0xed, 0xee, 0x88, 0xb8, 0xaf, 0x6c, 0x0b, 0x29,
      0xe9, 0xb4, 0x38, 0x27, 0x0b, 0x24, 0x2d, 0xca, 0x46, 0x7e, 0xe4, 0x87,
      0x4a, 0xcf, 0x7f, 0x9b, 0x6b, 0x24, 0x4c, 0x38, 0x43, 0x67, 0x49, 0x62,
      0xc9, 0xd0, 0xd6, 0x7f, 0xdb, 0x70, 0x21, 0xab, 0xa6, 0x3f, 0xca, 0xec,
      0x2e, 0xac, 0x3b, 0x6b, 0x51, 0x14, 0xca, 0x4b, 0x24, 0x2b, 0x08, 0xa1,
      0xdd, 0xc1, 0xdc, 0x67, 0x1b, 0x40, 0x3b, 0xbd, 0x5c, 0xcb, 0x57, 0xc7,
      0xf6, 0xc8, 0x7c, 0xf0, 0xdc, 0x99, 0x5b, 0x38, 0xab, 0xa6, 0xfe, 0x63,
      0x5f, 0x4a, 0x72, 0x7f, 0x6b, 0x16, 0x4b, 0xd3, 0x6a, 0x5f, 0xf5, 0xe7,
      0xb9, 0x1e, 0x42, 0xbb, 0xe5, 0x08, 0x35, 0x63, 0x8c, 0xf9, 0xe3, 0xc7,
      0xa5, 0x39, 0x7f, 0x5f, 0x09, 0x57, 0x84, 0xc3, 0xdc, 0x5c, 0x49, 0x3e,
      0xe1, 0xa2, 0x2a, 0x9e, 0x2b, 0x3f, 0x28, 0xc7, 0x1d, 0xdd, 0xda, 0x25,
      0x53, 0xe2, 0x69, 0xd6, 0xe8, 0x18, 0xaa, 0xad, 0x19, 0x6b, 0x22, 0xe6,
      0x70, 0xee, 0xc5, 0x83, 0x2a, 0x84, 0xa0, 0xf8, 0x9c, 0xb9, 0xbf, 0x5d,
      0x8f, 0x69, 0xe3, 0x5f, 0x34, 0xcc, 0xbe, 0xf4, 0x03, 0x7e, 0x9a, 0x4b,
      0x6b, 0xf2, 0xd8, 0xd3, 0x19, 0x7b, 0xd0, 0x2a, 0xcb, 0x34, 0x4c, 0xbe,
      0x27, 0x00, 0x6e, 0xfb, 0x73, 0xdb, 0x0b, 0x9d, 0x54, 0x93, 0xdc, 0xd1,
      0x4b, 0x95, 0xb9, 0x34, 0xaf, 0xc2, 0x76, 0x8a, 0xf2, 0x7d, 0x1b, 0x3b,
      0x24, 0xde, 0x69, 0x4f, 0xc0, 0xf0, 0x0f, 0x75, 0x74, 0x88, 0xd2, 0x31,
      0xe3, 0xe2, 0xcc, 0x5b, 0xe7, 0x75, 0x30, 0xf5, 0x12, 0x01, 0x44, 0x45,
      0x88, 0x96, 0x00, 0xbd, 0x1a, 0x26, 0x5a, 0x4b, 0xf1, 0x88, 0xf6, 0x17,
      0xb9, 0x75, 0x17, 0x83},
     {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
      0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
      0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f},
     priv_key_1,
     true},

    // Comment: Longest valid message size
    // tcID: 11
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     11,
     {0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
      0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78},
     {0x9e, 0xdf, 0x0e, 0x6a, 0xe2, 0x5a, 0x3e, 0x7b, 0x6f, 0x31, 0xfa, 0x13,
      0xa7, 0xa3, 0x1d, 0xb0, 0xe6, 0xce, 0x2f, 0xaa, 0x62, 0x4c, 0x2e, 0xbc,
      0xba, 0x96, 0x69, 0xbf, 0x5f, 0x20, 0x57, 0x58, 0xe1, 0xe9, 0x04, 0xa9,
      0xa7, 0x38, 0xbd, 0xf4, 0x30, 0x07, 0x2b, 0x05, 0x63, 0xd1, 0xa8, 0x7f,
      0x16, 0x52, 0x28, 0x11, 0xd6, 0x45, 0xcd, 0x9f, 0x85, 0xf1, 0x33, 0x59,
      0xd2, 0x96, 0x1b, 0xbc, 0x58, 0x3a, 0x3b, 0x15, 0xc6, 0x6a, 0xb5, 0xa0,
      0xd1, 0x37, 0x3c, 0x29, 0x49, 0x26, 0x1e, 0x3f, 0x44, 0xc2, 0xa1, 0xa8,
      0x8e, 0x25, 0x19, 0x0e, 0xfd, 0x30, 0xaa, 0x9f, 0xc4, 0x10, 0xd2, 0xd2,
      0x31, 0x48, 0xc1, 0x6d, 0xaa, 0x90, 0x45, 0x7b, 0xf1, 0xee, 0x77, 0xc2,
      0xd3, 0x44, 0x52, 0x50, 0x36, 0xe0, 0x37, 0xed, 0x47, 0x32, 0x75, 0xbd,
      0x53, 0x5f, 0xa9, 0x61, 0xa6, 0x6e, 0x47, 0x07, 0x2b, 0x58, 0x69, 0x15,
      0xd8, 0x5d, 0x3d, 0x7e, 0xda, 0xae, 0x79, 0x45, 0xb5, 0xe7, 0xf0, 0x8f,
      0xa1, 0x5a, 0x4d, 0x08, 0xcc, 0x66, 0x9b, 0x38, 0x46, 0xb1, 0xea, 0x02,
      0xcd, 0xc3, 0xeb, 0x9b, 0xc5, 0xa5, 0x4a, 0xba, 0x22, 0x7f, 0x94, 0x34,
      0xf1, 0x9d, 0x28, 0xd0, 0x6a, 0xdd, 0x79, 0x1f, 0xce, 0x9e, 0xfe, 0x21,
      0x71, 0xe2, 0xc6, 0x76, 0xbc, 0x1b, 0x09, 0xbc, 0x16, 0x37, 0x98, 0xa1,
      0xa7, 0x4b, 0x7f, 0xde, 0xda, 0xd9, 0x93, 0xdc, 0x47, 0xc8, 0x32, 0x3c,
      0xbe, 0x3a, 0xea, 0xd9, 0x6d, 0x0d, 0x4e, 0x7e, 0x49, 0x4a, 0xc3, 0x90,
      0x20, 0x0e, 0x6a, 0x79, 0xf9, 0x6d, 0x88, 0x84, 0x4d, 0x59, 0xa3, 0xd7,
      0x86, 0x26, 0xb0, 0x79, 0x7b, 0x90, 0x22, 0x20, 0x87, 0x4e, 0x69, 0x57,
      0xe6, 0xc2, 0x14, 0xf3, 0xab, 0x75, 0x74, 0xc6, 0xe4, 0x76, 0xcc, 0x42,
      0x62, 0xbe, 0xda, 0x98},
     {},
     priv_key_1,
     true},

    // Comment: first byte of l_hash modified
    // tcID: 12
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     12,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x9a, 0x4a, 0x34, 0x67, 0x71, 0x8b, 0xbd, 0x45, 0x5b, 0xaf, 0x31, 0x2d,
      0xcf, 0xc6, 0x5e, 0xeb, 0x57, 0x0d, 0x28, 0x6b, 0xc8, 0x8f, 0xfb, 0xe1,
      0x9d, 0x2f, 0x8e, 0x03, 0x23, 0x08, 0xa5, 0x0a, 0xcb, 0xa1, 0xf7, 0x95,
      0x1f, 0x50, 0x7f, 0x50, 0x2d, 0xe9, 0x1c, 0x0a, 0xe3, 0xfa, 0x47, 0x08,
      0xf4, 0x7b, 0xa2, 0x45, 0x9c, 0x5c, 0x62, 0xca, 0x66, 0x7f, 0xde, 0x31,
      0x31, 0xec, 0x16, 0xf6, 0x5a, 0x22, 0x1a, 0x63, 0xd1, 0xd2, 0x73, 0x14,
      0xc5, 0x45, 0x89, 0xdb, 0x50, 0xa1, 0xfd, 0xfe, 0x44, 0xfc, 0x7c, 0x78,
      0x9c, 0x04, 0x1c, 0xa0, 0x39, 0x8a, 0x0e, 0x64, 0x8b, 0x12, 0x51, 0xfd,
      0x3e, 0xa5, 0x59, 0xef, 0xf4, 0x50, 0xba, 0x92, 0xd1, 0x33, 0x23, 0x3c,
      0xc1, 0x77, 0x9a, 0x20, 0x94, 0xe2, 0x3a, 0x6b, 0x88, 0xf0, 0xad, 0x8e,
      0xf1, 0xe0, 0xc6, 0xff, 0x42, 0xd9, 0xbe, 0x75, 0x4e, 0x2c, 0x9d, 0x90,
      0x4d, 0xfc, 0x75, 0x12, 0x4b, 0x3f, 0x34, 0xb0, 0x0e, 0x56, 0x08, 0x7e,
      0x67, 0x2f, 0x5e, 0xac, 0xb9, 0x8f, 0x27, 0xb5, 0xf0, 0xfd, 0xa7, 0xf6,
      0x7e, 0x71, 0xc2, 0xe3, 0xe2, 0xd9, 0x8c, 0xe3, 0x79, 0x87, 0x2d, 0x81,
      0x20, 0xae, 0xac, 0x24, 0xbc, 0x5e, 0xdb, 0x39, 0x19, 0xa1, 0x96, 0xf2,
      0x79, 0x08, 0x30, 0xb6, 0x15, 0x80, 0x6f, 0xc0, 0xb5, 0xbf, 0x03, 0xe6,
      0xb6, 0x0f, 0xbb, 0x36, 0xc9, 0xb2, 0x02, 0xa9, 0x97, 0x2d, 0xfb, 0x71,
      0xd2, 0x8d, 0x16, 0x8f, 0x00, 0xf6, 0x98, 0x96, 0x0b, 0x2e, 0x1c, 0xf6,
      0xa6, 0x52, 0x80, 0x60, 0xff, 0x7f, 0xff, 0x91, 0xaf, 0xa0, 0x08, 0x2b,
      0xb9, 0xa6, 0x18, 0xc5, 0xa0, 0x52, 0x06, 0xde, 0x8b, 0xdd, 0x07, 0x59,
      0xce, 0xfb, 0xe1, 0x6b, 0x30, 0x0a, 0x1b, 0x51, 0xee, 0x12, 0x80, 0x95,
      0x51, 0x00, 0x9b, 0xf0},
     {},
     priv_key_1,
     false},

    // Comment: last byte of l_hash modified
    // tcID: 13
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     13,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x8e, 0x70, 0x55, 0x3d, 0x2a, 0xb7, 0xd1, 0x72, 0x4c, 0x2e, 0x42,
      0x2b, 0xa5, 0x25, 0xeb, 0xed, 0x71, 0x73, 0x9b, 0xd8, 0xeb, 0x96, 0x8c,
      0x65, 0xd8, 0x66, 0x77, 0x04, 0x38, 0x3f, 0xec, 0x64, 0x32, 0xf0, 0xe0,
      0x71, 0xcd, 0x0a, 0xd7, 0x18, 0x09, 0xa3, 0xfd, 0xe9, 0x22, 0x33, 0xbf,
      0x7e, 0xf0, 0x14, 0x4d, 0xab, 0xc6, 0x88, 0xdc, 0x1b, 0xea, 0xbc, 0xc8,
      0x29, 0xc7, 0x6b, 0x3e, 0x41, 0x8b, 0x6a, 0x99, 0x4c, 0x94, 0x20, 0x9e,
      0x87, 0x2b, 0xf7, 0xe7, 0xdc, 0x64, 0xe6, 0xee, 0x8c, 0xac, 0x7a, 0x5a,
      0x6c, 0xa3, 0xd4, 0x0a, 0x22, 0x80, 0xf8, 0x75, 0xd8, 0x8f, 0xbb, 0xd5,
      0x9a, 0x2f, 0x5a, 0xfd, 0x24, 0x5a, 0x5b, 0x12, 0xc3, 0xfd, 0xa1, 0x26,
      0x3c, 0x97, 0xbd, 0x1c, 0x55, 0x36, 0x24, 0x5d, 0x08, 0x91, 0xeb, 0xc2,
      0x20, 0x75, 0x7f, 0x6a, 0x95, 0x15, 0x1c, 0xf0, 0x6a, 0xf7, 0x44, 0x84,
      0x0c, 0xf2, 0xee, 0x86, 0x10, 0x15, 0x04, 0x27, 0xff, 0xdc, 0xc6, 0x19,
      0xde, 0x7e, 0x0b, 0x0c, 0x85, 0x19, 0xc2, 0xee, 0xce, 0x9c, 0x45, 0x88,
      0x2d, 0xce, 0xc3, 0xbc, 0x48, 0x22, 0x05, 0x7e, 0x5b, 0xe0, 0x17, 0xd1,
      0x7c, 0xf3, 0xb1, 0xdf, 0x53, 0xc0, 0x04, 0x14, 0xfc, 0x19, 0xfe, 0x47,
      0x8e, 0x67, 0xab, 0xec, 0x5b, 0x1b, 0x8e, 0x04, 0x62, 0xec, 0x9e, 0x86,
      0x06, 0x99, 0x4f, 0x60, 0x43, 0x3f, 0xe1, 0x5b, 0xa3, 0x65, 0x27, 0x19,
      0x04, 0x7d, 0x54, 0x08, 0x9c, 0x91, 0x93, 0x21, 0x80, 0x77, 0xf7, 0x43,
      0xb7, 0x1d, 0x04, 0x99, 0x07, 0x05, 0xc6, 0x63, 0x81, 0x79, 0x18, 0xb8,
      0x03, 0xef, 0x8f, 0x36, 0x2e, 0xe1, 0x75, 0x22, 0xc3, 0x08, 0x0b, 0x97,
      0xa1, 0xdb, 0x10, 0x02, 0x91, 0xa7, 0x0f, 0xab, 0xd9, 0x25, 0xde, 0x20,
      0x94, 0x96, 0x20, 0x9d},
     {},
     priv_key_1,
     false},

    // Comment: l_hash changed to all 0
    // tcID: 14
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     14,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x45, 0xa7, 0xb9, 0x89, 0x44, 0xf4, 0x29, 0x52, 0x6c, 0x32, 0xff, 0xd6,
      0x77, 0x0d, 0x2c, 0xfa, 0x27, 0x5e, 0xb8, 0x1a, 0x81, 0x63, 0xd0, 0x66,
      0x2e, 0x1e, 0x41, 0x8d, 0x9a, 0x09, 0x37, 0x36, 0xad, 0x0a, 0xef, 0x2e,
      0xc7, 0x00, 0x13, 0xf1, 0x5b, 0x5f, 0x24, 0x03, 0x36, 0xa0, 0xc2, 0xc3,
      0xc6, 0x73, 0xba, 0x26, 0x51, 0x25, 0xff, 0x6a, 0x38, 0x97, 0xa9, 0x1a,
      0x74, 0x9a, 0x28, 0x94, 0x18, 0x7b, 0xf7, 0xad, 0xe1, 0x53, 0xba, 0x14,
      0x91, 0xc6, 0x6c, 0x52, 0xb5, 0xdc, 0x67, 0xb3, 0xb1, 0x63, 0x72, 0x5d,
      0xff, 0x9c, 0x49, 0xe4, 0xf3, 0x6d, 0x90, 0x1e, 0x1e, 0x9d, 0x96, 0x4b,
      0x28, 0x55, 0x86, 0x77, 0x74, 0x55, 0x43, 0x8f, 0x8c, 0x00, 0x1c, 0xaf,
      0x53, 0xe0, 0x13, 0x72, 0x0e, 0xcb, 0x14, 0xe1, 0xe2, 0x8a, 0xed, 0xae,
      0x25, 0xbe, 0xdd, 0xc5, 0xf4, 0x25, 0x80, 0xb9, 0xf7, 0x2b, 0xcc, 0xef,
      0x98, 0x6a, 0xe0, 0xed, 0x3d, 0xaf, 0x04, 0x35, 0x83, 0x8b, 0x4c, 0x2d,
      0x55, 0xbd, 0xce, 0xf2, 0x34, 0x1f, 0x8a, 0x08, 0xf6, 0xef, 0x5c, 0x2b,
      0xc4, 0x19, 0x4e, 0xed, 0x1c, 0x1b, 0x2c, 0x74, 0x1c, 0x7c, 0x90, 0x41,
      0xfa, 0xe5, 0xc8, 0xa4, 0x8e, 0x90, 0xa4, 0x69, 0x80, 0x77, 0x50, 0xbe,
      0xa3, 0xa5, 0x0f, 0xb7, 0xc8, 0x48, 0x19, 0x9e, 0xd6, 0x2a, 0x6d, 0x0b,
      0x09, 0xea, 0x8b, 0xeb, 0xe4, 0xea, 0x6d, 0x43, 0x3a, 0x73, 0xd6, 0xa3,
      0x4e, 0x31, 0xcd, 0x9f, 0xdd, 0x21, 0x62, 0x28, 0x14, 0xca, 0xb5, 0x47,
      0xf0, 0x1d, 0x4f, 0x6a, 0x62, 0x6a, 0xa1, 0x80, 0xe9, 0x82, 0xb2, 0xa8,
      0x99, 0x77, 0x14, 0x07, 0x62, 0x56, 0x7f, 0x39, 0x1e, 0xc0, 0x69, 0xd8,
      0x59, 0x77, 0xa9, 0x46, 0x95, 0x13, 0xee, 0x60, 0xe7, 0xa9, 0xab, 0xb5,
      0x4e, 0x07, 0xb3, 0xa4},
     {},
     priv_key_1,
     false},

    // Comment: l_hash changed to all 1
    // tcID: 15
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     15,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x2f, 0x78, 0x2d, 0x8e, 0x57, 0x83, 0x11, 0x58, 0xd1, 0x0e, 0xf1, 0xfc,
      0xfa, 0x7c, 0x1f, 0xff, 0x1a, 0xed, 0x67, 0x5d, 0x34, 0xbc, 0x49, 0x65,
      0x6a, 0x11, 0xd9, 0x7e, 0x19, 0x27, 0x50, 0x3e, 0x18, 0x9f, 0x76, 0xbf,
      0x4e, 0x33, 0x5b, 0x1e, 0xa0, 0xf5, 0x3b, 0x1e, 0x90, 0x9f, 0xdd, 0x5f,
      0xdf, 0xf6, 0x7d, 0x7e, 0x03, 0x4b, 0x51, 0x8d, 0xa0, 0x36, 0xc0, 0x0d,
      0xba, 0x89, 0x70, 0x06, 0x03, 0x1a, 0xf4, 0x83, 0x08, 0x63, 0xfd, 0x11,
      0xd6, 0xfe, 0xce, 0xc2, 0x54, 0x64, 0x6d, 0x00, 0xa2, 0xbf, 0xc2, 0xdb,
      0x8c, 0xde, 0x7b, 0x30, 0x39, 0x22, 0xc7, 0x03, 0x88, 0x53, 0x72, 0xcd,
      0xac, 0x94, 0xd1, 0x9a, 0x29, 0x67, 0x61, 0x85, 0x0d, 0xd5, 0x82, 0xc4,
      0x2b, 0xa5, 0xc9, 0x69, 0x05, 0xeb, 0xce, 0xf5, 0x82, 0x44, 0x26, 0x43,
      0xff, 0x8b, 0xaa, 0x83, 0x91, 0x18, 0x17, 0xa4, 0xf0, 0x0a, 0xd7, 0xf6,
      0x44, 0xac, 0xd3, 0xfe, 0xf8, 0x6d, 0x43, 0xc2, 0x0c, 0x8f, 0x81, 0x58,
      0x0f, 0x04, 0x45, 0x46, 0xe6, 0x06, 0xc8, 0x7a, 0x5b, 0x07, 0x3a, 0xc8,
      0x60, 0x46, 0x2f, 0x11, 0xa0, 0x04, 0xac, 0x2f, 0xa0, 0x0f, 0x77, 0x5c,
      0xeb, 0xb9, 0x8e, 0x20, 0xd0, 0x7b, 0xdb, 0x3b, 0xfc, 0x40, 0x7f, 0x27,
      0x11, 0x26, 0x78, 0x89, 0xb0, 0xfc, 0x36, 0x57, 0x62, 0x27, 0x22, 0x76,
      0xd5, 0x09, 0xf4, 0xa9, 0xfa, 0x94, 0xb6, 0x3c, 0x40, 0x7c, 0x0a, 0xb9,
      0x8b, 0x60, 0x18, 0x37, 0xf6, 0xf5, 0xd0, 0xe5, 0x17, 0x1a, 0xd8, 0x6b,
      0x5b, 0x66, 0xaf, 0x9e, 0xb9, 0x45, 0x09, 0x95, 0x0c, 0x42, 0xf5, 0xfd,
      0x7c, 0xdb, 0x0c, 0xc9, 0xcd, 0x3d, 0x95, 0xa9, 0x6f, 0x85, 0x2b, 0x59,
      0x41, 0xeb, 0x73, 0xdb, 0x45, 0x84, 0x3a, 0xe0, 0x62, 0x51, 0x80, 0x44,
      0xce, 0x18, 0xd2, 0x00},
     {},
     priv_key_1,
     false},

    // Comment: first byte of ps modified
    // tcID: 16
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     16,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x3a, 0x88, 0xfa, 0xf7, 0xdc, 0x86, 0x58, 0x07, 0x07, 0x03, 0xee, 0xdb,
      0xaf, 0x36, 0x30, 0x2d, 0xb8, 0xe4, 0x3a, 0xec, 0x4f, 0x1c, 0xab, 0x99,
      0xa3, 0x96, 0x37, 0xcf, 0x22, 0x21, 0xf5, 0xfe, 0xb0, 0xf7, 0x16, 0xd4,
      0xfc, 0xe3, 0x89, 0x03, 0x53, 0x20, 0x55, 0xf8, 0xfb, 0x6f, 0x90, 0x36,
      0xa2, 0xe0, 0xbe, 0x53, 0x41, 0x77, 0x36, 0xbd, 0x37, 0x46, 0xa0, 0x4b,
      0xcf, 0xe4, 0x79, 0x54, 0xa6, 0x14, 0x02, 0xfc, 0xcf, 0x19, 0x85, 0x1a,
      0x22, 0x99, 0xa5, 0x4d, 0x3c, 0x63, 0x48, 0x5d, 0x69, 0xdb, 0xc5, 0x20,
      0x95, 0xbe, 0xc0, 0x83, 0x8b, 0xa8, 0x7e, 0xec, 0x63, 0x62, 0x51, 0xa2,
      0x48, 0x3d, 0x32, 0x05, 0x69, 0xd7, 0xe6, 0x2d, 0xa6, 0x16, 0xda, 0xfe,
      0x0b, 0x5f, 0x0a, 0xb8, 0xaa, 0xe2, 0xb2, 0xf9, 0x43, 0xd6, 0x58, 0x3d,
      0xbe, 0x35, 0xe2, 0x04, 0x7d, 0x50, 0xeb, 0x9b, 0x3a, 0xe9, 0xee, 0xea,
      0x5c, 0xab, 0xb5, 0x80, 0xbc, 0x34, 0x62, 0x8f, 0xe5, 0xd0, 0x0e, 0x6f,
      0x5e, 0x5e, 0x9a, 0x1b, 0x5d, 0xb8, 0x5d, 0x44, 0x6c, 0x27, 0x67, 0x49,
      0xfe, 0x47, 0xad, 0x1c, 0x49, 0x54, 0x28, 0x67, 0x7e, 0x33, 0x69, 0x8e,
      0xbd, 0xc4, 0xda, 0x12, 0x97, 0x2b, 0xcd, 0xec, 0x64, 0x31, 0x8b, 0xc7,
      0x81, 0x4e, 0x85, 0x78, 0x85, 0x1f, 0x19, 0x05, 0xa6, 0xac, 0x08, 0x74,
      0xaf, 0x69, 0x1d, 0xa2, 0x51, 0x8d, 0xaa, 0x47, 0xb9, 0xda, 0x4c, 0x9f,
      0x94, 0xe8, 0x32, 0xd9, 0xd9, 0x32, 0xb5, 0x28, 0x5e, 0xe4, 0xeb, 0x5e,
      0x50, 0x07, 0x25, 0x90, 0xf9, 0xd3, 0x07, 0x5e, 0x76, 0xf1, 0xe3, 0xd6,
      0x91, 0x26, 0x9d, 0x76, 0xda, 0xd0, 0x90, 0xd9, 0x8a, 0x6c, 0x32, 0xae,
      0xd8, 0x56, 0x7b, 0x74, 0xf4, 0xdc, 0x34, 0x3b, 0xec, 0x1c, 0xd5, 0xa5,
      0x38, 0xca, 0x79, 0x6e},
     {},
     priv_key_1,
     false},

    // Comment: ps terminated by 0xff
    // tcID: 17
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     17,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x36, 0xb2, 0xdd, 0x6a, 0xae, 0x05, 0xf5, 0xcc, 0x14, 0x3d, 0x28, 0x53,
      0x2d, 0x5e, 0x9c, 0x21, 0x07, 0xcd, 0x30, 0xcd, 0xfa, 0x69, 0xc6, 0x70,
      0x00, 0x4d, 0x61, 0x65, 0x78, 0x77, 0xcb, 0xc8, 0x0e, 0x61, 0x9d, 0x26,
      0x73, 0xca, 0x3d, 0xe8, 0x31, 0x39, 0x42, 0xf1, 0xfb, 0xc2, 0x15, 0x1e,
      0x7b, 0x2c, 0xd2, 0xab, 0x86, 0xe9, 0x1f, 0x99, 0xa3, 0x9a, 0xf4, 0x48,
      0x64, 0x99, 0x9b, 0xf1, 0x03, 0x75, 0x04, 0xfd, 0xf0, 0x56, 0x18, 0x75,
      0xe7, 0xb7, 0x13, 0xe4, 0x97, 0xda, 0x20, 0x00, 0x22, 0x0c, 0xe6, 0x15,
      0xd9, 0x33, 0xad, 0x78, 0xf0, 0x4d, 0x5c, 0xcd, 0xbf, 0x05, 0x0a, 0xff,
      0xa7, 0x29, 0x53, 0xce, 0xbe, 0x1b, 0x52, 0xfc, 0x2f, 0x27, 0x45, 0xda,
      0x7e, 0x91, 0x8a, 0x23, 0x5d, 0x5e, 0x0a, 0x55, 0xbb, 0xbb, 0x8f, 0xff,
      0x75, 0x57, 0x04, 0xad, 0xf3, 0x05, 0xff, 0xdb, 0xa1, 0x0f, 0xa5, 0x36,
      0x36, 0x1c, 0xe9, 0x84, 0x12, 0x6f, 0x0f, 0x8b, 0x72, 0x73, 0x12, 0x18,
      0xcf, 0xa4, 0xad, 0x4c, 0x6c, 0x00, 0x7a, 0x2d, 0x3b, 0x93, 0x29, 0x91,
      0x63, 0x93, 0xa9, 0x13, 0x3b, 0x80, 0xc9, 0x51, 0xa5, 0x73, 0x1f, 0x62,
      0xb1, 0xe8, 0xef, 0xf8, 0xc2, 0xc6, 0x68, 0x65, 0x26, 0x0e, 0x18, 0x04,
      0x0f, 0xc6, 0x03, 0xb2, 0x47, 0x9a, 0xee, 0x5e, 0xa7, 0x62, 0x07, 0x0c,
      0x09, 0xaf, 0x91, 0x49, 0x30, 0x0c, 0x12, 0xc9, 0xbc, 0xa1, 0x7f, 0x36,
      0x05, 0x70, 0x3b, 0x40, 0xbb, 0x91, 0x4e, 0x8d, 0xa3, 0x15, 0xd6, 0xdb,
      0x10, 0x62, 0xf5, 0x76, 0x6c, 0xd0, 0x3d, 0x9b, 0xaf, 0xc0, 0xcb, 0xab,
      0x49, 0x2d, 0xf3, 0xf2, 0xc7, 0x4f, 0x59, 0xa6, 0x5e, 0x4d, 0x3b, 0x3e,
      0xb2, 0x65, 0x19, 0xb6, 0xcf, 0x77, 0x52, 0x39, 0xd3, 0x70, 0x17, 0x40,
      0x32, 0xe2, 0xc0, 0xed},
     {},
     priv_key_1,
     false},

    // Comment: ps is all zero
    // tcID: 18
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     18,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x7c, 0x44, 0x0d, 0x60, 0x13, 0xa1, 0x8f, 0x8f, 0xe0, 0x17, 0xbe, 0x3f,
      0x55, 0x38, 0x4c, 0x3b, 0x98, 0xe0, 0x8a, 0x0d, 0xf1, 0xd7, 0x1b, 0x68,
      0xe2, 0x1c, 0x8a, 0xe7, 0x57, 0x74, 0xa8, 0x05, 0x84, 0xf9, 0x70, 0x8c,
      0x21, 0xc5, 0x6f, 0x78, 0xd0, 0xd9, 0xbf, 0xeb, 0x0b, 0xf7, 0x23, 0x18,
      0xab, 0xb6, 0x1c, 0x8c, 0x89, 0xdf, 0x56, 0xdb, 0x67, 0x26, 0x19, 0x30,
      0x90, 0x0a, 0x1e, 0x63, 0x53, 0xb7, 0xab, 0x46, 0x15, 0xbb, 0x4c, 0x5f,
      0xe5, 0x24, 0xb5, 0x91, 0xe6, 0x38, 0x3d, 0xd5, 0x4e, 0xd7, 0x74, 0x0f,
      0x0e, 0x0a, 0x5f, 0x64, 0xec, 0xb4, 0x97, 0xc3, 0xd5, 0x03, 0xd4, 0xd7,
      0xfc, 0xb2, 0x04, 0x41, 0xea, 0x1b, 0xf6, 0x78, 0xa2, 0xed, 0xb7, 0x92,
      0xdc, 0xd4, 0xc5, 0xa6, 0xc0, 0xef, 0x57, 0x0f, 0x11, 0x21, 0x2e, 0xdf,
      0x69, 0x8b, 0x24, 0x2c, 0x43, 0xeb, 0xb3, 0x08, 0x1a, 0xb1, 0x7f, 0x62,
      0x71, 0xf2, 0x8c, 0x45, 0xe3, 0x00, 0xbd, 0x36, 0x72, 0x95, 0x19, 0x5d,
      0xb3, 0xf2, 0xf1, 0x60, 0xf7, 0xd6, 0x79, 0x31, 0x92, 0xdc, 0xdf, 0x15,
      0x04, 0x9e, 0x89, 0x11, 0x3b, 0xdb, 0x4f, 0xb5, 0x26, 0x83, 0x3d, 0xb5,
      0x59, 0xe4, 0x2f, 0x93, 0x92, 0x29, 0xc2, 0xde, 0x0f, 0x1d, 0x86, 0xf0,
      0xc1, 0xb5, 0x9f, 0x6c, 0xc2, 0x7f, 0x44, 0x74, 0x4e, 0x22, 0x7b, 0x37,
      0x36, 0x73, 0xc1, 0x9d, 0x0c, 0x20, 0xc5, 0x29, 0x8f, 0xdc, 0xad, 0x47,
      0x8d, 0x2b, 0xf4, 0xbe, 0x55, 0x14, 0x01, 0x5e, 0x58, 0x40, 0xa5, 0xa2,
      0x07, 0xf2, 0xc6, 0x11, 0x88, 0x51, 0x1d, 0x45, 0x13, 0xa8, 0x74, 0xcd,
      0x98, 0x36, 0x28, 0x29, 0x84, 0x61, 0x53, 0x69, 0xef, 0x4d, 0x0d, 0x17,
      0x2b, 0x6d, 0x50, 0xa3, 0x9f, 0xd1, 0x28, 0x46, 0xf0, 0xc0, 0xcd, 0xba,
      0x4f, 0x8a, 0x6c, 0x59},
     {},
     priv_key_1,
     false},

    // Comment: ps replaced by 0xff's
    // tcID: 19
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     19,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x54, 0x0c, 0x7f, 0x1a, 0xdc, 0x69, 0xc3, 0x4a, 0x2c, 0x23, 0x0c, 0xf1,
      0xa2, 0x2a, 0x81, 0xf8, 0xa0, 0x4b, 0xde, 0x9d, 0xa4, 0xf8, 0x44, 0x00,
      0x80, 0x74, 0xf3, 0xf6, 0x88, 0x56, 0xe2, 0xf0, 0x9f, 0xea, 0x0a, 0xd1,
      0xae, 0x62, 0xdf, 0x08, 0xaf, 0xbb, 0x99, 0xb6, 0x59, 0xdb, 0x9f, 0xff,
      0xd0, 0x4f, 0x94, 0x0d, 0x4f, 0x76, 0x48, 0x29, 0xa0, 0x55, 0x90, 0x8a,
      0x13, 0xb5, 0x92, 0x63, 0x26, 0x4a, 0x85, 0x4f, 0xbe, 0x97, 0xea, 0xa2,
      0x51, 0xee, 0x50, 0x73, 0x68, 0x2f, 0xbd, 0x7f, 0x23, 0x16, 0xe9, 0xec,
      0x34, 0xa4, 0x03, 0xb0, 0x5d, 0x28, 0x5e, 0x28, 0x52, 0xa5, 0x74, 0xa2,
      0x5a, 0x29, 0xd1, 0xa1, 0xac, 0x4a, 0x6d, 0x85, 0xb7, 0x4f, 0x83, 0x31,
      0x60, 0xaa, 0x29, 0x2a, 0xae, 0x2c, 0x90, 0xf1, 0x69, 0xa8, 0x33, 0x49,
      0xd5, 0x82, 0x32, 0x59, 0x0b, 0xe8, 0x45, 0x33, 0x44, 0x8d, 0x63, 0xf7,
      0x56, 0x5d, 0x1b, 0x35, 0x30, 0xb2, 0x95, 0x91, 0x3d, 0x71, 0x07, 0x21,
      0x7d, 0x6e, 0x98, 0xdb, 0xc1, 0x84, 0x35, 0xda, 0x1b, 0xe6, 0x50, 0xab,
      0x74, 0x7c, 0x5f, 0xc8, 0x0b, 0xd3, 0xb6, 0xb3, 0xe6, 0x85, 0xbc, 0xde,
      0xd8, 0x2b, 0x90, 0x1b, 0x8b, 0x58, 0xda, 0xb7, 0xd3, 0xea, 0x18, 0x09,
      0x65, 0x35, 0xa9, 0xc7, 0x7c, 0x31, 0x44, 0xe9, 0x3a, 0x81, 0x91, 0xe0,
      0xeb, 0x2d, 0x0f, 0x99, 0x1a, 0xf3, 0x31, 0xa0, 0x3c, 0x63, 0x23, 0xc5,
      0x9a, 0x45, 0xef, 0xd1, 0xc8, 0x7a, 0x73, 0xde, 0xc2, 0x9f, 0x9f, 0x09,
      0x1b, 0x7f, 0x7d, 0xa2, 0x3f, 0x4d, 0x7d, 0xb3, 0x99, 0xce, 0xda, 0x50,
      0x61, 0x44, 0x5e, 0x13, 0x74, 0xeb, 0x75, 0x65, 0x3d, 0x84, 0x22, 0xd3,
      0x2c, 0x4f, 0x36, 0x55, 0x7e, 0xc6, 0x61, 0x28, 0xad, 0x15, 0x11, 0xa9,
      0xc3, 0x7a, 0x13, 0x2b},
     {},
     priv_key_1,
     false},

    // Comment: seed is all 0
    // tcID: 20
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     20,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x61, 0x0b, 0x4b, 0x5d, 0x2a, 0x85, 0xde, 0x68, 0x25, 0xab, 0x29, 0x36,
      0x19, 0x16, 0x23, 0x35, 0xcf, 0x8b, 0xb7, 0xb2, 0x34, 0xe2, 0xb7, 0xe3,
      0xbc, 0x89, 0x8d, 0x71, 0x23, 0xb3, 0x0f, 0x0a, 0xbe, 0x76, 0x4a, 0x0a,
      0x5c, 0x9e, 0xe8, 0x49, 0xcc, 0x10, 0x7c, 0x6e, 0x9d, 0xab, 0x86, 0xcc,
      0xe4, 0x26, 0xb4, 0x20, 0x10, 0x71, 0x9a, 0x05, 0x09, 0x6e, 0x3c, 0xc7,
      0xe0, 0xac, 0x1f, 0x01, 0x33, 0x03, 0x57, 0x56, 0xc1, 0x38, 0x0a, 0xce,
      0x2a, 0xfe, 0xe8, 0x4e, 0xa8, 0x2d, 0xe9, 0xb8, 0xf6, 0x12, 0xb7, 0xd2,
      0x92, 0x59, 0x8d, 0x85, 0x33, 0xa8, 0xce, 0x28, 0x48, 0xed, 0x6d, 0x53,
      0x9b, 0x25, 0x19, 0x01, 0x88, 0x06, 0xa1, 0x13, 0x18, 0x31, 0x7a, 0x86,
      0x4b, 0xfa, 0x2f, 0x2d, 0x55, 0xdb, 0x11, 0x0d, 0x74, 0x77, 0xd4, 0xf4,
      0xf7, 0x1a, 0xb9, 0x26, 0x14, 0x77, 0xc7, 0xd8, 0x48, 0x5b, 0xeb, 0x1c,
      0x5e, 0xba, 0x81, 0xc5, 0x25, 0x29, 0xf9, 0x8a, 0x54, 0x30, 0xd3, 0xeb,
      0x2f, 0x54, 0x0c, 0x7a, 0x66, 0xec, 0xde, 0xbe, 0xb1, 0xd7, 0x53, 0x91,
      0xcf, 0x1f, 0x2d, 0x99, 0xbe, 0x18, 0x96, 0x7f, 0xc3, 0x2f, 0xb0, 0x2b,
      0x51, 0x5d, 0x10, 0xf6, 0x0c, 0x20, 0xef, 0x63, 0xef, 0x6d, 0xa4, 0x5f,
      0x78, 0xec, 0x16, 0x92, 0xb1, 0x31, 0xb2, 0xdc, 0x8c, 0x1b, 0x33, 0x7e,
      0x78, 0xcf, 0x81, 0x97, 0x6d, 0x8e, 0x89, 0x08, 0xb4, 0xf6, 0x2c, 0x07,
      0x67, 0xbe, 0x8b, 0x3a, 0x4c, 0xd8, 0xb3, 0xcd, 0x2f, 0x7e, 0xf8, 0xb9,
      0x45, 0x4e, 0xff, 0x54, 0x79, 0x5a, 0x3e, 0xdf, 0xbf, 0xe2, 0x1c, 0xde,
      0x68, 0x0d, 0xae, 0x88, 0x54, 0x4d, 0x88, 0x62, 0x4e, 0xa2, 0x7e, 0xfd,
      0xf7, 0x2c, 0xd4, 0xbe, 0xbe, 0x4a, 0x86, 0x95, 0x1e, 0x5a, 0xfa, 0xf6,
      0x17, 0x0a, 0x23, 0x98},
     {},
     priv_key_1,
     true},

    // Comment: seed is all 1
    // tcID: 21
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     21,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x6b, 0xfe, 0x4b, 0x01, 0xa7, 0x74, 0x7e, 0x8f, 0x92, 0xa4, 0xd9, 0x13,
      0x8a, 0x2e, 0xf0, 0x34, 0xb0, 0x12, 0x72, 0x15, 0x09, 0x51, 0x45, 0xb3,
      0x6e, 0x26, 0x68, 0xe1, 0x02, 0x75, 0xc4, 0xee, 0x9b, 0xd7, 0x9e, 0x39,
      0x7f, 0x28, 0xbc, 0x94, 0x22, 0x75, 0xc9, 0xf4, 0x01, 0xe8, 0x1a, 0x3d,
      0x7f, 0x0b, 0x6e, 0x3e, 0x19, 0x10, 0x26, 0xbe, 0x64, 0x11, 0x71, 0xee,
      0x91, 0x6a, 0xf6, 0xbb, 0x4d, 0xda, 0xaa, 0x20, 0xfb, 0xe5, 0x5b, 0xe2,
      0xe2, 0x51, 0xe2, 0xaa, 0x4f, 0x07, 0xb1, 0x29, 0x1c, 0x95, 0x5a, 0xf8,
      0x78, 0x23, 0xe2, 0x13, 0x4f, 0xef, 0x3e, 0x84, 0x3c, 0x8a, 0xf3, 0xbb,
      0xd1, 0x68, 0x34, 0x41, 0x76, 0xd9, 0xfb, 0xc8, 0xd1, 0x1e, 0xc8, 0xd8,
      0xb4, 0x10, 0xfa, 0x22, 0x45, 0x30, 0xc9, 0x8b, 0x84, 0xa0, 0x1d, 0xa0,
      0x48, 0xb7, 0x61, 0x8c, 0x94, 0x4d, 0x8c, 0xc7, 0xb1, 0x8a, 0xb1, 0x7b,
      0xd4, 0x05, 0xd2, 0x62, 0xa1, 0x87, 0x05, 0x52, 0xe8, 0x27, 0xde, 0xe9,
      0xd1, 0xa8, 0x19, 0x6d, 0xdd, 0x93, 0x97, 0x5d, 0x4c, 0x48, 0x7e, 0x81,
      0x9e, 0x4b, 0x2e, 0x0c, 0xf5, 0xdc, 0x39, 0xee, 0xe5, 0x67, 0x0e, 0x24,
      0x94, 0x37, 0xc5, 0x46, 0x0d, 0xc4, 0x68, 0x47, 0x94, 0x76, 0x0e, 0x26,
      0x24, 0x4e, 0x83, 0xe0, 0x01, 0x7e, 0x3c, 0xb3, 0x7a, 0x1b, 0x59, 0x47,
      0x70, 0x9f, 0x90, 0x59, 0xd2, 0x45, 0xc5, 0xe3, 0xff, 0x23, 0xfc, 0xfe,
      0x3b, 0x10, 0x1e, 0x49, 0x6e, 0x7a, 0x22, 0x2b, 0xf9, 0x88, 0x3f, 0x2f,
      0x12, 0xe2, 0x2b, 0x0a, 0x31, 0xda, 0x93, 0x2f, 0x6e, 0xc8, 0x00, 0x3f,
      0x13, 0xa7, 0x00, 0x50, 0xe2, 0xdd, 0xa3, 0x2c, 0x01, 0xec, 0x3f, 0xb8,
      0x09, 0x08, 0x59, 0x3b, 0xfe, 0xb2, 0xc9, 0xb0, 0x6e, 0x08, 0x68, 0x73,
      0x8d, 0x54, 0x54, 0x75},
     {},
     priv_key_1,
     true},

    // Comment: First byte is 1
    // tcID: 22
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     22,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x98, 0x9d, 0x25, 0x56, 0xe8, 0xfe, 0x1a, 0x5b, 0xb1, 0x02, 0xc2, 0x81,
      0x90, 0xc8, 0xee, 0x1a, 0xbf, 0x3c, 0xe7, 0x00, 0x85, 0x7a, 0x0f, 0xe2,
      0x5e, 0x64, 0x89, 0x98, 0xda, 0xf3, 0x37, 0xbc, 0x5c, 0xd8, 0x35, 0x79,
      0x9d, 0x86, 0xa3, 0xb3, 0xc9, 0x3c, 0x7b, 0xa7, 0xfa, 0x9d, 0x7f, 0xea,
      0xda, 0x59, 0xbf, 0xe6, 0x2a, 0x6f, 0x76, 0xc6, 0x94, 0xd3, 0x7a, 0xa6,
      0xe7, 0x41, 0xc1, 0xa6, 0xa0, 0xf5, 0x5c, 0x82, 0x02, 0xb3, 0x64, 0x9d,
      0x9f, 0x13, 0x4c, 0x3f, 0x71, 0x1b, 0x9d, 0xc9, 0x07, 0xb5, 0xb8, 0xff,
      0x93, 0x23, 0x79, 0xc3, 0xb2, 0x4d, 0xa5, 0x7c, 0x46, 0x84, 0xc9, 0x9c,
      0xd9, 0x4b, 0x5f, 0x0d, 0xd3, 0x63, 0x10, 0x8c, 0x06, 0xf5, 0xb6, 0xa7,
      0xb6, 0xf7, 0x74, 0x3f, 0x46, 0xf7, 0x26, 0xd0, 0x64, 0xa4, 0xcf, 0x2d,
      0xd6, 0x3f, 0xe0, 0xc2, 0x6e, 0x02, 0xb2, 0x95, 0x0d, 0xb0, 0x39, 0x03,
      0xf1, 0x4b, 0x7b, 0x1a, 0x22, 0xe1, 0xa6, 0x86, 0x20, 0x38, 0x4c, 0xce,
      0xd1, 0xe5, 0x4e, 0xfd, 0x29, 0xb9, 0x77, 0xcb, 0xd5, 0x81, 0x86, 0xf1,
      0x0d, 0x46, 0xd5, 0x49, 0x64, 0xec, 0x04, 0xf2, 0x9b, 0x8a, 0xb3, 0xc6,
      0xb5, 0x8c, 0xbd, 0xe5, 0x63, 0x04, 0x65, 0xba, 0x34, 0x10, 0xc8, 0x14,
      0xb9, 0xda, 0x99, 0x03, 0xf8, 0x54, 0x9c, 0x84, 0x55, 0xd3, 0xf9, 0x05,
      0x0d, 0x90, 0x5b, 0xa7, 0x5c, 0x8f, 0x7f, 0xeb, 0x55, 0xa2, 0x0d, 0xc9,
      0x96, 0xd0, 0x40, 0x18, 0x4d, 0xcd, 0xc3, 0x01, 0x9f, 0x84, 0x1d, 0xab,
      0xd6, 0x57, 0xb0, 0x7c, 0xc0, 0xda, 0x57, 0x9f, 0x88, 0xea, 0xa0, 0x29,
      0x85, 0x07, 0xae, 0x6b, 0x2e, 0x5b, 0x8b, 0x0e, 0xcf, 0xab, 0xc2, 0x54,
      0x67, 0x99, 0x00, 0x36, 0x6e, 0xe7, 0x47, 0x83, 0x17, 0x60, 0xff, 0x16,
      0x67, 0xac, 0x96, 0x25},
     {},
     priv_key_1,
     false},

    // Comment: m is 0
    // tcID: 23
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     23,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00},
     {},
     priv_key_1,
     false},

    // Comment: m is 1
    // tcID: 24
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     24,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01},
     {},
     priv_key_1,
     false},

    // Comment: m is n-1
    // tcID: 25
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     25,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0xa2, 0xb4, 0x51, 0xa0, 0x7d, 0x0a, 0xa5, 0xf9, 0x6e, 0x45, 0x56, 0x71,
      0x51, 0x35, 0x50, 0x51, 0x4a, 0x8a, 0x5b, 0x46, 0x2e, 0xbe, 0xf7, 0x17,
      0x09, 0x4f, 0xa1, 0xfe, 0xe8, 0x22, 0x24, 0xe6, 0x37, 0xf9, 0x74, 0x6d,
      0x3f, 0x7c, 0xaf, 0xd3, 0x18, 0x78, 0xd8, 0x03, 0x25, 0xb6, 0xef, 0x5a,
      0x17, 0x00, 0xf6, 0x59, 0x03, 0xb4, 0x69, 0x42, 0x9e, 0x89, 0xd6, 0xea,
      0xc8, 0x84, 0x50, 0x97, 0xb5, 0xab, 0x39, 0x31, 0x89, 0xdb, 0x92, 0x51,
      0x2e, 0xd8, 0xa7, 0x71, 0x1a, 0x12, 0x53, 0xfa, 0xcd, 0x20, 0xf7, 0x9c,
      0x15, 0xe8, 0x24, 0x7f, 0x3d, 0x3e, 0x42, 0xe4, 0x6e, 0x48, 0xc9, 0x8e,
      0x25, 0x4a, 0x2f, 0xe9, 0x76, 0x53, 0x13, 0xa0, 0x3e, 0xff, 0x8f, 0x17,
      0xe1, 0xa0, 0x29, 0x39, 0x7a, 0x1f, 0xa2, 0x6a, 0x8d, 0xce, 0x26, 0xf4,
      0x90, 0xed, 0x81, 0x29, 0x96, 0x15, 0xd9, 0x81, 0x4c, 0x22, 0xda, 0x61,
      0x04, 0x28, 0xe0, 0x9c, 0x7d, 0x96, 0x58, 0x59, 0x42, 0x66, 0xf5, 0xc0,
      0x21, 0xd0, 0xfc, 0xec, 0xa0, 0x8d, 0x94, 0x5a, 0x12, 0xbe, 0x82, 0xde,
      0x4d, 0x1e, 0xce, 0x6b, 0x4c, 0x03, 0x14, 0x5b, 0x5d, 0x34, 0x95, 0xd4,
      0xed, 0x54, 0x11, 0xeb, 0x87, 0x8d, 0xaf, 0x05, 0xfd, 0x7a, 0xfc, 0x3e,
      0x09, 0xad, 0xa0, 0xf1, 0x12, 0x64, 0x22, 0xf5, 0x90, 0x97, 0x5a, 0x19,
      0x69, 0x81, 0x6f, 0x48, 0x69, 0x8b, 0xcb, 0xba, 0x1b, 0x4d, 0x9c, 0xae,
      0x79, 0xd4, 0x60, 0xd8, 0xf9, 0xf8, 0x5e, 0x79, 0x75, 0x00, 0x5d, 0x9b,
      0xc2, 0x2c, 0x4e, 0x5a, 0xc0, 0xf7, 0xc1, 0xa4, 0x5d, 0x12, 0x56, 0x9a,
      0x62, 0x80, 0x7d, 0x3b, 0x9a, 0x02, 0xe5, 0xa5, 0x30, 0xe7, 0x73, 0x06,
      0x6f, 0x45, 0x3d, 0x1f, 0x5b, 0x4c, 0x2e, 0x9c, 0xf7, 0x82, 0x02, 0x83,
      0xf7, 0x42, 0xb9, 0xd4},
     {},
     priv_key_1,
     false},

    // Comment: ciphertext is empty
    // tcID: 26
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     26,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {},
     {},
     priv_key_1,
     false},

    // Comment: prepended bytes to ciphertext
    // tcID: 27
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     27,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x00, 0x00, 0x82, 0x2e, 0x88, 0x70, 0xc0, 0x09, 0x08, 0xcb, 0xf5, 0x03,
      0x22, 0x26, 0x54, 0x7d, 0x38, 0xe4, 0x23, 0xde, 0xb9, 0x12, 0xc4, 0x9c,
      0x9f, 0xcb, 0xee, 0x66, 0x92, 0x0c, 0xd2, 0xe9, 0xe3, 0x19, 0x7b, 0x3f,
      0xd7, 0x42, 0x8c, 0xbb, 0xc5, 0xe9, 0x0e, 0x66, 0x05, 0x45, 0x72, 0x0f,
      0x18, 0x0a, 0xc0, 0xce, 0x06, 0x20, 0x5c, 0xef, 0x87, 0x35, 0x44, 0x6d,
      0xe3, 0x0d, 0xf3, 0x2c, 0x87, 0x97, 0x38, 0x0c, 0xcc, 0xe9, 0xc0, 0x51,
      0x2e, 0xb2, 0x85, 0xb7, 0xbf, 0xfd, 0x88, 0x3e, 0xf0, 0x0f, 0xe1, 0x18,
      0xf0, 0x27, 0xbd, 0xc7, 0x57, 0x00, 0xe5, 0x11, 0x22, 0x6e, 0xc4, 0xda,
      0x35, 0xf4, 0x06, 0xe4, 0x60, 0xfb, 0x88, 0xf9, 0xaf, 0x2e, 0x9c, 0x4e,
      0xc2, 0x19, 0x38, 0x76, 0x76, 0xae, 0x21, 0xca, 0xdf, 0xad, 0x0f, 0xb1,
      0xd7, 0x04, 0xbe, 0x69, 0xd0, 0xeb, 0xcd, 0xda, 0x90, 0xdf, 0xf7, 0xe1,
      0x72, 0x61, 0x2c, 0x97, 0x2c, 0x6a, 0x97, 0x4b, 0x82, 0x8a, 0xce, 0xe6,
      0xca, 0x18, 0x6c, 0x71, 0xb5, 0x03, 0x76, 0xd1, 0xed, 0x5e, 0xb6, 0xc1,
      0x07, 0x40, 0x80, 0x65, 0x47, 0x3d, 0x53, 0xa2, 0xeb, 0xed, 0xc8, 0x33,
      0xf0, 0x7f, 0x60, 0xf9, 0x09, 0xa6, 0xc4, 0x24, 0x64, 0xd7, 0x9d, 0x76,
      0xf9, 0x45, 0x31, 0xa0, 0xd3, 0x86, 0x21, 0x3f, 0xce, 0x5e, 0xfc, 0x2e,
      0x66, 0xf3, 0x11, 0xe7, 0x3b, 0x06, 0x14, 0x2f, 0x82, 0x45, 0xb0, 0x63,
      0xb9, 0xe3, 0x95, 0x72, 0x2d, 0xbe, 0xa0, 0x29, 0xda, 0xbe, 0x5e, 0xd1,
      0xc1, 0x27, 0x88, 0xb8, 0x90, 0x97, 0x4b, 0xa1, 0xd2, 0x84, 0x92, 0xcc,
      0xe2, 0xc9, 0x0e, 0x0a, 0x30, 0x26, 0xc2, 0x82, 0x96, 0x47, 0x63, 0xa0,
      0x30, 0xa7, 0xf7, 0xf3, 0xf7, 0x6a, 0x72, 0x84, 0x3a, 0x97, 0xd9, 0xee,
      0xe1, 0x7c, 0xdb, 0xbb, 0x00, 0xf4},
     {},
     priv_key_1,
     false},

    // Comment: appended bytes to ciphertext
    // tcID: 28
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     28,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x82, 0x2e, 0x88, 0x70, 0xc0, 0x09, 0x08, 0xcb, 0xf5, 0x03, 0x22, 0x26,
      0x54, 0x7d, 0x38, 0xe4, 0x23, 0xde, 0xb9, 0x12, 0xc4, 0x9c, 0x9f, 0xcb,
      0xee, 0x66, 0x92, 0x0c, 0xd2, 0xe9, 0xe3, 0x19, 0x7b, 0x3f, 0xd7, 0x42,
      0x8c, 0xbb, 0xc5, 0xe9, 0x0e, 0x66, 0x05, 0x45, 0x72, 0x0f, 0x18, 0x0a,
      0xc0, 0xce, 0x06, 0x20, 0x5c, 0xef, 0x87, 0x35, 0x44, 0x6d, 0xe3, 0x0d,
      0xf3, 0x2c, 0x87, 0x97, 0x38, 0x0c, 0xcc, 0xe9, 0xc0, 0x51, 0x2e, 0xb2,
      0x85, 0xb7, 0xbf, 0xfd, 0x88, 0x3e, 0xf0, 0x0f, 0xe1, 0x18, 0xf0, 0x27,
      0xbd, 0xc7, 0x57, 0x00, 0xe5, 0x11, 0x22, 0x6e, 0xc4, 0xda, 0x35, 0xf4,
      0x06, 0xe4, 0x60, 0xfb, 0x88, 0xf9, 0xaf, 0x2e, 0x9c, 0x4e, 0xc2, 0x19,
      0x38, 0x76, 0x76, 0xae, 0x21, 0xca, 0xdf, 0xad, 0x0f, 0xb1, 0xd7, 0x04,
      0xbe, 0x69, 0xd0, 0xeb, 0xcd, 0xda, 0x90, 0xdf, 0xf7, 0xe1, 0x72, 0x61,
      0x2c, 0x97, 0x2c, 0x6a, 0x97, 0x4b, 0x82, 0x8a, 0xce, 0xe6, 0xca, 0x18,
      0x6c, 0x71, 0xb5, 0x03, 0x76, 0xd1, 0xed, 0x5e, 0xb6, 0xc1, 0x07, 0x40,
      0x80, 0x65, 0x47, 0x3d, 0x53, 0xa2, 0xeb, 0xed, 0xc8, 0x33, 0xf0, 0x7f,
      0x60, 0xf9, 0x09, 0xa6, 0xc4, 0x24, 0x64, 0xd7, 0x9d, 0x76, 0xf9, 0x45,
      0x31, 0xa0, 0xd3, 0x86, 0x21, 0x3f, 0xce, 0x5e, 0xfc, 0x2e, 0x66, 0xf3,
      0x11, 0xe7, 0x3b, 0x06, 0x14, 0x2f, 0x82, 0x45, 0xb0, 0x63, 0xb9, 0xe3,
      0x95, 0x72, 0x2d, 0xbe, 0xa0, 0x29, 0xda, 0xbe, 0x5e, 0xd1, 0xc1, 0x27,
      0x88, 0xb8, 0x90, 0x97, 0x4b, 0xa1, 0xd2, 0x84, 0x92, 0xcc, 0xe2, 0xc9,
      0x0e, 0x0a, 0x30, 0x26, 0xc2, 0x82, 0x96, 0x47, 0x63, 0xa0, 0x30, 0xa7,
      0xf7, 0xf3, 0xf7, 0x6a, 0x72, 0x84, 0x3a, 0x97, 0xd9, 0xee, 0xe1, 0x7c,
      0xdb, 0xbb, 0x00, 0xf4, 0x00, 0x00},
     {},
     priv_key_1,
     false},

    // Comment: truncated ciphertext
    // tcID: 29
    {SEC_OID_SHA256,
     CKG_MGF1_SHA1,
     29,
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     {0x2e, 0x88, 0x70, 0xc0, 0x09, 0x08, 0xcb, 0xf5, 0x03, 0x22, 0x26, 0x54,
      0x7d, 0x38, 0xe4, 0x23, 0xde, 0xb9, 0x12, 0xc4, 0x9c, 0x9f, 0xcb, 0xee,
      0x66, 0x92, 0x0c, 0xd2, 0xe9, 0xe3, 0x19, 0x7b, 0x3f, 0xd7, 0x42, 0x8c,
      0xbb, 0xc5, 0xe9, 0x0e, 0x66, 0x05, 0x45, 0x72, 0x0f, 0x18, 0x0a, 0xc0,
      0xce, 0x06, 0x20, 0x5c, 0xef, 0x87, 0x35, 0x44, 0x6d, 0xe3, 0x0d, 0xf3,
      0x2c, 0x87, 0x97, 0x38, 0x0c, 0xcc, 0xe9, 0xc0, 0x51, 0x2e, 0xb2, 0x85,
      0xb7, 0xbf, 0xfd, 0x88, 0x3e, 0xf0, 0x0f, 0xe1, 0x18, 0xf0, 0x27, 0xbd,
      0xc7, 0x57, 0x00, 0xe5, 0x11, 0x22, 0x6e, 0xc4, 0xda, 0x35, 0xf4, 0x06,
      0xe4, 0x60, 0xfb, 0x88, 0xf9, 0xaf, 0x2e, 0x9c, 0x4e, 0xc2, 0x19, 0x38,
      0x76, 0x76, 0xae, 0x21, 0xca, 0xdf, 0xad, 0x0f, 0xb1, 0xd7, 0x04, 0xbe,
      0x69, 0xd0, 0xeb, 0xcd, 0xda, 0x90, 0xdf, 0xf7, 0xe1, 0x72, 0x61, 0x2c,
      0x97, 0x2c, 0x6a, 0x97, 0x4b, 0x82, 0x8a, 0xce, 0xe6, 0xca, 0x18, 0x6c,
      0x71, 0xb5, 0x03, 0x76, 0xd1, 0xed, 0x5e, 0xb6, 0xc1, 0x07, 0x40, 0x80,
      0x65, 0x47, 0x3d, 0x53, 0xa2, 0xeb, 0xed, 0xc8, 0x33, 0xf0, 0x7f, 0x60,
      0xf9, 0x09, 0xa6, 0xc4, 0x24, 0x64, 0xd7, 0x9d, 0x76, 0xf9, 0x45, 0x31,
      0xa0, 0xd3, 0x86, 0x21, 0x3f, 0xce, 0x5e, 0xfc, 0x2e, 0x66, 0xf3, 0x11,
      0xe7, 0x3b, 0x06, 0x14, 0x2f, 0x82, 0x45, 0xb0, 0x63, 0xb9, 0xe3, 0x95,
      0x72, 0x2d, 0xbe, 0xa0, 0x29, 0xda, 0xbe, 0x5e, 0xd1, 0xc1, 0x27, 0x88,
      0xb8, 0x90, 0x97, 0x4b, 0xa1, 0xd2, 0x84, 0x92, 0xcc, 0xe2, 0xc9, 0x0e,
      0x0a, 0x30, 0x26, 0xc2, 0x82, 0x96, 0x47, 0x63, 0xa0, 0x30, 0xa7, 0xf7,
      0xf3, 0xf7, 0x6a, 0x72, 0x84, 0x3a, 0x97, 0xd9, 0xee, 0xe1, 0x7c, 0xdb,
      0xbb, 0x00, 0xf4},
     {},
     priv_key_1,
     false}};

#endif  // rsa_oaep_2048_sha256_mgf1sha1_vectors_h__
