'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbKeyType __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeyType \- Obtain the index of a key type or the pointer to a key type
.SH SYNOPSIS
.B XkbKeyTypePtr XkbKeyType
(
.I xkb,
.I keycode,
.I group
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      KeyCode \fIkeycode\fP\^;
.br
      int \fIgroup\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description of interest
.TP
.I \- keycode
keycode of interest
.TP
.I \- group
group index
.SH DESCRIPTION
.LP
.I XkbKeyType 
returns a pointer to the key type in the 
.I types 
vector of the client map in 
.I xkb 
corresponding to the given 
.I keycode 
and 
.I group 
index.
.SH STRUCTURES
.LP
.nf

typedef struct {                             /\(** Key Type */
	XkbModsRec              mods;           /\(** modifiers used to compute shift level */
	unsigned char           num_levels;     /\(** total # shift levels, do not modify directly */
	unsigned char           map_count;      /\(** # entries in map, preserve (if non-NULL) */
	XkbKTMapEntryPtr        map;            /\(** vector of modifiers for each shift level */
	XkbModsPtr              preserve;       /\(** mods to preserve for corresponding map entry */
	Atom                    name;           /\(** name of key type */
	Atom *                  level_names;    /\(** array of names of each shift level */
} XkbKeyTypeRec, *XkbKeyTypePtr;

.fi
