/* SPDX-License-Identifier: MIT */
/*
 * Copyright 2024 Advanced Micro Devices, Inc.
 *
 */

#ifndef __IGT_COLOR_LUT_H__
#define __IGT_COLOR_LUT_H__

#include "drm_mode.h"

typedef struct igt_3dlut_norm {
	struct drm_color_lut32 lut[4913];
} igt_3dlut_norm_t;

struct igt_color_lut_float {
	float red;
	float green;
	float blue;
};

typedef struct igt_3dlut {
	struct igt_color_lut_float lut[4913];
} igt_3dlut_t;

/*
 * A 3D LUT table with 17x17x17 entries for Traversal order RGB.
 * It can be generated by scripts/convert_3dlut.py
 */
const igt_3dlut_t igt_3dlut_17_rgb = { {
	{ .red = 0.000000, .green = 0.000000, .blue = 0.000000 },
	{ .red = 0.175580, .green = 0.003419, .blue = 0.006838 },
	{ .red = 0.338706, .green = 0.015140, .blue = 0.012454 },
	{ .red = 0.492552, .green = 0.015629, .blue = 0.012454 },
	{ .red = 0.641026, .green = 0.023687, .blue = 0.013187 },
	{ .red = 0.734310, .green = 0.049817, .blue = 0.013675 },
	{ .red = 0.809035, .green = 0.063736, .blue = 0.006105 },
	{ .red = 0.884982, .green = 0.063492, .blue = 0.019048 },
	{ .red = 0.963370, .green = 0.056899, .blue = 0.028571 },
	{ .red = 0.993407, .green = 0.080586, .blue = 0.044689 },
	{ .red = 0.999267, .green = 0.099145, .blue = 0.054457 },
	{ .red = 0.999267, .green = 0.110623, .blue = 0.060317 },
	{ .red = 0.999267, .green = 0.116972, .blue = 0.064225 },
	{ .red = 0.999267, .green = 0.121612, .blue = 0.066422 },
	{ .red = 0.999267, .green = 0.126007, .blue = 0.067643 },
	{ .red = 0.999512, .green = 0.130647, .blue = 0.067888 },
	{ .red = 0.999512, .green = 0.134799, .blue = 0.067888 },
	{ .red = 0.016606, .green = 0.179976, .blue = 0.018559 },
	{ .red = 0.173382, .green = 0.173382, .blue = 0.005861 },
	{ .red = 0.328205, .green = 0.158974, .blue = 0.007082 },
	{ .red = 0.484493, .green = 0.155800, .blue = 0.003663 },
	{ .red = 0.634432, .green = 0.154090, .blue = 0.006593 },
	{ .red = 0.718437, .green = 0.145543, .blue = 0.004151 },
	{ .red = 0.794872, .green = 0.140904, .blue = 0.008791 },
	{ .red = 0.884493, .green = 0.130891, .blue = 0.003175 },
	{ .red = 0.978755, .green = 0.118681, .blue = 0.013187 },
	{ .red = 0.995116, .green = 0.126740, .blue = 0.042002 },
	{ .red = 0.998046, .green = 0.132357, .blue = 0.053236 },
	{ .red = 0.999023, .green = 0.135775, .blue = 0.059096 },
	{ .red = 0.999512, .green = 0.136752, .blue = 0.063004 },
	{ .red = 0.999512, .green = 0.137729, .blue = 0.065446 },
	{ .red = 0.999512, .green = 0.139438, .blue = 0.066667 },
	{ .red = 0.999512, .green = 0.141880, .blue = 0.067399 },
	{ .red = 0.999512, .green = 0.144567, .blue = 0.067643 },
	{ .red = 0.020757, .green = 0.326984, .blue = 0.023932 },
	{ .red = 0.161416, .green = 0.325763, .blue = 0.006838 },
	{ .red = 0.334554, .green = 0.334310, .blue = 0.008791 },
	{ .red = 0.462027, .green = 0.302564, .blue = 0.005617 },
	{ .red = 0.587790, .green = 0.288400, .blue = 0.010012 },
	{ .red = 0.672772, .green = 0.266667, .blue = 0.006105 },
	{ .red = 0.755067, .green = 0.251038, .blue = 0.005128 },
	{ .red = 0.844689, .green = 0.239560, .blue = 0.005372 },
	{ .red = 0.936508, .green = 0.229548, .blue = 0.010012 },
	{ .red = 0.990720, .green = 0.218315, .blue = 0.031013 },
	{ .red = 0.998535, .green = 0.207082, .blue = 0.046398 },
	{ .red = 0.998779, .green = 0.197802, .blue = 0.054701 },
	{ .red = 0.998535, .green = 0.189988, .blue = 0.060073 },
	{ .red = 0.999023, .green = 0.183883, .blue = 0.063248 },
	{ .red = 0.999267, .green = 0.179487, .blue = 0.064957 },
	{ .red = 0.999267, .green = 0.176801, .blue = 0.065690 },
	{ .red = 0.999512, .green = 0.174847, .blue = 0.066422 },
	{ .red = 0.044933, .green = 0.454701, .blue = 0.035409 },
	{ .red = 0.150427, .green = 0.454945, .blue = 0.008791 },
	{ .red = 0.310379, .green = 0.465934, .blue = 0.008547 },
	{ .red = 0.481807, .green = 0.481807, .blue = 0.010501 },
	{ .red = 0.573382, .green = 0.425397, .blue = 0.012454 },
	{ .red = 0.676679, .green = 0.400244, .blue = 0.009280 },
	{ .red = 0.756044, .green = 0.372405, .blue = 0.011477 },
	{ .red = 0.821001, .green = 0.346520, .blue = 0.010256 },
	{ .red = 0.872772, .green = 0.322100, .blue = 0.009768 },
	{ .red = 0.950183, .green = 0.309890, .blue = 0.010256 },
	{ .red = 0.986813, .green = 0.291819, .blue = 0.030037 },
	{ .red = 0.997802, .green = 0.273504, .blue = 0.044444 },
	{ .red = 0.996825, .green = 0.256410, .blue = 0.052015 },
	{ .red = 0.998779, .green = 0.243223, .blue = 0.056899 },
	{ .red = 0.999023, .green = 0.232967, .blue = 0.059829 },
	{ .red = 0.999023, .green = 0.224176, .blue = 0.061294 },
	{ .red = 0.999267, .green = 0.217094, .blue = 0.062271 },
	{ .red = 0.071062, .green = 0.569719, .blue = 0.048840 },
	{ .red = 0.143590, .green = 0.571673, .blue = 0.011722 },
	{ .red = 0.291087, .green = 0.581929, .blue = 0.010256 },
	{ .red = 0.449817, .green = 0.599756, .blue = 0.007570 },
	{ .red = 0.619780, .green = 0.619536, .blue = 0.012943 },
	{ .red = 0.693284, .green = 0.548962, .blue = 0.011966 },
	{ .red = 0.781685, .green = 0.513065, .blue = 0.009768 },
	{ .red = 0.847619, .green = 0.475702, .blue = 0.011233 },
	{ .red = 0.895238, .green = 0.439072, .blue = 0.011477 },
	{ .red = 0.929426, .green = 0.404884, .blue = 0.010989 },
	{ .red = 0.954823, .green = 0.374359, .blue = 0.008547 },
	{ .red = 0.975092, .green = 0.347985, .blue = 0.019048 },
	{ .red = 0.998535, .green = 0.328938, .blue = 0.032723 },
	{ .red = 0.995116, .green = 0.307937, .blue = 0.044200 },
	{ .red = 0.996825, .green = 0.291575, .blue = 0.049573 },
	{ .red = 0.997802, .green = 0.278144, .blue = 0.053480 },
	{ .red = 0.998779, .green = 0.266178, .blue = 0.055433 },
	{ .red = 0.086935, .green = 0.676679, .blue = 0.055678 },
	{ .red = 0.139927, .green = 0.680342, .blue = 0.010256 },
	{ .red = 0.277656, .green = 0.689621, .blue = 0.013675 },
	{ .red = 0.424420, .green = 0.705983, .blue = 0.010256 },
	{ .red = 0.582418, .green = 0.727473, .blue = 0.008303 },
	{ .red = 0.746764, .green = 0.746764, .blue = 0.014408 },
	{ .red = 0.805128, .green = 0.664469, .blue = 0.017582 },
	{ .red = 0.863980, .green = 0.608059, .blue = 0.016117 },
	{ .red = 0.908913, .green = 0.558242, .blue = 0.011722 },
	{ .red = 0.939927, .green = 0.512576, .blue = 0.014896 },
	{ .red = 0.962149, .green = 0.471795, .blue = 0.013919 },
	{ .red = 0.978755, .green = 0.436386, .blue = 0.010256 },
	{ .red = 0.978755, .green = 0.401709, .blue = 0.023199 },
	{ .red = 0.981685, .green = 0.373626, .blue = 0.023687 },
	{ .red = 0.993895, .green = 0.352869, .blue = 0.025641 },
	{ .red = 0.993895, .green = 0.334310, .blue = 0.038828 },
	{ .red = 0.993651, .green = 0.317949, .blue = 0.044444 },
	{ .red = 0.097192, .green = 0.774603, .blue = 0.057875 },
	{ .red = 0.137973, .green = 0.779243, .blue = 0.008303 },
	{ .red = 0.265446, .green = 0.785592, .blue = 0.011966 },
	{ .red = 0.400488, .green = 0.796581, .blue = 0.015140 },
	{ .red = 0.541880, .green = 0.810989, .blue = 0.007082 },
	{ .red = 0.689621, .green = 0.826618, .blue = 0.009035 },
	{ .red = 0.837851, .green = 0.837851, .blue = 0.014652 },
	{ .red = 0.880586, .green = 0.748474, .blue = 0.010989 },
	{ .red = 0.917705, .green = 0.678877, .blue = 0.014652 },
	{ .red = 0.947009, .green = 0.621245, .blue = 0.013675 },
	{ .red = 0.965812, .green = 0.569719, .blue = 0.018803 },
	{ .red = 0.982173, .green = 0.526252, .blue = 0.008547 },
	{ .red = 0.983150, .green = 0.484737, .blue = 0.024664 },
	{ .red = 0.981441, .green = 0.448352, .blue = 0.029548 },
	{ .red = 0.981197, .green = 0.418315, .blue = 0.030525 },
	{ .red = 0.983150, .green = 0.392918, .blue = 0.029548 },
	{ .red = 0.980464, .green = 0.369231, .blue = 0.026862 },
	{ .red = 0.101587, .green = 0.846398, .blue = 0.059096 },
	{ .red = 0.132845, .green = 0.851038, .blue = 0.011966 },
	{ .red = 0.249084, .green = 0.855189, .blue = 0.008059 },
	{ .red = 0.372405, .green = 0.862027, .blue = 0.013431 },
	{ .red = 0.499878, .green = 0.871062, .blue = 0.011966 },
	{ .red = 0.631013, .green = 0.881563, .blue = 0.011477 },
	{ .red = 0.765324, .green = 0.892063, .blue = 0.020513 },
	{ .red = 0.897680, .green = 0.897680, .blue = 0.017338 },
	{ .red = 0.928205, .green = 0.806105, .blue = 0.019780 },
	{ .red = 0.951404, .green = 0.731136, .blue = 0.016361 },
	{ .red = 0.970452, .green = 0.669597, .blue = 0.013187 },
	{ .red = 0.977534, .green = 0.613675, .blue = 0.030281 },
	{ .red = 0.981685, .green = 0.565568, .blue = 0.033700 },
	{ .red = 0.990476, .green = 0.527228, .blue = 0.024908 },
	{ .red = 0.995849, .green = 0.493040, .blue = 0.019048 },
	{ .red = 0.994383, .green = 0.461538, .blue = 0.023687 },
	{ .red = 0.990232, .green = 0.432723, .blue = 0.023443 },
	{ .red = 0.101832, .green = 0.896215, .blue = 0.062515 },
	{ .red = 0.122344, .green = 0.900855, .blue = 0.016361 },
	{ .red = 0.230525, .green = 0.903297, .blue = 0.020024 },
	{ .red = 0.343101, .green = 0.907937, .blue = 0.014896 },
	{ .red = 0.458608, .green = 0.913797, .blue = 0.014896 },
	{ .red = 0.576801, .green = 0.920391, .blue = 0.020024 },
	{ .red = 0.696703, .green = 0.927717, .blue = 0.015873 },
	{ .red = 0.818315, .green = 0.934554, .blue = 0.021245 },
	{ .red = 0.936508, .green = 0.936264, .blue = 0.016850 },
	{ .red = 0.957998, .green = 0.845665, .blue = 0.023687 },
	{ .red = 0.971184, .green = 0.768987, .blue = 0.027839 },
	{ .red = 0.978022, .green = 0.703541, .blue = 0.039805 },
	{ .red = 0.982173, .green = 0.648107, .blue = 0.041270 },
	{ .red = 0.985836, .green = 0.600977, .blue = 0.037851 },
	{ .red = 0.989011, .green = 0.560684, .blue = 0.032967 },
	{ .red = 0.992674, .green = 0.526252, .blue = 0.028571 },
	{ .red = 0.993651, .green = 0.494994, .blue = 0.022222 },
	{ .red = 0.100366, .green = 0.930159, .blue = 0.065201 },
	{ .red = 0.113309, .green = 0.935043, .blue = 0.025397 },
	{ .red = 0.211233, .green = 0.936996, .blue = 0.016361 },
	{ .red = 0.315263, .green = 0.939683, .blue = 0.012698 },
	{ .red = 0.420757, .green = 0.943590, .blue = 0.013187 },
	{ .red = 0.527717, .green = 0.947985, .blue = 0.012454 },
	{ .red = 0.636142, .green = 0.952625, .blue = 0.015873 },
	{ .red = 0.745543, .green = 0.957265, .blue = 0.017582 },
	{ .red = 0.855922, .green = 0.961661, .blue = 0.019536 },
	{ .red = 0.961172, .green = 0.960195, .blue = 0.018559 },
	{ .red = 0.976801, .green = 0.873504, .blue = 0.019048 },
	{ .red = 0.985348, .green = 0.798535, .blue = 0.021001 },
	{ .red = 0.991453, .green = 0.736020, .blue = 0.022711 },
	{ .red = 0.993407, .green = 0.680830, .blue = 0.029060 },
	{ .red = 0.995116, .green = 0.633944, .blue = 0.027106 },
	{ .red = 0.994628, .green = 0.592918, .blue = 0.029548 },
	{ .red = 0.993407, .green = 0.556288, .blue = 0.026618 },
	{ .red = 0.095238, .green = 0.952869, .blue = 0.073016 },
	{ .red = 0.106227, .green = 0.956777, .blue = 0.047619 },
	{ .red = 0.188034, .green = 0.960195, .blue = 0.012210 },
	{ .red = 0.286691, .green = 0.961905, .blue = 0.014896 },
	{ .red = 0.385348, .green = 0.963370, .blue = 0.027350 },
	{ .red = 0.483272, .green = 0.966789, .blue = 0.018559 },
	{ .red = 0.582418, .green = 0.969963, .blue = 0.010745 },
	{ .red = 0.681807, .green = 0.972650, .blue = 0.020269 },
	{ .red = 0.781929, .green = 0.975824, .blue = 0.016117 },
	{ .red = 0.882051, .green = 0.978510, .blue = 0.020513 },
	{ .red = 0.976313, .green = 0.975092, .blue = 0.019048 },
	{ .red = 0.985592, .green = 0.891331, .blue = 0.045177 },
	{ .red = 0.986081, .green = 0.816606, .blue = 0.055922 },
	{ .red = 0.986569, .green = 0.754090, .blue = 0.054457 },
	{ .red = 0.987057, .green = 0.700855, .blue = 0.050549 },
	{ .red = 0.987057, .green = 0.654945, .blue = 0.046642 },
	{ .red = 0.986813, .green = 0.614652, .blue = 0.041514 },
	{ .red = 0.105983, .green = 0.965324, .blue = 0.085958 },
	{ .red = 0.112332, .green = 0.969475, .blue = 0.067888 },
	{ .red = 0.174115, .green = 0.973871, .blue = 0.039560 },
	{ .red = 0.261783, .green = 0.976557, .blue = 0.017338 },
	{ .red = 0.355067, .green = 0.976313, .blue = 0.039805 },
	{ .red = 0.444444, .green = 0.979487, .blue = 0.022955 },
	{ .red = 0.535531, .green = 0.981197, .blue = 0.023687 },
	{ .red = 0.626618, .green = 0.981197, .blue = 0.048840 },
	{ .red = 0.716972, .green = 0.982418, .blue = 0.057143 },
	{ .red = 0.807570, .green = 0.984127, .blue = 0.063492 },
	{ .red = 0.897924, .green = 0.985836, .blue = 0.071551 },
	{ .red = 0.985348, .green = 0.983883, .blue = 0.019048 },
	{ .red = 0.988278, .green = 0.902808, .blue = 0.068620 },
	{ .red = 0.988523, .green = 0.832479, .blue = 0.063248 },
	{ .red = 0.990476, .green = 0.773871, .blue = 0.052747 },
	{ .red = 0.995116, .green = 0.725275, .blue = 0.036874 },
	{ .red = 0.994628, .green = 0.680342, .blue = 0.032967 },
	{ .red = 0.115507, .green = 0.973626, .blue = 0.093040 },
	{ .red = 0.122100, .green = 0.976557, .blue = 0.080342 },
	{ .red = 0.165568, .green = 0.981929, .blue = 0.052991 },
	{ .red = 0.242491, .green = 0.985592, .blue = 0.031502 },
	{ .red = 0.329182, .green = 0.984371, .blue = 0.047863 },
	{ .red = 0.412210, .green = 0.985836, .blue = 0.045177 },
	{ .red = 0.496215, .green = 0.984860, .blue = 0.060562 },
	{ .red = 0.578999, .green = 0.987057, .blue = 0.055189 },
	{ .red = 0.662515, .green = 0.991453, .blue = 0.018559 },
	{ .red = 0.746032, .green = 0.991453, .blue = 0.041758 },
	{ .red = 0.828327, .green = 0.990965, .blue = 0.062515 },
	{ .red = 0.910134, .green = 0.990965, .blue = 0.080342 },
	{ .red = 0.988278, .green = 0.987790, .blue = 0.063004 },
	{ .red = 0.990720, .green = 0.912332, .blue = 0.075458 },
	{ .red = 0.991941, .green = 0.846886, .blue = 0.060073 },
	{ .red = 0.997558, .green = 0.793651, .blue = 0.031990 },
	{ .red = 0.990965, .green = 0.740415, .blue = 0.048840 },
	{ .red = 0.122344, .green = 0.979243, .blue = 0.095482 },
	{ .red = 0.128205, .green = 0.981685, .blue = 0.085714 },
	{ .red = 0.160928, .green = 0.986813, .blue = 0.061050 },
	{ .red = 0.228571, .green = 0.990232, .blue = 0.044200 },
	{ .red = 0.307204, .green = 0.989744, .blue = 0.050549 },
	{ .red = 0.385348, .green = 0.988767, .blue = 0.060073 },
	{ .red = 0.461538, .green = 0.989499, .blue = 0.061294 },
	{ .red = 0.537241, .green = 0.993651, .blue = 0.037363 },
	{ .red = 0.614408, .green = 0.990232, .blue = 0.068864 },
	{ .red = 0.690598, .green = 0.989988, .blue = 0.077411 },
	{ .red = 0.768010, .green = 0.994383, .blue = 0.055189 },
	{ .red = 0.844933, .green = 0.995849, .blue = 0.049817 },
	{ .red = 0.919414, .green = 0.994139, .blue = 0.081319 },
	{ .red = 0.989499, .green = 0.989255, .blue = 0.080830 },
	{ .red = 0.992430, .green = 0.920147, .blue = 0.077167 },
	{ .red = 0.995360, .green = 0.859585, .blue = 0.052259 },
	{ .red = 0.992918, .green = 0.804151, .blue = 0.052015 },
	{ .red = 0.127717, .green = 0.982906, .blue = 0.095238 },
	{ .red = 0.132601, .green = 0.984860, .blue = 0.087668 },
	{ .red = 0.158730, .green = 0.989744, .blue = 0.065690 },
	{ .red = 0.218071, .green = 0.992674, .blue = 0.052015 },
	{ .red = 0.287668, .green = 0.993651, .blue = 0.047863 },
	{ .red = 0.362637, .green = 0.989988, .blue = 0.069353 },
	{ .red = 0.431013, .green = 0.993407, .blue = 0.054701 },
	{ .red = 0.502808, .green = 0.991453, .blue = 0.069109 },
	{ .red = 0.573382, .green = 0.992186, .blue = 0.069353 },
	{ .red = 0.644444, .green = 0.995604, .blue = 0.051526 },
	{ .red = 0.714530, .green = 0.992674, .blue = 0.076435 },
	{ .red = 0.784615, .green = 0.992674, .blue = 0.083272 },
	{ .red = 0.857631, .green = 0.997802, .blue = 0.047619 },
	{ .red = 0.926252, .green = 0.995849, .blue = 0.079365 },
	{ .red = 0.989988, .green = 0.990232, .blue = 0.089133 },
	{ .red = 0.993407, .green = 0.926252, .blue = 0.076435 },
	{ .red = 0.997314, .green = 0.870085, .blue = 0.042491 },
	{ .red = 0.131868, .green = 0.985592, .blue = 0.093284 },
	{ .red = 0.136020, .green = 0.987057, .blue = 0.087179 },
	{ .red = 0.157998, .green = 0.991209, .blue = 0.068376 },
	{ .red = 0.210256, .green = 0.993895, .blue = 0.056654 },
	{ .red = 0.270085, .green = 0.996825, .blue = 0.038584 },
	{ .red = 0.343101, .green = 0.990965, .blue = 0.072772 },
	{ .red = 0.404884, .green = 0.995116, .blue = 0.054212 },
	{ .red = 0.472772, .green = 0.991453, .blue = 0.074969 },
	{ .red = 0.536752, .green = 0.997314, .blue = 0.043223 },
	{ .red = 0.603419, .green = 0.991941, .blue = 0.077900 },
	{ .red = 0.669109, .green = 0.994139, .blue = 0.070085 },
	{ .red = 0.735287, .green = 0.995849, .blue = 0.063492 },
	{ .red = 0.799512, .green = 0.993407, .blue = 0.085470 },
	{ .red = 0.866178, .green = 0.995849, .blue = 0.074969 },
	{ .red = 0.931624, .green = 0.996581, .blue = 0.076190 },
	{ .red = 0.989988, .green = 0.990965, .blue = 0.092308 },
	{ .red = 0.994383, .green = 0.931624, .blue = 0.074725 },
	{ .red = 0.135287, .green = 0.987302, .blue = 0.090842 },
	{ .red = 0.138706, .green = 0.988767, .blue = 0.085226 },
	{ .red = 0.158486, .green = 0.992186, .blue = 0.069597 },
	{ .red = 0.204640, .green = 0.994628, .blue = 0.059829 },
	{ .red = 0.254457, .green = 0.999267, .blue = 0.022466 },
	{ .red = 0.325763, .green = 0.991941, .blue = 0.073016 },
	{ .red = 0.384615, .green = 0.993407, .blue = 0.066911 },
	{ .red = 0.445665, .green = 0.993162, .blue = 0.070330 },
	{ .red = 0.506716, .green = 0.993407, .blue = 0.070330 },
	{ .red = 0.568010, .green = 0.993895, .blue = 0.069841 },
	{ .red = 0.629304, .green = 0.995116, .blue = 0.065446 },
	{ .red = 0.690110, .green = 0.992186, .blue = 0.084249 },
	{ .red = 0.753358, .green = 0.998291, .blue = 0.046154 },
	{ .red = 0.812698, .green = 0.994383, .blue = 0.081807 },
	{ .red = 0.873748, .green = 0.995116, .blue = 0.083761 },
	{ .red = 0.936020, .green = 0.997070, .blue = 0.073016 },
	{ .red = 0.989988, .green = 0.991209, .blue = 0.092796 },
	{ .red = 0.010745, .green = 0.008059, .blue = 0.156532 },
	{ .red = 0.173382, .green = 0.005372, .blue = 0.173626 },
	{ .red = 0.344078, .green = 0.008059, .blue = 0.169719 },
	{ .red = 0.495971, .green = 0.007814, .blue = 0.163858 },
	{ .red = 0.640293, .green = 0.014408, .blue = 0.159463 },
	{ .red = 0.725763, .green = 0.015140, .blue = 0.143834 },
	{ .red = 0.795360, .green = 0.013919, .blue = 0.129915 },
	{ .red = 0.861050, .green = 0.012454, .blue = 0.121368 },
	{ .red = 0.926252, .green = 0.014408, .blue = 0.116239 },
	{ .red = 0.979976, .green = 0.025397, .blue = 0.111844 },
	{ .red = 0.991209, .green = 0.059829, .blue = 0.106227 },
	{ .red = 0.995849, .green = 0.075214, .blue = 0.101099 },
	{ .red = 0.998046, .green = 0.084005, .blue = 0.096703 },
	{ .red = 0.998779, .green = 0.090354, .blue = 0.092552 },
	{ .red = 0.999267, .green = 0.095726, .blue = 0.088645 },
	{ .red = 0.999756, .green = 0.100366, .blue = 0.084249 },
	{ .red = 0.999512, .green = 0.109158, .blue = 0.082051 },
	{ .red = 0.011722, .green = 0.216117, .blue = 0.216117 },
	{ .red = 0.147253, .green = 0.147009, .blue = 0.147253 },
	{ .red = 0.326007, .green = 0.137973, .blue = 0.143834 },
	{ .red = 0.495726, .green = 0.120147, .blue = 0.139438 },
	{ .red = 0.662759, .green = 0.088156, .blue = 0.134554 },
	{ .red = 0.815140, .green = 0.010012, .blue = 0.128449 },
	{ .red = 0.889866, .green = 0.015385, .blue = 0.119902 },
	{ .red = 0.953358, .green = 0.013919, .blue = 0.114042 },
	{ .red = 0.988034, .green = 0.051038, .blue = 0.109402 },
	{ .red = 0.995116, .green = 0.075458, .blue = 0.104274 },
	{ .red = 0.997802, .green = 0.087179, .blue = 0.099389 },
	{ .red = 0.998779, .green = 0.094505, .blue = 0.094750 },
	{ .red = 0.999267, .green = 0.099145, .blue = 0.091331 },
	{ .red = 0.999512, .green = 0.105006, .blue = 0.088889 },
	{ .red = 0.999512, .green = 0.119658, .blue = 0.089621 },
	{ .red = 0.999512, .green = 0.135287, .blue = 0.091575 },
	{ .red = 0.999512, .green = 0.148230, .blue = 0.093284 },
	{ .red = 0.013675, .green = 0.354823, .blue = 0.199756 },
	{ .red = 0.084493, .green = 0.298168, .blue = 0.128694 },
	{ .red = 0.299389, .green = 0.296947, .blue = 0.134310 },
	{ .red = 0.474969, .green = 0.293284, .blue = 0.131624 },
	{ .red = 0.645665, .green = 0.286447, .blue = 0.124298 },
	{ .red = 0.814164, .green = 0.275702, .blue = 0.115995 },
	{ .red = 0.982418, .green = 0.259829, .blue = 0.108181 },
	{ .red = 0.999267, .green = 0.239316, .blue = 0.108913 },
	{ .red = 0.999756, .green = 0.232723, .blue = 0.114286 },
	{ .red = 0.999512, .green = 0.231746, .blue = 0.119658 },
	{ .red = 0.999267, .green = 0.232723, .blue = 0.124054 },
	{ .red = 0.999267, .green = 0.234188, .blue = 0.127228 },
	{ .red = 0.999267, .green = 0.233211, .blue = 0.128449 },
	{ .red = 0.999267, .green = 0.231502, .blue = 0.128205 },
	{ .red = 0.999267, .green = 0.230525, .blue = 0.127228 },
	{ .red = 0.999267, .green = 0.230037, .blue = 0.126252 },
	{ .red = 0.999267, .green = 0.229304, .blue = 0.124786 },
	{ .red = 0.008303, .green = 0.469841, .blue = 0.183883 },
	{ .red = 0.012698, .green = 0.454212, .blue = 0.132845 },
	{ .red = 0.268376, .green = 0.445665, .blue = 0.097924 },
	{ .red = 0.450794, .green = 0.446154, .blue = 0.105739 },
	{ .red = 0.626862, .green = 0.443223, .blue = 0.104274 },
	{ .red = 0.798779, .green = 0.437851, .blue = 0.097924 },
	{ .red = 0.969719, .green = 0.429304, .blue = 0.088889 },
	{ .red = 0.999512, .green = 0.387302, .blue = 0.101099 },
	{ .red = 0.998779, .green = 0.353846, .blue = 0.112088 },
	{ .red = 0.999267, .green = 0.330891, .blue = 0.118926 },
	{ .red = 0.999023, .green = 0.314286, .blue = 0.123565 },
	{ .red = 0.999756, .green = 0.302320, .blue = 0.127228 },
	{ .red = 0.999267, .green = 0.292796, .blue = 0.129670 },
	{ .red = 0.998779, .green = 0.284493, .blue = 0.130403 },
	{ .red = 0.999023, .green = 0.276923, .blue = 0.129182 },
	{ .red = 0.999512, .green = 0.269597, .blue = 0.126984 },
	{ .red = 0.999756, .green = 0.262027, .blue = 0.123810 },
	{ .red = 0.001954, .green = 0.578999, .blue = 0.172405 },
	{ .red = 0.000000, .green = 0.581197, .blue = 0.134554 },
	{ .red = 0.224908, .green = 0.591697, .blue = 0.009035 },
	{ .red = 0.425153, .green = 0.594872, .blue = 0.011722 },
	{ .red = 0.602442, .green = 0.595849, .blue = 0.011477 },
	{ .red = 0.776801, .green = 0.590232, .blue = 0.013919 },
	{ .red = 0.937973, .green = 0.579243, .blue = 0.010501 },
	{ .red = 0.998535, .green = 0.529670, .blue = 0.074969 },
	{ .red = 0.999512, .green = 0.474725, .blue = 0.102564 },
	{ .red = 0.999267, .green = 0.433211, .blue = 0.113797 },
	{ .red = 0.999512, .green = 0.401221, .blue = 0.119170 },
	{ .red = 0.998779, .green = 0.377045, .blue = 0.124054 },
	{ .red = 0.998535, .green = 0.357265, .blue = 0.126496 },
	{ .red = 0.999023, .green = 0.340904, .blue = 0.126984 },
	{ .red = 0.999512, .green = 0.326740, .blue = 0.125763 },
	{ .red = 0.999267, .green = 0.313309, .blue = 0.123077 },
	{ .red = 0.999756, .green = 0.301587, .blue = 0.120147 },
	{ .red = 0.012698, .green = 0.683761, .blue = 0.163370 },
	{ .red = 0.012210, .green = 0.692552, .blue = 0.131136 },
	{ .red = 0.206593, .green = 0.713797, .blue = 0.012454 },
	{ .red = 0.401465, .green = 0.724054, .blue = 0.012454 },
	{ .red = 0.577534, .green = 0.735531, .blue = 0.007326 },
	{ .red = 0.747009, .green = 0.741392, .blue = 0.013431 },
	{ .red = 0.863980, .green = 0.696703, .blue = 0.014896 },
	{ .red = 0.962882, .green = 0.654945, .blue = 0.018315 },
	{ .red = 0.998779, .green = 0.596337, .blue = 0.077411 },
	{ .red = 0.999756, .green = 0.539438, .blue = 0.105739 },
	{ .red = 0.999267, .green = 0.494505, .blue = 0.116728 },
	{ .red = 0.998779, .green = 0.457875, .blue = 0.120879 },
	{ .red = 0.999023, .green = 0.427595, .blue = 0.121123 },
	{ .red = 0.999512, .green = 0.401954, .blue = 0.119658 },
	{ .red = 0.998779, .green = 0.381197, .blue = 0.119170 },
	{ .red = 0.998535, .green = 0.362882, .blue = 0.117460 },
	{ .red = 0.998779, .green = 0.346032, .blue = 0.114042 },
	{ .red = 0.000000, .green = 0.780952, .blue = 0.154335 },
	{ .red = 0.008547, .green = 0.791697, .blue = 0.125275 },
	{ .red = 0.191941, .green = 0.814164, .blue = 0.013675 },
	{ .red = 0.374359, .green = 0.821978, .blue = 0.010501 },
	{ .red = 0.535775, .green = 0.830769, .blue = 0.012943 },
	{ .red = 0.693284, .green = 0.838828, .blue = 0.007326 },
	{ .red = 0.844444, .green = 0.840049, .blue = 0.013187 },
	{ .red = 0.921368, .green = 0.771673, .blue = 0.017582 },
	{ .red = 0.979731, .green = 0.710623, .blue = 0.035897 },
	{ .red = 0.999267, .green = 0.646642, .blue = 0.085470 },
	{ .red = 0.998779, .green = 0.589255, .blue = 0.109402 },
	{ .red = 0.999756, .green = 0.543101, .blue = 0.117705 },
	{ .red = 0.999756, .green = 0.504518, .blue = 0.119902 },
	{ .red = 0.999267, .green = 0.471306, .blue = 0.118681 },
	{ .red = 0.999267, .green = 0.442491, .blue = 0.115018 },
	{ .red = 0.999023, .green = 0.417094, .blue = 0.110379 },
	{ .red = 0.999512, .green = 0.394628, .blue = 0.105250 },
	{ .red = 0.000000, .green = 0.852503, .blue = 0.143834 },
	{ .red = 0.033455, .green = 0.862027, .blue = 0.118437 },
	{ .red = 0.175824, .green = 0.882295, .blue = 0.014164 },
	{ .red = 0.343346, .green = 0.887179, .blue = 0.015629 },
	{ .red = 0.489866, .green = 0.893284, .blue = 0.011966 },
	{ .red = 0.631746, .green = 0.899389, .blue = 0.015385 },
	{ .red = 0.771917, .green = 0.904029, .blue = 0.021734 },
	{ .red = 0.905739, .green = 0.902564, .blue = 0.015873 },
	{ .red = 0.957998, .green = 0.823687, .blue = 0.015385 },
	{ .red = 0.987546, .green = 0.750183, .blue = 0.054945 },
	{ .red = 0.999023, .green = 0.686203, .blue = 0.094261 },
	{ .red = 0.999023, .green = 0.629304, .blue = 0.111355 },
	{ .red = 0.998779, .green = 0.582418, .blue = 0.116972 },
	{ .red = 0.999756, .green = 0.542857, .blue = 0.116728 },
	{ .red = 0.999756, .green = 0.508425, .blue = 0.114042 },
	{ .red = 0.999512, .green = 0.477900, .blue = 0.109646 },
	{ .red = 0.998779, .green = 0.450794, .blue = 0.104029 },
	{ .red = 0.018071, .green = 0.901587, .blue = 0.134554 },
	{ .red = 0.055922, .green = 0.908913, .blue = 0.114774 },
	{ .red = 0.157509, .green = 0.927717, .blue = 0.016361 },
	{ .red = 0.312088, .green = 0.930891, .blue = 0.011966 },
	{ .red = 0.445421, .green = 0.934799, .blue = 0.012454 },
	{ .red = 0.573871, .green = 0.938950, .blue = 0.016361 },
	{ .red = 0.700366, .green = 0.942613, .blue = 0.015385 },
	{ .red = 0.825397, .green = 0.945055, .blue = 0.021245 },
	{ .red = 0.944078, .green = 0.941392, .blue = 0.016606 },
	{ .red = 0.978755, .green = 0.858364, .blue = 0.032723 },
	{ .red = 0.998779, .green = 0.785104, .blue = 0.063736 },
	{ .red = 0.999512, .green = 0.717705, .blue = 0.100611 },
	{ .red = 0.998779, .green = 0.662027, .blue = 0.111600 },
	{ .red = 0.999267, .green = 0.615385, .blue = 0.113797 },
	{ .red = 0.999512, .green = 0.575092, .blue = 0.112088 },
	{ .red = 0.999756, .green = 0.539927, .blue = 0.107937 },
	{ .red = 0.999756, .green = 0.508669, .blue = 0.102564 },
	{ .red = 0.046642, .green = 0.934554, .blue = 0.127961 },
	{ .red = 0.069109, .green = 0.940415, .blue = 0.111355 },
	{ .red = 0.140171, .green = 0.957998, .blue = 0.013431 },
	{ .red = 0.284249, .green = 0.959951, .blue = 0.014896 },
	{ .red = 0.406105, .green = 0.961661, .blue = 0.027839 },
	{ .red = 0.522100, .green = 0.964591, .blue = 0.023932 },
	{ .red = 0.636386, .green = 0.967033, .blue = 0.025397 },
	{ .red = 0.749939, .green = 0.969475, .blue = 0.015873 },
	{ .red = 0.862271, .green = 0.970452, .blue = 0.018071 },
	{ .red = 0.968010, .green = 0.964835, .blue = 0.018559 },
	{ .red = 0.992186, .green = 0.883028, .blue = 0.030525 },
	{ .red = 0.997558, .green = 0.806838, .blue = 0.086447 },
	{ .red = 0.998779, .green = 0.743101, .blue = 0.104274 },
	{ .red = 0.999267, .green = 0.689133, .blue = 0.109402 },
	{ .red = 0.999023, .green = 0.642735, .blue = 0.109402 },
	{ .red = 0.999267, .green = 0.602686, .blue = 0.105983 },
	{ .red = 0.999267, .green = 0.567277, .blue = 0.100855 },
	{ .red = 0.067643, .green = 0.954823, .blue = 0.127473 },
	{ .red = 0.086447, .green = 0.958974, .blue = 0.115507 },
	{ .red = 0.125031, .green = 0.976068, .blue = 0.039560 },
	{ .red = 0.255189, .green = 0.979243, .blue = 0.018071 },
	{ .red = 0.370696, .green = 0.977778, .blue = 0.047375 },
	{ .red = 0.476190, .green = 0.979976, .blue = 0.043956 },
	{ .red = 0.580220, .green = 0.982418, .blue = 0.037118 },
	{ .red = 0.683272, .green = 0.982662, .blue = 0.048107 },
	{ .red = 0.785348, .green = 0.983639, .blue = 0.052747 },
	{ .red = 0.886447, .green = 0.984127, .blue = 0.056410 },
	{ .red = 0.982173, .green = 0.979243, .blue = 0.019048 },
	{ .red = 0.992918, .green = 0.895971, .blue = 0.077167 },
	{ .red = 0.999023, .green = 0.825885, .blue = 0.093773 },
	{ .red = 0.999512, .green = 0.764347, .blue = 0.103541 },
	{ .red = 0.999267, .green = 0.711844, .blue = 0.105250 },
	{ .red = 0.999023, .green = 0.666422, .blue = 0.103297 },
	{ .red = 0.999023, .green = 0.626618, .blue = 0.098657 },
	{ .red = 0.082295, .green = 0.968010, .blue = 0.126984 },
	{ .red = 0.097924, .green = 0.970940, .blue = 0.117949 },
	{ .red = 0.133333, .green = 0.983639, .blue = 0.070818 },
	{ .red = 0.234188, .green = 0.989744, .blue = 0.040293 },
	{ .red = 0.341636, .green = 0.987057, .blue = 0.062027 },
	{ .red = 0.436142, .green = 0.991209, .blue = 0.041758 },
	{ .red = 0.531868, .green = 0.991941, .blue = 0.043956 },
	{ .red = 0.626129, .green = 0.990476, .blue = 0.061294 },
	{ .red = 0.718926, .green = 0.990476, .blue = 0.069353 },
	{ .red = 0.810989, .green = 0.990476, .blue = 0.074725 },
	{ .red = 0.902076, .green = 0.990476, .blue = 0.083028 },
	{ .red = 0.988767, .green = 0.986325, .blue = 0.056410 },
	{ .red = 0.995849, .green = 0.908181, .blue = 0.088889 },
	{ .red = 0.998779, .green = 0.840537, .blue = 0.097924 },
	{ .red = 0.999023, .green = 0.781685, .blue = 0.101099 },
	{ .red = 0.999267, .green = 0.731136, .blue = 0.099634 },
	{ .red = 0.999023, .green = 0.686935, .blue = 0.095971 },
	{ .red = 0.096703, .green = 0.976068, .blue = 0.126007 },
	{ .red = 0.107448, .green = 0.978755, .blue = 0.117949 },
	{ .red = 0.138950, .green = 0.988523, .blue = 0.083272 },
	{ .red = 0.219048, .green = 0.995360, .blue = 0.053724 },
	{ .red = 0.317705, .green = 0.992186, .blue = 0.071062 },
	{ .red = 0.403663, .green = 0.996093, .blue = 0.056654 },
	{ .red = 0.492796, .green = 0.993162, .blue = 0.077167 },
	{ .red = 0.578022, .green = 0.993407, .blue = 0.080586 },
	{ .red = 0.663004, .green = 0.996581, .blue = 0.067643 },
	{ .red = 0.748230, .green = 0.998291, .blue = 0.056410 },
	{ .red = 0.831746, .green = 0.996825, .blue = 0.069597 },
	{ .red = 0.913797, .green = 0.995116, .blue = 0.087424 },
	{ .red = 0.990720, .green = 0.989255, .blue = 0.087912 },
	{ .red = 0.998779, .green = 0.918437, .blue = 0.091575 },
	{ .red = 0.998779, .green = 0.852503, .blue = 0.096703 },
	{ .red = 0.999267, .green = 0.796581, .blue = 0.096215 },
	{ .red = 0.998779, .green = 0.747497, .blue = 0.093773 },
	{ .red = 0.111844, .green = 0.980708, .blue = 0.125031 },
	{ .red = 0.118926, .green = 0.982906, .blue = 0.117949 },
	{ .red = 0.142369, .green = 0.991697, .blue = 0.088645 },
	{ .red = 0.221001, .green = 0.999512, .blue = 0.083516 },
	{ .red = 0.305250, .green = 0.997314, .blue = 0.091087 },
	{ .red = 0.382173, .green = 0.999267, .blue = 0.084982 },
	{ .red = 0.462027, .green = 0.996581, .blue = 0.094505 },
	{ .red = 0.538706, .green = 0.999512, .blue = 0.084737 },
	{ .red = 0.616606, .green = 0.999023, .blue = 0.087179 },
	{ .red = 0.693284, .green = 0.996581, .blue = 0.097436 },
	{ .red = 0.770208, .green = 0.997558, .blue = 0.093773 },
	{ .red = 0.847863, .green = 0.999756, .blue = 0.079609 },
	{ .red = 0.923565, .green = 0.998779, .blue = 0.087668 },
	{ .red = 0.991697, .green = 0.991209, .blue = 0.102808 },
	{ .red = 0.999267, .green = 0.925275, .blue = 0.093040 },
	{ .red = 0.998535, .green = 0.863004, .blue = 0.094505 },
	{ .red = 0.998046, .green = 0.809035, .blue = 0.091819 },
	{ .red = 0.122100, .green = 0.983639, .blue = 0.122344 },
	{ .red = 0.127961, .green = 0.985592, .blue = 0.116484 },
	{ .red = 0.154335, .green = 0.995360, .blue = 0.098168 },
	{ .red = 0.226374, .green = 0.999512, .blue = 0.103297 },
	{ .red = 0.295238, .green = 0.999267, .blue = 0.103053 },
	{ .red = 0.364347, .green = 0.999756, .blue = 0.100611 },
	{ .red = 0.435897, .green = 0.998291, .blue = 0.104518 },
	{ .red = 0.505495, .green = 0.999756, .blue = 0.098901 },
	{ .red = 0.576557, .green = 0.997802, .blue = 0.104029 },
	{ .red = 0.647131, .green = 0.998291, .blue = 0.101343 },
	{ .red = 0.717949, .green = 0.998779, .blue = 0.098168 },
	{ .red = 0.788034, .green = 0.997802, .blue = 0.102808 },
	{ .red = 0.858852, .green = 0.998779, .blue = 0.096947 },
	{ .red = 0.929670, .green = 0.999512, .blue = 0.093284 },
	{ .red = 0.991941, .green = 0.991941, .blue = 0.107692 },
	{ .red = 0.999023, .green = 0.930647, .blue = 0.090598 },
	{ .red = 0.998291, .green = 0.871551, .blue = 0.088889 },
	{ .red = 0.129182, .green = 0.985592, .blue = 0.118681 },
	{ .red = 0.133333, .green = 0.987546, .blue = 0.113065 },
	{ .red = 0.165568, .green = 0.996337, .blue = 0.105250 },
	{ .red = 0.226862, .green = 0.999512, .blue = 0.110867 },
	{ .red = 0.285714, .green = 0.999756, .blue = 0.108913 },
	{ .red = 0.347985, .green = 1.000000, .blue = 0.107204 },
	{ .red = 0.412210, .green = 0.999267, .blue = 0.107204 },
	{ .red = 0.476190, .green = 0.999756, .blue = 0.103297 },
	{ .red = 0.541636, .green = 0.999267, .blue = 0.103297 },
	{ .red = 0.606838, .green = 0.999023, .blue = 0.102320 },
	{ .red = 0.672039, .green = 0.997802, .blue = 0.105006 },
	{ .red = 0.737729, .green = 0.999023, .blue = 0.098657 },
	{ .red = 0.803175, .green = 0.998779, .blue = 0.098168 },
	{ .red = 0.867888, .green = 0.998046, .blue = 0.104029 },
	{ .red = 0.934310, .green = 0.999512, .blue = 0.092796 },
	{ .red = 0.991941, .green = 0.992430, .blue = 0.108181 },
	{ .red = 0.998779, .green = 0.935043, .blue = 0.086447 },
	{ .red = 0.133333, .green = 0.987546, .blue = 0.113553 },
	{ .red = 0.136508, .green = 0.989011, .blue = 0.108181 },
	{ .red = 0.170940, .green = 0.997070, .blue = 0.107204 },
	{ .red = 0.223932, .green = 0.999512, .blue = 0.112088 },
	{ .red = 0.276190, .green = 0.999756, .blue = 0.110134 },
	{ .red = 0.332357, .green = 1.000000, .blue = 0.108181 },
	{ .red = 0.391209, .green = 0.999512, .blue = 0.107204 },
	{ .red = 0.451282, .green = 0.998535, .blue = 0.107692 },
	{ .red = 0.510867, .green = 0.999512, .blue = 0.101832 },
	{ .red = 0.571673, .green = 0.998046, .blue = 0.105006 },
	{ .red = 0.632479, .green = 0.998779, .blue = 0.099389 },
	{ .red = 0.693284, .green = 0.997802, .blue = 0.101832 },
	{ .red = 0.754823, .green = 0.999023, .blue = 0.095482 },
	{ .red = 0.815873, .green = 0.999023, .blue = 0.093529 },
	{ .red = 0.875702, .green = 0.997314, .blue = 0.103785 },
	{ .red = 0.938462, .green = 0.999512, .blue = 0.088400 },
	{ .red = 0.991453, .green = 0.992430, .blue = 0.106471 },
	{ .red = 0.015385, .green = 0.007814, .blue = 0.294994 },
	{ .red = 0.162882, .green = 0.007326, .blue = 0.296215 },
	{ .red = 0.327961, .green = 0.007570, .blue = 0.328205 },
	{ .red = 0.486935, .green = 0.006838, .blue = 0.320879 },
	{ .red = 0.632967, .green = 0.010501, .blue = 0.313065 },
	{ .red = 0.707937, .green = 0.013431, .blue = 0.280830 },
	{ .red = 0.769963, .green = 0.010745, .blue = 0.254945 },
	{ .red = 0.830281, .green = 0.010989, .blue = 0.237118 },
	{ .red = 0.891575, .green = 0.012210, .blue = 0.224664 },
	{ .red = 0.944567, .green = 0.013187, .blue = 0.213187 },
	{ .red = 0.987790, .green = 0.018803, .blue = 0.202442 },
	{ .red = 0.999267, .green = 0.049573, .blue = 0.188767 },
	{ .red = 0.999512, .green = 0.070085, .blue = 0.176313 },
	{ .red = 0.996337, .green = 0.081074, .blue = 0.164835 },
	{ .red = 0.997558, .green = 0.086691, .blue = 0.154823 },
	{ .red = 0.999267, .green = 0.090842, .blue = 0.145543 },
	{ .red = 0.999756, .green = 0.096215, .blue = 0.137485 },
	{ .red = 0.006838, .green = 0.154090, .blue = 0.289621 },
	{ .red = 0.150183, .green = 0.137973, .blue = 0.297680 },
	{ .red = 0.314286, .green = 0.133822, .blue = 0.313553 },
	{ .red = 0.491331, .green = 0.110379, .blue = 0.310379 },
	{ .red = 0.663248, .green = 0.059829, .blue = 0.303785 },
	{ .red = 0.774115, .green = 0.016850, .blue = 0.284005 },
	{ .red = 0.840781, .green = 0.016606, .blue = 0.260317 },
	{ .red = 0.900855, .green = 0.010745, .blue = 0.242979 },
	{ .red = 0.956288, .green = 0.015873, .blue = 0.229304 },
	{ .red = 0.985836, .green = 0.049084, .blue = 0.214652 },
	{ .red = 0.996337, .green = 0.066178, .blue = 0.199023 },
	{ .red = 0.999267, .green = 0.077656, .blue = 0.184860 },
	{ .red = 0.999267, .green = 0.087424, .blue = 0.172894 },
	{ .red = 0.998535, .green = 0.092552, .blue = 0.161905 },
	{ .red = 0.999756, .green = 0.109158, .blue = 0.155067 },
	{ .red = 0.999756, .green = 0.123321, .blue = 0.149206 },
	{ .red = 0.999512, .green = 0.135775, .blue = 0.144322 },
	{ .red = 0.021490, .green = 0.377289, .blue = 0.377289 },
	{ .red = 0.021245, .green = 0.306960, .blue = 0.308425 },
	{ .red = 0.295238, .green = 0.294750, .blue = 0.294994 },
	{ .red = 0.478632, .green = 0.287668, .blue = 0.292308 },
	{ .red = 0.652747, .green = 0.276679, .blue = 0.289133 },
	{ .red = 0.823199, .green = 0.261294, .blue = 0.285226 },
	{ .red = 0.992186, .green = 0.240049, .blue = 0.282784 },
	{ .red = 0.999512, .green = 0.226862, .blue = 0.259341 },
	{ .red = 0.999267, .green = 0.223932, .blue = 0.242002 },
	{ .red = 0.999267, .green = 0.223443, .blue = 0.227839 },
	{ .red = 0.999512, .green = 0.223687, .blue = 0.216117 },
	{ .red = 0.998535, .green = 0.223687, .blue = 0.205861 },
	{ .red = 0.999267, .green = 0.222955, .blue = 0.197070 },
	{ .red = 0.999756, .green = 0.221978, .blue = 0.188767 },
	{ .red = 0.998779, .green = 0.221978, .blue = 0.181441 },
	{ .red = 0.998779, .green = 0.221490, .blue = 0.174359 },
	{ .red = 0.999023, .green = 0.220757, .blue = 0.168010 },
	{ .red = 0.024176, .green = 0.494505, .blue = 0.355800 },
	{ .red = 0.013431, .green = 0.476190, .blue = 0.325763 },
	{ .red = 0.249817, .green = 0.447375, .blue = 0.280098 },
	{ .red = 0.447863, .green = 0.444933, .blue = 0.284982 },
	{ .red = 0.625641, .green = 0.441758, .blue = 0.282295 },
	{ .red = 0.800000, .green = 0.435653, .blue = 0.276190 },
	{ .red = 0.972161, .green = 0.425885, .blue = 0.271062 },
	{ .red = 0.999267, .green = 0.410745, .blue = 0.275458 },
	{ .red = 0.999267, .green = 0.396825, .blue = 0.274969 },
	{ .red = 0.999023, .green = 0.385104, .blue = 0.270085 },
	{ .red = 0.999023, .green = 0.374603, .blue = 0.263004 },
	{ .red = 0.998779, .green = 0.364347, .blue = 0.254701 },
	{ .red = 0.998779, .green = 0.354090, .blue = 0.245910 },
	{ .red = 0.999267, .green = 0.344078, .blue = 0.236386 },
	{ .red = 0.999512, .green = 0.335043, .blue = 0.227106 },
	{ .red = 0.999267, .green = 0.326252, .blue = 0.217827 },
	{ .red = 0.998535, .green = 0.317949, .blue = 0.209035 },
	{ .red = 0.014408, .green = 0.596093, .blue = 0.335775 },
	{ .red = 0.021001, .green = 0.594872, .blue = 0.317949 },
	{ .red = 0.164835, .green = 0.597314, .blue = 0.259585 },
	{ .red = 0.419048, .green = 0.594383, .blue = 0.263492 },
	{ .red = 0.599756, .green = 0.594383, .blue = 0.269353 },
	{ .red = 0.778510, .green = 0.590965, .blue = 0.268620 },
	{ .red = 0.952381, .green = 0.584615, .blue = 0.264957 },
	{ .red = 0.999023, .green = 0.544811, .blue = 0.273993 },
	{ .red = 0.999512, .green = 0.511111, .blue = 0.281563 },
	{ .red = 0.998291, .green = 0.488400, .blue = 0.285470 },
	{ .red = 0.999267, .green = 0.472039, .blue = 0.286203 },
	{ .red = 0.999267, .green = 0.458608, .blue = 0.284737 },
	{ .red = 0.999756, .green = 0.446398, .blue = 0.280830 },
	{ .red = 0.999512, .green = 0.434676, .blue = 0.274969 },
	{ .red = 0.999512, .green = 0.422711, .blue = 0.267155 },
	{ .red = 0.999023, .green = 0.410501, .blue = 0.257875 },
	{ .red = 0.999512, .green = 0.397802, .blue = 0.247863 },
	{ .red = 0.018803, .green = 0.693773, .blue = 0.320635 },
	{ .red = 0.016361, .green = 0.699878, .blue = 0.307692 },
	{ .red = 0.010989, .green = 0.734066, .blue = 0.248107 },
	{ .red = 0.375580, .green = 0.743346, .blue = 0.232723 },
	{ .red = 0.571917, .green = 0.742857, .blue = 0.240781 },
	{ .red = 0.746276, .green = 0.738462, .blue = 0.243956 },
	{ .red = 0.914774, .green = 0.725763, .blue = 0.240049 },
	{ .red = 0.998779, .green = 0.678877, .blue = 0.254212 },
	{ .red = 0.999267, .green = 0.619048, .blue = 0.272283 },
	{ .red = 0.998779, .green = 0.576068, .blue = 0.278632 },
	{ .red = 0.999512, .green = 0.543346, .blue = 0.279121 },
	{ .red = 0.998779, .green = 0.516972, .blue = 0.276679 },
	{ .red = 0.998779, .green = 0.495971, .blue = 0.273016 },
	{ .red = 0.999267, .green = 0.476923, .blue = 0.266667 },
	{ .red = 0.998779, .green = 0.459341, .blue = 0.259341 },
	{ .red = 0.999512, .green = 0.442491, .blue = 0.250061 },
	{ .red = 0.998779, .green = 0.426618, .blue = 0.240537 },
	{ .red = 0.015140, .green = 0.785348, .blue = 0.306716 },
	{ .red = 0.014408, .green = 0.793895, .blue = 0.295726 },
	{ .red = 0.025885, .green = 0.833700, .blue = 0.246642 },
	{ .red = 0.303053, .green = 0.878632, .blue = 0.184371 },
	{ .red = 0.522589, .green = 0.871306, .blue = 0.191453 },
	{ .red = 0.698657, .green = 0.860562, .blue = 0.196093 },
	{ .red = 0.855922, .green = 0.845665, .blue = 0.195849 },
	{ .red = 0.999756, .green = 0.819536, .blue = 0.195116 },
	{ .red = 0.998779, .green = 0.731380, .blue = 0.249817 },
	{ .red = 0.998535, .green = 0.669353, .blue = 0.266422 },
	{ .red = 0.999512, .green = 0.622955, .blue = 0.270818 },
	{ .red = 0.999267, .green = 0.585104, .blue = 0.269353 },
	{ .red = 0.998291, .green = 0.553358, .blue = 0.264469 },
	{ .red = 0.999512, .green = 0.525763, .blue = 0.256899 },
	{ .red = 0.998779, .green = 0.500855, .blue = 0.248107 },
	{ .red = 0.999267, .green = 0.479609, .blue = 0.240049 },
	{ .red = 0.998779, .green = 0.460073, .blue = 0.231502 },
	{ .red = 0.019292, .green = 0.853724, .blue = 0.288645 },
	{ .red = 0.018803, .green = 0.862027, .blue = 0.278877 },
	{ .red = 0.010989, .green = 0.899145, .blue = 0.235409 },
	{ .red = 0.164591, .green = 0.983883, .blue = 0.092552 },
	{ .red = 0.449573, .green = 0.973138, .blue = 0.105495 },
	{ .red = 0.634188, .green = 0.958730, .blue = 0.115751 },
	{ .red = 0.791209, .green = 0.940904, .blue = 0.121123 },
	{ .red = 0.931624, .green = 0.919414, .blue = 0.120391 },
	{ .red = 0.999756, .green = 0.851526, .blue = 0.198779 },
	{ .red = 0.999023, .green = 0.768498, .blue = 0.244200 },
	{ .red = 0.998779, .green = 0.706716, .blue = 0.257143 },
	{ .red = 0.999023, .green = 0.657875, .blue = 0.259341 },
	{ .red = 0.999512, .green = 0.617582, .blue = 0.256166 },
	{ .red = 0.999512, .green = 0.582906, .blue = 0.249817 },
	{ .red = 0.999267, .green = 0.552381, .blue = 0.241758 },
	{ .red = 0.999023, .green = 0.524542, .blue = 0.232234 },
	{ .red = 0.999023, .green = 0.499634, .blue = 0.221978 },
	{ .red = 0.016117, .green = 0.901832, .blue = 0.269109 },
	{ .red = 0.000000, .green = 0.909402, .blue = 0.260073 },
	{ .red = 0.000000, .green = 0.941148, .blue = 0.221490 },
	{ .red = 0.188034, .green = 0.997558, .blue = 0.136264 },
	{ .red = 0.402442, .green = 0.999512, .blue = 0.128449 },
	{ .red = 0.564347, .green = 0.998779, .blue = 0.112576 },
	{ .red = 0.712576, .green = 0.995116, .blue = 0.083028 },
	{ .red = 0.851526, .green = 0.985104, .blue = 0.032234 },
	{ .red = 0.975824, .green = 0.963614, .blue = 0.018559 },
	{ .red = 0.999756, .green = 0.874481, .blue = 0.203419 },
	{ .red = 0.999267, .green = 0.795849, .blue = 0.237118 },
	{ .red = 0.999023, .green = 0.735043, .blue = 0.245665 },
	{ .red = 0.999267, .green = 0.685470, .blue = 0.245665 },
	{ .red = 0.999512, .green = 0.643712, .blue = 0.241026 },
	{ .red = 0.998779, .green = 0.607082, .blue = 0.234188 },
	{ .red = 0.999023, .green = 0.575092, .blue = 0.225641 },
	{ .red = 0.999267, .green = 0.546032, .blue = 0.216117 },
	{ .red = 0.018071, .green = 0.935043, .blue = 0.249817 },
	{ .red = 0.031746, .green = 0.941392, .blue = 0.242247 },
	{ .red = 0.027106, .green = 0.968010, .blue = 0.207326 },
	{ .red = 0.232234, .green = 0.999512, .blue = 0.175092 },
	{ .red = 0.391209, .green = 0.999267, .blue = 0.180220 },
	{ .red = 0.518926, .green = 0.999023, .blue = 0.174603 },
	{ .red = 0.640781, .green = 0.999267, .blue = 0.163126 },
	{ .red = 0.761416, .green = 0.999512, .blue = 0.140659 },
	{ .red = 0.881563, .green = 0.996825, .blue = 0.102320 },
	{ .red = 0.992918, .green = 0.982906, .blue = 0.064225 },
	{ .red = 0.999512, .green = 0.891087, .blue = 0.205861 },
	{ .red = 0.999267, .green = 0.816850, .blue = 0.228327 },
	{ .red = 0.998779, .green = 0.757265, .blue = 0.233211 },
	{ .red = 0.999756, .green = 0.708181, .blue = 0.230769 },
	{ .red = 0.999512, .green = 0.665690, .blue = 0.225397 },
	{ .red = 0.998779, .green = 0.628083, .blue = 0.218315 },
	{ .red = 0.999023, .green = 0.595360, .blue = 0.209768 },
	{ .red = 0.055678, .green = 0.955311, .blue = 0.235409 },
	{ .red = 0.051526, .green = 0.961172, .blue = 0.227839 },
	{ .red = 0.087668, .green = 0.979243, .blue = 0.201465 },
	{ .red = 0.260562, .green = 0.999512, .blue = 0.200733 },
	{ .red = 0.386813, .green = 0.999756, .blue = 0.211233 },
	{ .red = 0.488889, .green = 0.999512, .blue = 0.207082 },
	{ .red = 0.590232, .green = 0.999756, .blue = 0.199512 },
	{ .red = 0.692063, .green = 0.999512, .blue = 0.190965 },
	{ .red = 0.794383, .green = 0.999023, .blue = 0.178266 },
	{ .red = 0.898901, .green = 0.999756, .blue = 0.152625 },
	{ .red = 0.996093, .green = 0.989499, .blue = 0.129426 },
	{ .red = 0.999267, .green = 0.903541, .blue = 0.204151 },
	{ .red = 0.998779, .green = 0.832967, .blue = 0.218315 },
	{ .red = 0.999267, .green = 0.775580, .blue = 0.219536 },
	{ .red = 0.999267, .green = 0.726740, .blue = 0.215873 },
	{ .red = 0.999756, .green = 0.684737, .blue = 0.209768 },
	{ .red = 0.998535, .green = 0.646886, .blue = 0.202930 },
	{ .red = 0.041514, .green = 0.970940, .blue = 0.219780 },
	{ .red = 0.027350, .green = 0.976313, .blue = 0.212454 },
	{ .red = 0.115751, .green = 0.984860, .blue = 0.196093 },
	{ .red = 0.278877, .green = 0.999512, .blue = 0.215629 },
	{ .red = 0.385104, .green = 0.999512, .blue = 0.230281 },
	{ .red = 0.467643, .green = 0.999512, .blue = 0.225885 },
	{ .red = 0.552869, .green = 0.999267, .blue = 0.220513 },
	{ .red = 0.639805, .green = 0.999267, .blue = 0.213675 },
	{ .red = 0.728205, .green = 0.999023, .blue = 0.205861 },
	{ .red = 0.818559, .green = 1.000000, .blue = 0.194139 },
	{ .red = 0.909890, .green = 0.999512, .blue = 0.181929 },
	{ .red = 0.994628, .green = 0.991209, .blue = 0.168010 },
	{ .red = 0.999512, .green = 0.913309, .blue = 0.199756 },
	{ .red = 0.999512, .green = 0.846642, .blue = 0.206349 },
	{ .red = 0.999023, .green = 0.790476, .blue = 0.205617 },
	{ .red = 0.998779, .green = 0.742857, .blue = 0.201465 },
	{ .red = 0.999267, .green = 0.701099, .blue = 0.195116 },
	{ .red = 0.058852, .green = 0.979976, .blue = 0.206838 },
	{ .red = 0.084493, .green = 0.981197, .blue = 0.203663 },
	{ .red = 0.135043, .green = 0.989988, .blue = 0.190965 },
	{ .red = 0.289377, .green = 0.999267, .blue = 0.222711 },
	{ .red = 0.382418, .green = 0.999267, .blue = 0.240049 },
	{ .red = 0.450061, .green = 0.999512, .blue = 0.235165 },
	{ .red = 0.522833, .green = 0.998779, .blue = 0.230525 },
	{ .red = 0.598046, .green = 0.999023, .blue = 0.223687 },
	{ .red = 0.675702, .green = 0.999023, .blue = 0.217338 },
	{ .red = 0.755067, .green = 0.999023, .blue = 0.210012 },
	{ .red = 0.836142, .green = 0.999512, .blue = 0.201709 },
	{ .red = 0.917949, .green = 0.999512, .blue = 0.194383 },
	{ .red = 0.993895, .green = 0.992186, .blue = 0.181929 },
	{ .red = 0.999267, .green = 0.920635, .blue = 0.191697 },
	{ .red = 0.999756, .green = 0.857875, .blue = 0.194139 },
	{ .red = 0.999023, .green = 0.803663, .blue = 0.191941 },
	{ .red = 0.998779, .green = 0.757021, .blue = 0.187546 },
	{ .red = 0.101343, .green = 0.981685, .blue = 0.199023 },
	{ .red = 0.111355, .green = 0.983394, .blue = 0.195604 },
	{ .red = 0.158486, .green = 0.995604, .blue = 0.189499 },
	{ .red = 0.293040, .green = 0.999267, .blue = 0.223687 },
	{ .red = 0.376313, .green = 0.999267, .blue = 0.242491 },
	{ .red = 0.433455, .green = 0.999512, .blue = 0.237363 },
	{ .red = 0.496703, .green = 0.999023, .blue = 0.232479 },
	{ .red = 0.562882, .green = 0.999267, .blue = 0.225885 },
	{ .red = 0.631990, .green = 0.999512, .blue = 0.219048 },
	{ .red = 0.703297, .green = 0.999267, .blue = 0.212943 },
	{ .red = 0.776068, .green = 0.999512, .blue = 0.206105 },
	{ .red = 0.849573, .green = 0.999023, .blue = 0.201465 },
	{ .red = 0.924542, .green = 0.999512, .blue = 0.195604 },
	{ .red = 0.993407, .green = 0.992918, .blue = 0.184615 },
	{ .red = 0.999512, .green = 0.927228, .blue = 0.182662 },
	{ .red = 0.999267, .green = 0.866911, .blue = 0.182173 },
	{ .red = 0.999756, .green = 0.815629, .blue = 0.178266 },
	{ .red = 0.114530, .green = 0.984127, .blue = 0.189255 },
	{ .red = 0.118193, .green = 0.986325, .blue = 0.185104 },
	{ .red = 0.172894, .green = 0.999023, .blue = 0.186325 },
	{ .red = 0.291819, .green = 0.999267, .blue = 0.220513 },
	{ .red = 0.367277, .green = 0.999023, .blue = 0.239560 },
	{ .red = 0.416850, .green = 0.999512, .blue = 0.234188 },
	{ .red = 0.472527, .green = 0.999267, .blue = 0.229304 },
	{ .red = 0.532357, .green = 0.998779, .blue = 0.224420 },
	{ .red = 0.594383, .green = 0.999267, .blue = 0.217094 },
	{ .red = 0.659096, .green = 0.998779, .blue = 0.211722 },
	{ .red = 0.725275, .green = 0.999023, .blue = 0.205128 },
	{ .red = 0.792674, .green = 0.999512, .blue = 0.198291 },
	{ .red = 0.860562, .green = 0.998779, .blue = 0.195360 },
	{ .red = 0.929670, .green = 0.999267, .blue = 0.190476 },
	{ .red = 0.992918, .green = 0.993162, .blue = 0.180952 },
	{ .red = 0.999756, .green = 0.932601, .blue = 0.171673 },
	{ .red = 0.999267, .green = 0.875214, .blue = 0.170208 },
	{ .red = 0.109646, .green = 0.988523, .blue = 0.176313 },
	{ .red = 0.108425, .green = 0.991697, .blue = 0.171673 },
	{ .red = 0.184860, .green = 0.999267, .blue = 0.183150 },
	{ .red = 0.286935, .green = 0.999267, .blue = 0.214164 },
	{ .red = 0.355800, .green = 0.999023, .blue = 0.232967 },
	{ .red = 0.400000, .green = 0.999756, .blue = 0.227839 },
	{ .red = 0.450305, .green = 0.999267, .blue = 0.223199 },
	{ .red = 0.504518, .green = 0.999023, .blue = 0.218315 },
	{ .red = 0.561416, .green = 0.999267, .blue = 0.211722 },
	{ .red = 0.620513, .green = 0.999267, .blue = 0.205861 },
	{ .red = 0.681319, .green = 0.999267, .blue = 0.200000 },
	{ .red = 0.743346, .green = 0.998779, .blue = 0.195360 },
	{ .red = 0.806593, .green = 0.999512, .blue = 0.188278 },
	{ .red = 0.870085, .green = 0.999267, .blue = 0.185104 },
	{ .red = 0.934310, .green = 0.999267, .blue = 0.181441 },
	{ .red = 0.992674, .green = 0.993407, .blue = 0.174115 },
	{ .red = 0.999756, .green = 0.936996, .blue = 0.160195 },
	{ .red = 0.087424, .green = 0.994872, .blue = 0.160195 },
	{ .red = 0.103297, .green = 0.999023, .blue = 0.159951 },
	{ .red = 0.191209, .green = 0.999267, .blue = 0.178022 },
	{ .red = 0.280586, .green = 0.999512, .blue = 0.206349 },
	{ .red = 0.342857, .green = 0.999023, .blue = 0.223687 },
	{ .red = 0.382906, .green = 0.999756, .blue = 0.218803 },
	{ .red = 0.429548, .green = 0.999023, .blue = 0.215140 },
	{ .red = 0.478877, .green = 0.999756, .blue = 0.209280 },
	{ .red = 0.531868, .green = 0.999023, .blue = 0.204884 },
	{ .red = 0.586325, .green = 0.999756, .blue = 0.198046 },
	{ .red = 0.642735, .green = 0.999267, .blue = 0.193407 },
	{ .red = 0.700611, .green = 0.999512, .blue = 0.187302 },
	{ .red = 0.758974, .green = 0.998779, .blue = 0.184127 },
	{ .red = 0.818559, .green = 0.999512, .blue = 0.177778 },
	{ .red = 0.878388, .green = 0.999512, .blue = 0.172894 },
	{ .red = 0.938217, .green = 0.999267, .blue = 0.171429 },
	{ .red = 0.992674, .green = 0.993651, .blue = 0.164591 },
	{ .red = 0.016117, .green = 0.017338, .blue = 0.421490 },
	{ .red = 0.157509, .green = 0.010989, .blue = 0.424664 },
	{ .red = 0.316972, .green = 0.011722, .blue = 0.442002 },
	{ .red = 0.470085, .green = 0.010501, .blue = 0.470085 },
	{ .red = 0.613675, .green = 0.012210, .blue = 0.456410 },
	{ .red = 0.688889, .green = 0.015140, .blue = 0.409524 },
	{ .red = 0.751160, .green = 0.010256, .blue = 0.372894 },
	{ .red = 0.809280, .green = 0.017094, .blue = 0.346520 },
	{ .red = 0.865690, .green = 0.018071, .blue = 0.326496 },
	{ .red = 0.916484, .green = 0.018071, .blue = 0.309402 },
	{ .red = 0.958730, .green = 0.020024, .blue = 0.293040 },
	{ .red = 0.980952, .green = 0.036386, .blue = 0.274725 },
	{ .red = 0.992430, .green = 0.054701, .blue = 0.257631 },
	{ .red = 0.999023, .green = 0.063980, .blue = 0.241270 },
	{ .red = 0.999756, .green = 0.075458, .blue = 0.226129 },
	{ .red = 0.997314, .green = 0.082784, .blue = 0.211722 },
	{ .red = 0.998291, .green = 0.087668, .blue = 0.199512 },
	{ .red = 0.000000, .green = 0.143346, .blue = 0.415629 },
	{ .red = 0.150427, .green = 0.119170, .blue = 0.449084 },
	{ .red = 0.313309, .green = 0.123077, .blue = 0.451526 },
	{ .red = 0.476435, .green = 0.096459, .blue = 0.480342 },
	{ .red = 0.652503, .green = 0.014896, .blue = 0.476435 },
	{ .red = 0.751160, .green = 0.013919, .blue = 0.432234 },
	{ .red = 0.814408, .green = 0.010745, .blue = 0.390720 },
	{ .red = 0.870818, .green = 0.014408, .blue = 0.361172 },
	{ .red = 0.925275, .green = 0.008791, .blue = 0.338950 },
	{ .red = 0.969719, .green = 0.015629, .blue = 0.318926 },
	{ .red = 0.994139, .green = 0.039560, .blue = 0.297680 },
	{ .red = 0.991697, .green = 0.063736, .blue = 0.273748 },
	{ .red = 0.996337, .green = 0.073748, .blue = 0.255433 },
	{ .red = 0.999267, .green = 0.079121, .blue = 0.238584 },
	{ .red = 0.999512, .green = 0.100122, .blue = 0.226129 },
	{ .red = 0.999267, .green = 0.117216, .blue = 0.215140 },
	{ .red = 0.999267, .green = 0.129915, .blue = 0.205617 },
	{ .red = 0.014164, .green = 0.273993, .blue = 0.389255 },
	{ .red = 0.069353, .green = 0.284737, .blue = 0.460317 },
	{ .red = 0.299389, .green = 0.286935, .blue = 0.445665 },
	{ .red = 0.464957, .green = 0.285470, .blue = 0.460562 },
	{ .red = 0.645177, .green = 0.271551, .blue = 0.461050 },
	{ .red = 0.820269, .green = 0.253236, .blue = 0.455922 },
	{ .red = 0.991941, .green = 0.228327, .blue = 0.452015 },
	{ .red = 0.998535, .green = 0.216361, .blue = 0.401954 },
	{ .red = 0.998535, .green = 0.214164, .blue = 0.365079 },
	{ .red = 0.999512, .green = 0.214652, .blue = 0.336752 },
	{ .red = 0.999267, .green = 0.215873, .blue = 0.313553 },
	{ .red = 0.999023, .green = 0.217338, .blue = 0.294261 },
	{ .red = 0.998779, .green = 0.218315, .blue = 0.277411 },
	{ .red = 0.999267, .green = 0.219292, .blue = 0.263248 },
	{ .red = 0.999267, .green = 0.219292, .blue = 0.249817 },
	{ .red = 0.999023, .green = 0.219292, .blue = 0.237851 },
	{ .red = 0.999023, .green = 0.219536, .blue = 0.227106 },
	{ .red = 0.021734, .green = 0.507937, .blue = 0.508181 },
	{ .red = 0.010989, .green = 0.487424, .blue = 0.488645 },
	{ .red = 0.224176, .green = 0.446398, .blue = 0.447863 },
	{ .red = 0.442979, .green = 0.442491, .blue = 0.442735 },
	{ .red = 0.629060, .green = 0.435897, .blue = 0.440537 },
	{ .red = 0.806349, .green = 0.426618, .blue = 0.438584 },
	{ .red = 0.979731, .green = 0.414408, .blue = 0.437118 },
	{ .red = 0.998779, .green = 0.401221, .blue = 0.416361 },
	{ .red = 0.999267, .green = 0.390720, .blue = 0.395360 },
	{ .red = 0.999512, .green = 0.380952, .blue = 0.375580 },
	{ .red = 0.999023, .green = 0.371917, .blue = 0.357265 },
	{ .red = 0.998535, .green = 0.362882, .blue = 0.339927 },
	{ .red = 0.999023, .green = 0.353602, .blue = 0.323565 },
	{ .red = 0.999512, .green = 0.344567, .blue = 0.307937 },
	{ .red = 0.999023, .green = 0.336020, .blue = 0.293040 },
	{ .red = 0.999267, .green = 0.327473, .blue = 0.279121 },
	{ .red = 0.999267, .green = 0.318926, .blue = 0.265690 },
	{ .red = 0.029060, .green = 0.611966, .blue = 0.485226 },
	{ .red = 0.024176, .green = 0.609035, .blue = 0.475214 },
	{ .red = 0.022466, .green = 0.600244, .blue = 0.432479 },
	{ .red = 0.401465, .green = 0.595604, .blue = 0.429060 },
	{ .red = 0.596093, .green = 0.592674, .blue = 0.433700 },
	{ .red = 0.776801, .green = 0.589255, .blue = 0.431258 },
	{ .red = 0.951893, .green = 0.581685, .blue = 0.425153 },
	{ .red = 0.998779, .green = 0.564591, .blue = 0.433944 },
	{ .red = 0.998779, .green = 0.546032, .blue = 0.435653 },
	{ .red = 0.998535, .green = 0.529426, .blue = 0.428571 },
	{ .red = 0.999023, .green = 0.513065, .blue = 0.416606 },
	{ .red = 0.999267, .green = 0.497192, .blue = 0.402198 },
	{ .red = 0.998046, .green = 0.481074, .blue = 0.386081 },
	{ .red = 0.999023, .green = 0.465446, .blue = 0.369231 },
	{ .red = 0.999756, .green = 0.450061, .blue = 0.352137 },
	{ .red = 0.998779, .green = 0.434921, .blue = 0.335287 },
	{ .red = 0.998779, .green = 0.420024, .blue = 0.318681 },
	{ .red = 0.023443, .green = 0.705739, .blue = 0.465446 },
	{ .red = 0.017094, .green = 0.709646, .blue = 0.458608 },
	{ .red = 0.028083, .green = 0.730159, .blue = 0.431502 },
	{ .red = 0.340659, .green = 0.746764, .blue = 0.411966 },
	{ .red = 0.567033, .green = 0.741392, .blue = 0.414652 },
	{ .red = 0.742613, .green = 0.736264, .blue = 0.417338 },
	{ .red = 0.911111, .green = 0.723321, .blue = 0.411233 },
	{ .red = 0.998535, .green = 0.687668, .blue = 0.419048 },
	{ .red = 0.999023, .green = 0.649084, .blue = 0.435653 },
	{ .red = 0.998779, .green = 0.625885, .blue = 0.444444 },
	{ .red = 0.999023, .green = 0.610012, .blue = 0.447619 },
	{ .red = 0.999023, .green = 0.596825, .blue = 0.446642 },
	{ .red = 0.999512, .green = 0.584615, .blue = 0.441514 },
	{ .red = 0.998535, .green = 0.571917, .blue = 0.433211 },
	{ .red = 0.998535, .green = 0.558486, .blue = 0.421978 },
	{ .red = 0.999023, .green = 0.539683, .blue = 0.403175 },
	{ .red = 0.999023, .green = 0.520391, .blue = 0.384127 },
	{ .red = 0.020757, .green = 0.792186, .blue = 0.446642 },
	{ .red = 0.019292, .green = 0.798535, .blue = 0.441270 },
	{ .red = 0.031502, .green = 0.827595, .blue = 0.419536 },
	{ .red = 0.237118, .green = 0.881563, .blue = 0.383639 },
	{ .red = 0.515507, .green = 0.869597, .blue = 0.380952 },
	{ .red = 0.693529, .green = 0.858364, .blue = 0.383150 },
	{ .red = 0.851770, .green = 0.843223, .blue = 0.379976 },
	{ .red = 0.998779, .green = 0.819048, .blue = 0.372650 },
	{ .red = 0.999267, .green = 0.747253, .blue = 0.411477 },
	{ .red = 0.999023, .green = 0.701587, .blue = 0.426129 },
	{ .red = 0.998535, .green = 0.668620, .blue = 0.430281 },
	{ .red = 0.998535, .green = 0.642735, .blue = 0.428327 },
	{ .red = 0.999267, .green = 0.621734, .blue = 0.423443 },
	{ .red = 0.999756, .green = 0.602442, .blue = 0.415629 },
	{ .red = 0.999267, .green = 0.584371, .blue = 0.405372 },
	{ .red = 0.998779, .green = 0.566300, .blue = 0.392918 },
	{ .red = 0.999023, .green = 0.548962, .blue = 0.378999 },
	{ .red = 0.026618, .green = 0.856410, .blue = 0.421734 },
	{ .red = 0.020513, .green = 0.863492, .blue = 0.416850 },
	{ .red = 0.013431, .green = 0.892796, .blue = 0.396825 },
	{ .red = 0.047375, .green = 0.970940, .blue = 0.348474 },
	{ .red = 0.439805, .green = 0.971184, .blue = 0.335775 },
	{ .red = 0.628327, .green = 0.956532, .blue = 0.337485 },
	{ .red = 0.786325, .green = 0.938462, .blue = 0.336020 },
	{ .red = 0.927717, .green = 0.916728, .blue = 0.330647 },
	{ .red = 0.999023, .green = 0.855678, .blue = 0.365324 },
	{ .red = 0.999023, .green = 0.785348, .blue = 0.398046 },
	{ .red = 0.999512, .green = 0.736508, .blue = 0.408547 },
	{ .red = 0.999023, .green = 0.698657, .blue = 0.409768 },
	{ .red = 0.998535, .green = 0.667155, .blue = 0.405128 },
	{ .red = 0.998535, .green = 0.639805, .blue = 0.396825 },
	{ .red = 0.999023, .green = 0.615140, .blue = 0.385592 },
	{ .red = 0.998291, .green = 0.592430, .blue = 0.373626 },
	{ .red = 0.999267, .green = 0.571917, .blue = 0.361416 },
	{ .red = 0.023932, .green = 0.902564, .blue = 0.394628 },
	{ .red = 0.027839, .green = 0.908913, .blue = 0.389988 },
	{ .red = 0.026618, .green = 0.935287, .blue = 0.371429 },
	{ .red = 0.115507, .green = 0.991453, .blue = 0.332112 },
	{ .red = 0.416361, .green = 0.999512, .blue = 0.339194 },
	{ .red = 0.571673, .green = 0.999512, .blue = 0.329670 },
	{ .red = 0.712821, .green = 0.999512, .blue = 0.307448 },
	{ .red = 0.853236, .green = 0.991697, .blue = 0.281319 },
	{ .red = 0.979243, .green = 0.966300, .blue = 0.275458 },
	{ .red = 0.998535, .green = 0.879365, .blue = 0.355800 },
	{ .red = 0.999267, .green = 0.811477, .blue = 0.380220 },
	{ .red = 0.998779, .green = 0.760684, .blue = 0.386813 },
	{ .red = 0.998535, .green = 0.719658, .blue = 0.385348 },
	{ .red = 0.998779, .green = 0.685226, .blue = 0.378999 },
	{ .red = 0.999023, .green = 0.654945, .blue = 0.369475 },
	{ .red = 0.998535, .green = 0.627350, .blue = 0.357998 },
	{ .red = 0.999512, .green = 0.602198, .blue = 0.345055 },
	{ .red = 0.024908, .green = 0.935043, .blue = 0.367521 },
	{ .red = 0.027350, .green = 0.940659, .blue = 0.363126 },
	{ .red = 0.039072, .green = 0.963126, .blue = 0.346032 },
	{ .red = 0.193407, .green = 0.998779, .blue = 0.325763 },
	{ .red = 0.429060, .green = 0.999023, .blue = 0.356777 },
	{ .red = 0.552137, .green = 0.999023, .blue = 0.359707 },
	{ .red = 0.656654, .green = 0.999512, .blue = 0.344567 },
	{ .red = 0.766789, .green = 0.999023, .blue = 0.325763 },
	{ .red = 0.883028, .green = 0.999023, .blue = 0.295238 },
	{ .red = 0.999512, .green = 0.988278, .blue = 0.257631 },
	{ .red = 0.999267, .green = 0.896215, .blue = 0.342613 },
	{ .red = 0.999756, .green = 0.830769, .blue = 0.359219 },
	{ .red = 0.999023, .green = 0.778755, .blue = 0.362637 },
	{ .red = 0.999512, .green = 0.736508, .blue = 0.358974 },
	{ .red = 0.998779, .green = 0.699878, .blue = 0.351893 },
	{ .red = 0.998779, .green = 0.667643, .blue = 0.342125 },
	{ .red = 0.999023, .green = 0.638584, .blue = 0.330891 },
	{ .red = 0.041026, .green = 0.956288, .blue = 0.343101 },
	{ .red = 0.058120, .green = 0.960195, .blue = 0.339438 },
	{ .red = 0.053480, .green = 0.979731, .blue = 0.323565 },
	{ .red = 0.243712, .green = 0.999023, .blue = 0.324054 },
	{ .red = 0.434432, .green = 0.999023, .blue = 0.364103 },
	{ .red = 0.541880, .green = 0.999512, .blue = 0.377045 },
	{ .red = 0.621978, .green = 0.999023, .blue = 0.364835 },
	{ .red = 0.708669, .green = 0.998535, .blue = 0.350916 },
	{ .red = 0.801465, .green = 0.999267, .blue = 0.332357 },
	{ .red = 0.899389, .green = 0.998779, .blue = 0.312332 },
	{ .red = 0.999512, .green = 0.992674, .blue = 0.273260 },
	{ .red = 0.999267, .green = 0.908425, .blue = 0.327228 },
	{ .red = 0.999267, .green = 0.844444, .blue = 0.337729 },
	{ .red = 0.999512, .green = 0.793162, .blue = 0.337973 },
	{ .red = 0.999023, .green = 0.749939, .blue = 0.333333 },
	{ .red = 0.998779, .green = 0.712332, .blue = 0.325763 },
	{ .red = 0.999267, .green = 0.679365, .blue = 0.315995 },
	{ .red = 0.045665, .green = 0.970940, .blue = 0.320391 },
	{ .red = 0.069109, .green = 0.973382, .blue = 0.317460 },
	{ .red = 0.062759, .green = 0.990232, .blue = 0.302564 },
	{ .red = 0.273260, .green = 0.998779, .blue = 0.320391 },
	{ .red = 0.435165, .green = 0.999023, .blue = 0.363858 },
	{ .red = 0.533578, .green = 0.999267, .blue = 0.385104 },
	{ .red = 0.596581, .green = 0.998779, .blue = 0.373871 },
	{ .red = 0.666422, .green = 0.999023, .blue = 0.359951 },
	{ .red = 0.742857, .green = 0.998779, .blue = 0.346032 },
	{ .red = 0.824664, .green = 0.999512, .blue = 0.330403 },
	{ .red = 0.910623, .green = 0.998779, .blue = 0.317216 },
	{ .red = 0.997558, .green = 0.993895, .blue = 0.281807 },
	{ .red = 0.999023, .green = 0.916972, .blue = 0.310867 },
	{ .red = 0.999512, .green = 0.855922, .blue = 0.315995 },
	{ .red = 0.998779, .green = 0.804884, .blue = 0.314530 },
	{ .red = 0.999267, .green = 0.761905, .blue = 0.308669 },
	{ .red = 0.998779, .green = 0.723810, .blue = 0.301343 },
	{ .red = 0.016606, .green = 0.981929, .blue = 0.298413 },
	{ .red = 0.025153, .green = 0.985592, .blue = 0.294994 },
	{ .red = 0.119170, .green = 0.989988, .blue = 0.287912 },
	{ .red = 0.290598, .green = 0.999023, .blue = 0.315018 },
	{ .red = 0.431013, .green = 0.999023, .blue = 0.358486 },
	{ .red = 0.524054, .green = 0.999023, .blue = 0.385104 },
	{ .red = 0.574603, .green = 0.999023, .blue = 0.373871 },
	{ .red = 0.632479, .green = 0.999267, .blue = 0.360684 },
	{ .red = 0.697192, .green = 0.999267, .blue = 0.347741 },
	{ .red = 0.767033, .green = 0.999023, .blue = 0.334799 },
	{ .red = 0.841514, .green = 0.999512, .blue = 0.321856 },
	{ .red = 0.918681, .green = 0.998779, .blue = 0.312576 },
	{ .red = 0.995849, .green = 0.994383, .blue = 0.281074 },
	{ .red = 0.999267, .green = 0.924298, .blue = 0.292796 },
	{ .red = 0.999267, .green = 0.864957, .blue = 0.294750 },
	{ .red = 0.998779, .green = 0.815140, .blue = 0.292063 },
	{ .red = 0.999512, .green = 0.772650, .blue = 0.286203 },
	{ .red = 0.100366, .green = 0.982418, .blue = 0.283516 },
	{ .red = 0.106960, .green = 0.984371, .blue = 0.280830 },
	{ .red = 0.140171, .green = 0.998046, .blue = 0.275214 },
	{ .red = 0.298901, .green = 0.998779, .blue = 0.306960 },
	{ .red = 0.422711, .green = 0.999267, .blue = 0.348718 },
	{ .red = 0.511111, .green = 0.998779, .blue = 0.378755 },
	{ .red = 0.553602, .green = 0.998779, .blue = 0.368010 },
	{ .red = 0.603419, .green = 0.998779, .blue = 0.356288 },
	{ .red = 0.658852, .green = 0.999512, .blue = 0.342857 },
	{ .red = 0.719902, .green = 0.998779, .blue = 0.331868 },
	{ .red = 0.785348, .green = 0.999023, .blue = 0.319902 },
	{ .red = 0.854212, .green = 0.999756, .blue = 0.308181 },
	{ .red = 0.925275, .green = 0.999267, .blue = 0.300855 },
	{ .red = 0.994872, .green = 0.994628, .blue = 0.273504 },
	{ .red = 0.998535, .green = 0.929426, .blue = 0.275458 },
	{ .red = 0.999512, .green = 0.873260, .blue = 0.274481 },
	{ .red = 0.999267, .green = 0.824664, .blue = 0.271062 },
	{ .red = 0.089377, .green = 0.988767, .blue = 0.264469 },
	{ .red = 0.097192, .green = 0.990476, .blue = 0.262271 },
	{ .red = 0.170940, .green = 0.999267, .blue = 0.266911 },
	{ .red = 0.300366, .green = 0.998779, .blue = 0.296947 },
	{ .red = 0.410745, .green = 0.999756, .blue = 0.335531 },
	{ .red = 0.494994, .green = 0.999267, .blue = 0.366789 },
	{ .red = 0.532357, .green = 0.999023, .blue = 0.357265 },
	{ .red = 0.575580, .green = 0.999756, .blue = 0.345543 },
	{ .red = 0.625397, .green = 0.999023, .blue = 0.334799 },
	{ .red = 0.679609, .green = 0.999512, .blue = 0.322833 },
	{ .red = 0.738217, .green = 0.999267, .blue = 0.312088 },
	{ .red = 0.799756, .green = 0.998779, .blue = 0.302808 },
	{ .red = 0.864225, .green = 0.999267, .blue = 0.292796 },
	{ .red = 0.930403, .green = 0.999267, .blue = 0.286447 },
	{ .red = 0.994139, .green = 0.994628, .blue = 0.262271 },
	{ .red = 0.998535, .green = 0.933822, .blue = 0.258364 },
	{ .red = 0.999267, .green = 0.880098, .blue = 0.255922 },
	{ .red = 0.123077, .green = 0.986325, .blue = 0.252503 },
	{ .red = 0.130647, .green = 0.987790, .blue = 0.251038 },
	{ .red = 0.190965, .green = 0.998535, .blue = 0.258608 },
	{ .red = 0.298901, .green = 0.998779, .blue = 0.286203 },
	{ .red = 0.397070, .green = 0.999756, .blue = 0.321123 },
	{ .red = 0.476679, .green = 0.999512, .blue = 0.351893 },
	{ .red = 0.511111, .green = 0.998535, .blue = 0.344078 },
	{ .red = 0.550183, .green = 0.999267, .blue = 0.333578 },
	{ .red = 0.594872, .green = 0.999267, .blue = 0.323321 },
	{ .red = 0.643956, .green = 0.999756, .blue = 0.312332 },
	{ .red = 0.697192, .green = 0.999512, .blue = 0.302076 },
	{ .red = 0.753358, .green = 0.999267, .blue = 0.293040 },
	{ .red = 0.811722, .green = 0.998535, .blue = 0.285226 },
	{ .red = 0.872527, .green = 0.999023, .blue = 0.276679 },
	{ .red = 0.934310, .green = 0.999267, .blue = 0.270818 },
	{ .red = 0.993651, .green = 0.994383, .blue = 0.248840 },
	{ .red = 0.998535, .green = 0.937973, .blue = 0.242491 },
	{ .red = 0.126252, .green = 0.988767, .blue = 0.238339 },
	{ .red = 0.141392, .green = 0.992186, .blue = 0.239805 },
	{ .red = 0.199267, .green = 0.999023, .blue = 0.248596 },
	{ .red = 0.294750, .green = 0.998779, .blue = 0.274969 },
	{ .red = 0.382906, .green = 0.999512, .blue = 0.306227 },
	{ .red = 0.458120, .green = 0.999267, .blue = 0.336020 },
	{ .red = 0.489621, .green = 0.998779, .blue = 0.328938 },
	{ .red = 0.525763, .green = 0.999267, .blue = 0.319902 },
	{ .red = 0.566789, .green = 0.999512, .blue = 0.310379 },
	{ .red = 0.611966, .green = 0.999756, .blue = 0.300611 },
	{ .red = 0.661050, .green = 0.999512, .blue = 0.291087 },
	{ .red = 0.712821, .green = 0.999512, .blue = 0.282051 },
	{ .red = 0.766545, .green = 0.998779, .blue = 0.274969 },
	{ .red = 0.822711, .green = 0.999023, .blue = 0.266667 },
	{ .red = 0.880098, .green = 0.999267, .blue = 0.259829 },
	{ .red = 0.938217, .green = 0.999267, .blue = 0.254945 },
	{ .red = 0.993407, .green = 0.994383, .blue = 0.235165 },
	{ .red = 0.026618, .green = 0.072039, .blue = 0.524542 },
	{ .red = 0.152381, .green = 0.013675, .blue = 0.548230 },
	{ .red = 0.309646, .green = 0.013919, .blue = 0.561172 },
	{ .red = 0.461294, .green = 0.017338, .blue = 0.580220 },
	{ .red = 0.584860, .green = 0.014652, .blue = 0.584615 },
	{ .red = 0.673504, .green = 0.016361, .blue = 0.535043 },
	{ .red = 0.740171, .green = 0.012698, .blue = 0.489866 },
	{ .red = 0.794872, .green = 0.012698, .blue = 0.452991 },
	{ .red = 0.848840, .green = 0.015140, .blue = 0.425641 },
	{ .red = 0.896703, .green = 0.015629, .blue = 0.402198 },
	{ .red = 0.936996, .green = 0.017338, .blue = 0.380464 },
	{ .red = 0.968742, .green = 0.017094, .blue = 0.359463 },
	{ .red = 0.986813, .green = 0.037118, .blue = 0.338217 },
	{ .red = 0.996093, .green = 0.052015, .blue = 0.317460 },
	{ .red = 0.999512, .green = 0.061538, .blue = 0.297436 },
	{ .red = 0.995604, .green = 0.071306, .blue = 0.277900 },
	{ .red = 0.996093, .green = 0.080342, .blue = 0.262027 },
	{ .red = 0.000000, .green = 0.131868, .blue = 0.519414 },
	{ .red = 0.149939, .green = 0.075702, .blue = 0.603419 },
	{ .red = 0.312576, .green = 0.102320, .blue = 0.593651 },
	{ .red = 0.474481, .green = 0.074237, .blue = 0.614652 },
	{ .red = 0.620513, .green = 0.010256, .blue = 0.626618 },
	{ .red = 0.728938, .green = 0.013431, .blue = 0.576068 },
	{ .red = 0.799267, .green = 0.015629, .blue = 0.521612 },
	{ .red = 0.851282, .green = 0.018559, .blue = 0.476923 },
	{ .red = 0.903297, .green = 0.018559, .blue = 0.445177 },
	{ .red = 0.948962, .green = 0.014164, .blue = 0.418315 },
	{ .red = 0.980220, .green = 0.026129, .blue = 0.391941 },
	{ .red = 0.986081, .green = 0.047619, .blue = 0.361905 },
	{ .red = 0.992186, .green = 0.061050, .blue = 0.336996 },
	{ .red = 0.997802, .green = 0.070085, .blue = 0.315507 },
	{ .red = 0.999267, .green = 0.089621, .blue = 0.297192 },
	{ .red = 0.999023, .green = 0.110867, .blue = 0.281807 },
	{ .red = 0.999512, .green = 0.126496, .blue = 0.268620 },
	{ .red = 0.010501, .green = 0.247863, .blue = 0.462759 },
	{ .red = 0.109158, .green = 0.267155, .blue = 0.613675 },
	{ .red = 0.301587, .green = 0.276190, .blue = 0.595604 },
	{ .red = 0.465201, .green = 0.278144, .blue = 0.600977 },
	{ .red = 0.629548, .green = 0.267643, .blue = 0.627839 },
	{ .red = 0.807326, .green = 0.247863, .blue = 0.628816 },
	{ .red = 0.982418, .green = 0.221490, .blue = 0.623932 },
	{ .red = 0.999267, .green = 0.211722, .blue = 0.548230 },
	{ .red = 0.999756, .green = 0.210745, .blue = 0.490110 },
	{ .red = 0.999267, .green = 0.211233, .blue = 0.445910 },
	{ .red = 0.999512, .green = 0.212698, .blue = 0.411722 },
	{ .red = 0.999267, .green = 0.214652, .blue = 0.383394 },
	{ .red = 0.998535, .green = 0.216117, .blue = 0.359463 },
	{ .red = 0.999756, .green = 0.217338, .blue = 0.339194 },
	{ .red = 0.999023, .green = 0.218071, .blue = 0.320391 },
	{ .red = 0.999512, .green = 0.219048, .blue = 0.304274 },
	{ .red = 0.999512, .green = 0.219048, .blue = 0.289377 },
	{ .red = 0.012943, .green = 0.401954, .blue = 0.514530 },
	{ .red = 0.021734, .green = 0.403419, .blue = 0.535775 },
	{ .red = 0.252503, .green = 0.432479, .blue = 0.609280 },
	{ .red = 0.449084, .green = 0.434676, .blue = 0.593162 },
	{ .red = 0.614652, .green = 0.434432, .blue = 0.607814 },
	{ .red = 0.796825, .green = 0.422955, .blue = 0.610745 },
	{ .red = 0.973871, .green = 0.409280, .blue = 0.608059 },
	{ .red = 0.998535, .green = 0.399023, .blue = 0.557265 },
	{ .red = 0.998779, .green = 0.389988, .blue = 0.514774 },
	{ .red = 0.999756, .green = 0.381197, .blue = 0.481074 },
	{ .red = 0.999512, .green = 0.372650, .blue = 0.452015 },
	{ .red = 0.999756, .green = 0.364347, .blue = 0.426618 },
	{ .red = 0.998535, .green = 0.355556, .blue = 0.403419 },
	{ .red = 0.999267, .green = 0.347009, .blue = 0.382418 },
	{ .red = 0.999512, .green = 0.338217, .blue = 0.362393 },
	{ .red = 0.999023, .green = 0.329426, .blue = 0.343834 },
	{ .red = 0.999023, .green = 0.321123, .blue = 0.326496 },
	{ .red = 0.023443, .green = 0.622466, .blue = 0.622711 },
	{ .red = 0.021978, .green = 0.617827, .blue = 0.618559 },
	{ .red = 0.017827, .green = 0.599267, .blue = 0.602442 },
	{ .red = 0.381929, .green = 0.594139, .blue = 0.595849 },
	{ .red = 0.590965, .green = 0.590232, .blue = 0.590476 },
	{ .red = 0.778755, .green = 0.583639, .blue = 0.589744 },
	{ .red = 0.955311, .green = 0.573138, .blue = 0.587057 },
	{ .red = 0.999267, .green = 0.559219, .blue = 0.570696 },
	{ .red = 0.999023, .green = 0.545055, .blue = 0.549939 },
	{ .red = 0.999023, .green = 0.530647, .blue = 0.528694 },
	{ .red = 0.999023, .green = 0.515995, .blue = 0.506960 },
	{ .red = 0.999267, .green = 0.500855, .blue = 0.485226 },
	{ .red = 0.999756, .green = 0.485470, .blue = 0.463004 },
	{ .red = 0.998535, .green = 0.469841, .blue = 0.441026 },
	{ .red = 0.998779, .green = 0.454457, .blue = 0.419536 },
	{ .red = 0.998779, .green = 0.439072, .blue = 0.398291 },
	{ .red = 0.998779, .green = 0.423932, .blue = 0.378022 },
	{ .red = 0.023687, .green = 0.717216, .blue = 0.599512 },
	{ .red = 0.021978, .green = 0.719902, .blue = 0.597558 },
	{ .red = 0.025397, .green = 0.732601, .blue = 0.589744 },
	{ .red = 0.294994, .green = 0.748718, .blue = 0.580708 },
	{ .red = 0.549451, .green = 0.741636, .blue = 0.575824 },
	{ .red = 0.736996, .green = 0.733089, .blue = 0.575824 },
	{ .red = 0.906227, .green = 0.719414, .blue = 0.566056 },
	{ .red = 0.999023, .green = 0.697192, .blue = 0.568498 },
	{ .red = 0.998046, .green = 0.678877, .blue = 0.581441 },
	{ .red = 0.998291, .green = 0.659829, .blue = 0.576801 },
	{ .red = 0.998779, .green = 0.640781, .blue = 0.564347 },
	{ .red = 0.998779, .green = 0.621734, .blue = 0.547497 },
	{ .red = 0.998291, .green = 0.601954, .blue = 0.527717 },
	{ .red = 0.999512, .green = 0.582173, .blue = 0.505983 },
	{ .red = 0.999023, .green = 0.562149, .blue = 0.483516 },
	{ .red = 0.998291, .green = 0.541880, .blue = 0.460562 },
	{ .red = 0.999023, .green = 0.522344, .blue = 0.437607 },
	{ .red = 0.016850, .green = 0.799756, .blue = 0.576068 },
	{ .red = 0.012454, .green = 0.804884, .blue = 0.574115 },
	{ .red = 0.018071, .green = 0.826862, .blue = 0.566789 },
	{ .red = 0.125763, .green = 0.883028, .blue = 0.552869 },
	{ .red = 0.483028, .green = 0.870574, .blue = 0.545788 },
	{ .red = 0.686691, .green = 0.854701, .blue = 0.540904 },
	{ .red = 0.845665, .green = 0.839072, .blue = 0.536508 },
	{ .red = 0.996581, .green = 0.816606, .blue = 0.523810 },
	{ .red = 0.998535, .green = 0.764835, .blue = 0.559951 },
	{ .red = 0.998291, .green = 0.736752, .blue = 0.575336 },
	{ .red = 0.999023, .green = 0.719658, .blue = 0.582662 },
	{ .red = 0.999512, .green = 0.706471, .blue = 0.583394 },
	{ .red = 0.999267, .green = 0.694261, .blue = 0.579487 },
	{ .red = 0.998535, .green = 0.679853, .blue = 0.568987 },
	{ .red = 0.998291, .green = 0.656654, .blue = 0.546520 },
	{ .red = 0.999756, .green = 0.633455, .blue = 0.521612 },
	{ .red = 0.999756, .green = 0.610989, .blue = 0.497924 },
	{ .red = 0.023443, .green = 0.860562, .blue = 0.545055 },
	{ .red = 0.024664, .green = 0.866178, .blue = 0.542857 },
	{ .red = 0.021978, .green = 0.889621, .blue = 0.534554 },
	{ .red = 0.031013, .green = 0.948962, .blue = 0.517216 },
	{ .red = 0.391209, .green = 0.972405, .blue = 0.503541 },
	{ .red = 0.620513, .green = 0.952869, .blue = 0.495726 },
	{ .red = 0.779731, .green = 0.934554, .blue = 0.493040 },
	{ .red = 0.921856, .green = 0.912821, .blue = 0.484737 },
	{ .red = 0.998535, .green = 0.859829, .blue = 0.509646 },
	{ .red = 0.999023, .green = 0.804640, .blue = 0.542125 },
	{ .red = 0.999267, .green = 0.769475, .blue = 0.553846 },
	{ .red = 0.999756, .green = 0.743346, .blue = 0.555800 },
	{ .red = 0.998291, .green = 0.721612, .blue = 0.552381 },
	{ .red = 0.999023, .green = 0.703541, .blue = 0.545788 },
	{ .red = 0.998535, .green = 0.685958, .blue = 0.536020 },
	{ .red = 0.999267, .green = 0.668620, .blue = 0.523077 },
	{ .red = 0.999023, .green = 0.651282, .blue = 0.508425 },
	{ .red = 0.026618, .green = 0.904274, .blue = 0.511111 },
	{ .red = 0.027106, .green = 0.909890, .blue = 0.508913 },
	{ .red = 0.018803, .green = 0.931868, .blue = 0.499878 },
	{ .red = 0.078144, .green = 0.980464, .blue = 0.481563 },
	{ .red = 0.379976, .green = 0.998779, .blue = 0.482295 },
	{ .red = 0.575580, .green = 0.998535, .blue = 0.483272 },
	{ .red = 0.710379, .green = 0.999267, .blue = 0.459585 },
	{ .red = 0.847131, .green = 0.988278, .blue = 0.438584 },
	{ .red = 0.973871, .green = 0.962637, .blue = 0.429548 },
	{ .red = 0.998535, .green = 0.885714, .blue = 0.492308 },
	{ .red = 0.999023, .green = 0.829548, .blue = 0.517460 },
	{ .red = 0.998779, .green = 0.789988, .blue = 0.525275 },
	{ .red = 0.999023, .green = 0.758974, .blue = 0.524542 },
	{ .red = 0.998291, .green = 0.732357, .blue = 0.518437 },
	{ .red = 0.999267, .green = 0.708669, .blue = 0.508181 },
	{ .red = 0.999756, .green = 0.686447, .blue = 0.495238 },
	{ .red = 0.998291, .green = 0.666422, .blue = 0.482784 },
	{ .red = 0.028327, .green = 0.935531, .blue = 0.477411 },
	{ .red = 0.031502, .green = 0.940415, .blue = 0.474969 },
	{ .red = 0.050794, .green = 0.959219, .blue = 0.466178 },
	{ .red = 0.136508, .green = 0.995849, .blue = 0.451038 },
	{ .red = 0.405128, .green = 0.999267, .blue = 0.473260 },
	{ .red = 0.573382, .green = 0.998779, .blue = 0.498413 },
	{ .red = 0.678632, .green = 0.999267, .blue = 0.492552 },
	{ .red = 0.774603, .green = 0.998779, .blue = 0.468620 },
	{ .red = 0.883272, .green = 0.999267, .blue = 0.434432 },
	{ .red = 0.998535, .green = 0.987790, .blue = 0.396093 },
	{ .red = 0.999023, .green = 0.902564, .blue = 0.470085 },
	{ .red = 0.999267, .green = 0.846398, .blue = 0.488400 },
	{ .red = 0.998779, .green = 0.803907, .blue = 0.492796 },
	{ .red = 0.999023, .green = 0.769719, .blue = 0.489377 },
	{ .red = 0.999023, .green = 0.740171, .blue = 0.482051 },
	{ .red = 0.999023, .green = 0.713553, .blue = 0.471306 },
	{ .red = 0.999267, .green = 0.689133, .blue = 0.458608 },
	{ .red = 0.046886, .green = 0.956288, .blue = 0.446154 },
	{ .red = 0.050061, .green = 0.960440, .blue = 0.443712 },
	{ .red = 0.062271, .green = 0.976557, .blue = 0.434921 },
	{ .red = 0.211477, .green = 0.999267, .blue = 0.432234 },
	{ .red = 0.419536, .green = 0.999512, .blue = 0.463492 },
	{ .red = 0.568742, .green = 0.998779, .blue = 0.500366 },
	{ .red = 0.663736, .green = 0.998779, .blue = 0.511355 },
	{ .red = 0.731868, .green = 0.998291, .blue = 0.490110 },
	{ .red = 0.811233, .green = 0.998291, .blue = 0.466667 },
	{ .red = 0.901832, .green = 0.999267, .blue = 0.439316 },
	{ .red = 0.997558, .green = 0.991453, .blue = 0.399267 },
	{ .red = 0.999267, .green = 0.914042, .blue = 0.445177 },
	{ .red = 0.999267, .green = 0.858120, .blue = 0.457387 },
	{ .red = 0.999267, .green = 0.814408, .blue = 0.458364 },
	{ .red = 0.999512, .green = 0.778022, .blue = 0.453968 },
	{ .red = 0.998535, .green = 0.746032, .blue = 0.446398 },
	{ .red = 0.998779, .green = 0.717949, .blue = 0.435653 },
	{ .red = 0.049573, .green = 0.970940, .blue = 0.416850 },
	{ .red = 0.060806, .green = 0.973871, .blue = 0.414652 },
	{ .red = 0.090598, .green = 0.985836, .blue = 0.406838 },
	{ .red = 0.256654, .green = 0.999512, .blue = 0.417094 },
	{ .red = 0.426618, .green = 0.999267, .blue = 0.452015 },
	{ .red = 0.560440, .green = 0.998535, .blue = 0.493529 },
	{ .red = 0.652503, .green = 0.998535, .blue = 0.517705 },
	{ .red = 0.701832, .green = 0.999756, .blue = 0.495726 },
	{ .red = 0.763370, .green = 0.998779, .blue = 0.475946 },
	{ .red = 0.834188, .green = 0.999512, .blue = 0.453480 },
	{ .red = 0.913309, .green = 0.998779, .blue = 0.435409 },
	{ .red = 0.997070, .green = 0.993895, .blue = 0.392186 },
	{ .red = 0.998779, .green = 0.921856, .blue = 0.419536 },
	{ .red = 0.998779, .green = 0.866667, .blue = 0.426618 },
	{ .red = 0.999267, .green = 0.822711, .blue = 0.425397 },
	{ .red = 0.999023, .green = 0.785104, .blue = 0.420269 },
	{ .red = 0.999267, .green = 0.752381, .blue = 0.412210 },
	{ .red = 0.079609, .green = 0.978510, .blue = 0.390720 },
	{ .red = 0.084005, .green = 0.981441, .blue = 0.388523 },
	{ .red = 0.119414, .green = 0.989011, .blue = 0.382173 },
	{ .red = 0.281807, .green = 0.999512, .blue = 0.401954 },
	{ .red = 0.427595, .green = 0.998535, .blue = 0.438095 },
	{ .red = 0.547741, .green = 0.998535, .blue = 0.480342 },
	{ .red = 0.639072, .green = 0.999267, .blue = 0.513553 },
	{ .red = 0.677900, .green = 0.999267, .blue = 0.494261 },
	{ .red = 0.726496, .green = 0.999023, .blue = 0.474725 },
	{ .red = 0.783883, .green = 0.998779, .blue = 0.455189 },
	{ .red = 0.849573, .green = 0.999512, .blue = 0.435409 },
	{ .red = 0.920635, .green = 0.998291, .blue = 0.422955 },
	{ .red = 0.997802, .green = 0.996093, .blue = 0.376068 },
	{ .red = 0.998779, .green = 0.927961, .blue = 0.393162 },
	{ .red = 0.998779, .green = 0.873993, .blue = 0.396825 },
	{ .red = 0.998535, .green = 0.829548, .blue = 0.394628 },
	{ .red = 0.998291, .green = 0.791453, .blue = 0.389255 },
	{ .red = 0.096215, .green = 0.983394, .blue = 0.366789 },
	{ .red = 0.099389, .green = 0.986081, .blue = 0.364835 },
	{ .red = 0.144811, .green = 0.995360, .blue = 0.362882 },
	{ .red = 0.294994, .green = 0.999023, .blue = 0.386813 },
	{ .red = 0.420269, .green = 0.999756, .blue = 0.421001 },
	{ .red = 0.531624, .green = 0.998779, .blue = 0.463004 },
	{ .red = 0.622955, .green = 1.000000, .blue = 0.502076 },
	{ .red = 0.655678, .green = 0.998779, .blue = 0.485714 },
	{ .red = 0.695238, .green = 0.999267, .blue = 0.466422 },
	{ .red = 0.743346, .green = 0.998779, .blue = 0.448352 },
	{ .red = 0.798779, .green = 0.999267, .blue = 0.430037 },
	{ .red = 0.860562, .green = 0.999023, .blue = 0.414896 },
	{ .red = 0.926740, .green = 0.999023, .blue = 0.403175 },
	{ .red = 0.999267, .green = 0.998535, .blue = 0.353602 },
	{ .red = 0.998779, .green = 0.932845, .blue = 0.367766 },
	{ .red = 0.999512, .green = 0.880830, .blue = 0.368742 },
	{ .red = 0.999756, .green = 0.836874, .blue = 0.365812 },
	{ .red = 0.108669, .green = 0.986325, .blue = 0.345299 },
	{ .red = 0.114042, .green = 0.988034, .blue = 0.343590 },
	{ .red = 0.167033, .green = 0.999267, .blue = 0.346276 },
	{ .red = 0.298657, .green = 0.999267, .blue = 0.370452 },
	{ .red = 0.411722, .green = 0.999023, .blue = 0.403907 },
	{ .red = 0.512576, .green = 0.999512, .blue = 0.442735 },
	{ .red = 0.600733, .green = 0.999023, .blue = 0.482540 },
	{ .red = 0.632234, .green = 0.999267, .blue = 0.470818 },
	{ .red = 0.666667, .green = 0.999267, .blue = 0.453724 },
	{ .red = 0.708425, .green = 0.998779, .blue = 0.437118 },
	{ .red = 0.756532, .green = 0.999023, .blue = 0.419780 },
	{ .red = 0.810501, .green = 0.999267, .blue = 0.404151 },
	{ .red = 0.869597, .green = 0.999512, .blue = 0.390476 },
	{ .red = 0.931624, .green = 0.999267, .blue = 0.381685 },
	{ .red = 0.998291, .green = 0.998046, .blue = 0.336264 },
	{ .red = 0.999023, .green = 0.936996, .blue = 0.343590 },
	{ .red = 0.999023, .green = 0.886203, .blue = 0.343590 },
	{ .red = 0.107937, .green = 0.989744, .blue = 0.324542 },
	{ .red = 0.115751, .green = 0.990965, .blue = 0.323321 },
	{ .red = 0.193651, .green = 0.997558, .blue = 0.332601 },
	{ .red = 0.298168, .green = 0.999267, .blue = 0.354335 },
	{ .red = 0.400244, .green = 0.998535, .blue = 0.385592 },
	{ .red = 0.493040, .green = 0.999756, .blue = 0.421978 },
	{ .red = 0.576557, .green = 0.999023, .blue = 0.459829 },
	{ .red = 0.608791, .green = 0.999267, .blue = 0.453236 },
	{ .red = 0.639805, .green = 0.998779, .blue = 0.438584 },
	{ .red = 0.676435, .green = 0.999512, .blue = 0.421978 },
	{ .red = 0.719658, .green = 0.999023, .blue = 0.407326 },
	{ .red = 0.767766, .green = 0.999267, .blue = 0.392186 },
	{ .red = 0.820513, .green = 0.999512, .blue = 0.378266 },
	{ .red = 0.876679, .green = 0.999512, .blue = 0.366789 },
	{ .red = 0.935775, .green = 0.999512, .blue = 0.358242 },
	{ .red = 0.995849, .green = 0.996581, .blue = 0.321856 },
	{ .red = 0.999267, .green = 0.940659, .blue = 0.320635 },
	{ .red = 0.090598, .green = 0.994872, .blue = 0.304274 },
	{ .red = 0.108181, .green = 0.998535, .blue = 0.305250 },
	{ .red = 0.199512, .green = 0.999267, .blue = 0.317216 },
	{ .red = 0.294994, .green = 0.998779, .blue = 0.338462 },
	{ .red = 0.386569, .green = 0.999023, .blue = 0.367033 },
	{ .red = 0.474237, .green = 0.999267, .blue = 0.401954 },
	{ .red = 0.551648, .green = 0.999267, .blue = 0.436386 },
	{ .red = 0.585348, .green = 0.999023, .blue = 0.434188 },
	{ .red = 0.613919, .green = 0.998779, .blue = 0.421245 },
	{ .red = 0.647131, .green = 0.999512, .blue = 0.406105 },
	{ .red = 0.686447, .green = 0.998779, .blue = 0.392918 },
	{ .red = 0.730159, .green = 0.999023, .blue = 0.378999 },
	{ .red = 0.778022, .green = 0.998779, .blue = 0.367033 },
	{ .red = 0.829304, .green = 0.999512, .blue = 0.354090 },
	{ .red = 0.883516, .green = 0.999756, .blue = 0.344078 },
	{ .red = 0.938950, .green = 0.999512, .blue = 0.337729 },
	{ .red = 0.994383, .green = 0.995849, .blue = 0.306471 },
	{ .red = 0.000000, .green = 0.082051, .blue = 0.585348 },
	{ .red = 0.135775, .green = 0.011966, .blue = 0.620024 },
	{ .red = 0.285470, .green = 0.015385, .blue = 0.642979 },
	{ .red = 0.425641, .green = 0.014896, .blue = 0.650061 },
	{ .red = 0.540904, .green = 0.011722, .blue = 0.642979 },
	{ .red = 0.656654, .green = 0.013187, .blue = 0.655433 },
	{ .red = 0.732112, .green = 0.019048, .blue = 0.606349 },
	{ .red = 0.793162, .green = 0.011722, .blue = 0.564103 },
	{ .red = 0.843223, .green = 0.018071, .blue = 0.527228 },
	{ .red = 0.882540, .green = 0.017827, .blue = 0.493284 },
	{ .red = 0.919414, .green = 0.012698, .blue = 0.464713 },
	{ .red = 0.952625, .green = 0.016606, .blue = 0.440293 },
	{ .red = 0.978999, .green = 0.017582, .blue = 0.416850 },
	{ .red = 0.991453, .green = 0.037851, .blue = 0.391941 },
	{ .red = 0.989744, .green = 0.053480, .blue = 0.365568 },
	{ .red = 0.992430, .green = 0.064469, .blue = 0.343834 },
	{ .red = 0.995604, .green = 0.069841, .blue = 0.324298 },
	{ .red = 0.000000, .green = 0.124786, .blue = 0.581929 },
	{ .red = 0.139438, .green = 0.014896, .blue = 0.695482 },
	{ .red = 0.311600, .green = 0.044200, .blue = 0.741148 },
	{ .red = 0.473260, .green = 0.012210, .blue = 0.750427 },
	{ .red = 0.585836, .green = 0.015873, .blue = 0.710134 },
	{ .red = 0.701832, .green = 0.015385, .blue = 0.705495 },
	{ .red = 0.785592, .green = 0.016850, .blue = 0.650061 },
	{ .red = 0.846642, .green = 0.017582, .blue = 0.598291 },
	{ .red = 0.895971, .green = 0.011966, .blue = 0.555067 },
	{ .red = 0.928449, .green = 0.019292, .blue = 0.513553 },
	{ .red = 0.962393, .green = 0.014896, .blue = 0.481563 },
	{ .red = 0.985836, .green = 0.024420, .blue = 0.451038 },
	{ .red = 0.995360, .green = 0.042735, .blue = 0.420513 },
	{ .red = 0.998779, .green = 0.056410, .blue = 0.392430 },
	{ .red = 0.999267, .green = 0.081319, .blue = 0.368498 },
	{ .red = 0.999512, .green = 0.105495, .blue = 0.348718 },
	{ .red = 0.999023, .green = 0.122344, .blue = 0.331136 },
	{ .red = 0.006105, .green = 0.217094, .blue = 0.501099 },
	{ .red = 0.124054, .green = 0.244689, .blue = 0.767033 },
	{ .red = 0.302808, .green = 0.260562, .blue = 0.746520 },
	{ .red = 0.466178, .green = 0.267155, .blue = 0.743590 },
	{ .red = 0.628816, .green = 0.258608, .blue = 0.764103 },
	{ .red = 0.792186, .green = 0.238095, .blue = 0.795360 },
	{ .red = 0.968498, .green = 0.209768, .blue = 0.796581 },
	{ .red = 0.998779, .green = 0.205617, .blue = 0.697680 },
	{ .red = 0.999023, .green = 0.208303, .blue = 0.615629 },
	{ .red = 0.999756, .green = 0.210012, .blue = 0.555800 },
	{ .red = 0.999756, .green = 0.211966, .blue = 0.509402 },
	{ .red = 0.999512, .green = 0.214164, .blue = 0.472039 },
	{ .red = 0.999267, .green = 0.215873, .blue = 0.441026 },
	{ .red = 0.999267, .green = 0.217338, .blue = 0.414408 },
	{ .red = 0.999267, .green = 0.218803, .blue = 0.391209 },
	{ .red = 0.998779, .green = 0.219048, .blue = 0.369963 },
	{ .red = 0.998535, .green = 0.219780, .blue = 0.351648 },
	{ .red = 0.015629, .green = 0.348474, .blue = 0.548230 },
	{ .red = 0.008791, .green = 0.367521, .blue = 0.624176 },
	{ .red = 0.281807, .green = 0.416117, .blue = 0.761172 },
	{ .red = 0.453480, .green = 0.425153, .blue = 0.742613 },
	{ .red = 0.616361, .green = 0.427595, .blue = 0.748718 },
	{ .red = 0.780952, .green = 0.421001, .blue = 0.774603 },
	{ .red = 0.959463, .green = 0.406105, .blue = 0.779976 },
	{ .red = 0.998535, .green = 0.398046, .blue = 0.700366 },
	{ .red = 0.999267, .green = 0.390965, .blue = 0.632723 },
	{ .red = 0.998779, .green = 0.383639, .blue = 0.583394 },
	{ .red = 0.999512, .green = 0.375580, .blue = 0.544078 },
	{ .red = 0.999023, .green = 0.367521, .blue = 0.510867 },
	{ .red = 0.999023, .green = 0.358974, .blue = 0.481807 },
	{ .red = 0.999023, .green = 0.350427, .blue = 0.455433 },
	{ .red = 0.998779, .green = 0.341392, .blue = 0.431013 },
	{ .red = 0.999512, .green = 0.332845, .blue = 0.408791 },
	{ .red = 0.998779, .green = 0.324054, .blue = 0.387790 },
	{ .red = 0.025885, .green = 0.521123, .blue = 0.631746 },
	{ .red = 0.020757, .green = 0.525519, .blue = 0.646642 },
	{ .red = 0.053480, .green = 0.583394, .blue = 0.768498 },
	{ .red = 0.410012, .green = 0.579487, .blue = 0.757998 },
	{ .red = 0.598535, .green = 0.582173, .blue = 0.740904 },
	{ .red = 0.763370, .green = 0.582662, .blue = 0.755067 },
	{ .red = 0.941880, .green = 0.569475, .blue = 0.756288 },
	{ .red = 0.998535, .green = 0.557998, .blue = 0.706716 },
	{ .red = 0.998535, .green = 0.547497, .blue = 0.659829 },
	{ .red = 0.998535, .green = 0.535043, .blue = 0.623932 },
	{ .red = 0.999023, .green = 0.521368, .blue = 0.593162 },
	{ .red = 0.999267, .green = 0.506960, .blue = 0.564591 },
	{ .red = 0.999267, .green = 0.491575, .blue = 0.537485 },
	{ .red = 0.998535, .green = 0.476190, .blue = 0.511111 },
	{ .red = 0.998535, .green = 0.460317, .blue = 0.485714 },
	{ .red = 0.999023, .green = 0.444444, .blue = 0.461294 },
	{ .red = 0.998779, .green = 0.429548, .blue = 0.438095 },
	{ .red = 0.032723, .green = 0.726740, .blue = 0.726740 },
	{ .red = 0.031258, .green = 0.728205, .blue = 0.728694 },
	{ .red = 0.025397, .green = 0.734799, .blue = 0.736996 },
	{ .red = 0.272772, .green = 0.744567, .blue = 0.747985 },
	{ .red = 0.531624, .green = 0.738706, .blue = 0.740415 },
	{ .red = 0.729426, .green = 0.728449, .blue = 0.728694 },
	{ .red = 0.903297, .green = 0.711844, .blue = 0.718681 },
	{ .red = 0.999267, .green = 0.694017, .blue = 0.704274 },
	{ .red = 0.998779, .green = 0.679853, .blue = 0.686447 },
	{ .red = 0.999512, .green = 0.663980, .blue = 0.666667 },
	{ .red = 0.999512, .green = 0.646886, .blue = 0.644933 },
	{ .red = 0.999023, .green = 0.628571, .blue = 0.621978 },
	{ .red = 0.998779, .green = 0.609524, .blue = 0.597802 },
	{ .red = 0.999756, .green = 0.589744, .blue = 0.572405 },
	{ .red = 0.998535, .green = 0.569475, .blue = 0.546764 },
	{ .red = 0.999023, .green = 0.548962, .blue = 0.520879 },
	{ .red = 0.999756, .green = 0.528938, .blue = 0.495482 },
	{ .red = 0.018559, .green = 0.807326, .blue = 0.697680 },
	{ .red = 0.021001, .green = 0.811477, .blue = 0.698657 },
	{ .red = 0.033700, .green = 0.828571, .blue = 0.702564 },
	{ .red = 0.036142, .green = 0.872772, .blue = 0.713797 },
	{ .red = 0.447863, .green = 0.868864, .blue = 0.705983 },
	{ .red = 0.668132, .green = 0.852015, .blue = 0.693040 },
	{ .red = 0.837607, .green = 0.833455, .blue = 0.684249 },
	{ .red = 0.989255, .green = 0.810989, .blue = 0.667155 },
	{ .red = 0.999756, .green = 0.784860, .blue = 0.692552 },
	{ .red = 0.998779, .green = 0.767277, .blue = 0.697680 },
	{ .red = 0.998779, .green = 0.747741, .blue = 0.687912 },
	{ .red = 0.998779, .green = 0.727961, .blue = 0.672039 },
	{ .red = 0.998779, .green = 0.706960, .blue = 0.651770 },
	{ .red = 0.998779, .green = 0.685470, .blue = 0.629060 },
	{ .red = 0.998535, .green = 0.663248, .blue = 0.604640 },
	{ .red = 0.999512, .green = 0.640537, .blue = 0.578755 },
	{ .red = 0.999023, .green = 0.618071, .blue = 0.552869 },
	{ .red = 0.029792, .green = 0.865201, .blue = 0.660073 },
	{ .red = 0.022711, .green = 0.870085, .blue = 0.660073 },
	{ .red = 0.016117, .green = 0.889377, .blue = 0.660317 },
	{ .red = 0.030525, .green = 0.935043, .blue = 0.662027 },
	{ .red = 0.339194, .green = 0.970940, .blue = 0.659341 },
	{ .red = 0.590476, .green = 0.951648, .blue = 0.647131 },
	{ .red = 0.771673, .green = 0.929182, .blue = 0.636630 },
	{ .red = 0.914042, .green = 0.907204, .blue = 0.626618 },
	{ .red = 0.998779, .green = 0.864469, .blue = 0.641758 },
	{ .red = 0.998779, .green = 0.825397, .blue = 0.672527 },
	{ .red = 0.999512, .green = 0.803907, .blue = 0.683516 },
	{ .red = 0.999023, .green = 0.789499, .blue = 0.687424 },
	{ .red = 0.999512, .green = 0.777045, .blue = 0.684982 },
	{ .red = 0.999267, .green = 0.763858, .blue = 0.676923 },
	{ .red = 0.999512, .green = 0.740171, .blue = 0.653236 },
	{ .red = 0.999512, .green = 0.716972, .blue = 0.629304 },
	{ .red = 0.999267, .green = 0.693773, .blue = 0.604151 },
	{ .red = 0.034432, .green = 0.906960, .blue = 0.620024 },
	{ .red = 0.030037, .green = 0.911600, .blue = 0.619536 },
	{ .red = 0.031990, .green = 0.929915, .blue = 0.617094 },
	{ .red = 0.038339, .green = 0.971917, .blue = 0.612943 },
	{ .red = 0.337973, .green = 0.998535, .blue = 0.614164 },
	{ .red = 0.545299, .green = 0.999512, .blue = 0.613431 },
	{ .red = 0.704274, .green = 0.999023, .blue = 0.593162 },
	{ .red = 0.839805, .green = 0.983150, .blue = 0.577289 },
	{ .red = 0.967033, .green = 0.957753, .blue = 0.565568 },
	{ .red = 0.999267, .green = 0.892552, .blue = 0.618071 },
	{ .red = 0.998535, .green = 0.848596, .blue = 0.644933 },
	{ .red = 0.998779, .green = 0.820513, .blue = 0.652991 },
	{ .red = 0.998779, .green = 0.798535, .blue = 0.652259 },
	{ .red = 0.998291, .green = 0.779976, .blue = 0.647375 },
	{ .red = 0.998535, .green = 0.763614, .blue = 0.639072 },
	{ .red = 0.998291, .green = 0.747253, .blue = 0.627839 },
	{ .red = 0.998046, .green = 0.731136, .blue = 0.614408 },
	{ .red = 0.028083, .green = 0.936996, .blue = 0.580464 },
	{ .red = 0.025397, .green = 0.941148, .blue = 0.579487 },
	{ .red = 0.044444, .green = 0.957509, .blue = 0.575580 },
	{ .red = 0.112332, .green = 0.988278, .blue = 0.568254 },
	{ .red = 0.380464, .green = 0.998779, .blue = 0.583883 },
	{ .red = 0.554823, .green = 0.999267, .blue = 0.602198 },
	{ .red = 0.692552, .green = 0.999756, .blue = 0.616361 },
	{ .red = 0.783639, .green = 0.999756, .blue = 0.594628 },
	{ .red = 0.883028, .green = 0.999023, .blue = 0.556777 },
	{ .red = 0.999267, .green = 0.988767, .blue = 0.512576 },
	{ .red = 0.999023, .green = 0.909158, .blue = 0.590476 },
	{ .red = 0.999267, .green = 0.863248, .blue = 0.610256 },
	{ .red = 0.998779, .green = 0.830281, .blue = 0.615873 },
	{ .red = 0.998779, .green = 0.804151, .blue = 0.613431 },
	{ .red = 0.999267, .green = 0.781441, .blue = 0.605861 },
	{ .red = 0.998779, .green = 0.760195, .blue = 0.595116 },
	{ .red = 0.998535, .green = 0.740659, .blue = 0.582662 },
	{ .red = 0.041758, .green = 0.957265, .blue = 0.543101 },
	{ .red = 0.052259, .green = 0.960684, .blue = 0.541880 },
	{ .red = 0.040537, .green = 0.976068, .blue = 0.537241 },
	{ .red = 0.170696, .green = 0.999756, .blue = 0.534799 },
	{ .red = 0.404396, .green = 0.999512, .blue = 0.559951 },
	{ .red = 0.557753, .green = 0.998779, .blue = 0.589011 },
	{ .red = 0.682295, .green = 0.998535, .blue = 0.619292 },
	{ .red = 0.759951, .green = 0.999023, .blue = 0.617338 },
	{ .red = 0.823932, .green = 0.999267, .blue = 0.586569 },
	{ .red = 0.904762, .green = 0.998779, .blue = 0.555800 },
	{ .red = 0.999756, .green = 0.993407, .blue = 0.503785 },
	{ .red = 0.999023, .green = 0.919902, .blue = 0.558730 },
	{ .red = 0.999023, .green = 0.872527, .blue = 0.573138 },
	{ .red = 0.998779, .green = 0.836630, .blue = 0.575824 },
	{ .red = 0.998291, .green = 0.807326, .blue = 0.572161 },
	{ .red = 0.999023, .green = 0.781929, .blue = 0.564103 },
	{ .red = 0.998535, .green = 0.758486, .blue = 0.553358 },
	{ .red = 0.042979, .green = 0.971673, .blue = 0.508181 },
	{ .red = 0.063980, .green = 0.973871, .blue = 0.506960 },
	{ .red = 0.083272, .green = 0.985348, .blue = 0.502320 },
	{ .red = 0.241270, .green = 0.999023, .blue = 0.509646 },
	{ .red = 0.418071, .green = 0.999267, .blue = 0.538217 },
	{ .red = 0.553114, .green = 0.999512, .blue = 0.571917 },
	{ .red = 0.667643, .green = 0.998535, .blue = 0.609035 },
	{ .red = 0.744811, .green = 0.999267, .blue = 0.624420 },
	{ .red = 0.788278, .green = 0.999512, .blue = 0.596093 },
	{ .red = 0.846154, .green = 0.999267, .blue = 0.568254 },
	{ .red = 0.917216, .green = 0.998779, .blue = 0.544078 },
	{ .red = 0.998046, .green = 0.994628, .blue = 0.491331 },
	{ .red = 0.999023, .green = 0.927228, .blue = 0.525031 },
	{ .red = 0.999023, .green = 0.879121, .blue = 0.535043 },
	{ .red = 0.999267, .green = 0.841514, .blue = 0.535287 },
	{ .red = 0.998535, .green = 0.810012, .blue = 0.531136 },
	{ .red = 0.999512, .green = 0.782662, .blue = 0.522589 },
	{ .red = 0.070818, .green = 0.979976, .blue = 0.476435 },
	{ .red = 0.080342, .green = 0.982173, .blue = 0.475214 },
	{ .red = 0.108181, .green = 0.990232, .blue = 0.470574 },
	{ .red = 0.273260, .green = 0.999512, .blue = 0.486935 },
	{ .red = 0.422955, .green = 0.998535, .blue = 0.516972 },
	{ .red = 0.542857, .green = 0.999756, .blue = 0.551648 },
	{ .red = 0.649328, .green = 0.998779, .blue = 0.591453 },
	{ .red = 0.731624, .green = 0.998535, .blue = 0.622955 },
	{ .red = 0.762393, .green = 0.998779, .blue = 0.596093 },
	{ .red = 0.805128, .green = 0.999267, .blue = 0.568987 },
	{ .red = 0.859829, .green = 0.999023, .blue = 0.544322 },
	{ .red = 0.925031, .green = 0.999512, .blue = 0.523321 },
	{ .red = 0.995604, .green = 0.994628, .blue = 0.475458 },
	{ .red = 0.999512, .green = 0.932845, .blue = 0.490842 },
	{ .red = 0.998291, .green = 0.884005, .blue = 0.498413 },
	{ .red = 0.999512, .green = 0.845910, .blue = 0.496947 },
	{ .red = 0.998779, .green = 0.812698, .blue = 0.492308 },
	{ .red = 0.088156, .green = 0.985104, .blue = 0.447619 },
	{ .red = 0.099145, .green = 0.986325, .blue = 0.446398 },
	{ .red = 0.136752, .green = 0.994872, .blue = 0.444933 },
	{ .red = 0.290354, .green = 0.999512, .blue = 0.464957 },
	{ .red = 0.419780, .green = 0.998535, .blue = 0.494994 },
	{ .red = 0.530647, .green = 0.998535, .blue = 0.530647 },
	{ .red = 0.628571, .green = 0.998779, .blue = 0.569719 },
	{ .red = 0.712088, .green = 0.999023, .blue = 0.607814 },
	{ .red = 0.738462, .green = 0.999267, .blue = 0.586081 },
	{ .red = 0.772161, .green = 0.999512, .blue = 0.560684 },
	{ .red = 0.816117, .green = 0.998535, .blue = 0.538462 },
	{ .red = 0.869109, .green = 0.998779, .blue = 0.516484 },
	{ .red = 0.929915, .green = 0.999023, .blue = 0.500122 },
	{ .red = 0.994383, .green = 0.994628, .blue = 0.453724 },
	{ .red = 0.998779, .green = 0.936752, .blue = 0.459341 },
	{ .red = 0.999267, .green = 0.889133, .blue = 0.462759 },
	{ .red = 0.999267, .green = 0.849817, .blue = 0.461538 },
	{ .red = 0.107204, .green = 0.987302, .blue = 0.421490 },
	{ .red = 0.110623, .green = 0.989011, .blue = 0.420269 },
	{ .red = 0.162882, .green = 0.999023, .blue = 0.423199 },
	{ .red = 0.298657, .green = 0.998779, .blue = 0.444200 },
	{ .red = 0.410256, .green = 0.999512, .blue = 0.472039 },
	{ .red = 0.513309, .green = 0.998779, .blue = 0.506716 },
	{ .red = 0.605128, .green = 0.999267, .blue = 0.544811 },
	{ .red = 0.685958, .green = 0.999267, .blue = 0.583150 },
	{ .red = 0.715507, .green = 0.999023, .blue = 0.571673 },
	{ .red = 0.743346, .green = 0.998535, .blue = 0.548962 },
	{ .red = 0.779731, .green = 0.998535, .blue = 0.526496 },
	{ .red = 0.824176, .green = 0.999023, .blue = 0.504762 },
	{ .red = 0.876190, .green = 0.999023, .blue = 0.486447 },
	{ .red = 0.934066, .green = 0.999267, .blue = 0.473016 },
	{ .red = 0.994383, .green = 0.995360, .blue = 0.428816 },
	{ .red = 0.999023, .green = 0.940171, .blue = 0.428816 },
	{ .red = 0.999267, .green = 0.893284, .blue = 0.431258 },
	{ .red = 0.113553, .green = 0.989499, .blue = 0.397558 },
	{ .red = 0.113797, .green = 0.991453, .blue = 0.396093 },
	{ .red = 0.185348, .green = 0.999756, .blue = 0.403663 },
	{ .red = 0.298413, .green = 0.999267, .blue = 0.423199 },
	{ .red = 0.400488, .green = 0.998779, .blue = 0.450061 },
	{ .red = 0.494994, .green = 0.998535, .blue = 0.482784 },
	{ .red = 0.580952, .green = 0.999267, .blue = 0.518681 },
	{ .red = 0.659096, .green = 0.999023, .blue = 0.556777 },
	{ .red = 0.691819, .green = 0.999023, .blue = 0.552625 },
	{ .red = 0.715995, .green = 0.998779, .blue = 0.531868 },
	{ .red = 0.747497, .green = 0.998535, .blue = 0.511355 },
	{ .red = 0.786081, .green = 0.999267, .blue = 0.490598 },
	{ .red = 0.831258, .green = 0.998535, .blue = 0.473504 },
	{ .red = 0.882295, .green = 0.999267, .blue = 0.456899 },
	{ .red = 0.937241, .green = 0.999267, .blue = 0.445910 },
	{ .red = 0.995849, .green = 0.996825, .blue = 0.400000 },
	{ .red = 0.999023, .green = 0.943346, .blue = 0.401465 },
	{ .red = 0.126740, .green = 0.989988, .blue = 0.376557 },
	{ .red = 0.142369, .green = 0.992918, .blue = 0.378022 },
	{ .red = 0.200488, .green = 0.999023, .blue = 0.385348 },
	{ .red = 0.294994, .green = 0.999512, .blue = 0.403175 },
	{ .red = 0.388278, .green = 0.998535, .blue = 0.428327 },
	{ .red = 0.475214, .green = 0.999023, .blue = 0.458608 },
	{ .red = 0.557753, .green = 0.998779, .blue = 0.493773 },
	{ .red = 0.632234, .green = 0.999023, .blue = 0.529670 },
	{ .red = 0.668132, .green = 0.999023, .blue = 0.531624 },
	{ .red = 0.689621, .green = 0.999267, .blue = 0.512332 },
	{ .red = 0.718193, .green = 0.998291, .blue = 0.494750 },
	{ .red = 0.752381, .green = 0.998779, .blue = 0.476190 },
	{ .red = 0.792430, .green = 0.998535, .blue = 0.459096 },
	{ .red = 0.837851, .green = 0.999512, .blue = 0.442247 },
	{ .red = 0.887424, .green = 0.999023, .blue = 0.429792 },
	{ .red = 0.940171, .green = 0.999267, .blue = 0.420513 },
	{ .red = 0.998046, .green = 0.998779, .blue = 0.371429 },
	{ .red = 0.000000, .green = 0.109402, .blue = 0.609035 },
	{ .red = 0.118193, .green = 0.014652, .blue = 0.668376 },
	{ .red = 0.258852, .green = 0.016117, .blue = 0.700611 },
	{ .red = 0.398046, .green = 0.013919, .blue = 0.719170 },
	{ .red = 0.513797, .green = 0.011477, .blue = 0.711600 },
	{ .red = 0.607326, .green = 0.011722, .blue = 0.696947 },
	{ .red = 0.723077, .green = 0.018315, .blue = 0.721123 },
	{ .red = 0.791209, .green = 0.016606, .blue = 0.675214 },
	{ .red = 0.844200, .green = 0.016850, .blue = 0.632234 },
	{ .red = 0.884493, .green = 0.014164, .blue = 0.591209 },
	{ .red = 0.914286, .green = 0.016361, .blue = 0.552625 },
	{ .red = 0.936752, .green = 0.018559, .blue = 0.517460 },
	{ .red = 0.958974, .green = 0.017827, .blue = 0.488156 },
	{ .red = 0.981929, .green = 0.022222, .blue = 0.463492 },
	{ .red = 0.990965, .green = 0.041026, .blue = 0.436386 },
	{ .red = 0.998046, .green = 0.046642, .blue = 0.411477 },
	{ .red = 0.999267, .green = 0.059341, .blue = 0.388034 },
	{ .red = 0.000000, .green = 0.134554, .blue = 0.609035 },
	{ .red = 0.122344, .green = 0.015873, .blue = 0.734310 },
	{ .red = 0.281319, .green = 0.015873, .blue = 0.794628 },
	{ .red = 0.441758, .green = 0.019048, .blue = 0.823932 },
	{ .red = 0.561661, .green = 0.019292, .blue = 0.793895 },
	{ .red = 0.650549, .green = 0.019048, .blue = 0.755311 },
	{ .red = 0.767766, .green = 0.019292, .blue = 0.769475 },
	{ .red = 0.839805, .green = 0.018803, .blue = 0.717216 },
	{ .red = 0.891575, .green = 0.019292, .blue = 0.665446 },
	{ .red = 0.927961, .green = 0.017094, .blue = 0.616850 },
	{ .red = 0.954335, .green = 0.011722, .blue = 0.573138 },
	{ .red = 0.970208, .green = 0.020513, .blue = 0.532357 },
	{ .red = 0.979731, .green = 0.038095, .blue = 0.495726 },
	{ .red = 0.987546, .green = 0.051282, .blue = 0.463980 },
	{ .red = 0.995604, .green = 0.077900, .blue = 0.438339 },
	{ .red = 0.999023, .green = 0.100122, .blue = 0.414896 },
	{ .red = 0.999023, .green = 0.118926, .blue = 0.393407 },
	{ .red = 0.003175, .green = 0.204884, .blue = 0.562393 },
	{ .red = 0.129670, .green = 0.212943, .blue = 0.921856 },
	{ .red = 0.304518, .green = 0.237118, .blue = 0.899389 },
	{ .red = 0.467399, .green = 0.251282, .blue = 0.888645 },
	{ .red = 0.628816, .green = 0.246642, .blue = 0.901343 },
	{ .red = 0.791209, .green = 0.225641, .blue = 0.929426 },
	{ .red = 0.954090, .green = 0.190476, .blue = 0.962637 },
	{ .red = 0.999512, .green = 0.192430, .blue = 0.852259 },
	{ .red = 0.999023, .green = 0.202930, .blue = 0.742613 },
	{ .red = 0.998535, .green = 0.208791, .blue = 0.664713 },
	{ .red = 0.998779, .green = 0.211966, .blue = 0.606105 },
	{ .red = 0.999267, .green = 0.214408, .blue = 0.559707 },
	{ .red = 0.999267, .green = 0.216606, .blue = 0.521368 },
	{ .red = 0.999512, .green = 0.218071, .blue = 0.488889 },
	{ .red = 0.998779, .green = 0.219292, .blue = 0.460317 },
	{ .red = 0.999023, .green = 0.220269, .blue = 0.435409 },
	{ .red = 0.999512, .green = 0.220024, .blue = 0.413187 },
	{ .red = 0.000000, .green = 0.313797, .blue = 0.591941 },
	{ .red = 0.010745, .green = 0.340904, .blue = 0.729915 },
	{ .red = 0.288156, .green = 0.401465, .blue = 0.912332 },
	{ .red = 0.457143, .green = 0.413187, .blue = 0.892308 },
	{ .red = 0.619048, .green = 0.418071, .blue = 0.891819 },
	{ .red = 0.781197, .green = 0.413675, .blue = 0.911844 },
	{ .red = 0.944811, .green = 0.401221, .blue = 0.942613 },
	{ .red = 0.999023, .green = 0.394139, .blue = 0.848107 },
	{ .red = 0.999512, .green = 0.390965, .blue = 0.750427 },
	{ .red = 0.999023, .green = 0.385592, .blue = 0.683516 },
	{ .red = 0.998779, .green = 0.378755, .blue = 0.632967 },
	{ .red = 0.998535, .green = 0.371184, .blue = 0.591941 },
	{ .red = 0.999756, .green = 0.363126, .blue = 0.557509 },
	{ .red = 0.999756, .green = 0.354579, .blue = 0.526252 },
	{ .red = 0.999023, .green = 0.345543, .blue = 0.497680 },
	{ .red = 0.999512, .green = 0.336508, .blue = 0.472039 },
	{ .red = 0.999267, .green = 0.327717, .blue = 0.448107 },
	{ .red = 0.024176, .green = 0.450305, .blue = 0.644444 },
	{ .red = 0.017827, .green = 0.465934, .blue = 0.686935 },
	{ .red = 0.168010, .green = 0.566056, .blue = 0.926496 },
	{ .red = 0.436386, .green = 0.564347, .blue = 0.907937 },
	{ .red = 0.604396, .green = 0.572894, .blue = 0.890110 },
	{ .red = 0.765812, .green = 0.575580, .blue = 0.895726 },
	{ .red = 0.923321, .green = 0.566545, .blue = 0.914530 },
	{ .red = 0.998291, .green = 0.555311, .blue = 0.846886 },
	{ .red = 0.998046, .green = 0.548718, .blue = 0.765812 },
	{ .red = 0.999512, .green = 0.538706, .blue = 0.714042 },
	{ .red = 0.998535, .green = 0.526740, .blue = 0.673260 },
	{ .red = 0.998779, .green = 0.513065, .blue = 0.638828 },
	{ .red = 0.998779, .green = 0.498413, .blue = 0.607082 },
	{ .red = 0.998779, .green = 0.483028, .blue = 0.577534 },
	{ .red = 0.999756, .green = 0.466911, .blue = 0.548962 },
	{ .red = 0.999023, .green = 0.451038, .blue = 0.521856 },
	{ .red = 0.999512, .green = 0.434921, .blue = 0.496215 },
	{ .red = 0.023443, .green = 0.630525, .blue = 0.738217 },
	{ .red = 0.021978, .green = 0.636386, .blue = 0.750672 },
	{ .red = 0.027839, .green = 0.671795, .blue = 0.817338 },
	{ .red = 0.306471, .green = 0.729426, .blue = 0.915751 },
	{ .red = 0.558730, .green = 0.721123, .blue = 0.899634 },
	{ .red = 0.734554, .green = 0.717460, .blue = 0.873748 },
	{ .red = 0.883761, .green = 0.707692, .blue = 0.874969 },
	{ .red = 0.998535, .green = 0.690110, .blue = 0.842491 },
	{ .red = 0.999267, .green = 0.681807, .blue = 0.785348 },
	{ .red = 0.998779, .green = 0.669353, .blue = 0.748718 },
	{ .red = 0.998291, .green = 0.653968, .blue = 0.718437 },
	{ .red = 0.998535, .green = 0.636874, .blue = 0.690110 },
	{ .red = 0.999512, .green = 0.618071, .blue = 0.662027 },
	{ .red = 0.998535, .green = 0.598291, .blue = 0.634188 },
	{ .red = 0.997802, .green = 0.577778, .blue = 0.606105 },
	{ .red = 0.999512, .green = 0.557265, .blue = 0.578755 },
	{ .red = 0.999267, .green = 0.536752, .blue = 0.551160 },
	{ .red = 0.036142, .green = 0.814164, .blue = 0.814164 },
	{ .red = 0.035409, .green = 0.817338, .blue = 0.817582 },
	{ .red = 0.031013, .green = 0.830037, .blue = 0.831746 },
	{ .red = 0.028571, .green = 0.862271, .blue = 0.866911 },
	{ .red = 0.431013, .green = 0.860562, .blue = 0.864225 },
	{ .red = 0.649573, .green = 0.845665, .blue = 0.847375 },
	{ .red = 0.827595, .green = 0.826374, .blue = 0.826618 },
	{ .red = 0.982662, .green = 0.801954, .blue = 0.809280 },
	{ .red = 0.998291, .green = 0.787057, .blue = 0.793651 },
	{ .red = 0.998291, .green = 0.771917, .blue = 0.776557 },
	{ .red = 0.998535, .green = 0.754823, .blue = 0.757265 },
	{ .red = 0.999756, .green = 0.736020, .blue = 0.735531 },
	{ .red = 0.998535, .green = 0.715995, .blue = 0.711844 },
	{ .red = 0.998535, .green = 0.694505, .blue = 0.686691 },
	{ .red = 0.998535, .green = 0.672283, .blue = 0.660317 },
	{ .red = 0.998046, .green = 0.649573, .blue = 0.633455 },
	{ .red = 0.998779, .green = 0.626618, .blue = 0.605861 },
	{ .red = 0.026129, .green = 0.870085, .blue = 0.769231 },
	{ .red = 0.029792, .green = 0.874237, .blue = 0.771184 },
	{ .red = 0.037851, .green = 0.890110, .blue = 0.778755 },
	{ .red = 0.036142, .green = 0.926740, .blue = 0.795849 },
	{ .red = 0.293040, .green = 0.965324, .blue = 0.810989 },
	{ .red = 0.560928, .green = 0.947497, .blue = 0.794872 },
	{ .red = 0.752869, .green = 0.924542, .blue = 0.776313 },
	{ .red = 0.904518, .green = 0.900366, .blue = 0.761905 },
	{ .red = 0.998291, .green = 0.868376, .blue = 0.763370 },
	{ .red = 0.999512, .green = 0.848840, .blue = 0.784615 },
	{ .red = 0.999267, .green = 0.831502, .blue = 0.781929 },
	{ .red = 0.998535, .green = 0.812210, .blue = 0.768987 },
	{ .red = 0.999267, .green = 0.791697, .blue = 0.750672 },
	{ .red = 0.998779, .green = 0.770452, .blue = 0.729426 },
	{ .red = 0.999512, .green = 0.748230, .blue = 0.705495 },
	{ .red = 0.999512, .green = 0.725275, .blue = 0.680342 },
	{ .red = 0.998535, .green = 0.701832, .blue = 0.653968 },
	{ .red = 0.037363, .green = 0.909646, .blue = 0.722833 },
	{ .red = 0.033455, .green = 0.913797, .blue = 0.723565 },
	{ .red = 0.019536, .green = 0.929915, .blue = 0.726740 },
	{ .red = 0.049573, .green = 0.964103, .blue = 0.733822 },
	{ .red = 0.287668, .green = 0.998779, .blue = 0.742125 },
	{ .red = 0.514286, .green = 0.998779, .blue = 0.740171 },
	{ .red = 0.675214, .green = 0.998779, .blue = 0.724054 },
	{ .red = 0.831013, .green = 0.976557, .blue = 0.707204 },
	{ .red = 0.958242, .green = 0.951404, .blue = 0.693773 },
	{ .red = 0.999267, .green = 0.899878, .blue = 0.733333 },
	{ .red = 0.998535, .green = 0.869597, .blue = 0.756288 },
	{ .red = 0.998046, .green = 0.852015, .blue = 0.762882 },
	{ .red = 0.998779, .green = 0.838828, .blue = 0.762149 },
	{ .red = 0.999267, .green = 0.826862, .blue = 0.757021 },
	{ .red = 0.999267, .green = 0.808547, .blue = 0.740659 },
	{ .red = 0.999512, .green = 0.786081, .blue = 0.717460 },
	{ .red = 0.998779, .green = 0.763370, .blue = 0.693284 },
	{ .red = 0.031746, .green = 0.938462, .blue = 0.677411 },
	{ .red = 0.035165, .green = 0.942125, .blue = 0.677656 },
	{ .red = 0.025641, .green = 0.957021, .blue = 0.677900 },
	{ .red = 0.087668, .green = 0.985104, .blue = 0.678632 },
	{ .red = 0.352625, .green = 0.999023, .blue = 0.690110 },
	{ .red = 0.535775, .green = 0.999512, .blue = 0.703053 },
	{ .red = 0.675702, .green = 0.999512, .blue = 0.712088 },
	{ .red = 0.793162, .green = 0.999512, .blue = 0.710134 },
	{ .red = 0.881319, .green = 0.998291, .blue = 0.669597 },
	{ .red = 0.995116, .green = 0.985836, .blue = 0.627350 },
	{ .red = 0.998291, .green = 0.916239, .blue = 0.702076 },
	{ .red = 0.998535, .green = 0.881074, .blue = 0.720879 },
	{ .red = 0.999512, .green = 0.857387, .blue = 0.724786 },
	{ .red = 0.998535, .green = 0.838339, .blue = 0.722344 },
	{ .red = 0.998046, .green = 0.821978, .blue = 0.716239 },
	{ .red = 0.999512, .green = 0.806838, .blue = 0.706471 },
	{ .red = 0.998535, .green = 0.791697, .blue = 0.695238 },
	{ .red = 0.035653, .green = 0.958486, .blue = 0.634676 },
	{ .red = 0.034432, .green = 0.961905, .blue = 0.634432 },
	{ .red = 0.055189, .green = 0.974359, .blue = 0.632967 },
	{ .red = 0.150427, .green = 0.994628, .blue = 0.632234 },
	{ .red = 0.390720, .green = 0.998779, .blue = 0.652747 },
	{ .red = 0.547741, .green = 0.998291, .blue = 0.675214 },
	{ .red = 0.672039, .green = 0.998535, .blue = 0.697680 },
	{ .red = 0.776801, .green = 0.998535, .blue = 0.718193 },
	{ .red = 0.839072, .green = 0.998535, .blue = 0.698413 },
	{ .red = 0.908425, .green = 0.999267, .blue = 0.658608 },
	{ .red = 0.999267, .green = 0.992918, .blue = 0.606838 },
	{ .red = 0.999267, .green = 0.926496, .blue = 0.664713 },
	{ .red = 0.998046, .green = 0.887424, .blue = 0.681074 },
	{ .red = 0.998291, .green = 0.859829, .blue = 0.683761 },
	{ .red = 0.998779, .green = 0.837118, .blue = 0.679609 },
	{ .red = 0.998046, .green = 0.816850, .blue = 0.672039 },
	{ .red = 0.999756, .green = 0.798291, .blue = 0.660317 },
	{ .red = 0.021001, .green = 0.972894, .blue = 0.595116 },
	{ .red = 0.021978, .green = 0.976068, .blue = 0.594383 },
	{ .red = 0.088645, .green = 0.983883, .blue = 0.591941 },
	{ .red = 0.222466, .green = 0.999023, .blue = 0.598046 },
	{ .red = 0.411233, .green = 0.998535, .blue = 0.621978 },
	{ .red = 0.547741, .green = 0.999023, .blue = 0.649328 },
	{ .red = 0.662271, .green = 0.998291, .blue = 0.678877 },
	{ .red = 0.758486, .green = 0.998535, .blue = 0.707937 },
	{ .red = 0.818803, .green = 0.998291, .blue = 0.709646 },
	{ .red = 0.860806, .green = 0.998535, .blue = 0.675458 },
	{ .red = 0.921856, .green = 0.998535, .blue = 0.644200 },
	{ .red = 0.999023, .green = 0.995116, .blue = 0.585836 },
	{ .red = 0.999023, .green = 0.932601, .blue = 0.626374 },
	{ .red = 0.998535, .green = 0.891819, .blue = 0.638339 },
	{ .red = 0.998779, .green = 0.861050, .blue = 0.639560 },
	{ .red = 0.999512, .green = 0.835897, .blue = 0.634921 },
	{ .red = 0.998535, .green = 0.813187, .blue = 0.627595 },
	{ .red = 0.042491, .green = 0.982173, .blue = 0.558242 },
	{ .red = 0.062027, .green = 0.983883, .blue = 0.557509 },
	{ .red = 0.101343, .green = 0.990476, .blue = 0.554823 },
	{ .red = 0.265201, .green = 0.999267, .blue = 0.568254 },
	{ .red = 0.417094, .green = 0.999756, .blue = 0.593407 },
	{ .red = 0.540415, .green = 0.999267, .blue = 0.623199 },
	{ .red = 0.645665, .green = 0.999267, .blue = 0.655189 },
	{ .red = 0.737241, .green = 0.998535, .blue = 0.689133 },
	{ .red = 0.801954, .green = 0.999756, .blue = 0.706716 },
	{ .red = 0.830037, .green = 0.999023, .blue = 0.675702 },
	{ .red = 0.872527, .green = 0.999267, .blue = 0.644200 },
	{ .red = 0.929915, .green = 0.999756, .blue = 0.617582 },
	{ .red = 0.999023, .green = 0.997070, .blue = 0.557753 },
	{ .red = 0.999756, .green = 0.937485, .blue = 0.586081 },
	{ .red = 0.999023, .green = 0.895238, .blue = 0.595604 },
	{ .red = 0.999023, .green = 0.862271, .blue = 0.596093 },
	{ .red = 0.998291, .green = 0.834676, .blue = 0.592186 },
	{ .red = 0.088645, .green = 0.985592, .blue = 0.525031 },
	{ .red = 0.088889, .green = 0.988034, .blue = 0.524298 },
	{ .red = 0.123321, .green = 0.995360, .blue = 0.523077 },
	{ .red = 0.288889, .green = 0.998779, .blue = 0.541148 },
	{ .red = 0.416606, .green = 0.999512, .blue = 0.566056 },
	{ .red = 0.528449, .green = 0.999267, .blue = 0.596337 },
	{ .red = 0.626862, .green = 0.998779, .blue = 0.629792 },
	{ .red = 0.713065, .green = 0.998779, .blue = 0.664713 },
	{ .red = 0.785104, .green = 0.999512, .blue = 0.696703 },
	{ .red = 0.805128, .green = 0.999756, .blue = 0.667399 },
	{ .red = 0.836386, .green = 0.998535, .blue = 0.639316 },
	{ .red = 0.879853, .green = 0.998779, .blue = 0.611966 },
	{ .red = 0.934554, .green = 0.999512, .blue = 0.589499 },
	{ .red = 0.997314, .green = 0.996825, .blue = 0.531380 },
	{ .red = 0.998291, .green = 0.940171, .blue = 0.549695 },
	{ .red = 0.998535, .green = 0.897924, .blue = 0.555556 },
	{ .red = 0.999512, .green = 0.863980, .blue = 0.554823 },
	{ .red = 0.098168, .green = 0.989011, .blue = 0.494750 },
	{ .red = 0.103785, .green = 0.990476, .blue = 0.494017 },
	{ .red = 0.157509, .green = 0.999756, .blue = 0.497192 },
	{ .red = 0.296947, .green = 0.999023, .blue = 0.515263 },
	{ .red = 0.410012, .green = 0.999512, .blue = 0.539438 },
	{ .red = 0.512332, .green = 0.999267, .blue = 0.568987 },
	{ .red = 0.605617, .green = 0.998291, .blue = 0.602686 },
	{ .red = 0.687179, .green = 0.999023, .blue = 0.637363 },
	{ .red = 0.759707, .green = 0.998291, .blue = 0.673016 },
	{ .red = 0.782906, .green = 0.998535, .blue = 0.655678 },
	{ .red = 0.806593, .green = 0.998779, .blue = 0.627350 },
	{ .red = 0.840781, .green = 0.999023, .blue = 0.600488 },
	{ .red = 0.884982, .green = 0.999023, .blue = 0.577045 },
	{ .red = 0.936996, .green = 0.998291, .blue = 0.562149 },
	{ .red = 0.996093, .green = 0.996337, .blue = 0.504518 },
	{ .red = 0.999023, .green = 0.943346, .blue = 0.513065 },
	{ .red = 0.999267, .green = 0.900855, .blue = 0.517949 },
	{ .red = 0.117460, .green = 0.989499, .blue = 0.467399 },
	{ .red = 0.123321, .green = 0.990476, .blue = 0.466667 },
	{ .red = 0.188523, .green = 0.998779, .blue = 0.473748 },
	{ .red = 0.297924, .green = 0.999512, .blue = 0.490354 },
	{ .red = 0.400733, .green = 0.999023, .blue = 0.513797 },
	{ .red = 0.495482, .green = 0.998535, .blue = 0.542369 },
	{ .red = 0.581685, .green = 0.999023, .blue = 0.574359 },
	{ .red = 0.660562, .green = 0.998779, .blue = 0.608791 },
	{ .red = 0.731380, .green = 0.998779, .blue = 0.644200 },
	{ .red = 0.760195, .green = 0.998291, .blue = 0.638095 },
	{ .red = 0.779243, .green = 0.998779, .blue = 0.611477 },
	{ .red = 0.807570, .green = 0.999023, .blue = 0.586081 },
	{ .red = 0.844444, .green = 0.999512, .blue = 0.562393 },
	{ .red = 0.889377, .green = 0.999267, .blue = 0.542613 },
	{ .red = 0.940415, .green = 0.999512, .blue = 0.528205 },
	{ .red = 0.994383, .green = 0.995604, .blue = 0.479121 },
	{ .red = 0.999267, .green = 0.946276, .blue = 0.480342 },
	{ .red = 0.118193, .green = 0.991941, .blue = 0.442247 },
	{ .red = 0.134066, .green = 0.994872, .blue = 0.443956 },
	{ .red = 0.198779, .green = 0.999756, .blue = 0.451282 },
	{ .red = 0.295726, .green = 0.999512, .blue = 0.466911 },
	{ .red = 0.388767, .green = 0.999023, .blue = 0.488889 },
	{ .red = 0.475458, .green = 0.999512, .blue = 0.515507 },
	{ .red = 0.557998, .green = 0.999023, .blue = 0.546276 },
	{ .red = 0.634188, .green = 0.998535, .blue = 0.579976 },
	{ .red = 0.702076, .green = 0.999267, .blue = 0.613431 },
	{ .red = 0.736508, .green = 0.999023, .blue = 0.615873 },
	{ .red = 0.753602, .green = 0.999023, .blue = 0.592918 },
	{ .red = 0.777778, .green = 0.999267, .blue = 0.569475 },
	{ .red = 0.809768, .green = 0.998535, .blue = 0.548718 },
	{ .red = 0.848352, .green = 0.999023, .blue = 0.527961 },
	{ .red = 0.893040, .green = 0.999023, .blue = 0.511355 },
	{ .red = 0.942613, .green = 0.999512, .blue = 0.498413 },
	{ .red = 0.993895, .green = 0.995360, .blue = 0.453480 },
	{ .red = 0.000000, .green = 0.135287, .blue = 0.610745 },
	{ .red = 0.102320, .green = 0.017338, .blue = 0.712088 },
	{ .red = 0.236630, .green = 0.019292, .blue = 0.749451 },
	{ .red = 0.374359, .green = 0.017338, .blue = 0.783639 },
	{ .red = 0.493040, .green = 0.020757, .blue = 0.782173 },
	{ .red = 0.587057, .green = 0.019292, .blue = 0.763614 },
	{ .red = 0.674725, .green = 0.013187, .blue = 0.756288 },
	{ .red = 0.786569, .green = 0.021490, .blue = 0.784860 },
	{ .red = 0.844200, .green = 0.018071, .blue = 0.736996 },
	{ .red = 0.884493, .green = 0.018559, .blue = 0.688156 },
	{ .red = 0.915263, .green = 0.016361, .blue = 0.643468 },
	{ .red = 0.937241, .green = 0.020024, .blue = 0.601954 },
	{ .red = 0.956288, .green = 0.015140, .blue = 0.565568 },
	{ .red = 0.968742, .green = 0.020269, .blue = 0.531380 },
	{ .red = 0.976801, .green = 0.033700, .blue = 0.499389 },
	{ .red = 0.985592, .green = 0.042979, .blue = 0.472283 },
	{ .red = 0.991209, .green = 0.052259, .blue = 0.446886 },
	{ .red = 0.007814, .green = 0.146764, .blue = 0.626129 },
	{ .red = 0.107937, .green = 0.010256, .blue = 0.770696 },
	{ .red = 0.253236, .green = 0.020024, .blue = 0.824908 },
	{ .red = 0.410745, .green = 0.011966, .blue = 0.882051 },
	{ .red = 0.538706, .green = 0.024420, .blue = 0.871306 },
	{ .red = 0.632479, .green = 0.021245, .blue = 0.833455 },
	{ .red = 0.716239, .green = 0.010501, .blue = 0.809035 },
	{ .red = 0.829304, .green = 0.017827, .blue = 0.830525 },
	{ .red = 0.886935, .green = 0.019048, .blue = 0.775092 },
	{ .red = 0.925519, .green = 0.016117, .blue = 0.718926 },
	{ .red = 0.952869, .green = 0.010989, .blue = 0.667643 },
	{ .red = 0.970696, .green = 0.017827, .blue = 0.620757 },
	{ .red = 0.985104, .green = 0.015873, .blue = 0.579976 },
	{ .red = 0.989255, .green = 0.030281, .blue = 0.540171 },
	{ .red = 0.998535, .green = 0.065934, .blue = 0.509646 },
	{ .red = 0.999512, .green = 0.095238, .blue = 0.480586 },
	{ .red = 0.998779, .green = 0.115018, .blue = 0.454945 },
	{ .red = 0.000000, .green = 0.198779, .blue = 0.646154 },
	{ .red = 0.129915, .green = 0.171917, .blue = 0.999023 },
	{ .red = 0.293040, .green = 0.202442, .blue = 0.998291 },
	{ .red = 0.453236, .green = 0.226862, .blue = 0.998291 },
	{ .red = 0.607082, .green = 0.230525, .blue = 0.999512 },
	{ .red = 0.747253, .green = 0.216361, .blue = 0.999023 },
	{ .red = 0.874969, .green = 0.194139, .blue = 0.998779 },
	{ .red = 0.992430, .green = 0.171673, .blue = 0.999023 },
	{ .red = 0.999756, .green = 0.191209, .blue = 0.873016 },
	{ .red = 0.999023, .green = 0.203907, .blue = 0.775092 },
	{ .red = 0.999023, .green = 0.211233, .blue = 0.702808 },
	{ .red = 0.999756, .green = 0.215140, .blue = 0.646886 },
	{ .red = 0.999267, .green = 0.217582, .blue = 0.600488 },
	{ .red = 0.999023, .green = 0.219048, .blue = 0.561661 },
	{ .red = 0.999023, .green = 0.220269, .blue = 0.528449 },
	{ .red = 0.999267, .green = 0.221245, .blue = 0.499389 },
	{ .red = 0.999512, .green = 0.221490, .blue = 0.473748 },
	{ .red = 0.000000, .green = 0.279365, .blue = 0.617582 },
	{ .red = 0.000000, .green = 0.350916, .blue = 0.981441 },
	{ .red = 0.285958, .green = 0.376557, .blue = 1.000000 },
	{ .red = 0.446886, .green = 0.393407, .blue = 0.998291 },
	{ .red = 0.604396, .green = 0.402930, .blue = 0.999023 },
	{ .red = 0.750427, .green = 0.401954, .blue = 0.998046 },
	{ .red = 0.884249, .green = 0.395604, .blue = 0.999512 },
	{ .red = 0.999512, .green = 0.385836, .blue = 0.994872 },
	{ .red = 0.998779, .green = 0.387057, .blue = 0.870085 },
	{ .red = 0.999023, .green = 0.385348, .blue = 0.783150 },
	{ .red = 0.998779, .green = 0.380952, .blue = 0.720147 },
	{ .red = 0.999267, .green = 0.374603, .blue = 0.671062 },
	{ .red = 0.998535, .green = 0.366789, .blue = 0.629304 },
	{ .red = 0.999023, .green = 0.358242, .blue = 0.593895 },
	{ .red = 0.998291, .green = 0.349451, .blue = 0.561416 },
	{ .red = 0.999267, .green = 0.340171, .blue = 0.532845 },
	{ .red = 0.998779, .green = 0.331380, .blue = 0.506227 },
	{ .red = 0.018071, .green = 0.412698, .blue = 0.687179 },
	{ .red = 0.008303, .green = 0.431502, .blue = 0.752381 },
	{ .red = 0.230525, .green = 0.522344, .blue = 0.998291 },
	{ .red = 0.439316, .green = 0.544078, .blue = 0.998291 },
	{ .red = 0.597314, .green = 0.557021, .blue = 0.998046 },
	{ .red = 0.749206, .green = 0.562393, .blue = 0.999267 },
	{ .red = 0.886935, .green = 0.557753, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.547741, .blue = 0.987302 },
	{ .red = 0.998535, .green = 0.545299, .blue = 0.874237 },
	{ .red = 0.999023, .green = 0.539438, .blue = 0.800977 },
	{ .red = 0.999512, .green = 0.530159, .blue = 0.749695 },
	{ .red = 0.999756, .green = 0.518193, .blue = 0.708181 },
	{ .red = 0.998535, .green = 0.504274, .blue = 0.671795 },
	{ .red = 0.999267, .green = 0.489133, .blue = 0.639072 },
	{ .red = 0.998779, .green = 0.473260, .blue = 0.608059 },
	{ .red = 0.999512, .green = 0.457143, .blue = 0.579243 },
	{ .red = 0.999023, .green = 0.441270, .blue = 0.551404 },
	{ .red = 0.026374, .green = 0.556532, .blue = 0.749206 },
	{ .red = 0.024908, .green = 0.567277, .blue = 0.774603 },
	{ .red = 0.018315, .green = 0.640049, .blue = 0.930403 },
	{ .red = 0.372161, .green = 0.682540, .blue = 0.998291 },
	{ .red = 0.584127, .green = 0.697436, .blue = 0.999512 },
	{ .red = 0.733089, .green = 0.702808, .blue = 0.998046 },
	{ .red = 0.877411, .green = 0.696947, .blue = 0.999023 },
	{ .red = 0.998535, .green = 0.682051, .blue = 0.987057 },
	{ .red = 0.998291, .green = 0.679121, .blue = 0.883028 },
	{ .red = 0.998779, .green = 0.671306, .blue = 0.825153 },
	{ .red = 0.998535, .green = 0.659096, .blue = 0.784860 },
	{ .red = 0.998779, .green = 0.643468, .blue = 0.751160 },
	{ .red = 0.998779, .green = 0.625641, .blue = 0.720147 },
	{ .red = 0.998779, .green = 0.606593, .blue = 0.690354 },
	{ .red = 0.999267, .green = 0.586081, .blue = 0.660806 },
	{ .red = 0.998779, .green = 0.565324, .blue = 0.631746 },
	{ .red = 0.999023, .green = 0.544322, .blue = 0.603175 },
	{ .red = 0.031990, .green = 0.720391, .blue = 0.823199 },
	{ .red = 0.032723, .green = 0.726007, .blue = 0.832967 },
	{ .red = 0.024664, .green = 0.752381, .blue = 0.878144 },
	{ .red = 0.148718, .green = 0.828083, .blue = 0.998535 },
	{ .red = 0.467888, .green = 0.830525, .blue = 0.999267 },
	{ .red = 0.672527, .green = 0.825153, .blue = 0.995604 },
	{ .red = 0.829548, .green = 0.813187, .blue = 0.961172 },
	{ .red = 0.961172, .green = 0.795849, .blue = 0.952381 },
	{ .red = 0.998779, .green = 0.785836, .blue = 0.888645 },
	{ .red = 0.998291, .green = 0.775824, .blue = 0.847131 },
	{ .red = 0.999512, .green = 0.761416, .blue = 0.818071 },
	{ .red = 0.999756, .green = 0.744322, .blue = 0.791697 },
	{ .red = 0.998535, .green = 0.725031, .blue = 0.765079 },
	{ .red = 0.999512, .green = 0.703785, .blue = 0.738462 },
	{ .red = 0.999512, .green = 0.681563, .blue = 0.711111 },
	{ .red = 0.999023, .green = 0.658608, .blue = 0.683028 },
	{ .red = 0.998291, .green = 0.635409, .blue = 0.654457 },
	{ .red = 0.025153, .green = 0.874725, .blue = 0.874725 },
	{ .red = 0.025885, .green = 0.878144, .blue = 0.878388 },
	{ .red = 0.028327, .green = 0.891087, .blue = 0.892308 },
	{ .red = 0.031990, .green = 0.920391, .blue = 0.923810 },
	{ .red = 0.272772, .green = 0.954090, .blue = 0.959219 },
	{ .red = 0.546032, .green = 0.937241, .blue = 0.940659 },
	{ .red = 0.735043, .green = 0.916239, .blue = 0.917949 },
	{ .red = 0.893040, .green = 0.891819, .blue = 0.892063 },
	{ .red = 0.998535, .green = 0.867643, .blue = 0.873016 },
	{ .red = 0.998291, .green = 0.853724, .blue = 0.858364 },
	{ .red = 0.998535, .green = 0.837851, .blue = 0.841270 },
	{ .red = 0.998291, .green = 0.820024, .blue = 0.822222 },
	{ .red = 0.998291, .green = 0.800733, .blue = 0.800977 },
	{ .red = 0.999512, .green = 0.779731, .blue = 0.777778 },
	{ .red = 0.998291, .green = 0.757509, .blue = 0.753114 },
	{ .red = 0.999267, .green = 0.734554, .blue = 0.726984 },
	{ .red = 0.999023, .green = 0.710867, .blue = 0.699878 },
	{ .red = 0.031502, .green = 0.913309, .blue = 0.821245 },
	{ .red = 0.029304, .green = 0.916728, .blue = 0.823199 },
	{ .red = 0.015873, .green = 0.930647, .blue = 0.831502 },
	{ .red = 0.066178, .green = 0.958974, .blue = 0.847619 },
	{ .red = 0.225885, .green = 0.999512, .blue = 0.870818 },
	{ .red = 0.480098, .green = 0.999023, .blue = 0.867888 },
	{ .red = 0.644444, .green = 0.996825, .blue = 0.856166 },
	{ .red = 0.812698, .green = 0.970696, .blue = 0.834432 },
	{ .red = 0.947985, .green = 0.943834, .blue = 0.816606 },
	{ .red = 0.998779, .green = 0.908425, .blue = 0.835409 },
	{ .red = 0.999512, .green = 0.893284, .blue = 0.848352 },
	{ .red = 0.999023, .green = 0.875946, .blue = 0.840537 },
	{ .red = 0.998535, .green = 0.857143, .blue = 0.825397 },
	{ .red = 0.999267, .green = 0.837118, .blue = 0.806349 },
	{ .red = 0.999512, .green = 0.816117, .blue = 0.784860 },
	{ .red = 0.999267, .green = 0.794139, .blue = 0.761416 },
	{ .red = 0.999023, .green = 0.771673, .blue = 0.736508 },
	{ .red = 0.035409, .green = 0.940415, .blue = 0.769719 },
	{ .red = 0.037851, .green = 0.943834, .blue = 0.770940 },
	{ .red = 0.032234, .green = 0.956777, .blue = 0.774847 },
	{ .red = 0.093529, .green = 0.980708, .blue = 0.782173 },
	{ .red = 0.324298, .green = 0.999512, .blue = 0.794139 },
	{ .red = 0.518926, .green = 0.999267, .blue = 0.802442 },
	{ .red = 0.659829, .green = 0.998779, .blue = 0.807082 },
	{ .red = 0.775336, .green = 0.998779, .blue = 0.802930 },
	{ .red = 0.875458, .green = 0.999512, .blue = 0.770208 },
	{ .red = 0.986081, .green = 0.978999, .blue = 0.743346 },
	{ .red = 0.999023, .green = 0.924786, .blue = 0.800244 },
	{ .red = 0.998779, .green = 0.900611, .blue = 0.815140 },
	{ .red = 0.998779, .green = 0.885470, .blue = 0.817094 },
	{ .red = 0.998779, .green = 0.873260, .blue = 0.813919 },
	{ .red = 0.999267, .green = 0.861538, .blue = 0.807082 },
	{ .red = 0.999023, .green = 0.841026, .blue = 0.786569 },
	{ .red = 0.998535, .green = 0.819780, .blue = 0.764591 },
	{ .red = 0.018315, .green = 0.959951, .blue = 0.721856 },
	{ .red = 0.022466, .green = 0.963126, .blue = 0.722344 },
	{ .red = 0.060806, .green = 0.973382, .blue = 0.723565 },
	{ .red = 0.133333, .green = 0.990720, .blue = 0.725031 },
	{ .red = 0.376068, .green = 0.999267, .blue = 0.742369 },
	{ .red = 0.536996, .green = 0.999267, .blue = 0.758974 },
	{ .red = 0.662027, .green = 0.999512, .blue = 0.774603 },
	{ .red = 0.766545, .green = 0.998535, .blue = 0.788034 },
	{ .red = 0.854945, .green = 0.999267, .blue = 0.794872 },
	{ .red = 0.911600, .green = 0.999267, .blue = 0.753846 },
	{ .red = 0.999512, .green = 0.993162, .blue = 0.700855 },
	{ .red = 0.999023, .green = 0.933333, .blue = 0.761905 },
	{ .red = 0.998779, .green = 0.904029, .blue = 0.775580 },
	{ .red = 0.998535, .green = 0.883516, .blue = 0.777045 },
	{ .red = 0.998535, .green = 0.866667, .blue = 0.772405 },
	{ .red = 0.999023, .green = 0.852015, .blue = 0.765079 },
	{ .red = 0.998535, .green = 0.837851, .blue = 0.755800 },
	{ .red = 0.023443, .green = 0.973626, .blue = 0.677656 },
	{ .red = 0.025397, .green = 0.976313, .blue = 0.677411 },
	{ .red = 0.088400, .green = 0.983639, .blue = 0.676923 },
	{ .red = 0.201465, .green = 0.999512, .blue = 0.683028 },
	{ .red = 0.404151, .green = 0.998779, .blue = 0.702320 },
	{ .red = 0.543590, .green = 0.998535, .blue = 0.724298 },
	{ .red = 0.657387, .green = 0.998291, .blue = 0.746764 },
	{ .red = 0.751893, .green = 0.999023, .blue = 0.768010 },
	{ .red = 0.833944, .green = 0.998779, .blue = 0.788767 },
	{ .red = 0.877656, .green = 0.999756, .blue = 0.768987 },
	{ .red = 0.927228, .green = 0.998779, .blue = 0.733089 },
	{ .red = 0.998046, .green = 0.994383, .blue = 0.677900 },
	{ .red = 0.998291, .green = 0.938217, .blue = 0.720879 },
	{ .red = 0.999023, .green = 0.905495, .blue = 0.731868 },
	{ .red = 0.998535, .green = 0.881074, .blue = 0.733333 },
	{ .red = 0.999023, .green = 0.861294, .blue = 0.728449 },
	{ .red = 0.998535, .green = 0.843223, .blue = 0.720635 },
	{ .red = 0.065934, .green = 0.981441, .blue = 0.636630 },
	{ .red = 0.073016, .green = 0.983394, .blue = 0.636142 },
	{ .red = 0.106227, .green = 0.989499, .blue = 0.634921 },
	{ .red = 0.258364, .green = 0.999023, .blue = 0.646398 },
	{ .red = 0.415385, .green = 0.999023, .blue = 0.667643 },
	{ .red = 0.539194, .green = 0.998779, .blue = 0.692063 },
	{ .red = 0.644444, .green = 0.998535, .blue = 0.718437 },
	{ .red = 0.733822, .green = 0.998535, .blue = 0.744811 },
	{ .red = 0.810256, .green = 0.999512, .blue = 0.769963 },
	{ .red = 0.858120, .green = 0.999512, .blue = 0.771673 },
	{ .red = 0.887179, .green = 0.999267, .blue = 0.736264 },
	{ .red = 0.934799, .green = 0.998291, .blue = 0.706960 },
	{ .red = 0.998046, .green = 0.995849, .blue = 0.646642 },
	{ .red = 0.999267, .green = 0.941880, .blue = 0.677167 },
	{ .red = 0.998291, .green = 0.905983, .blue = 0.687668 },
	{ .red = 0.999267, .green = 0.879365, .blue = 0.687668 },
	{ .red = 0.999023, .green = 0.856899, .blue = 0.683516 },
	{ .red = 0.051770, .green = 0.988767, .blue = 0.599267 },
	{ .red = 0.070574, .green = 0.989744, .blue = 0.598779 },
	{ .red = 0.114286, .green = 0.995116, .blue = 0.597802 },
	{ .red = 0.285470, .green = 0.998779, .blue = 0.613919 },
	{ .red = 0.417338, .green = 0.998535, .blue = 0.635653 },
	{ .red = 0.528938, .green = 0.998535, .blue = 0.661294 },
	{ .red = 0.625397, .green = 0.999267, .blue = 0.688645 },
	{ .red = 0.711355, .green = 0.998535, .blue = 0.717705 },
	{ .red = 0.785104, .green = 0.999267, .blue = 0.745788 },
	{ .red = 0.842491, .green = 0.998779, .blue = 0.766545 },
	{ .red = 0.859829, .green = 0.998291, .blue = 0.733333 },
	{ .red = 0.892063, .green = 0.999267, .blue = 0.699389 },
	{ .red = 0.938950, .green = 0.999023, .blue = 0.674481 },
	{ .red = 0.997558, .green = 0.996581, .blue = 0.613187 },
	{ .red = 0.998779, .green = 0.944322, .blue = 0.635409 },
	{ .red = 0.999023, .green = 0.907448, .blue = 0.642979 },
	{ .red = 0.998535, .green = 0.878144, .blue = 0.644200 },
	{ .red = 0.107204, .green = 0.988523, .blue = 0.565324 },
	{ .red = 0.114042, .green = 0.989499, .blue = 0.564835 },
	{ .red = 0.167521, .green = 0.996825, .blue = 0.568498 },
	{ .red = 0.295238, .green = 0.999512, .blue = 0.583883 },
	{ .red = 0.411722, .green = 0.998779, .blue = 0.605128 },
	{ .red = 0.512821, .green = 0.999512, .blue = 0.630525 },
	{ .red = 0.604640, .green = 0.999267, .blue = 0.658608 },
	{ .red = 0.686203, .green = 0.999023, .blue = 0.688156 },
	{ .red = 0.758730, .green = 0.998535, .blue = 0.718681 },
	{ .red = 0.819780, .green = 0.999512, .blue = 0.746276 },
	{ .red = 0.836874, .green = 0.998291, .blue = 0.722344 },
	{ .red = 0.859585, .green = 0.998535, .blue = 0.690598 },
	{ .red = 0.894994, .green = 0.999756, .blue = 0.660073 },
	{ .red = 0.941636, .green = 0.999023, .blue = 0.641026 },
	{ .red = 0.998779, .green = 0.998291, .blue = 0.575336 },
	{ .red = 0.999023, .green = 0.946764, .blue = 0.594872 },
	{ .red = 0.999267, .green = 0.908669, .blue = 0.601709 },
	{ .red = 0.098657, .green = 0.992430, .blue = 0.534310 },
	{ .red = 0.107692, .green = 0.993162, .blue = 0.533822 },
	{ .red = 0.185836, .green = 0.999512, .blue = 0.540904 },
	{ .red = 0.301343, .green = 0.998535, .blue = 0.555800 },
	{ .red = 0.401465, .green = 0.999267, .blue = 0.576068 },
	{ .red = 0.494505, .green = 0.999756, .blue = 0.600244 },
	{ .red = 0.582418, .green = 0.998535, .blue = 0.628816 },
	{ .red = 0.659829, .green = 0.999267, .blue = 0.657631 },
	{ .red = 0.730403, .green = 0.998779, .blue = 0.688400 },
	{ .red = 0.792430, .green = 0.999023, .blue = 0.718926 },
	{ .red = 0.814896, .green = 0.998291, .blue = 0.706471 },
	{ .red = 0.831746, .green = 0.999023, .blue = 0.676190 },
	{ .red = 0.859585, .green = 0.998535, .blue = 0.649328 },
	{ .red = 0.897436, .green = 0.999267, .blue = 0.623687 },
	{ .red = 0.943834, .green = 0.999512, .blue = 0.606349 },
	{ .red = 0.997558, .green = 0.997558, .blue = 0.544811 },
	{ .red = 0.999267, .green = 0.948962, .blue = 0.557509 },
	{ .red = 0.123810, .green = 0.991453, .blue = 0.506716 },
	{ .red = 0.141148, .green = 0.994139, .blue = 0.508669 },
	{ .red = 0.203907, .green = 0.999023, .blue = 0.515507 },
	{ .red = 0.299634, .green = 0.998291, .blue = 0.529426 },
	{ .red = 0.389988, .green = 0.999023, .blue = 0.548474 },
	{ .red = 0.477656, .green = 0.998779, .blue = 0.572161 },
	{ .red = 0.558730, .green = 0.999023, .blue = 0.598779 },
	{ .red = 0.633700, .green = 0.999023, .blue = 0.627839 },
	{ .red = 0.701832, .green = 0.999023, .blue = 0.657631 },
	{ .red = 0.763370, .green = 0.999023, .blue = 0.688400 },
	{ .red = 0.792186, .green = 0.999512, .blue = 0.685714 },
	{ .red = 0.806105, .green = 0.999756, .blue = 0.658364 },
	{ .red = 0.829304, .green = 0.999023, .blue = 0.633455 },
	{ .red = 0.860562, .green = 0.999267, .blue = 0.609280 },
	{ .red = 0.899878, .green = 0.999267, .blue = 0.588278 },
	{ .red = 0.945055, .green = 0.999023, .blue = 0.575092 },
	{ .red = 0.996337, .green = 0.997070, .blue = 0.517216 },
	{ .red = 0.005128, .green = 0.142125, .blue = 0.646154 },
	{ .red = 0.093529, .green = 0.014896, .blue = 0.755067 },
	{ .red = 0.219780, .green = 0.013431, .blue = 0.796093 },
	{ .red = 0.352869, .green = 0.013675, .blue = 0.841026 },
	{ .red = 0.476435, .green = 0.018071, .blue = 0.855189 },
	{ .red = 0.575580, .green = 0.020757, .blue = 0.839560 },
	{ .red = 0.653724, .green = 0.021245, .blue = 0.815140 },
	{ .red = 0.737973, .green = 0.021734, .blue = 0.813919 },
	{ .red = 0.840537, .green = 0.018071, .blue = 0.839316 },
	{ .red = 0.884005, .green = 0.021978, .blue = 0.784860 },
	{ .red = 0.915995, .green = 0.015873, .blue = 0.733822 },
	{ .red = 0.938462, .green = 0.018315, .blue = 0.686203 },
	{ .red = 0.956044, .green = 0.019048, .blue = 0.643712 },
	{ .red = 0.970696, .green = 0.015140, .blue = 0.605861 },
	{ .red = 0.980708, .green = 0.019048, .blue = 0.570452 },
	{ .red = 0.984615, .green = 0.029792, .blue = 0.536508 },
	{ .red = 0.983883, .green = 0.045177, .blue = 0.504518 },
	{ .red = 0.010989, .green = 0.146520, .blue = 0.684249 },
	{ .red = 0.099389, .green = 0.015140, .blue = 0.805372 },
	{ .red = 0.232234, .green = 0.021978, .blue = 0.857631 },
	{ .red = 0.380464, .green = 0.017582, .blue = 0.924542 },
	{ .red = 0.518193, .green = 0.020024, .blue = 0.946032 },
	{ .red = 0.622222, .green = 0.009035, .blue = 0.919658 },
	{ .red = 0.695971, .green = 0.022466, .blue = 0.875214 },
	{ .red = 0.777289, .green = 0.015873, .blue = 0.861783 },
	{ .red = 0.876435, .green = 0.024420, .blue = 0.877411 },
	{ .red = 0.920635, .green = 0.021001, .blue = 0.818315 },
	{ .red = 0.949695, .green = 0.016117, .blue = 0.760440 },
	{ .red = 0.968987, .green = 0.019048, .blue = 0.707204 },
	{ .red = 0.977534, .green = 0.033211, .blue = 0.656410 },
	{ .red = 0.984371, .green = 0.038339, .blue = 0.612698 },
	{ .red = 0.995604, .green = 0.064957, .blue = 0.578510 },
	{ .red = 0.999756, .green = 0.091087, .blue = 0.546276 },
	{ .red = 0.999023, .green = 0.111111, .blue = 0.515995 },
	{ .red = 0.000000, .green = 0.192186, .blue = 0.785348 },
	{ .red = 0.121123, .green = 0.140904, .blue = 0.999023 },
	{ .red = 0.261538, .green = 0.170452, .blue = 0.999023 },
	{ .red = 0.403175, .green = 0.199756, .blue = 0.999023 },
	{ .red = 0.541148, .green = 0.212943, .blue = 0.998291 },
	{ .red = 0.670330, .green = 0.210745, .blue = 0.998535 },
	{ .red = 0.788767, .green = 0.200488, .blue = 0.999023 },
	{ .red = 0.896215, .green = 0.187302, .blue = 0.998779 },
	{ .red = 0.993651, .green = 0.173871, .blue = 0.996825 },
	{ .red = 0.999267, .green = 0.194139, .blue = 0.887424 },
	{ .red = 0.999267, .green = 0.207326, .blue = 0.800000 },
	{ .red = 0.999023, .green = 0.214652, .blue = 0.732845 },
	{ .red = 0.998779, .green = 0.219048, .blue = 0.678632 },
	{ .red = 0.999512, .green = 0.221001, .blue = 0.634188 },
	{ .red = 0.999023, .green = 0.221734, .blue = 0.595360 },
	{ .red = 0.999023, .green = 0.221978, .blue = 0.561905 },
	{ .red = 0.999267, .green = 0.221978, .blue = 0.532601 },
	{ .red = 0.006838, .green = 0.260073, .blue = 0.664713 },
	{ .red = 0.093040, .green = 0.311844, .blue = 0.998291 },
	{ .red = 0.270574, .green = 0.348474, .blue = 0.999267 },
	{ .red = 0.409524, .green = 0.365324, .blue = 0.998535 },
	{ .red = 0.548230, .green = 0.378999, .blue = 0.998291 },
	{ .red = 0.680830, .green = 0.386325, .blue = 0.999267 },
	{ .red = 0.802198, .green = 0.387546, .blue = 0.999512 },
	{ .red = 0.910379, .green = 0.383883, .blue = 0.999267 },
	{ .red = 0.999512, .green = 0.379243, .blue = 0.989744 },
	{ .red = 0.999023, .green = 0.381929, .blue = 0.884737 },
	{ .red = 0.999267, .green = 0.380708, .blue = 0.806838 },
	{ .red = 0.998535, .green = 0.376557, .blue = 0.747497 },
	{ .red = 0.998779, .green = 0.370208, .blue = 0.699878 },
	{ .red = 0.999023, .green = 0.362149, .blue = 0.659341 },
	{ .red = 0.998779, .green = 0.353114, .blue = 0.623443 },
	{ .red = 0.999267, .green = 0.343834, .blue = 0.591453 },
	{ .red = 0.999756, .green = 0.334554, .blue = 0.562393 },
	{ .red = 0.004151, .green = 0.378755, .blue = 0.725519 },
	{ .red = 0.006105, .green = 0.402442, .blue = 0.824176 },
	{ .red = 0.266911, .green = 0.482540, .blue = 0.999756 },
	{ .red = 0.427350, .green = 0.515263, .blue = 0.999512 },
	{ .red = 0.561172, .green = 0.529915, .blue = 0.998535 },
	{ .red = 0.691575, .green = 0.540171, .blue = 0.999267 },
	{ .red = 0.812210, .green = 0.543590, .blue = 0.999512 },
	{ .red = 0.919414, .green = 0.541392, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.536996, .blue = 0.981441 },
	{ .red = 0.999023, .green = 0.536020, .blue = 0.889621 },
	{ .red = 0.999023, .green = 0.530159, .blue = 0.823199 },
	{ .red = 0.998779, .green = 0.520879, .blue = 0.773626 },
	{ .red = 0.999512, .green = 0.508669, .blue = 0.733333 },
	{ .red = 0.999267, .green = 0.494261, .blue = 0.696947 },
	{ .red = 0.999023, .green = 0.478877, .blue = 0.663736 },
	{ .red = 0.999267, .green = 0.462759, .blue = 0.632723 },
	{ .red = 0.998779, .green = 0.446642, .blue = 0.603175 },
	{ .red = 0.010989, .green = 0.510867, .blue = 0.782662 },
	{ .red = 0.021734, .green = 0.525031, .blue = 0.821734 },
	{ .red = 0.158974, .green = 0.600000, .blue = 0.999267 },
	{ .red = 0.416117, .green = 0.633700, .blue = 0.999023 },
	{ .red = 0.580708, .green = 0.666422, .blue = 0.998291 },
	{ .red = 0.700122, .green = 0.675458, .blue = 0.998535 },
	{ .red = 0.815140, .green = 0.678632, .blue = 0.998291 },
	{ .red = 0.920635, .green = 0.675702, .blue = 0.998291 },
	{ .red = 0.998779, .green = 0.669353, .blue = 0.980952 },
	{ .red = 0.999023, .green = 0.667643, .blue = 0.901343 },
	{ .red = 0.999267, .green = 0.659585, .blue = 0.847619 },
	{ .red = 0.998779, .green = 0.647131, .blue = 0.807326 },
	{ .red = 0.998779, .green = 0.631258, .blue = 0.772650 },
	{ .red = 0.999023, .green = 0.612943, .blue = 0.740904 },
	{ .red = 0.998046, .green = 0.593407, .blue = 0.710134 },
	{ .red = 0.998535, .green = 0.572894, .blue = 0.680342 },
	{ .red = 0.999023, .green = 0.551893, .blue = 0.651282 },
	{ .red = 0.023199, .green = 0.647619, .blue = 0.834188 },
	{ .red = 0.023687, .green = 0.655678, .blue = 0.851282 },
	{ .red = 0.025153, .green = 0.697192, .blue = 0.934554 },
	{ .red = 0.323321, .green = 0.742369, .blue = 0.998046 },
	{ .red = 0.536020, .green = 0.763858, .blue = 0.999023 },
	{ .red = 0.705006, .green = 0.788523, .blue = 0.998291 },
	{ .red = 0.810256, .green = 0.791209, .blue = 0.998535 },
	{ .red = 0.914286, .green = 0.786325, .blue = 0.998291 },
	{ .red = 0.999023, .green = 0.775824, .blue = 0.985592 },
	{ .red = 0.999267, .green = 0.773626, .blue = 0.914530 },
	{ .red = 0.999267, .green = 0.763858, .blue = 0.872527 },
	{ .red = 0.998779, .green = 0.749451, .blue = 0.840293 },
	{ .red = 0.998291, .green = 0.731868, .blue = 0.811722 },
	{ .red = 0.999756, .green = 0.711600, .blue = 0.784127 },
	{ .red = 0.998779, .green = 0.690110, .blue = 0.755800 },
	{ .red = 0.999023, .green = 0.667399, .blue = 0.727473 },
	{ .red = 0.999023, .green = 0.643956, .blue = 0.699145 },
	{ .red = 0.024176, .green = 0.786081, .blue = 0.881807 },
	{ .red = 0.025641, .green = 0.790720, .blue = 0.889377 },
	{ .red = 0.031746, .green = 0.810745, .blue = 0.921123 },
	{ .red = 0.104518, .green = 0.861783, .blue = 0.998779 },
	{ .red = 0.436874, .green = 0.869841, .blue = 0.998779 },
	{ .red = 0.620513, .green = 0.876190, .blue = 0.998291 },
	{ .red = 0.771673, .green = 0.879609, .blue = 0.999023 },
	{ .red = 0.890598, .green = 0.876923, .blue = 0.999512 },
	{ .red = 0.998779, .green = 0.858608, .blue = 0.990476 },
	{ .red = 0.999023, .green = 0.854212, .blue = 0.923077 },
	{ .red = 0.998535, .green = 0.842735, .blue = 0.892063 },
	{ .red = 0.998535, .green = 0.827106, .blue = 0.867643 },
	{ .red = 0.999512, .green = 0.808791, .blue = 0.844200 },
	{ .red = 0.998779, .green = 0.788523, .blue = 0.819780 },
	{ .red = 0.998535, .green = 0.766789, .blue = 0.794628 },
	{ .red = 0.998291, .green = 0.743834, .blue = 0.768254 },
	{ .red = 0.998535, .green = 0.720147, .blue = 0.741392 },
	{ .red = 0.029548, .green = 0.916484, .blue = 0.916239 },
	{ .red = 0.029792, .green = 0.919658, .blue = 0.919658 },
	{ .red = 0.030281, .green = 0.930891, .blue = 0.932112 },
	{ .red = 0.064957, .green = 0.954579, .blue = 0.957265 },
	{ .red = 0.185348, .green = 0.993407, .blue = 0.998291 },
	{ .red = 0.453968, .green = 0.994872, .blue = 0.999023 },
	{ .red = 0.630769, .green = 0.985592, .blue = 0.988767 },
	{ .red = 0.795604, .green = 0.961661, .blue = 0.963126 },
	{ .red = 0.936020, .green = 0.934799, .blue = 0.935043 },
	{ .red = 0.999756, .green = 0.913309, .blue = 0.916972 },
	{ .red = 0.999756, .green = 0.898901, .blue = 0.902320 },
	{ .red = 0.999267, .green = 0.882784, .blue = 0.885714 },
	{ .red = 0.998535, .green = 0.865201, .blue = 0.867155 },
	{ .red = 0.998291, .green = 0.845910, .blue = 0.846642 },
	{ .red = 0.998291, .green = 0.825153, .blue = 0.824420 },
	{ .red = 0.998779, .green = 0.803175, .blue = 0.800733 },
	{ .red = 0.999756, .green = 0.780220, .blue = 0.775580 },
	{ .red = 0.029792, .green = 0.942613, .blue = 0.858608 },
	{ .red = 0.029548, .green = 0.945788, .blue = 0.860562 },
	{ .red = 0.029792, .green = 0.957265, .blue = 0.868132 },
	{ .red = 0.035165, .green = 0.980952, .blue = 0.883516 },
	{ .red = 0.296703, .green = 0.999512, .blue = 0.897680 },
	{ .red = 0.505739, .green = 0.998779, .blue = 0.901099 },
	{ .red = 0.646886, .green = 0.998046, .blue = 0.902320 },
	{ .red = 0.757021, .green = 0.998291, .blue = 0.897924 },
	{ .red = 0.854457, .green = 0.999267, .blue = 0.874481 },
	{ .red = 0.975336, .green = 0.971184, .blue = 0.854701 },
	{ .red = 0.999512, .green = 0.935775, .blue = 0.884493 },
	{ .red = 0.999023, .green = 0.923077, .blue = 0.891575 },
	{ .red = 0.999512, .green = 0.906227, .blue = 0.879853 },
	{ .red = 0.999267, .green = 0.887912, .blue = 0.863736 },
	{ .red = 0.998535, .green = 0.868864, .blue = 0.844933 },
	{ .red = 0.998779, .green = 0.848596, .blue = 0.824176 },
	{ .red = 0.998535, .green = 0.827595, .blue = 0.801709 },
	{ .red = 0.058364, .green = 0.960440, .blue = 0.804884 },
	{ .red = 0.063492, .green = 0.962882, .blue = 0.805861 },
	{ .red = 0.084493, .green = 0.972161, .blue = 0.809524 },
	{ .red = 0.133822, .green = 0.988523, .blue = 0.815629 },
	{ .red = 0.367033, .green = 0.998291, .blue = 0.829792 },
	{ .red = 0.531380, .green = 0.999267, .blue = 0.841514 },
	{ .red = 0.656654, .green = 0.999267, .blue = 0.851526 },
	{ .red = 0.757998, .green = 0.998779, .blue = 0.858608 },
	{ .red = 0.842491, .green = 0.999512, .blue = 0.859829 },
	{ .red = 0.914530, .green = 0.999023, .blue = 0.841758 },
	{ .red = 0.998046, .green = 0.992186, .blue = 0.789988 },
	{ .red = 0.999267, .green = 0.942125, .blue = 0.846886 },
	{ .red = 0.998291, .green = 0.921856, .blue = 0.855922 },
	{ .red = 0.999756, .green = 0.908425, .blue = 0.854212 },
	{ .red = 0.999023, .green = 0.896703, .blue = 0.849573 },
	{ .red = 0.999023, .green = 0.884737, .blue = 0.840537 },
	{ .red = 0.999267, .green = 0.864469, .blue = 0.819536 },
	{ .red = 0.037607, .green = 0.974115, .blue = 0.756288 },
	{ .red = 0.044200, .green = 0.976557, .blue = 0.756777 },
	{ .red = 0.071306, .green = 0.984615, .blue = 0.758486 },
	{ .red = 0.185836, .green = 0.998535, .blue = 0.764835 },
	{ .red = 0.399512, .green = 0.998779, .blue = 0.780220 },
	{ .red = 0.541636, .green = 0.998779, .blue = 0.796825 },
	{ .red = 0.653968, .green = 0.999267, .blue = 0.813431 },
	{ .red = 0.747741, .green = 0.999023, .blue = 0.828327 },
	{ .red = 0.826618, .green = 0.999512, .blue = 0.840781 },
	{ .red = 0.896215, .green = 0.999267, .blue = 0.852503 },
	{ .red = 0.932845, .green = 0.999267, .blue = 0.813675 },
	{ .red = 0.999512, .green = 0.995360, .blue = 0.758974 },
	{ .red = 0.998535, .green = 0.945055, .blue = 0.805617 },
	{ .red = 0.998291, .green = 0.919902, .blue = 0.814652 },
	{ .red = 0.998291, .green = 0.901832, .blue = 0.813675 },
	{ .red = 0.999267, .green = 0.886691, .blue = 0.807570 },
	{ .red = 0.998779, .green = 0.873260, .blue = 0.800488 },
	{ .red = 0.033455, .green = 0.983394, .blue = 0.711600 },
	{ .red = 0.036630, .green = 0.985592, .blue = 0.711844 },
	{ .red = 0.078144, .green = 0.991941, .blue = 0.711844 },
	{ .red = 0.252747, .green = 0.999023, .blue = 0.721612 },
	{ .red = 0.414896, .green = 0.998779, .blue = 0.738950 },
	{ .red = 0.538706, .green = 0.999267, .blue = 0.758730 },
	{ .red = 0.643223, .green = 0.999267, .blue = 0.779243 },
	{ .red = 0.731868, .green = 0.998779, .blue = 0.799512 },
	{ .red = 0.806349, .green = 0.999267, .blue = 0.817827 },
	{ .red = 0.872039, .green = 0.999267, .blue = 0.836874 },
	{ .red = 0.904762, .green = 0.998291, .blue = 0.821245 },
	{ .red = 0.940904, .green = 0.999512, .blue = 0.782173 },
	{ .red = 0.998535, .green = 0.995604, .blue = 0.726984 },
	{ .red = 0.998535, .green = 0.946764, .blue = 0.761172 },
	{ .red = 0.999023, .green = 0.918193, .blue = 0.769475 },
	{ .red = 0.999512, .green = 0.896947, .blue = 0.768987 },
	{ .red = 0.998291, .green = 0.878877, .blue = 0.765079 },
	{ .red = 0.094994, .green = 0.986081, .blue = 0.670085 },
	{ .red = 0.094505, .green = 0.988278, .blue = 0.670085 },
	{ .red = 0.109402, .green = 0.994139, .blue = 0.669597 },
	{ .red = 0.284737, .green = 0.998535, .blue = 0.684005 },
	{ .red = 0.418071, .green = 0.998779, .blue = 0.702320 },
	{ .red = 0.530891, .green = 0.998291, .blue = 0.723810 },
	{ .red = 0.627106, .green = 0.998535, .blue = 0.746520 },
	{ .red = 0.710867, .green = 0.998535, .blue = 0.769475 },
	{ .red = 0.784127, .green = 0.998046, .blue = 0.792430 },
	{ .red = 0.846154, .green = 0.999267, .blue = 0.813675 },
	{ .red = 0.885958, .green = 0.999023, .blue = 0.816361 },
	{ .red = 0.905739, .green = 0.999267, .blue = 0.779731 },
	{ .red = 0.944567, .green = 0.999267, .blue = 0.749206 },
	{ .red = 0.997802, .green = 0.996093, .blue = 0.690354 },
	{ .red = 0.998535, .green = 0.948230, .blue = 0.716728 },
	{ .red = 0.999023, .green = 0.916972, .blue = 0.724542 },
	{ .red = 0.998779, .green = 0.893040, .blue = 0.725275 },
	{ .red = 0.111600, .green = 0.988523, .blue = 0.632723 },
	{ .red = 0.118193, .green = 0.989499, .blue = 0.632479 },
	{ .red = 0.163614, .green = 0.997070, .blue = 0.636142 },
	{ .red = 0.297192, .green = 0.999023, .blue = 0.649817 },
	{ .red = 0.412943, .green = 0.999023, .blue = 0.668376 },
	{ .red = 0.514530, .green = 0.999267, .blue = 0.689866 },
	{ .red = 0.605861, .green = 0.999023, .blue = 0.713797 },
	{ .red = 0.686447, .green = 0.998779, .blue = 0.738217 },
	{ .red = 0.757509, .green = 0.998535, .blue = 0.762882 },
	{ .red = 0.819292, .green = 0.998779, .blue = 0.786813 },
	{ .red = 0.869353, .green = 0.999023, .blue = 0.806349 },
	{ .red = 0.880098, .green = 0.999512, .blue = 0.771184 },
	{ .red = 0.905983, .green = 0.999267, .blue = 0.738706 },
	{ .red = 0.946276, .green = 0.998779, .blue = 0.715018 },
	{ .red = 0.997558, .green = 0.996825, .blue = 0.652991 },
	{ .red = 0.998291, .green = 0.949451, .blue = 0.673748 },
	{ .red = 0.999267, .green = 0.916728, .blue = 0.680586 },
	{ .red = 0.095238, .green = 0.993162, .blue = 0.599023 },
	{ .red = 0.103053, .green = 0.994139, .blue = 0.598535 },
	{ .red = 0.186813, .green = 0.999267, .blue = 0.605372 },
	{ .red = 0.302564, .green = 0.998535, .blue = 0.618559 },
	{ .red = 0.404396, .green = 0.998291, .blue = 0.636142 },
	{ .red = 0.498657, .green = 0.998291, .blue = 0.657875 },
	{ .red = 0.582906, .green = 0.999267, .blue = 0.681563 },
	{ .red = 0.660317, .green = 0.999267, .blue = 0.706471 },
	{ .red = 0.730159, .green = 0.998535, .blue = 0.732357 },
	{ .red = 0.790720, .green = 0.999023, .blue = 0.757021 },
	{ .red = 0.844444, .green = 0.999267, .blue = 0.782173 },
	{ .red = 0.858852, .green = 0.998291, .blue = 0.760195 },
	{ .red = 0.876435, .green = 0.999267, .blue = 0.727473 },
	{ .red = 0.906471, .green = 0.998779, .blue = 0.699878 },
	{ .red = 0.947497, .green = 0.998779, .blue = 0.679609 },
	{ .red = 0.997070, .green = 0.996825, .blue = 0.617338 },
	{ .red = 0.999023, .green = 0.951404, .blue = 0.632723 },
	{ .red = 0.125519, .green = 0.991453, .blue = 0.568254 },
	{ .red = 0.142613, .green = 0.993895, .blue = 0.570208 },
	{ .red = 0.205128, .green = 0.998779, .blue = 0.576801 },
	{ .red = 0.297924, .green = 0.999512, .blue = 0.589011 },
	{ .red = 0.392918, .green = 0.998291, .blue = 0.606105 },
	{ .red = 0.478877, .green = 0.999023, .blue = 0.626862 },
	{ .red = 0.559951, .green = 0.999023, .blue = 0.650061 },
	{ .red = 0.633944, .green = 0.999267, .blue = 0.674969 },
	{ .red = 0.701343, .green = 0.999267, .blue = 0.700611 },
	{ .red = 0.762149, .green = 0.999023, .blue = 0.726740 },
	{ .red = 0.816117, .green = 0.999267, .blue = 0.752381 },
	{ .red = 0.837851, .green = 0.999023, .blue = 0.743101 },
	{ .red = 0.851038, .green = 0.998779, .blue = 0.714042 },
	{ .red = 0.874481, .green = 0.998535, .blue = 0.686935 },
	{ .red = 0.907448, .green = 0.999512, .blue = 0.660562 },
	{ .red = 0.948474, .green = 0.998779, .blue = 0.645421 },
	{ .red = 0.998779, .green = 0.998535, .blue = 0.578999 },
	{ .red = 0.013919, .green = 0.144078, .blue = 0.702808 },
	{ .red = 0.089377, .green = 0.014896, .blue = 0.805128 },
	{ .red = 0.205372, .green = 0.019780, .blue = 0.835409 },
	{ .red = 0.332601, .green = 0.022466, .blue = 0.888889 },
	{ .red = 0.461294, .green = 0.020757, .blue = 0.925519 },
	{ .red = 0.566545, .green = 0.018803, .blue = 0.918681 },
	{ .red = 0.650305, .green = 0.015629, .blue = 0.894994 },
	{ .red = 0.711844, .green = 0.017094, .blue = 0.861050 },
	{ .red = 0.792186, .green = 0.014896, .blue = 0.863492 },
	{ .red = 0.879609, .green = 0.024908, .blue = 0.878632 },
	{ .red = 0.914530, .green = 0.022955, .blue = 0.822711 },
	{ .red = 0.938706, .green = 0.019292, .blue = 0.769963 },
	{ .red = 0.956532, .green = 0.018803, .blue = 0.721856 },
	{ .red = 0.971184, .green = 0.014408, .blue = 0.679121 },
	{ .red = 0.976557, .green = 0.030281, .blue = 0.636630 },
	{ .red = 0.985104, .green = 0.030281, .blue = 0.601465 },
	{ .red = 0.994139, .green = 0.026374, .blue = 0.570696 },
	{ .red = 0.016850, .green = 0.143834, .blue = 0.760440 },
	{ .red = 0.096215, .green = 0.019048, .blue = 0.854457 },
	{ .red = 0.215629, .green = 0.017338, .blue = 0.889621 },
	{ .red = 0.353114, .green = 0.023199, .blue = 0.958730 },
	{ .red = 0.490354, .green = 0.042735, .blue = 0.996581 },
	{ .red = 0.603663, .green = 0.040537, .blue = 0.989255 },
	{ .red = 0.691819, .green = 0.021490, .blue = 0.960684 },
	{ .red = 0.750183, .green = 0.020269, .blue = 0.913065 },
	{ .red = 0.825885, .green = 0.011477, .blue = 0.903541 },
	{ .red = 0.911355, .green = 0.023932, .blue = 0.912332 },
	{ .red = 0.944567, .green = 0.024420, .blue = 0.850794 },
	{ .red = 0.967033, .green = 0.019048, .blue = 0.792918 },
	{ .red = 0.979243, .green = 0.028327, .blue = 0.738217 },
	{ .red = 0.993162, .green = 0.020269, .blue = 0.693284 },
	{ .red = 0.994383, .green = 0.064469, .blue = 0.647619 },
	{ .red = 0.999023, .green = 0.092063, .blue = 0.610989 },
	{ .red = 0.999756, .green = 0.110867, .blue = 0.577289 },
	{ .red = 0.008791, .green = 0.174359, .blue = 0.940904 },
	{ .red = 0.113309, .green = 0.120635, .blue = 0.999267 },
	{ .red = 0.236386, .green = 0.146764, .blue = 0.998535 },
	{ .red = 0.362882, .green = 0.178510, .blue = 0.999267 },
	{ .red = 0.488156, .green = 0.198779, .blue = 0.998046 },
	{ .red = 0.608547, .green = 0.205861, .blue = 0.999267 },
	{ .red = 0.719170, .green = 0.204396, .blue = 0.998779 },
	{ .red = 0.820269, .green = 0.196825, .blue = 0.999267 },
	{ .red = 0.912821, .green = 0.187302, .blue = 0.999512 },
	{ .red = 0.994628, .green = 0.180220, .blue = 0.995360 },
	{ .red = 0.998535, .green = 0.199756, .blue = 0.897924 },
	{ .red = 0.999267, .green = 0.211722, .blue = 0.819536 },
	{ .red = 0.999267, .green = 0.218803, .blue = 0.756777 },
	{ .red = 0.999023, .green = 0.222466, .blue = 0.705250 },
	{ .red = 0.998535, .green = 0.224176, .blue = 0.661294 },
	{ .red = 0.999023, .green = 0.224420, .blue = 0.623932 },
	{ .red = 0.998779, .green = 0.223687, .blue = 0.590720 },
	{ .red = 0.002930, .green = 0.263980, .blue = 0.793162 },
	{ .red = 0.130891, .green = 0.305495, .blue = 0.998779 },
	{ .red = 0.255433, .green = 0.327228, .blue = 0.999023 },
	{ .red = 0.377534, .green = 0.344078, .blue = 0.998779 },
	{ .red = 0.502564, .green = 0.359951, .blue = 0.998291 },
	{ .red = 0.624176, .green = 0.371917, .blue = 0.999023 },
	{ .red = 0.736020, .green = 0.377534, .blue = 0.998779 },
	{ .red = 0.837363, .green = 0.378510, .blue = 0.999267 },
	{ .red = 0.927717, .green = 0.376557, .blue = 0.998291 },
	{ .red = 0.999267, .green = 0.375092, .blue = 0.986081 },
	{ .red = 0.999023, .green = 0.377778, .blue = 0.895238 },
	{ .red = 0.999023, .green = 0.376313, .blue = 0.824420 },
	{ .red = 0.998779, .green = 0.371917, .blue = 0.768987 },
	{ .red = 0.999023, .green = 0.365079, .blue = 0.723077 },
	{ .red = 0.998779, .green = 0.357021, .blue = 0.683516 },
	{ .red = 0.999023, .green = 0.347741, .blue = 0.648107 },
	{ .red = 0.999023, .green = 0.337973, .blue = 0.616117 },
	{ .red = 0.012454, .green = 0.347741, .blue = 0.757509 },
	{ .red = 0.010745, .green = 0.383150, .blue = 0.922100 },
	{ .red = 0.307937, .green = 0.484005, .blue = 0.999267 },
	{ .red = 0.411233, .green = 0.492552, .blue = 0.998535 },
	{ .red = 0.528449, .green = 0.507448, .blue = 0.999267 },
	{ .red = 0.644444, .green = 0.519414, .blue = 0.998779 },
	{ .red = 0.753846, .green = 0.526984, .blue = 0.999512 },
	{ .red = 0.852015, .green = 0.530159, .blue = 0.998779 },
	{ .red = 0.940171, .green = 0.529182, .blue = 0.998535 },
	{ .red = 0.998535, .green = 0.528205, .blue = 0.976557 },
	{ .red = 0.998535, .green = 0.526984, .blue = 0.898657 },
	{ .red = 0.999023, .green = 0.520635, .blue = 0.838828 },
	{ .red = 0.999267, .green = 0.510623, .blue = 0.791941 },
	{ .red = 0.998779, .green = 0.498168, .blue = 0.751893 },
	{ .red = 0.998779, .green = 0.483516, .blue = 0.715995 },
	{ .red = 0.999267, .green = 0.467643, .blue = 0.683516 },
	{ .red = 0.998779, .green = 0.451282, .blue = 0.652259 },
	{ .red = 0.021734, .green = 0.473016, .blue = 0.816850 },
	{ .red = 0.009768, .green = 0.491087, .blue = 0.874969 },
	{ .red = 0.224908, .green = 0.552137, .blue = 0.998535 },
	{ .red = 0.465201, .green = 0.628571, .blue = 0.998291 },
	{ .red = 0.565812, .green = 0.640781, .blue = 0.998291 },
	{ .red = 0.668620, .green = 0.651038, .blue = 0.998535 },
	{ .red = 0.769475, .green = 0.658120, .blue = 0.999267 },
	{ .red = 0.862027, .green = 0.661050, .blue = 0.998535 },
	{ .red = 0.946276, .green = 0.659585, .blue = 0.999512 },
	{ .red = 0.998535, .green = 0.657387, .blue = 0.975824 },
	{ .red = 0.999512, .green = 0.655433, .blue = 0.911111 },
	{ .red = 0.999023, .green = 0.646642, .blue = 0.860806 },
	{ .red = 0.999512, .green = 0.633700, .blue = 0.822222 },
	{ .red = 0.999756, .green = 0.617338, .blue = 0.788034 },
	{ .red = 0.998779, .green = 0.598779, .blue = 0.755800 },
	{ .red = 0.998535, .green = 0.578510, .blue = 0.724786 },
	{ .red = 0.999267, .green = 0.557753, .blue = 0.695238 },
	{ .red = 0.026129, .green = 0.591697, .blue = 0.851282 },
	{ .red = 0.020269, .green = 0.603419, .blue = 0.878388 },
	{ .red = 0.092308, .green = 0.655433, .blue = 0.995604 },
	{ .red = 0.377534, .green = 0.689621, .blue = 0.998046 },
	{ .red = 0.569475, .green = 0.731868, .blue = 0.998291 },
	{ .red = 0.696703, .green = 0.762393, .blue = 0.999023 },
	{ .red = 0.783150, .green = 0.767766, .blue = 0.998535 },
	{ .red = 0.867399, .green = 0.769719, .blue = 0.998046 },
	{ .red = 0.946032, .green = 0.767033, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.762637, .blue = 0.980708 },
	{ .red = 0.998535, .green = 0.760195, .blue = 0.925031 },
	{ .red = 0.999512, .green = 0.749939, .blue = 0.885470 },
	{ .red = 0.998535, .green = 0.735287, .blue = 0.853236 },
	{ .red = 0.999023, .green = 0.716972, .blue = 0.823932 },
	{ .red = 0.999023, .green = 0.696459, .blue = 0.795604 },
	{ .red = 0.998779, .green = 0.674237, .blue = 0.767033 },
	{ .red = 0.998535, .green = 0.651282, .blue = 0.738706 },
	{ .red = 0.019536, .green = 0.715018, .blue = 0.890354 },
	{ .red = 0.010745, .green = 0.721368, .blue = 0.902808 },
	{ .red = 0.023199, .green = 0.749206, .blue = 0.955311 },
	{ .red = 0.298413, .green = 0.784615, .blue = 0.998535 },
	{ .red = 0.503785, .green = 0.806593, .blue = 0.998779 },
	{ .red = 0.663736, .green = 0.829304, .blue = 0.999267 },
	{ .red = 0.795604, .green = 0.854945, .blue = 0.999023 },
	{ .red = 0.868132, .green = 0.855922, .blue = 0.998046 },
	{ .red = 0.941636, .green = 0.852015, .blue = 0.999023 },
	{ .red = 0.997802, .green = 0.844933, .blue = 0.985836 },
	{ .red = 0.999267, .green = 0.841026, .blue = 0.938706 },
	{ .red = 0.998291, .green = 0.829792, .blue = 0.906471 },
	{ .red = 0.998779, .green = 0.813919, .blue = 0.880830 },
	{ .red = 0.998535, .green = 0.795116, .blue = 0.855678 },
	{ .red = 0.998291, .green = 0.774115, .blue = 0.830525 },
	{ .red = 0.998535, .green = 0.751648, .blue = 0.804640 },
	{ .red = 0.999023, .green = 0.728205, .blue = 0.778022 },
	{ .red = 0.027350, .green = 0.832967, .blue = 0.921612 },
	{ .red = 0.028816, .green = 0.836874, .blue = 0.927473 },
	{ .red = 0.041514, .green = 0.852015, .blue = 0.950672 },
	{ .red = 0.139683, .green = 0.885714, .blue = 0.998779 },
	{ .red = 0.431502, .green = 0.895726, .blue = 0.998779 },
	{ .red = 0.600000, .green = 0.905250, .blue = 0.999023 },
	{ .red = 0.732601, .green = 0.912332, .blue = 0.998779 },
	{ .red = 0.844444, .green = 0.917949, .blue = 0.999023 },
	{ .red = 0.927717, .green = 0.918926, .blue = 0.998779 },
	{ .red = 0.998291, .green = 0.906960, .blue = 0.991697 },
	{ .red = 0.999512, .green = 0.901099, .blue = 0.947497 },
	{ .red = 0.998535, .green = 0.888156, .blue = 0.923077 },
	{ .red = 0.999023, .green = 0.871795, .blue = 0.901832 },
	{ .red = 0.998535, .green = 0.853480, .blue = 0.880586 },
	{ .red = 0.999267, .green = 0.832967, .blue = 0.858120 },
	{ .red = 0.999267, .green = 0.811477, .blue = 0.834676 },
	{ .red = 0.998535, .green = 0.789011, .blue = 0.810012 },
	{ .red = 0.045910, .green = 0.944567, .blue = 0.944567 },
	{ .red = 0.049817, .green = 0.947009, .blue = 0.947253 },
	{ .red = 0.062515, .green = 0.956288, .blue = 0.957265 },
	{ .red = 0.084982, .green = 0.975580, .blue = 0.977534 },
	{ .red = 0.284005, .green = 0.995849, .blue = 0.998535 },
	{ .red = 0.497924, .green = 0.996581, .blue = 0.998779 },
	{ .red = 0.636874, .green = 0.997070, .blue = 0.998779 },
	{ .red = 0.741392, .green = 0.996825, .blue = 0.998535 },
	{ .red = 0.838339, .green = 0.989744, .blue = 0.991209 },
	{ .red = 0.963370, .green = 0.962149, .blue = 0.962393 },
	{ .red = 0.999756, .green = 0.943590, .blue = 0.946032 },
	{ .red = 0.999756, .green = 0.929182, .blue = 0.931624 },
	{ .red = 0.999756, .green = 0.913065, .blue = 0.915263 },
	{ .red = 0.999756, .green = 0.895482, .blue = 0.897436 },
	{ .red = 0.999023, .green = 0.876679, .blue = 0.877900 },
	{ .red = 0.998291, .green = 0.856899, .blue = 0.856899 },
	{ .red = 0.998291, .green = 0.835653, .blue = 0.834676 },
	{ .red = 0.032479, .green = 0.962637, .blue = 0.885958 },
	{ .red = 0.033455, .green = 0.965324, .blue = 0.887668 },
	{ .red = 0.030769, .green = 0.974847, .blue = 0.894505 },
	{ .red = 0.130403, .green = 0.987790, .blue = 0.903053 },
	{ .red = 0.359219, .green = 0.998779, .blue = 0.915751 },
	{ .red = 0.530891, .green = 0.999756, .blue = 0.922344 },
	{ .red = 0.658608, .green = 0.998779, .blue = 0.926740 },
	{ .red = 0.755556, .green = 0.998779, .blue = 0.929915 },
	{ .red = 0.835165, .green = 0.998291, .blue = 0.928938 },
	{ .red = 0.906227, .green = 0.998291, .blue = 0.917705 },
	{ .red = 0.992186, .green = 0.988034, .blue = 0.881563 },
	{ .red = 0.999023, .green = 0.953602, .blue = 0.917705 },
	{ .red = 0.999267, .green = 0.942613, .blue = 0.919414 },
	{ .red = 0.998779, .green = 0.926496, .blue = 0.906471 },
	{ .red = 0.999512, .green = 0.908913, .blue = 0.889866 },
	{ .red = 0.999023, .green = 0.890598, .blue = 0.871551 },
	{ .red = 0.999512, .green = 0.871551, .blue = 0.851526 },
	{ .red = 0.027106, .green = 0.975336, .blue = 0.832234 },
	{ .red = 0.027595, .green = 0.977778, .blue = 0.833455 },
	{ .red = 0.030769, .green = 0.986325, .blue = 0.837363 },
	{ .red = 0.168010, .green = 0.998535, .blue = 0.844689 },
	{ .red = 0.398779, .green = 0.999267, .blue = 0.855922 },
	{ .red = 0.544567, .green = 0.999267, .blue = 0.867643 },
	{ .red = 0.657875, .green = 0.999023, .blue = 0.878877 },
	{ .red = 0.748718, .green = 0.999023, .blue = 0.888400 },
	{ .red = 0.823932, .green = 0.998779, .blue = 0.895482 },
	{ .red = 0.888400, .green = 0.999023, .blue = 0.899389 },
	{ .red = 0.940171, .green = 0.999267, .blue = 0.888645 },
	{ .red = 0.998779, .green = 0.994628, .blue = 0.837851 },
	{ .red = 0.998779, .green = 0.953602, .blue = 0.878632 },
	{ .red = 0.998046, .green = 0.936264, .blue = 0.883272 },
	{ .red = 0.998779, .green = 0.923810, .blue = 0.880098 },
	{ .red = 0.999512, .green = 0.913065, .blue = 0.873748 },
	{ .red = 0.998779, .green = 0.900366, .blue = 0.863248 },
	{ .red = 0.094994, .green = 0.980708, .blue = 0.782173 },
	{ .red = 0.100122, .green = 0.982418, .blue = 0.782418 },
	{ .red = 0.120635, .green = 0.988034, .blue = 0.783883 },
	{ .red = 0.249573, .green = 0.998779, .blue = 0.794139 },
	{ .red = 0.418803, .green = 0.998291, .blue = 0.807814 },
	{ .red = 0.544567, .green = 0.998535, .blue = 0.823443 },
	{ .red = 0.647375, .green = 0.999023, .blue = 0.839072 },
	{ .red = 0.733333, .green = 0.998779, .blue = 0.853480 },
	{ .red = 0.805861, .green = 0.998779, .blue = 0.866422 },
	{ .red = 0.867399, .green = 0.999267, .blue = 0.877656 },
	{ .red = 0.923077, .green = 0.998779, .blue = 0.890842 },
	{ .red = 0.947253, .green = 0.999023, .blue = 0.853968 },
	{ .red = 0.998291, .green = 0.995360, .blue = 0.802686 },
	{ .red = 0.999267, .green = 0.953358, .blue = 0.834921 },
	{ .red = 0.999023, .green = 0.931380, .blue = 0.841270 },
	{ .red = 0.999023, .green = 0.915018, .blue = 0.839316 },
	{ .red = 0.999756, .green = 0.901343, .blue = 0.832967 },
	{ .red = 0.033944, .green = 0.990232, .blue = 0.739194 },
	{ .red = 0.050549, .green = 0.991453, .blue = 0.739194 },
	{ .red = 0.086691, .green = 0.996337, .blue = 0.739438 },
	{ .red = 0.285226, .green = 0.998535, .blue = 0.751404 },
	{ .red = 0.421490, .green = 0.998779, .blue = 0.766789 },
	{ .red = 0.533578, .green = 0.999267, .blue = 0.784371 },
	{ .red = 0.630281, .green = 0.998779, .blue = 0.802442 },
	{ .red = 0.712088, .green = 0.999023, .blue = 0.820024 },
	{ .red = 0.782906, .green = 0.998779, .blue = 0.836874 },
	{ .red = 0.844444, .green = 0.998291, .blue = 0.853236 },
	{ .red = 0.897192, .green = 0.999023, .blue = 0.869109 },
	{ .red = 0.922344, .green = 0.998535, .blue = 0.854212 },
	{ .red = 0.949939, .green = 0.998779, .blue = 0.818559 },
	{ .red = 0.999267, .green = 0.996825, .blue = 0.760440 },
	{ .red = 0.998779, .green = 0.953114, .blue = 0.790476 },
	{ .red = 0.998779, .green = 0.927473, .blue = 0.797802 },
	{ .red = 0.998291, .green = 0.908425, .blue = 0.797558 },
	{ .red = 0.116728, .green = 0.988523, .blue = 0.697436 },
	{ .red = 0.120391, .green = 0.989744, .blue = 0.697436 },
	{ .red = 0.163370, .green = 0.997070, .blue = 0.701343 },
	{ .red = 0.300366, .green = 0.998535, .blue = 0.713553 },
	{ .red = 0.416361, .green = 0.999023, .blue = 0.729182 },
	{ .red = 0.518681, .green = 0.999023, .blue = 0.747497 },
	{ .red = 0.609035, .green = 0.998779, .blue = 0.767277 },
	{ .red = 0.687912, .green = 0.999023, .blue = 0.787057 },
	{ .red = 0.757021, .green = 0.999023, .blue = 0.806105 },
	{ .red = 0.817582, .green = 0.998779, .blue = 0.824908 },
	{ .red = 0.870330, .green = 0.999023, .blue = 0.843468 },
	{ .red = 0.904029, .green = 0.999267, .blue = 0.845910 },
	{ .red = 0.918681, .green = 0.999267, .blue = 0.810256 },
	{ .red = 0.951160, .green = 0.998535, .blue = 0.781929 },
	{ .red = 0.998291, .green = 0.996825, .blue = 0.721856 },
	{ .red = 0.999023, .green = 0.953358, .blue = 0.745788 },
	{ .red = 0.999267, .green = 0.925275, .blue = 0.753358 },
	{ .red = 0.102808, .green = 0.992674, .blue = 0.661050 },
	{ .red = 0.110134, .green = 0.993407, .blue = 0.660806 },
	{ .red = 0.188523, .green = 0.999023, .blue = 0.667399 },
	{ .red = 0.303785, .green = 0.999023, .blue = 0.678877 },
	{ .red = 0.406105, .green = 0.999267, .blue = 0.694261 },
	{ .red = 0.501832, .green = 0.998291, .blue = 0.713065 },
	{ .red = 0.585836, .green = 0.999023, .blue = 0.733089 },
	{ .red = 0.661783, .green = 0.999267, .blue = 0.753846 },
	{ .red = 0.730403, .green = 0.998535, .blue = 0.775092 },
	{ .red = 0.790232, .green = 0.998535, .blue = 0.795604 },
	{ .red = 0.841758, .green = 0.999756, .blue = 0.814408 },
	{ .red = 0.887668, .green = 0.999023, .blue = 0.833944 },
	{ .red = 0.895238, .green = 0.999267, .blue = 0.800244 },
	{ .red = 0.916484, .green = 0.999023, .blue = 0.768498 },
	{ .red = 0.952137, .green = 0.999756, .blue = 0.742613 },
	{ .red = 0.997070, .green = 0.996337, .blue = 0.685470 },
	{ .red = 0.999023, .green = 0.954335, .blue = 0.703297 },
	{ .red = 0.126984, .green = 0.991941, .blue = 0.627595 },
	{ .red = 0.145543, .green = 0.994139, .blue = 0.629548 },
	{ .red = 0.209280, .green = 0.998291, .blue = 0.636142 },
	{ .red = 0.302808, .green = 0.998779, .blue = 0.646886 },
	{ .red = 0.395116, .green = 0.998779, .blue = 0.661783 },
	{ .red = 0.481074, .green = 0.999267, .blue = 0.679853 },
	{ .red = 0.562393, .green = 0.998779, .blue = 0.700122 },
	{ .red = 0.635653, .green = 0.999023, .blue = 0.721612 },
	{ .red = 0.701343, .green = 0.999512, .blue = 0.742857 },
	{ .red = 0.761661, .green = 0.998779, .blue = 0.764835 },
	{ .red = 0.814896, .green = 0.998779, .blue = 0.786325 },
	{ .red = 0.861294, .green = 0.999756, .blue = 0.806838 },
	{ .red = 0.875214, .green = 0.998535, .blue = 0.788278 },
	{ .red = 0.889377, .green = 0.998779, .blue = 0.757021 },
	{ .red = 0.915507, .green = 0.998535, .blue = 0.730159 },
	{ .red = 0.952137, .green = 0.998535, .blue = 0.710134 },
	{ .red = 0.997070, .green = 0.996825, .blue = 0.648352 },
	{ .red = 0.020269, .green = 0.141148, .blue = 0.786569 },
	{ .red = 0.089866, .green = 0.018559, .blue = 0.868864 },
	{ .red = 0.193407, .green = 0.018803, .blue = 0.872283 },
	{ .red = 0.315263, .green = 0.021245, .blue = 0.934554 },
	{ .red = 0.441514, .green = 0.028816, .blue = 0.979487 },
	{ .red = 0.553602, .green = 0.037118, .blue = 0.988523 },
	{ .red = 0.644933, .green = 0.019292, .blue = 0.973382 },
	{ .red = 0.708913, .green = 0.015873, .blue = 0.935287 },
	{ .red = 0.755311, .green = 0.016117, .blue = 0.893040 },
	{ .red = 0.833455, .green = 0.014164, .blue = 0.900122 },
	{ .red = 0.910134, .green = 0.024176, .blue = 0.909402 },
	{ .red = 0.937241, .green = 0.025153, .blue = 0.852259 },
	{ .red = 0.956777, .green = 0.019292, .blue = 0.799756 },
	{ .red = 0.970940, .green = 0.017094, .blue = 0.751648 },
	{ .red = 0.981441, .green = 0.019048, .blue = 0.707937 },
	{ .red = 0.982418, .green = 0.036386, .blue = 0.663736 },
	{ .red = 0.983394, .green = 0.043468, .blue = 0.625153 },
	{ .red = 0.026862, .green = 0.124054, .blue = 0.891331 },
	{ .red = 0.096215, .green = 0.022955, .blue = 0.912576 },
	{ .red = 0.202198, .green = 0.019292, .blue = 0.919902 },
	{ .red = 0.332601, .green = 0.021734, .blue = 0.996825 },
	{ .red = 0.447375, .green = 0.075946, .blue = 0.999267 },
	{ .red = 0.556044, .green = 0.086935, .blue = 0.997558 },
	{ .red = 0.656166, .green = 0.071795, .blue = 0.995116 },
	{ .red = 0.738706, .green = 0.039316, .blue = 0.980220 },
	{ .red = 0.786813, .green = 0.024176, .blue = 0.934310 },
	{ .red = 0.860806, .green = 0.020513, .blue = 0.932357 },
	{ .red = 0.937485, .green = 0.021001, .blue = 0.938462 },
	{ .red = 0.962882, .green = 0.025153, .blue = 0.876679 },
	{ .red = 0.980708, .green = 0.018071, .blue = 0.819780 },
	{ .red = 0.981197, .green = 0.043468, .blue = 0.758974 },
	{ .red = 0.992918, .green = 0.062271, .blue = 0.715751 },
	{ .red = 0.999756, .green = 0.091819, .blue = 0.676190 },
	{ .red = 0.999023, .green = 0.112576, .blue = 0.637363 },
	{ .red = 0.045421, .green = 0.169963, .blue = 0.976068 },
	{ .red = 0.108181, .green = 0.120391, .blue = 0.999023 },
	{ .red = 0.216361, .green = 0.133333, .blue = 0.999023 },
	{ .red = 0.329915, .green = 0.165324, .blue = 0.998046 },
	{ .red = 0.445177, .green = 0.189499, .blue = 0.998779 },
	{ .red = 0.556777, .green = 0.203175, .blue = 0.999023 },
	{ .red = 0.660806, .green = 0.207326, .blue = 0.998291 },
	{ .red = 0.757021, .green = 0.204640, .blue = 0.999512 },
	{ .red = 0.843712, .green = 0.197558, .blue = 0.999023 },
	{ .red = 0.924786, .green = 0.191941, .blue = 0.999023 },
	{ .red = 0.995604, .green = 0.188767, .blue = 0.993895 },
	{ .red = 0.998535, .green = 0.206105, .blue = 0.906716 },
	{ .red = 0.999023, .green = 0.216606, .blue = 0.834676 },
	{ .red = 0.998779, .green = 0.222711, .blue = 0.775824 },
	{ .red = 0.999023, .green = 0.225641, .blue = 0.726984 },
	{ .red = 0.999023, .green = 0.226618, .blue = 0.684982 },
	{ .red = 0.999267, .green = 0.226374, .blue = 0.648596 },
	{ .red = 0.027839, .green = 0.265690, .blue = 0.957021 },
	{ .red = 0.155311, .green = 0.313553, .blue = 0.998779 },
	{ .red = 0.242247, .green = 0.313065, .blue = 0.999023 },
	{ .red = 0.351404, .green = 0.329182, .blue = 0.999023 },
	{ .red = 0.464957, .green = 0.346276, .blue = 0.998779 },
	{ .red = 0.576801, .green = 0.359951, .blue = 0.999512 },
	{ .red = 0.681074, .green = 0.368254, .blue = 0.999023 },
	{ .red = 0.776313, .green = 0.372161, .blue = 0.998535 },
	{ .red = 0.863004, .green = 0.372894, .blue = 0.998779 },
	{ .red = 0.941148, .green = 0.371673, .blue = 0.998535 },
	{ .red = 0.999267, .green = 0.371917, .blue = 0.983394 },
	{ .red = 0.999023, .green = 0.373871, .blue = 0.903053 },
	{ .red = 0.999512, .green = 0.371673, .blue = 0.838584 },
	{ .red = 0.998779, .green = 0.366789, .blue = 0.785836 },
	{ .red = 0.999267, .green = 0.359463, .blue = 0.742369 },
	{ .red = 0.998779, .green = 0.350916, .blue = 0.703297 },
	{ .red = 0.999512, .green = 0.341636, .blue = 0.669109 },
	{ .red = 0.000000, .green = 0.325763, .blue = 0.804884 },
	{ .red = 0.081074, .green = 0.369475, .blue = 0.997802 },
	{ .red = 0.303785, .green = 0.465934, .blue = 0.999023 },
	{ .red = 0.394872, .green = 0.474725, .blue = 0.998535 },
	{ .red = 0.498657, .green = 0.488645, .blue = 0.998291 },
	{ .red = 0.603907, .green = 0.501099, .blue = 0.998291 },
	{ .red = 0.704762, .green = 0.510867, .blue = 0.998779 },
	{ .red = 0.796825, .green = 0.516972, .blue = 0.998046 },
	{ .red = 0.880830, .green = 0.519658, .blue = 0.999512 },
	{ .red = 0.955067, .green = 0.519170, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.519658, .blue = 0.973871 },
	{ .red = 0.998535, .green = 0.517460, .blue = 0.905250 },
	{ .red = 0.999023, .green = 0.510134, .blue = 0.850305 },
	{ .red = 0.998535, .green = 0.499634, .blue = 0.805128 },
	{ .red = 0.999512, .green = 0.486447, .blue = 0.767033 },
	{ .red = 0.998535, .green = 0.471551, .blue = 0.731380 },
	{ .red = 0.998291, .green = 0.455678, .blue = 0.698901 },
	{ .red = 0.013675, .green = 0.440537, .blue = 0.852015 },
	{ .red = 0.007326, .green = 0.462271, .blue = 0.932601 },
	{ .red = 0.257143, .green = 0.522344, .blue = 0.999267 },
	{ .red = 0.463248, .green = 0.609768, .blue = 0.998291 },
	{ .red = 0.547497, .green = 0.619292, .blue = 0.998535 },
	{ .red = 0.639072, .green = 0.629548, .blue = 0.998291 },
	{ .red = 0.730159, .green = 0.638339, .blue = 0.998779 },
	{ .red = 0.815385, .green = 0.644200, .blue = 0.998779 },
	{ .red = 0.892796, .green = 0.646886, .blue = 0.998535 },
	{ .red = 0.961905, .green = 0.645910, .blue = 0.998779 },
	{ .red = 0.998779, .green = 0.645421, .blue = 0.972161 },
	{ .red = 0.998291, .green = 0.642491, .blue = 0.915263 },
	{ .red = 0.999023, .green = 0.632479, .blue = 0.869841 },
	{ .red = 0.999267, .green = 0.618803, .blue = 0.831990 },
	{ .red = 0.999023, .green = 0.601954, .blue = 0.798291 },
	{ .red = 0.998779, .green = 0.583150, .blue = 0.766545 },
	{ .red = 0.998291, .green = 0.562882, .blue = 0.736020 },
	{ .red = 0.020024, .green = 0.550427, .blue = 0.878144 },
	{ .red = 0.019292, .green = 0.562882, .blue = 0.912821 },
	{ .red = 0.193651, .green = 0.608791, .blue = 0.998779 },
	{ .red = 0.405861, .green = 0.656410, .blue = 0.998779 },
	{ .red = 0.610745, .green = 0.734310, .blue = 0.999023 },
	{ .red = 0.680586, .green = 0.739683, .blue = 0.998535 },
	{ .red = 0.757021, .green = 0.746276, .blue = 0.999023 },
	{ .red = 0.831746, .green = 0.750916, .blue = 0.999267 },
	{ .red = 0.901099, .green = 0.752625, .blue = 0.999023 },
	{ .red = 0.963858, .green = 0.750672, .blue = 0.998779 },
	{ .red = 0.998535, .green = 0.748962, .blue = 0.976557 },
	{ .red = 0.998291, .green = 0.745788, .blue = 0.929670 },
	{ .red = 0.999512, .green = 0.734310, .blue = 0.892552 },
	{ .red = 0.998535, .green = 0.718926, .blue = 0.860562 },
	{ .red = 0.999267, .green = 0.700122, .blue = 0.831746 },
	{ .red = 0.998779, .green = 0.679365, .blue = 0.802930 },
	{ .red = 0.999023, .green = 0.656899, .blue = 0.774847 },
	{ .red = 0.026862, .green = 0.656654, .blue = 0.900366 },
	{ .red = 0.030281, .green = 0.664469, .blue = 0.917460 },
	{ .red = 0.067888, .green = 0.696703, .blue = 0.987546 },
	{ .red = 0.355311, .green = 0.732845, .blue = 0.999267 },
	{ .red = 0.533822, .green = 0.767766, .blue = 0.998535 },
	{ .red = 0.690354, .green = 0.808791, .blue = 0.999023 },
	{ .red = 0.784860, .green = 0.832723, .blue = 0.999512 },
	{ .red = 0.846398, .green = 0.835897, .blue = 0.999267 },
	{ .red = 0.906471, .green = 0.836630, .blue = 0.999023 },
	{ .red = 0.963370, .green = 0.833700, .blue = 0.999512 },
	{ .red = 0.999756, .green = 0.830037, .blue = 0.984127 },
	{ .red = 0.998535, .green = 0.826374, .blue = 0.944078 },
	{ .red = 0.998779, .green = 0.814164, .blue = 0.913309 },
	{ .red = 0.998535, .green = 0.798046, .blue = 0.886935 },
	{ .red = 0.998535, .green = 0.778999, .blue = 0.861783 },
	{ .red = 0.999023, .green = 0.757265, .blue = 0.836386 },
	{ .red = 0.999023, .green = 0.734554, .blue = 0.810256 },
	{ .red = 0.026374, .green = 0.764835, .blue = 0.927961 },
	{ .red = 0.033700, .green = 0.769475, .blue = 0.936508 },
	{ .red = 0.054212, .green = 0.788278, .blue = 0.970696 },
	{ .red = 0.294994, .green = 0.816606, .blue = 0.999023 },
	{ .red = 0.489133, .green = 0.837363, .blue = 0.998779 },
	{ .red = 0.637363, .green = 0.857631, .blue = 0.997802 },
	{ .red = 0.759219, .green = 0.877900, .blue = 0.998779 },
	{ .red = 0.860073, .green = 0.900611, .blue = 0.998291 },
	{ .red = 0.909646, .green = 0.901099, .blue = 0.998779 },
	{ .red = 0.960195, .green = 0.897924, .blue = 0.999023 },
	{ .red = 0.999512, .green = 0.892063, .blue = 0.989988 },
	{ .red = 0.998779, .green = 0.887179, .blue = 0.955556 },
	{ .red = 0.999267, .green = 0.874481, .blue = 0.931136 },
	{ .red = 0.998291, .green = 0.858120, .blue = 0.908669 },
	{ .red = 0.999756, .green = 0.838828, .blue = 0.886691 },
	{ .red = 0.998535, .green = 0.818315, .blue = 0.863736 },
	{ .red = 0.998535, .green = 0.796093, .blue = 0.840049 },
	{ .red = 0.029548, .green = 0.866667, .blue = 0.948718 },
	{ .red = 0.029792, .green = 0.869841, .blue = 0.953358 },
	{ .red = 0.032479, .green = 0.882295, .blue = 0.971429 },
	{ .red = 0.199267, .green = 0.903541, .blue = 0.998535 },
	{ .red = 0.441270, .green = 0.914286, .blue = 0.998779 },
	{ .red = 0.596093, .green = 0.924054, .blue = 0.999023 },
	{ .red = 0.716484, .green = 0.931624, .blue = 0.998535 },
	{ .red = 0.812454, .green = 0.938462, .blue = 0.999023 },
	{ .red = 0.894750, .green = 0.944322, .blue = 0.999023 },
	{ .red = 0.953114, .green = 0.947253, .blue = 0.998535 },
	{ .red = 0.998291, .green = 0.939194, .blue = 0.993162 },
	{ .red = 0.999512, .green = 0.931868, .blue = 0.963614 },
	{ .red = 0.999023, .green = 0.918437, .blue = 0.943590 },
	{ .red = 0.998779, .green = 0.902076, .blue = 0.925031 },
	{ .red = 0.999023, .green = 0.883761, .blue = 0.905495 },
	{ .red = 0.999267, .green = 0.863980, .blue = 0.884737 },
	{ .red = 0.999512, .green = 0.843223, .blue = 0.863004 },
	{ .red = 0.067399, .green = 0.963126, .blue = 0.963126 },
	{ .red = 0.069597, .green = 0.965324, .blue = 0.965568 },
	{ .red = 0.078144, .green = 0.972894, .blue = 0.973871 },
	{ .red = 0.094505, .green = 0.988523, .blue = 0.990232 },
	{ .red = 0.361416, .green = 0.997070, .blue = 0.998291 },
	{ .red = 0.541636, .green = 0.997558, .blue = 0.998046 },
	{ .red = 0.664225, .green = 0.998779, .blue = 0.999267 },
	{ .red = 0.761905, .green = 0.997558, .blue = 0.998291 },
	{ .red = 0.833700, .green = 0.998046, .blue = 0.998779 },
	{ .red = 0.889377, .green = 0.998291, .blue = 0.999267 },
	{ .red = 0.980464, .green = 0.978999, .blue = 0.979243 },
	{ .red = 0.998535, .green = 0.963126, .blue = 0.964835 },
	{ .red = 0.999512, .green = 0.948718, .blue = 0.950427 },
	{ .red = 0.999756, .green = 0.932845, .blue = 0.934799 },
	{ .red = 0.999512, .green = 0.915995, .blue = 0.917705 },
	{ .red = 0.999756, .green = 0.897924, .blue = 0.899145 },
	{ .red = 0.999023, .green = 0.878877, .blue = 0.879609 },
	{ .red = 0.083028, .green = 0.974359, .blue = 0.904274 },
	{ .red = 0.090354, .green = 0.976068, .blue = 0.905495 },
	{ .red = 0.114286, .green = 0.981929, .blue = 0.909646 },
	{ .red = 0.169719, .green = 0.995849, .blue = 0.920635 },
	{ .red = 0.405861, .green = 0.999267, .blue = 0.929182 },
	{ .red = 0.557265, .green = 0.999023, .blue = 0.935287 },
	{ .red = 0.671795, .green = 0.998291, .blue = 0.941148 },
	{ .red = 0.758486, .green = 0.999267, .blue = 0.946520 },
	{ .red = 0.827595, .green = 0.999512, .blue = 0.949939 },
	{ .red = 0.885958, .green = 0.999023, .blue = 0.950183 },
	{ .red = 0.939194, .green = 0.998291, .blue = 0.945788 },
	{ .red = 0.998535, .green = 0.995116, .blue = 0.907937 },
	{ .red = 0.998535, .green = 0.965324, .blue = 0.938950 },
	{ .red = 0.999023, .green = 0.955311, .blue = 0.937485 },
	{ .red = 0.998779, .green = 0.939683, .blue = 0.923810 },
	{ .red = 0.998535, .green = 0.923321, .blue = 0.907692 },
	{ .red = 0.999267, .green = 0.905983, .blue = 0.890110 },
	{ .red = 0.112332, .green = 0.980220, .blue = 0.850061 },
	{ .red = 0.116728, .green = 0.981685, .blue = 0.850794 },
	{ .red = 0.133333, .green = 0.986813, .blue = 0.853480 },
	{ .red = 0.246398, .green = 0.999512, .blue = 0.864713 },
	{ .red = 0.424908, .green = 0.999267, .blue = 0.874725 },
	{ .red = 0.552625, .green = 1.000000, .blue = 0.886203 },
	{ .red = 0.656654, .green = 0.999512, .blue = 0.896703 },
	{ .red = 0.740415, .green = 0.999512, .blue = 0.906471 },
	{ .red = 0.809524, .green = 0.999023, .blue = 0.914286 },
	{ .red = 0.868620, .green = 0.998046, .blue = 0.920879 },
	{ .red = 0.918193, .green = 0.998535, .blue = 0.925763 },
	{ .red = 0.956288, .green = 0.999512, .blue = 0.918193 },
	{ .red = 0.998291, .green = 0.995360, .blue = 0.871795 },
	{ .red = 0.998779, .green = 0.961416, .blue = 0.900122 },
	{ .red = 0.999023, .green = 0.946032, .blue = 0.901343 },
	{ .red = 0.998535, .green = 0.934554, .blue = 0.897680 },
	{ .red = 0.999512, .green = 0.924298, .blue = 0.890842 },
	{ .red = 0.094017, .green = 0.987546, .blue = 0.803663 },
	{ .red = 0.097192, .green = 0.989011, .blue = 0.804151 },
	{ .red = 0.112576, .green = 0.993895, .blue = 0.805617 },
	{ .red = 0.286691, .green = 0.999267, .blue = 0.816850 },
	{ .red = 0.429304, .green = 0.998779, .blue = 0.828816 },
	{ .red = 0.541636, .green = 0.999512, .blue = 0.842735 },
	{ .red = 0.638584, .green = 0.998779, .blue = 0.856654 },
	{ .red = 0.717949, .green = 0.999267, .blue = 0.869841 },
	{ .red = 0.785348, .green = 0.999512, .blue = 0.881563 },
	{ .red = 0.843223, .green = 0.999267, .blue = 0.892063 },
	{ .red = 0.894017, .green = 0.999023, .blue = 0.902076 },
	{ .red = 0.939438, .green = 0.999023, .blue = 0.913797 },
	{ .red = 0.956532, .green = 0.999267, .blue = 0.879609 },
	{ .red = 0.998535, .green = 0.995849, .blue = 0.830525 },
	{ .red = 0.999023, .green = 0.958974, .blue = 0.856654 },
	{ .red = 0.998779, .green = 0.939194, .blue = 0.861050 },
	{ .red = 0.999023, .green = 0.924542, .blue = 0.858364 },
	{ .red = 0.102808, .green = 0.990476, .blue = 0.760195 },
	{ .red = 0.108913, .green = 0.991453, .blue = 0.760195 },
	{ .red = 0.152381, .green = 0.998779, .blue = 0.764835 },
	{ .red = 0.304762, .green = 0.998535, .blue = 0.774603 },
	{ .red = 0.424176, .green = 0.998291, .blue = 0.787790 },
	{ .red = 0.525031, .green = 0.999267, .blue = 0.803175 },
	{ .red = 0.613919, .green = 0.999756, .blue = 0.819048 },
	{ .red = 0.693284, .green = 0.998779, .blue = 0.834921 },
	{ .red = 0.760195, .green = 0.998779, .blue = 0.849573 },
	{ .red = 0.818071, .green = 0.998535, .blue = 0.863248 },
	{ .red = 0.868376, .green = 0.999023, .blue = 0.876190 },
	{ .red = 0.914042, .green = 0.998535, .blue = 0.890842 },
	{ .red = 0.934066, .green = 0.998779, .blue = 0.875946 },
	{ .red = 0.956532, .green = 0.998779, .blue = 0.842002 },
	{ .red = 0.998046, .green = 0.995849, .blue = 0.789499 },
	{ .red = 0.999023, .green = 0.957753, .blue = 0.812454 },
	{ .red = 0.998535, .green = 0.934554, .blue = 0.819292 },
	{ .red = 0.123321, .green = 0.990965, .blue = 0.720391 },
	{ .red = 0.125519, .green = 0.991941, .blue = 0.720391 },
	{ .red = 0.190476, .green = 0.999023, .blue = 0.727228 },
	{ .red = 0.307692, .green = 0.999023, .blue = 0.736996 },
	{ .red = 0.411477, .green = 0.999267, .blue = 0.750427 },
	{ .red = 0.506227, .green = 0.998779, .blue = 0.766300 },
	{ .red = 0.590232, .green = 0.999267, .blue = 0.783150 },
	{ .red = 0.665934, .green = 0.999023, .blue = 0.800488 },
	{ .red = 0.731868, .green = 0.999023, .blue = 0.817094 },
	{ .red = 0.789499, .green = 0.999267, .blue = 0.832723 },
	{ .red = 0.842247, .green = 0.998291, .blue = 0.849084 },
	{ .red = 0.887424, .green = 0.998535, .blue = 0.864469 },
	{ .red = 0.917216, .green = 0.998535, .blue = 0.867399 },
	{ .red = 0.927717, .green = 0.999267, .blue = 0.831746 },
	{ .red = 0.956288, .green = 0.999267, .blue = 0.803175 },
	{ .red = 0.999023, .green = 0.997314, .blue = 0.745788 },
	{ .red = 0.999512, .green = 0.957753, .blue = 0.768742 },
	{ .red = 0.107204, .green = 0.994872, .blue = 0.685226 },
	{ .red = 0.118681, .green = 0.998535, .blue = 0.687424 },
	{ .red = 0.209524, .green = 0.999023, .blue = 0.693040 },
	{ .red = 0.304762, .green = 0.999512, .blue = 0.702564 },
	{ .red = 0.398046, .green = 0.999267, .blue = 0.715507 },
	{ .red = 0.487668, .green = 0.998046, .blue = 0.731624 },
	{ .red = 0.566789, .green = 0.998535, .blue = 0.748962 },
	{ .red = 0.638584, .green = 0.999023, .blue = 0.766789 },
	{ .red = 0.704029, .green = 0.998779, .blue = 0.784860 },
	{ .red = 0.763126, .green = 0.998046, .blue = 0.802930 },
	{ .red = 0.813919, .green = 0.998535, .blue = 0.819536 },
	{ .red = 0.859829, .green = 0.999267, .blue = 0.836142 },
	{ .red = 0.900611, .green = 0.998779, .blue = 0.853480 },
	{ .red = 0.906471, .green = 0.998291, .blue = 0.822955 },
	{ .red = 0.924542, .green = 0.999512, .blue = 0.789744 },
	{ .red = 0.956288, .green = 0.999267, .blue = 0.766789 },
	{ .red = 0.999023, .green = 0.997802, .blue = 0.706227 },
	{ .red = 0.035897, .green = 0.070330, .blue = 0.999267 },
	{ .red = 0.091575, .green = 0.021734, .blue = 0.930159 },
	{ .red = 0.184860, .green = 0.016850, .blue = 0.913309 },
	{ .red = 0.300366, .green = 0.012698, .blue = 0.977045 },
	{ .red = 0.411722, .green = 0.066911, .blue = 0.998535 },
	{ .red = 0.513065, .green = 0.082784, .blue = 0.996825 },
	{ .red = 0.608303, .green = 0.079609, .blue = 0.995360 },
	{ .red = 0.699389, .green = 0.045421, .blue = 1.000000 },
	{ .red = 0.751648, .green = 0.024908, .blue = 0.959951 },
	{ .red = 0.786813, .green = 0.024420, .blue = 0.913797 },
	{ .red = 0.864225, .green = 0.021490, .blue = 0.926496 },
	{ .red = 0.933822, .green = 0.021245, .blue = 0.933578 },
	{ .red = 0.954823, .green = 0.026129, .blue = 0.875946 },
	{ .red = 0.971429, .green = 0.015385, .blue = 0.824664 },
	{ .red = 0.978022, .green = 0.030525, .blue = 0.773138 },
	{ .red = 0.984371, .green = 0.034432, .blue = 0.728694 },
	{ .red = 0.996093, .green = 0.023443, .blue = 0.693529 },
	{ .red = 0.044689, .green = 0.100855, .blue = 0.999756 },
	{ .red = 0.097924, .green = 0.025397, .blue = 0.969475 },
	{ .red = 0.192186, .green = 0.021978, .blue = 0.954335 },
	{ .red = 0.303541, .green = 0.061050, .blue = 0.992674 },
	{ .red = 0.410012, .green = 0.095238, .blue = 0.998779 },
	{ .red = 0.511844, .green = 0.107448, .blue = 0.998535 },
	{ .red = 0.607814, .green = 0.104029, .blue = 0.998291 },
	{ .red = 0.697680, .green = 0.084982, .blue = 0.999756 },
	{ .red = 0.775092, .green = 0.045665, .blue = 0.994139 },
	{ .red = 0.814896, .green = 0.024176, .blue = 0.949695 },
	{ .red = 0.886691, .green = 0.027839, .blue = 0.952625 },
	{ .red = 0.957021, .green = 0.018559, .blue = 0.957998 },
	{ .red = 0.977534, .green = 0.022955, .blue = 0.897680 },
	{ .red = 0.983883, .green = 0.038584, .blue = 0.835165 },
	{ .red = 0.999756, .green = 0.048352, .blue = 0.790232 },
	{ .red = 0.998779, .green = 0.092063, .blue = 0.739683 },
	{ .red = 0.999267, .green = 0.113553, .blue = 0.697680 },
	{ .red = 0.059341, .green = 0.171917, .blue = 0.992430 },
	{ .red = 0.104518, .green = 0.126252, .blue = 0.999023 },
	{ .red = 0.200733, .green = 0.131868, .blue = 0.999023 },
	{ .red = 0.304274, .green = 0.161172, .blue = 0.999512 },
	{ .red = 0.409768, .green = 0.186813, .blue = 0.998779 },
	{ .red = 0.513553, .green = 0.203663, .blue = 0.998779 },
	{ .red = 0.611722, .green = 0.211233, .blue = 0.999023 },
	{ .red = 0.702320, .green = 0.211966, .blue = 0.998535 },
	{ .red = 0.786081, .green = 0.208303, .blue = 0.999267 },
	{ .red = 0.862515, .green = 0.201465, .blue = 0.998779 },
	{ .red = 0.935043, .green = 0.198779, .blue = 0.999267 },
	{ .red = 0.996337, .green = 0.197802, .blue = 0.992918 },
	{ .red = 0.999023, .green = 0.212698, .blue = 0.914042 },
	{ .red = 0.999267, .green = 0.221490, .blue = 0.847375 },
	{ .red = 0.999023, .green = 0.226374, .blue = 0.792186 },
	{ .red = 0.999023, .green = 0.228327, .blue = 0.745543 },
	{ .red = 0.999023, .green = 0.228571, .blue = 0.705250 },
	{ .red = 0.059829, .green = 0.254457, .blue = 0.999023 },
	{ .red = 0.158730, .green = 0.309158, .blue = 0.998779 },
	{ .red = 0.231746, .green = 0.305495, .blue = 0.998535 },
	{ .red = 0.329915, .green = 0.320879, .blue = 0.998779 },
	{ .red = 0.432967, .green = 0.336752, .blue = 0.998046 },
	{ .red = 0.536020, .green = 0.350672, .blue = 0.998535 },
	{ .red = 0.634188, .green = 0.360195, .blue = 0.999023 },
	{ .red = 0.724786, .green = 0.366056, .blue = 0.999023 },
	{ .red = 0.807082, .green = 0.368742, .blue = 0.998291 },
	{ .red = 0.882784, .green = 0.368742, .blue = 0.999023 },
	{ .red = 0.951404, .green = 0.368254, .blue = 0.998779 },
	{ .red = 0.999267, .green = 0.368987, .blue = 0.981441 },
	{ .red = 0.998779, .green = 0.369963, .blue = 0.908913 },
	{ .red = 0.999267, .green = 0.366545, .blue = 0.849817 },
	{ .red = 0.998779, .green = 0.360928, .blue = 0.800000 },
	{ .red = 0.998779, .green = 0.353358, .blue = 0.757753 },
	{ .red = 0.999756, .green = 0.344567, .blue = 0.720879 },
	{ .red = 0.021245, .green = 0.335531, .blue = 0.952625 },
	{ .red = 0.125031, .green = 0.357509, .blue = 0.998779 },
	{ .red = 0.298901, .green = 0.453236, .blue = 0.999023 },
	{ .red = 0.379243, .green = 0.461294, .blue = 0.998779 },
	{ .red = 0.472772, .green = 0.473993, .blue = 0.998535 },
	{ .red = 0.569231, .green = 0.486447, .blue = 0.999023 },
	{ .red = 0.662515, .green = 0.496703, .blue = 0.998779 },
	{ .red = 0.750427, .green = 0.504274, .blue = 0.999756 },
	{ .red = 0.829060, .green = 0.509158, .blue = 0.998291 },
	{ .red = 0.901587, .green = 0.510867, .blue = 0.999512 },
	{ .red = 0.965812, .green = 0.510379, .blue = 0.999023 },
	{ .red = 0.999512, .green = 0.510867, .blue = 0.972161 },
	{ .red = 0.999267, .green = 0.507448, .blue = 0.910623 },
	{ .red = 0.999267, .green = 0.498901, .blue = 0.859096 },
	{ .red = 0.998779, .green = 0.487424, .blue = 0.815873 },
	{ .red = 0.999023, .green = 0.473748, .blue = 0.778510 },
	{ .red = 0.998291, .green = 0.459096, .blue = 0.744078 },
	{ .red = 0.016361, .green = 0.411477, .blue = 0.885714 },
	{ .red = 0.041514, .green = 0.436386, .blue = 0.987302 },
	{ .red = 0.283028, .green = 0.508913, .blue = 0.998535 },
	{ .red = 0.452259, .green = 0.591209, .blue = 0.997802 },
	{ .red = 0.528694, .green = 0.600977, .blue = 0.998535 },
	{ .red = 0.611966, .green = 0.611233, .blue = 0.999023 },
	{ .red = 0.695238, .green = 0.620269, .blue = 0.997802 },
	{ .red = 0.775336, .green = 0.627595, .blue = 0.999023 },
	{ .red = 0.848107, .green = 0.632479, .blue = 0.998046 },
	{ .red = 0.914530, .green = 0.634432, .blue = 0.999023 },
	{ .red = 0.973871, .green = 0.632967, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.632967, .blue = 0.969231 },
	{ .red = 0.998291, .green = 0.628571, .blue = 0.918681 },
	{ .red = 0.998535, .green = 0.617094, .blue = 0.875458 },
	{ .red = 0.999267, .green = 0.602442, .blue = 0.839316 },
	{ .red = 0.999756, .green = 0.585104, .blue = 0.806349 },
	{ .red = 0.998779, .green = 0.566300, .blue = 0.774847 },
	{ .red = 0.010745, .green = 0.514530, .blue = 0.904274 },
	{ .red = 0.016606, .green = 0.527961, .blue = 0.947497 },
	{ .red = 0.233211, .green = 0.574115, .blue = 0.999512 },
	{ .red = 0.426374, .green = 0.637118, .blue = 0.998779 },
	{ .red = 0.596337, .green = 0.712088, .blue = 0.998779 },
	{ .red = 0.662271, .green = 0.719414, .blue = 0.999023 },
	{ .red = 0.731624, .green = 0.726496, .blue = 0.999023 },
	{ .red = 0.800000, .green = 0.732357, .blue = 0.998535 },
	{ .red = 0.864225, .green = 0.736264, .blue = 0.998535 },
	{ .red = 0.922833, .green = 0.737485, .blue = 0.998535 },
	{ .red = 0.976313, .green = 0.735287, .blue = 0.999267 },
	{ .red = 0.998291, .green = 0.734310, .blue = 0.972894 },
	{ .red = 0.999023, .green = 0.729670, .blue = 0.932357 },
	{ .red = 0.998779, .green = 0.716972, .blue = 0.895971 },
	{ .red = 0.998535, .green = 0.700855, .blue = 0.864957 },
	{ .red = 0.999267, .green = 0.681563, .blue = 0.836142 },
	{ .red = 0.998535, .green = 0.660562, .blue = 0.807814 },
	{ .red = 0.023932, .green = 0.611966, .blue = 0.918681 },
	{ .red = 0.026129, .green = 0.620757, .blue = 0.940904 },
	{ .red = 0.177045, .green = 0.654945, .blue = 0.998779 },
	{ .red = 0.384860, .green = 0.695482, .blue = 0.998046 },
	{ .red = 0.552625, .green = 0.743590, .blue = 0.998535 },
	{ .red = 0.716972, .green = 0.808547, .blue = 0.999267 },
	{ .red = 0.768987, .green = 0.812698, .blue = 0.999756 },
	{ .red = 0.824176, .green = 0.816850, .blue = 0.998779 },
	{ .red = 0.878388, .green = 0.819536, .blue = 0.999512 },
	{ .red = 0.928449, .green = 0.820024, .blue = 0.998291 },
	{ .red = 0.974603, .green = 0.817094, .blue = 0.998046 },
	{ .red = 0.998779, .green = 0.814652, .blue = 0.979976 },
	{ .red = 0.999023, .green = 0.809768, .blue = 0.946276 },
	{ .red = 0.998535, .green = 0.796825, .blue = 0.915995 },
	{ .red = 0.998535, .green = 0.780220, .blue = 0.889621 },
	{ .red = 0.998779, .green = 0.760440, .blue = 0.864469 },
	{ .red = 0.998046, .green = 0.738950, .blue = 0.838828 },
	{ .red = 0.022466, .green = 0.708425, .blue = 0.936508 },
	{ .red = 0.021490, .green = 0.714286, .blue = 0.948718 },
	{ .red = 0.048596, .green = 0.739438, .blue = 0.999023 },
	{ .red = 0.347985, .green = 0.766056, .blue = 0.998046 },
	{ .red = 0.515263, .green = 0.797070, .blue = 0.998291 },
	{ .red = 0.654457, .green = 0.828327, .blue = 0.998291 },
	{ .red = 0.780464, .green = 0.864225, .blue = 0.998535 },
	{ .red = 0.848107, .green = 0.881807, .blue = 0.998779 },
	{ .red = 0.891087, .green = 0.883516, .blue = 0.998291 },
	{ .red = 0.933578, .green = 0.883516, .blue = 0.999023 },
	{ .red = 0.973871, .green = 0.880586, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.876679, .blue = 0.986569 },
	{ .red = 0.999023, .green = 0.871306, .blue = 0.957998 },
	{ .red = 0.999267, .green = 0.858120, .blue = 0.933578 },
	{ .red = 0.999023, .green = 0.841514, .blue = 0.911111 },
	{ .red = 0.999023, .green = 0.822222, .blue = 0.888889 },
	{ .red = 0.998535, .green = 0.801221, .blue = 0.865690 },
	{ .red = 0.033944, .green = 0.801954, .blue = 0.953358 },
	{ .red = 0.043956, .green = 0.805128, .blue = 0.959219 },
	{ .red = 0.084005, .green = 0.816850, .blue = 0.979731 },
	{ .red = 0.306960, .green = 0.841026, .blue = 0.998779 },
	{ .red = 0.484737, .green = 0.860806, .blue = 0.999512 },
	{ .red = 0.622711, .green = 0.878877, .blue = 0.998535 },
	{ .red = 0.734066, .green = 0.895726, .blue = 0.998779 },
	{ .red = 0.827350, .green = 0.911844, .blue = 0.998291 },
	{ .red = 0.904029, .green = 0.931380, .blue = 0.998291 },
	{ .red = 0.937729, .green = 0.931380, .blue = 0.998779 },
	{ .red = 0.972650, .green = 0.928938, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.924054, .blue = 0.991453 },
	{ .red = 0.998779, .green = 0.917705, .blue = 0.967033 },
	{ .red = 0.998291, .green = 0.904518, .blue = 0.947009 },
	{ .red = 0.998291, .green = 0.887912, .blue = 0.927717 },
	{ .red = 0.998779, .green = 0.869109, .blue = 0.907937 },
	{ .red = 0.999023, .green = 0.849084, .blue = 0.887179 },
	{ .red = 0.052259, .green = 0.890598, .blue = 0.966056 },
	{ .red = 0.062515, .green = 0.892552, .blue = 0.968987 },
	{ .red = 0.096703, .green = 0.899878, .blue = 0.979487 },
	{ .red = 0.254212, .green = 0.917705, .blue = 0.998535 },
	{ .red = 0.456410, .green = 0.928205, .blue = 0.999512 },
	{ .red = 0.599267, .green = 0.936752, .blue = 0.998779 },
	{ .red = 0.709158, .green = 0.944811, .blue = 0.999023 },
	{ .red = 0.796581, .green = 0.950916, .blue = 0.999023 },
	{ .red = 0.867643, .green = 0.955800, .blue = 0.998535 },
	{ .red = 0.927961, .green = 0.961661, .blue = 0.999512 },
	{ .red = 0.969475, .green = 0.965324, .blue = 0.999023 },
	{ .red = 0.999756, .green = 0.959463, .blue = 0.995849 },
	{ .red = 0.998779, .green = 0.951893, .blue = 0.973626 },
	{ .red = 0.998535, .green = 0.937973, .blue = 0.957021 },
	{ .red = 0.998779, .green = 0.921856, .blue = 0.940171 },
	{ .red = 0.999023, .green = 0.904274, .blue = 0.922344 },
	{ .red = 0.998779, .green = 0.885470, .blue = 0.903297 },
	{ .red = 0.078388, .green = 0.975580, .blue = 0.975580 },
	{ .red = 0.079853, .green = 0.977534, .blue = 0.977534 },
	{ .red = 0.086691, .green = 0.983883, .blue = 0.984615 },
	{ .red = 0.136264, .green = 0.997314, .blue = 0.998535 },
	{ .red = 0.424176, .green = 0.997314, .blue = 0.997314 },
	{ .red = 0.578999, .green = 0.997802, .blue = 0.997314 },
	{ .red = 0.688645, .green = 0.999512, .blue = 0.999023 },
	{ .red = 0.779243, .green = 0.997802, .blue = 0.997558 },
	{ .red = 0.844444, .green = 0.998291, .blue = 0.998291 },
	{ .red = 0.894261, .green = 0.998779, .blue = 0.999267 },
	{ .red = 0.934799, .green = 0.998779, .blue = 0.999267 },
	{ .red = 0.990476, .green = 0.989255, .blue = 0.989499 },
	{ .red = 0.999023, .green = 0.975092, .blue = 0.976068 },
	{ .red = 0.998779, .green = 0.961172, .blue = 0.962393 },
	{ .red = 0.999512, .green = 0.945788, .blue = 0.947497 },
	{ .red = 0.999756, .green = 0.929670, .blue = 0.931136 },
	{ .red = 0.999756, .green = 0.912576, .blue = 0.914042 },
	{ .red = 0.119658, .green = 0.980464, .blue = 0.916484 },
	{ .red = 0.123565, .green = 0.981929, .blue = 0.917460 },
	{ .red = 0.137241, .green = 0.987057, .blue = 0.921368 },
	{ .red = 0.252259, .green = 0.999267, .blue = 0.933089 },
	{ .red = 0.443468, .green = 0.998535, .blue = 0.938217 },
	{ .red = 0.577045, .green = 0.998291, .blue = 0.944078 },
	{ .red = 0.680830, .green = 0.998046, .blue = 0.950183 },
	{ .red = 0.760195, .green = 0.999023, .blue = 0.956044 },
	{ .red = 0.823443, .green = 0.999512, .blue = 0.960440 },
	{ .red = 0.874481, .green = 0.999756, .blue = 0.963126 },
	{ .red = 0.917216, .green = 0.999756, .blue = 0.963858 },
	{ .red = 0.957753, .green = 0.999267, .blue = 0.962149 },
	{ .red = 0.999023, .green = 0.996337, .blue = 0.932601 },
	{ .red = 0.998779, .green = 0.972405, .blue = 0.952137 },
	{ .red = 0.999023, .green = 0.963370, .blue = 0.949206 },
	{ .red = 0.998535, .green = 0.948474, .blue = 0.935287 },
	{ .red = 0.999267, .green = 0.933089, .blue = 0.919658 },
	{ .red = 0.115018, .green = 0.986325, .blue = 0.865934 },
	{ .red = 0.118193, .green = 0.987546, .blue = 0.866667 },
	{ .red = 0.129670, .green = 0.992186, .blue = 0.869109 },
	{ .red = 0.292796, .green = 0.999756, .blue = 0.880098 },
	{ .red = 0.442247, .green = 0.999023, .blue = 0.888645 },
	{ .red = 0.560684, .green = 0.997802, .blue = 0.898168 },
	{ .red = 0.654701, .green = 0.998291, .blue = 0.908425 },
	{ .red = 0.731136, .green = 0.999267, .blue = 0.917705 },
	{ .red = 0.796337, .green = 0.998779, .blue = 0.925519 },
	{ .red = 0.849817, .green = 0.998779, .blue = 0.931868 },
	{ .red = 0.894750, .green = 0.999023, .blue = 0.936752 },
	{ .red = 0.936264, .green = 0.998535, .blue = 0.941880 },
	{ .red = 0.966300, .green = 0.999023, .blue = 0.936996 },
	{ .red = 0.998535, .green = 0.995849, .blue = 0.893040 },
	{ .red = 0.998779, .green = 0.966545, .blue = 0.913797 },
	{ .red = 0.999512, .green = 0.952625, .blue = 0.913553 },
	{ .red = 0.998291, .green = 0.942125, .blue = 0.909890 },
	{ .red = 0.126007, .green = 0.988767, .blue = 0.819292 },
	{ .red = 0.129670, .green = 0.989744, .blue = 0.819780 },
	{ .red = 0.155556, .green = 0.998291, .blue = 0.825641 },
	{ .red = 0.311600, .green = 0.999023, .blue = 0.833944 },
	{ .red = 0.434188, .green = 0.998535, .blue = 0.844444 },
	{ .red = 0.538217, .green = 0.998535, .blue = 0.856654 },
	{ .red = 0.625641, .green = 0.999512, .blue = 0.869353 },
	{ .red = 0.703053, .green = 0.998779, .blue = 0.881074 },
	{ .red = 0.765812, .green = 0.999512, .blue = 0.891819 },
	{ .red = 0.822466, .green = 0.998291, .blue = 0.901343 },
	{ .red = 0.869597, .green = 0.998535, .blue = 0.909890 },
	{ .red = 0.910379, .green = 0.999512, .blue = 0.917216 },
	{ .red = 0.949695, .green = 0.999023, .blue = 0.928205 },
	{ .red = 0.962882, .green = 0.998291, .blue = 0.898413 },
	{ .red = 0.998535, .green = 0.996093, .blue = 0.849817 },
	{ .red = 0.999267, .green = 0.963126, .blue = 0.871551 },
	{ .red = 0.998779, .green = 0.945055, .blue = 0.875458 },
	{ .red = 0.133333, .green = 0.990232, .blue = 0.777289 },
	{ .red = 0.136508, .green = 0.990965, .blue = 0.777534 },
	{ .red = 0.196825, .green = 0.998535, .blue = 0.784860 },
	{ .red = 0.313065, .green = 0.999267, .blue = 0.793407 },
	{ .red = 0.421001, .green = 0.998535, .blue = 0.804640 },
	{ .red = 0.514286, .green = 0.999023, .blue = 0.817827 },
	{ .red = 0.598291, .green = 0.999267, .blue = 0.831746 },
	{ .red = 0.673260, .green = 0.998535, .blue = 0.845421 },
	{ .red = 0.736752, .green = 0.999023, .blue = 0.858364 },
	{ .red = 0.791941, .green = 0.999756, .blue = 0.870085 },
	{ .red = 0.842247, .green = 0.998535, .blue = 0.881563 },
	{ .red = 0.885470, .green = 0.998779, .blue = 0.892308 },
	{ .red = 0.925519, .green = 0.998046, .blue = 0.905739 },
	{ .red = 0.941636, .green = 0.999267, .blue = 0.889866 },
	{ .red = 0.960928, .green = 0.998779, .blue = 0.858120 },
	{ .red = 0.998046, .green = 0.996093, .blue = 0.808547 },
	{ .red = 0.998535, .green = 0.960928, .blue = 0.830281 },
	{ .red = 0.089377, .green = 0.996825, .blue = 0.741148 },
	{ .red = 0.127473, .green = 0.997558, .blue = 0.742857 },
	{ .red = 0.214652, .green = 0.998535, .blue = 0.747985 },
	{ .red = 0.312332, .green = 0.998535, .blue = 0.756288 },
	{ .red = 0.404151, .green = 0.999267, .blue = 0.767766 },
	{ .red = 0.491331, .green = 0.999512, .blue = 0.781197 },
	{ .red = 0.572405, .green = 0.998779, .blue = 0.795849 },
	{ .red = 0.643223, .green = 0.999512, .blue = 0.810989 },
	{ .red = 0.707937, .green = 0.998779, .blue = 0.825641 },
	{ .red = 0.764347, .green = 0.998779, .blue = 0.839560 },
	{ .red = 0.813919, .green = 0.999023, .blue = 0.852503 },
	{ .red = 0.858852, .green = 0.998535, .blue = 0.865690 },
	{ .red = 0.898413, .green = 0.999023, .blue = 0.878388 },
	{ .red = 0.925519, .green = 0.999023, .blue = 0.880830 },
	{ .red = 0.934799, .green = 0.998291, .blue = 0.849328 },
	{ .red = 0.960195, .green = 0.999023, .blue = 0.820513 },
	{ .red = 0.999023, .green = 0.997314, .blue = 0.765812 },
	{ .red = 0.048352, .green = 0.112576, .blue = 0.999756 },
	{ .red = 0.094505, .green = 0.028571, .blue = 0.988278 },
	{ .red = 0.178266, .green = 0.020269, .blue = 0.953358 },
	{ .red = 0.283028, .green = 0.049328, .blue = 0.998535 },
	{ .red = 0.379976, .green = 0.090110, .blue = 0.998046 },
	{ .red = 0.475458, .green = 0.106227, .blue = 0.998779 },
	{ .red = 0.565568, .green = 0.104518, .blue = 0.998291 },
	{ .red = 0.650061, .green = 0.092552, .blue = 0.998535 },
	{ .red = 0.724786, .green = 0.070085, .blue = 0.993407 },
	{ .red = 0.787546, .green = 0.022711, .blue = 0.980708 },
	{ .red = 0.818315, .green = 0.025885, .blue = 0.937241 },
	{ .red = 0.889377, .green = 0.023199, .blue = 0.947497 },
	{ .red = 0.952625, .green = 0.016606, .blue = 0.952381 },
	{ .red = 0.969475, .green = 0.023932, .blue = 0.895726 },
	{ .red = 0.978510, .green = 0.030525, .blue = 0.841270 },
	{ .red = 0.988767, .green = 0.025641, .blue = 0.795604 },
	{ .red = 0.983150, .green = 0.047619, .blue = 0.744078 },
	{ .red = 0.054457, .green = 0.128938, .blue = 0.999756 },
	{ .red = 0.097436, .green = 0.063492, .blue = 0.998535 },
	{ .red = 0.184615, .green = 0.026129, .blue = 0.989255 },
	{ .red = 0.282295, .green = 0.079121, .blue = 0.999267 },
	{ .red = 0.378510, .green = 0.107448, .blue = 0.998535 },
	{ .red = 0.473504, .green = 0.121612, .blue = 0.998535 },
	{ .red = 0.564103, .green = 0.120879, .blue = 0.998779 },
	{ .red = 0.649084, .green = 0.110623, .blue = 0.999512 },
	{ .red = 0.726740, .green = 0.091575, .blue = 0.998291 },
	{ .red = 0.793162, .green = 0.060562, .blue = 0.989744 },
	{ .red = 0.842491, .green = 0.019780, .blue = 0.967521 },
	{ .red = 0.909402, .green = 0.025397, .blue = 0.970696 },
	{ .red = 0.970696, .green = 0.023687, .blue = 0.971429 },
	{ .red = 0.988523, .green = 0.022955, .blue = 0.914042 },
	{ .red = 0.985592, .green = 0.056654, .blue = 0.847375 },
	{ .red = 0.998535, .green = 0.090842, .blue = 0.803663 },
	{ .red = 0.999023, .green = 0.114774, .blue = 0.757021 },
	{ .red = 0.068376, .green = 0.177289, .blue = 0.998779 },
	{ .red = 0.103541, .green = 0.143834, .blue = 0.998779 },
	{ .red = 0.188767, .green = 0.142125, .blue = 0.999023 },
	{ .red = 0.283761, .green = 0.167277, .blue = 0.999023 },
	{ .red = 0.380952, .green = 0.189988, .blue = 0.999267 },
	{ .red = 0.476923, .green = 0.206349, .blue = 0.998535 },
	{ .red = 0.569475, .green = 0.216117, .blue = 0.998779 },
	{ .red = 0.655433, .green = 0.219292, .blue = 0.998291 },
	{ .red = 0.735775, .green = 0.218071, .blue = 0.998779 },
	{ .red = 0.809524, .green = 0.213675, .blue = 0.999023 },
	{ .red = 0.877900, .green = 0.207326, .blue = 0.998779 },
	{ .red = 0.943101, .green = 0.206838, .blue = 0.999023 },
	{ .red = 0.997070, .green = 0.206593, .blue = 0.991697 },
	{ .red = 0.999512, .green = 0.219048, .blue = 0.919902 },
	{ .red = 0.999267, .green = 0.225885, .blue = 0.857875 },
	{ .red = 0.999512, .green = 0.229304, .blue = 0.806349 },
	{ .red = 0.999512, .green = 0.230281, .blue = 0.761661 },
	{ .red = 0.080342, .green = 0.250061, .blue = 0.998779 },
	{ .red = 0.163370, .green = 0.311111, .blue = 0.998779 },
	{ .red = 0.224176, .green = 0.303785, .blue = 0.998291 },
	{ .red = 0.312332, .green = 0.316728, .blue = 0.998535 },
	{ .red = 0.406349, .green = 0.331136, .blue = 0.998046 },
	{ .red = 0.501587, .green = 0.344322, .blue = 0.998779 },
	{ .red = 0.593407, .green = 0.354579, .blue = 0.999023 },
	{ .red = 0.679609, .green = 0.361661, .blue = 0.998779 },
	{ .red = 0.759463, .green = 0.365568, .blue = 0.999267 },
	{ .red = 0.831502, .green = 0.366789, .blue = 0.998535 },
	{ .red = 0.897924, .green = 0.365568, .blue = 0.999023 },
	{ .red = 0.959463, .green = 0.365568, .blue = 0.998535 },
	{ .red = 0.999023, .green = 0.365812, .blue = 0.979976 },
	{ .red = 0.999023, .green = 0.365324, .blue = 0.914286 },
	{ .red = 0.999023, .green = 0.361172, .blue = 0.858608 },
	{ .red = 0.998779, .green = 0.354579, .blue = 0.811722 },
	{ .red = 0.999023, .green = 0.346764, .blue = 0.771429 },
	{ .red = 0.060317, .green = 0.321368, .blue = 0.991941 },
	{ .red = 0.151160, .green = 0.356288, .blue = 0.998535 },
	{ .red = 0.294017, .green = 0.444444, .blue = 0.998779 },
	{ .red = 0.365324, .green = 0.451282, .blue = 0.998779 },
	{ .red = 0.450061, .green = 0.462759, .blue = 0.998779 },
	{ .red = 0.538217, .green = 0.474237, .blue = 0.998291 },
	{ .red = 0.625885, .green = 0.484737, .blue = 0.998535 },
	{ .red = 0.708913, .green = 0.493040, .blue = 0.999512 },
	{ .red = 0.784860, .green = 0.498657, .blue = 0.998779 },
	{ .red = 0.854457, .green = 0.502076, .blue = 0.999512 },
	{ .red = 0.916239, .green = 0.502564, .blue = 0.998291 },
	{ .red = 0.973382, .green = 0.501587, .blue = 0.998291 },
	{ .red = 0.999756, .green = 0.501343, .blue = 0.970696 },
	{ .red = 0.998535, .green = 0.496459, .blue = 0.914042 },
	{ .red = 0.998291, .green = 0.486691, .blue = 0.865446 },
	{ .red = 0.999023, .green = 0.474481, .blue = 0.824908 },
	{ .red = 0.999267, .green = 0.460806, .blue = 0.788767 },
	{ .red = 0.011233, .green = 0.386569, .blue = 0.918681 },
	{ .red = 0.100611, .green = 0.415629, .blue = 0.998779 },
	{ .red = 0.306716, .green = 0.509158, .blue = 0.999512 },
	{ .red = 0.441514, .green = 0.577045, .blue = 0.998535 },
	{ .red = 0.510867, .green = 0.586081, .blue = 0.999023 },
	{ .red = 0.586569, .green = 0.595116, .blue = 0.998046 },
	{ .red = 0.664225, .green = 0.604151, .blue = 0.998046 },
	{ .red = 0.739683, .green = 0.612210, .blue = 0.999023 },
	{ .red = 0.809524, .green = 0.618071, .blue = 0.998779 },
	{ .red = 0.872772, .green = 0.621734, .blue = 0.998535 },
	{ .red = 0.929670, .green = 0.622222, .blue = 0.998291 },
	{ .red = 0.981685, .green = 0.620024, .blue = 0.998535 },
	{ .red = 0.999756, .green = 0.619536, .blue = 0.968010 },
	{ .red = 0.998291, .green = 0.613431, .blue = 0.920635 },
	{ .red = 0.998779, .green = 0.600733, .blue = 0.879853 },
	{ .red = 0.999023, .green = 0.585104, .blue = 0.844444 },
	{ .red = 0.999023, .green = 0.567766, .blue = 0.812210 },
	{ .red = 0.017827, .green = 0.481319, .blue = 0.926007 },
	{ .red = 0.031746, .green = 0.494750, .blue = 0.975580 },
	{ .red = 0.256166, .green = 0.548474, .blue = 0.998046 },
	{ .red = 0.450305, .green = 0.633455, .blue = 0.998779 },
	{ .red = 0.583150, .green = 0.694750, .blue = 0.998779 },
	{ .red = 0.643223, .green = 0.701587, .blue = 0.998291 },
	{ .red = 0.707204, .green = 0.708669, .blue = 0.998291 },
	{ .red = 0.771429, .green = 0.715018, .blue = 0.999512 },
	{ .red = 0.831990, .green = 0.719902, .blue = 0.998779 },
	{ .red = 0.887668, .green = 0.722589, .blue = 0.998535 },
	{ .red = 0.938950, .green = 0.722833, .blue = 0.999267 },
	{ .red = 0.984615, .green = 0.719658, .blue = 0.998779 },
	{ .red = 0.999023, .green = 0.718681, .blue = 0.970696 },
	{ .red = 0.999023, .green = 0.712332, .blue = 0.933089 },
	{ .red = 0.998535, .green = 0.698413, .blue = 0.898168 },
	{ .red = 0.999267, .green = 0.681319, .blue = 0.867888 },
	{ .red = 0.999512, .green = 0.661783, .blue = 0.839316 },
	{ .red = 0.017827, .green = 0.573626, .blue = 0.937729 },
	{ .red = 0.014164, .green = 0.583639, .blue = 0.966056 },
	{ .red = 0.222222, .green = 0.618315, .blue = 0.998291 },
	{ .red = 0.402686, .green = 0.668864, .blue = 0.998046 },
	{ .red = 0.570452, .green = 0.731868, .blue = 0.998535 },
	{ .red = 0.702320, .green = 0.789499, .blue = 0.999512 },
	{ .red = 0.751404, .green = 0.794139, .blue = 0.998535 },
	{ .red = 0.802442, .green = 0.798779, .blue = 0.999023 },
	{ .red = 0.852503, .green = 0.802198, .blue = 0.998535 },
	{ .red = 0.900122, .green = 0.804151, .blue = 0.998535 },
	{ .red = 0.944078, .green = 0.803907, .blue = 0.999023 },
	{ .red = 0.983883, .green = 0.800244, .blue = 0.998779 },
	{ .red = 0.999512, .green = 0.798046, .blue = 0.977534 },
	{ .red = 0.998779, .green = 0.792186, .blue = 0.946032 },
	{ .red = 0.999267, .green = 0.777778, .blue = 0.917216 },
	{ .red = 0.999023, .green = 0.760440, .blue = 0.890842 },
	{ .red = 0.999267, .green = 0.740659, .blue = 0.865446 },
	{ .red = 0.021734, .green = 0.661294, .blue = 0.947741 },
	{ .red = 0.030525, .green = 0.667643, .blue = 0.962637 },
	{ .red = 0.178755, .green = 0.693773, .blue = 0.999512 },
	{ .red = 0.374359, .green = 0.728694, .blue = 0.999512 },
	{ .red = 0.529915, .green = 0.768498, .blue = 0.998535 },
	{ .red = 0.666911, .green = 0.810745, .blue = 0.999512 },
	{ .red = 0.794872, .green = 0.861538, .blue = 0.999023 },
	{ .red = 0.832967, .green = 0.864225, .blue = 0.999023 },
	{ .red = 0.872527, .green = 0.866667, .blue = 0.999023 },
	{ .red = 0.911355, .green = 0.867888, .blue = 0.998779 },
	{ .red = 0.948230, .green = 0.866911, .blue = 0.999267 },
	{ .red = 0.981685, .green = 0.863492, .blue = 0.998046 },
	{ .red = 0.999756, .green = 0.860073, .blue = 0.984127 },
	{ .red = 1.000000, .green = 0.853968, .blue = 0.958486 },
	{ .red = 0.998779, .green = 0.840293, .blue = 0.933333 },
	{ .red = 0.998779, .green = 0.822955, .blue = 0.910867 },
	{ .red = 0.999023, .green = 0.803419, .blue = 0.888645 },
	{ .red = 0.036142, .green = 0.747009, .blue = 0.959463 },
	{ .red = 0.045665, .green = 0.750916, .blue = 0.967033 },
	{ .red = 0.113309, .green = 0.769719, .blue = 0.999023 },
	{ .red = 0.348962, .green = 0.793407, .blue = 0.999023 },
	{ .red = 0.505006, .green = 0.820269, .blue = 0.998535 },
	{ .red = 0.634188, .green = 0.846886, .blue = 0.998291 },
	{ .red = 0.743101, .green = 0.872527, .blue = 0.998535 },
	{ .red = 0.842979, .green = 0.902808, .blue = 0.999512 },
	{ .red = 0.891575, .green = 0.915263, .blue = 0.998291 },
	{ .red = 0.921856, .green = 0.915995, .blue = 0.999267 },
	{ .red = 0.951648, .green = 0.915263, .blue = 0.998291 },
	{ .red = 0.980708, .green = 0.912088, .blue = 0.998535 },
	{ .red = 0.999267, .green = 0.907937, .blue = 0.989255 },
	{ .red = 0.999023, .green = 0.901587, .blue = 0.967521 },
	{ .red = 0.998779, .green = 0.887912, .blue = 0.947253 },
	{ .red = 0.999512, .green = 0.871306, .blue = 0.927961 },
	{ .red = 0.999512, .green = 0.852503, .blue = 0.907937 },
	{ .red = 0.032234, .green = 0.830281, .blue = 0.970940 },
	{ .red = 0.045910, .green = 0.832723, .blue = 0.975092 },
	{ .red = 0.090110, .green = 0.840537, .blue = 0.988767 },
	{ .red = 0.325519, .green = 0.860317, .blue = 0.998291 },
	{ .red = 0.486447, .green = 0.877900, .blue = 0.999023 },
	{ .red = 0.613919, .green = 0.894505, .blue = 0.998779 },
	{ .red = 0.717949, .green = 0.908913, .blue = 0.998046 },
	{ .red = 0.802198, .green = 0.922344, .blue = 0.998779 },
	{ .red = 0.873016, .green = 0.935287, .blue = 0.999512 },
	{ .red = 0.932601, .green = 0.951648, .blue = 0.999023 },
	{ .red = 0.956044, .green = 0.951404, .blue = 0.999023 },
	{ .red = 0.980220, .green = 0.948962, .blue = 0.998779 },
	{ .red = 0.998779, .green = 0.944567, .blue = 0.992918 },
	{ .red = 0.998779, .green = 0.937485, .blue = 0.974603 },
	{ .red = 0.998535, .green = 0.924054, .blue = 0.957753 },
	{ .red = 0.998779, .green = 0.907937, .blue = 0.940904 },
	{ .red = 0.998535, .green = 0.890110, .blue = 0.922833 },
	{ .red = 0.092552, .green = 0.905983, .blue = 0.975092 },
	{ .red = 0.097924, .green = 0.907448, .blue = 0.977289 },
	{ .red = 0.117949, .green = 0.913309, .blue = 0.985592 },
	{ .red = 0.298901, .green = 0.929426, .blue = 0.999267 },
	{ .red = 0.473993, .green = 0.937973, .blue = 0.998535 },
	{ .red = 0.604151, .green = 0.945788, .blue = 0.998046 },
	{ .red = 0.704762, .green = 0.953602, .blue = 0.999267 },
	{ .red = 0.786813, .green = 0.958730, .blue = 0.998291 },
	{ .red = 0.850794, .green = 0.963614, .blue = 0.999023 },
	{ .red = 0.902808, .green = 0.968010, .blue = 0.999756 },
	{ .red = 0.949206, .green = 0.972894, .blue = 0.999756 },
	{ .red = 0.979731, .green = 0.976557, .blue = 0.999023 },
	{ .red = 0.999267, .green = 0.972405, .blue = 0.996337 },
	{ .red = 0.998535, .green = 0.964103, .blue = 0.979976 },
	{ .red = 0.998535, .green = 0.950427, .blue = 0.965568 },
	{ .red = 0.998535, .green = 0.935043, .blue = 0.950183 },
	{ .red = 0.998535, .green = 0.918437, .blue = 0.933822 },
	{ .red = 0.084982, .green = 0.983883, .blue = 0.983883 },
	{ .red = 0.086203, .green = 0.985592, .blue = 0.985592 },
	{ .red = 0.091575, .green = 0.990965, .blue = 0.991453 },
	{ .red = 0.266178, .green = 0.998291, .blue = 0.998535 },
	{ .red = 0.469353, .green = 0.998046, .blue = 0.997314 },
	{ .red = 0.605861, .green = 0.998535, .blue = 0.997070 },
	{ .red = 0.707204, .green = 0.999267, .blue = 0.998046 },
	{ .red = 0.789255, .green = 0.998046, .blue = 0.997070 },
	{ .red = 0.849084, .green = 0.998535, .blue = 0.998046 },
	{ .red = 0.895482, .green = 0.999023, .blue = 0.998779 },
	{ .red = 0.933089, .green = 0.998779, .blue = 0.999023 },
	{ .red = 0.963126, .green = 0.998535, .blue = 0.999023 },
	{ .red = 0.996337, .green = 0.994872, .blue = 0.995360 },
	{ .red = 0.999512, .green = 0.981929, .blue = 0.982906 },
	{ .red = 0.998291, .green = 0.968742, .blue = 0.969963 },
	{ .red = 0.999267, .green = 0.954090, .blue = 0.955556 },
	{ .red = 0.999756, .green = 0.938950, .blue = 0.940415 },
	{ .red = 0.130891, .green = 0.985348, .blue = 0.926252 },
	{ .red = 0.133578, .green = 0.986569, .blue = 0.927228 },
	{ .red = 0.143101, .green = 0.990965, .blue = 0.930647 },
	{ .red = 0.309402, .green = 0.999512, .blue = 0.940659 },
	{ .red = 0.464469, .green = 0.999267, .blue = 0.945543 },
	{ .red = 0.584615, .green = 0.999267, .blue = 0.951160 },
	{ .red = 0.679853, .green = 0.999267, .blue = 0.956777 },
	{ .red = 0.757753, .green = 0.998779, .blue = 0.961416 },
	{ .red = 0.817094, .green = 0.999267, .blue = 0.966300 },
	{ .red = 0.865446, .green = 0.999512, .blue = 0.969475 },
	{ .red = 0.906471, .green = 0.998535, .blue = 0.971429 },
	{ .red = 0.936996, .green = 0.999756, .blue = 0.972405 },
	{ .red = 0.968987, .green = 0.999512, .blue = 0.971917 },
	{ .red = 0.998779, .green = 0.996581, .blue = 0.948718 },
	{ .red = 0.999023, .green = 0.976801, .blue = 0.959951 },
	{ .red = 0.999023, .green = 0.968254, .blue = 0.956288 },
	{ .red = 0.998779, .green = 0.954579, .blue = 0.943101 },
	{ .red = 0.093773, .green = 0.992430, .blue = 0.879609 },
	{ .red = 0.096215, .green = 0.993407, .blue = 0.880342 },
	{ .red = 0.155800, .green = 0.999023, .blue = 0.885226 },
	{ .red = 0.321123, .green = 0.999756, .blue = 0.891819 },
	{ .red = 0.449573, .green = 0.999267, .blue = 0.899145 },
	{ .red = 0.558486, .green = 0.997802, .blue = 0.907204 },
	{ .red = 0.646398, .green = 0.998535, .blue = 0.916484 },
	{ .red = 0.721123, .green = 0.998291, .blue = 0.925031 },
	{ .red = 0.780952, .green = 0.999267, .blue = 0.932601 },
	{ .red = 0.832234, .green = 0.999023, .blue = 0.938462 },
	{ .red = 0.874481, .green = 0.999512, .blue = 0.943346 },
	{ .red = 0.912088, .green = 0.999267, .blue = 0.947253 },
	{ .red = 0.947253, .green = 0.998535, .blue = 0.951648 },
	{ .red = 0.972161, .green = 0.999267, .blue = 0.947497 },
	{ .red = 0.998291, .green = 0.995849, .blue = 0.907204 },
	{ .red = 0.998779, .green = 0.969963, .blue = 0.923565 },
	{ .red = 0.999756, .green = 0.957265, .blue = 0.922344 },
	{ .red = 0.084737, .green = 0.995360, .blue = 0.835653 },
	{ .red = 0.088156, .green = 0.996337, .blue = 0.835897 },
	{ .red = 0.200977, .green = 0.998779, .blue = 0.840781 },
	{ .red = 0.323321, .green = 0.999267, .blue = 0.847863 },
	{ .red = 0.432234, .green = 0.999023, .blue = 0.856899 },
	{ .red = 0.527717, .green = 0.999267, .blue = 0.867399 },
	{ .red = 0.612698, .green = 0.998779, .blue = 0.878144 },
	{ .red = 0.683761, .green = 0.999512, .blue = 0.889133 },
	{ .red = 0.747497, .green = 0.998779, .blue = 0.898657 },
	{ .red = 0.799756, .green = 0.999267, .blue = 0.907204 },
	{ .red = 0.846398, .green = 0.998535, .blue = 0.914774 },
	{ .red = 0.886203, .green = 0.998779, .blue = 0.921368 },
	{ .red = 0.923077, .green = 0.998046, .blue = 0.928938 },
	{ .red = 0.956288, .green = 0.998779, .blue = 0.937729 },
	{ .red = 0.966789, .green = 0.998535, .blue = 0.908913 },
	{ .red = 0.998779, .green = 0.996337, .blue = 0.863492 },
	{ .red = 0.999512, .green = 0.966300, .blue = 0.883028 },
	{ .red = 0.111844, .green = 0.994872, .blue = 0.794383 },
	{ .red = 0.119170, .green = 0.999023, .blue = 0.797070 },
	{ .red = 0.215873, .green = 0.999512, .blue = 0.801465 },
	{ .red = 0.320147, .green = 0.998535, .blue = 0.808303 },
	{ .red = 0.413431, .green = 0.999267, .blue = 0.818071 },
	{ .red = 0.503541, .green = 0.998291, .blue = 0.829060 },
	{ .red = 0.581441, .green = 0.999023, .blue = 0.841514 },
	{ .red = 0.654212, .green = 0.998046, .blue = 0.853724 },
	{ .red = 0.714774, .green = 0.999023, .blue = 0.865201 },
	{ .red = 0.768254, .green = 0.999512, .blue = 0.875946 },
	{ .red = 0.815873, .green = 0.999512, .blue = 0.885470 },
	{ .red = 0.859096, .green = 0.998779, .blue = 0.894750 },
	{ .red = 0.896947, .green = 0.999023, .blue = 0.903541 },
	{ .red = 0.932357, .green = 0.998535, .blue = 0.914530 },
	{ .red = 0.947253, .green = 0.999023, .blue = 0.900855 },
	{ .red = 0.964347, .green = 0.999023, .blue = 0.870085 },
	{ .red = 0.998535, .green = 0.996337, .blue = 0.822955 },
	{ .red = 0.057631, .green = 0.137973, .blue = 0.999756 },
	{ .red = 0.093773, .green = 0.086203, .blue = 0.999023 },
	{ .red = 0.171429, .green = 0.036386, .blue = 0.984127 },
	{ .red = 0.262515, .green = 0.076190, .blue = 0.996825 },
	{ .red = 0.352625, .green = 0.102076, .blue = 0.998779 },
	{ .red = 0.441270, .green = 0.116728, .blue = 0.998535 },
	{ .red = 0.526740, .green = 0.119902, .blue = 0.998535 },
	{ .red = 0.607082, .green = 0.114530, .blue = 0.998291 },
	{ .red = 0.683272, .green = 0.100122, .blue = 0.999512 },
	{ .red = 0.752869, .green = 0.071551, .blue = 0.999267 },
	{ .red = 0.803907, .green = 0.040781, .blue = 0.980220 },
	{ .red = 0.847131, .green = 0.021001, .blue = 0.958730 },
	{ .red = 0.910379, .green = 0.020757, .blue = 0.964835 },
	{ .red = 0.965812, .green = 0.021001, .blue = 0.965568 },
	{ .red = 0.981441, .green = 0.021001, .blue = 0.912088 },
	{ .red = 0.979976, .green = 0.045421, .blue = 0.851770 },
	{ .red = 0.994383, .green = 0.030281, .blue = 0.812454 },
	{ .red = 0.062271, .green = 0.148718, .blue = 0.999756 },
	{ .red = 0.095726, .green = 0.103297, .blue = 0.999023 },
	{ .red = 0.173871, .green = 0.056410, .blue = 0.998535 },
	{ .red = 0.262271, .green = 0.092308, .blue = 0.999023 },
	{ .red = 0.351648, .green = 0.114530, .blue = 0.999267 },
	{ .red = 0.439805, .green = 0.127961, .blue = 0.998535 },
	{ .red = 0.525031, .green = 0.130891, .blue = 0.998535 },
	{ .red = 0.605372, .green = 0.126007, .blue = 0.998291 },
	{ .red = 0.681563, .green = 0.113553, .blue = 0.999267 },
	{ .red = 0.751893, .green = 0.090598, .blue = 0.999512 },
	{ .red = 0.812943, .green = 0.060317, .blue = 0.993162 },
	{ .red = 0.863248, .green = 0.031013, .blue = 0.978999 },
	{ .red = 0.926984, .green = 0.025153, .blue = 0.984127 },
	{ .red = 0.981197, .green = 0.026862, .blue = 0.981929 },
	{ .red = 0.987790, .green = 0.046154, .blue = 0.918437 },
	{ .red = 0.999023, .green = 0.088645, .blue = 0.868132 },
	{ .red = 0.998779, .green = 0.115995, .blue = 0.816117 },
	{ .red = 0.077656, .green = 0.189744, .blue = 0.998535 },
	{ .red = 0.107204, .green = 0.171184, .blue = 0.999267 },
	{ .red = 0.180220, .green = 0.159707, .blue = 0.999023 },
	{ .red = 0.267155, .green = 0.178999, .blue = 0.999023 },
	{ .red = 0.356777, .green = 0.198046, .blue = 0.999023 },
	{ .red = 0.446154, .green = 0.212943, .blue = 0.998779 },
	{ .red = 0.532845, .green = 0.222711, .blue = 0.998535 },
	{ .red = 0.615385, .green = 0.227595, .blue = 0.998779 },
	{ .red = 0.691819, .green = 0.227595, .blue = 0.998779 },
	{ .red = 0.763614, .green = 0.225153, .blue = 0.999267 },
	{ .red = 0.829548, .green = 0.220757, .blue = 0.999023 },
	{ .red = 0.891087, .green = 0.215140, .blue = 0.998779 },
	{ .red = 0.949939, .green = 0.214896, .blue = 0.999023 },
	{ .red = 0.997558, .green = 0.214652, .blue = 0.990720 },
	{ .red = 0.999512, .green = 0.224664, .blue = 0.924542 },
	{ .red = 0.999267, .green = 0.229792, .blue = 0.866667 },
	{ .red = 0.999267, .green = 0.231990, .blue = 0.817827 },
	{ .red = 0.112821, .green = 0.277411, .blue = 0.998535 },
	{ .red = 0.168742, .green = 0.317460, .blue = 0.998779 },
	{ .red = 0.218315, .green = 0.305739, .blue = 0.998291 },
	{ .red = 0.297680, .green = 0.316239, .blue = 0.998535 },
	{ .red = 0.384371, .green = 0.329182, .blue = 0.999512 },
	{ .red = 0.471795, .green = 0.341148, .blue = 0.998291 },
	{ .red = 0.558242, .green = 0.351404, .blue = 0.998535 },
	{ .red = 0.640293, .green = 0.358242, .blue = 0.999023 },
	{ .red = 0.716972, .green = 0.363126, .blue = 0.999512 },
	{ .red = 0.787302, .green = 0.365324, .blue = 0.999512 },
	{ .red = 0.851282, .green = 0.365079, .blue = 0.999267 },
	{ .red = 0.910623, .green = 0.362637, .blue = 0.999512 },
	{ .red = 0.965568, .green = 0.362393, .blue = 0.998535 },
	{ .red = 0.999023, .green = 0.362149, .blue = 0.978999 },
	{ .red = 0.999023, .green = 0.360440, .blue = 0.918681 },
	{ .red = 0.999267, .green = 0.355067, .blue = 0.866667 },
	{ .red = 0.998779, .green = 0.347985, .blue = 0.821978 },
	{ .red = 0.076435, .green = 0.305250, .blue = 0.997802 },
	{ .red = 0.187546, .green = 0.379731, .blue = 0.998779 },
	{ .red = 0.290354, .green = 0.439316, .blue = 0.998535 },
	{ .red = 0.353358, .green = 0.444689, .blue = 0.998779 },
	{ .red = 0.430037, .green = 0.454701, .blue = 0.998535 },
	{ .red = 0.511844, .green = 0.465446, .blue = 0.999023 },
	{ .red = 0.593407, .green = 0.474969, .blue = 0.999023 },
	{ .red = 0.671795, .green = 0.483272, .blue = 0.998535 },
	{ .red = 0.745055, .green = 0.489377, .blue = 0.998779 },
	{ .red = 0.812210, .green = 0.493529, .blue = 0.998535 },
	{ .red = 0.873748, .green = 0.495238, .blue = 0.999512 },
	{ .red = 0.928205, .green = 0.493773, .blue = 0.998535 },
	{ .red = 0.979243, .green = 0.492308, .blue = 0.998291 },
	{ .red = 0.999512, .green = 0.491331, .blue = 0.969719 },
	{ .red = 0.999267, .green = 0.484737, .blue = 0.917705 },
	{ .red = 0.998535, .green = 0.473993, .blue = 0.871551 },
	{ .red = 0.999756, .green = 0.461294, .blue = 0.832967 },
	{ .red = 0.028816, .green = 0.370208, .blue = 0.960195 },
	{ .red = 0.129182, .green = 0.401221, .blue = 0.998779 },
	{ .red = 0.346032, .green = 0.531868, .blue = 0.998779 },
	{ .red = 0.431502, .green = 0.565812, .blue = 0.998291 },
	{ .red = 0.494261, .green = 0.573626, .blue = 0.998046 },
	{ .red = 0.564347, .green = 0.582173, .blue = 0.998779 },
	{ .red = 0.636386, .green = 0.590720, .blue = 0.998779 },
	{ .red = 0.706960, .green = 0.598291, .blue = 0.997802 },
	{ .red = 0.774359, .green = 0.604640, .blue = 0.999023 },
	{ .red = 0.836142, .green = 0.608791, .blue = 0.999512 },
	{ .red = 0.891819, .green = 0.610745, .blue = 0.999756 },
	{ .red = 0.942125, .green = 0.609524, .blue = 0.999267 },
	{ .red = 0.988034, .green = 0.606593, .blue = 0.998779 },
	{ .red = 0.999023, .green = 0.605128, .blue = 0.965812 },
	{ .red = 0.998779, .green = 0.597070, .blue = 0.922833 },
	{ .red = 0.998535, .green = 0.583394, .blue = 0.883272 },
	{ .red = 0.998779, .green = 0.567277, .blue = 0.848840 },
	{ .red = 0.000000, .green = 0.453968, .blue = 0.951160 },
	{ .red = 0.079609, .green = 0.471306, .blue = 0.999267 },
	{ .red = 0.270574, .green = 0.530891, .blue = 0.999023 },
	{ .red = 0.495238, .green = 0.655189, .blue = 0.999023 },
	{ .red = 0.569475, .green = 0.679609, .blue = 0.998291 },
	{ .red = 0.624908, .green = 0.685958, .blue = 0.999023 },
	{ .red = 0.684249, .green = 0.692552, .blue = 0.999023 },
	{ .red = 0.744322, .green = 0.698657, .blue = 0.998779 },
	{ .red = 0.802198, .green = 0.704029, .blue = 0.998779 },
	{ .red = 0.855922, .green = 0.707692, .blue = 0.998291 },
	{ .red = 0.905495, .green = 0.709158, .blue = 0.999023 },
	{ .red = 0.950427, .green = 0.707692, .blue = 0.999512 },
	{ .red = 0.990476, .green = 0.703541, .blue = 0.998046 },
	{ .red = 0.998779, .green = 0.701832, .blue = 0.968254 },
	{ .red = 0.999267, .green = 0.693773, .blue = 0.933333 },
	{ .red = 0.999023, .green = 0.678632, .blue = 0.899389 },
	{ .red = 0.998535, .green = 0.661050, .blue = 0.869109 },
	{ .red = 0.016850, .green = 0.538950, .blue = 0.954823 },
	{ .red = 0.042002, .green = 0.545788, .blue = 0.978755 },
	{ .red = 0.245665, .green = 0.589988, .blue = 0.999267 },
	{ .red = 0.415140, .green = 0.650794, .blue = 0.998779 },
	{ .red = 0.598046, .green = 0.736264, .blue = 0.998291 },
	{ .red = 0.687668, .green = 0.772650, .blue = 0.998291 },
	{ .red = 0.733333, .green = 0.777289, .blue = 0.999267 },
	{ .red = 0.780952, .green = 0.781929, .blue = 0.998535 },
	{ .red = 0.828816, .green = 0.785836, .blue = 0.999023 },
	{ .red = 0.873993, .green = 0.788278, .blue = 0.998779 },
	{ .red = 0.915995, .green = 0.789255, .blue = 0.998535 },
	{ .red = 0.954090, .green = 0.787546, .blue = 0.998046 },
	{ .red = 0.990476, .green = 0.782662, .blue = 0.998779 },
	{ .red = 0.999267, .green = 0.780220, .blue = 0.974359 },
	{ .red = 0.999267, .green = 0.772894, .blue = 0.945543 },
	{ .red = 0.998779, .green = 0.757509, .blue = 0.916484 },
	{ .red = 0.999267, .green = 0.739683, .blue = 0.890354 },
	{ .red = 0.024908, .green = 0.621245, .blue = 0.960928 },
	{ .red = 0.028083, .green = 0.628327, .blue = 0.979243 },
	{ .red = 0.222222, .green = 0.656654, .blue = 0.998535 },
	{ .red = 0.390476, .green = 0.698901, .blue = 0.998291 },
	{ .red = 0.539927, .green = 0.747985, .blue = 0.998535 },
	{ .red = 0.683028, .green = 0.803419, .blue = 0.998535 },
	{ .red = 0.780464, .green = 0.844689, .blue = 0.998535 },
	{ .red = 0.816361, .green = 0.847619, .blue = 0.998291 },
	{ .red = 0.853480, .green = 0.850305, .blue = 0.999267 },
	{ .red = 0.890354, .green = 0.852015, .blue = 0.999023 },
	{ .red = 0.925031, .green = 0.852259, .blue = 0.998291 },
	{ .red = 0.957509, .green = 0.850549, .blue = 0.998291 },
	{ .red = 0.989499, .green = 0.845665, .blue = 0.999756 },
	{ .red = 0.998046, .green = 0.842735, .blue = 0.979731 },
	{ .red = 0.999267, .green = 0.835409, .blue = 0.956777 },
	{ .red = 0.999512, .green = 0.820513, .blue = 0.932601 },
	{ .red = 0.998779, .green = 0.803175, .blue = 0.909646 },
	{ .red = 0.039560, .green = 0.699634, .blue = 0.966300 },
	{ .red = 0.051282, .green = 0.703785, .blue = 0.975336 },
	{ .red = 0.195360, .green = 0.725763, .blue = 0.998535 },
	{ .red = 0.371184, .green = 0.755800, .blue = 0.999512 },
	{ .red = 0.515263, .green = 0.789988, .blue = 0.999267 },
	{ .red = 0.640781, .green = 0.824176, .blue = 0.999267 },
	{ .red = 0.750916, .green = 0.858120, .blue = 0.998535 },
	{ .red = 0.849817, .green = 0.897924, .blue = 0.998046 },
	{ .red = 0.876923, .green = 0.899634, .blue = 0.999023 },
	{ .red = 0.905495, .green = 0.900611, .blue = 0.999267 },
	{ .red = 0.933822, .green = 0.900611, .blue = 0.999512 },
	{ .red = 0.960928, .green = 0.899145, .blue = 0.998779 },
	{ .red = 0.986325, .green = 0.894994, .blue = 0.998291 },
	{ .red = 0.999267, .green = 0.890842, .blue = 0.986569 },
	{ .red = 0.999023, .green = 0.884005, .blue = 0.966300 },
	{ .red = 0.998779, .green = 0.869841, .blue = 0.945543 },
	{ .red = 0.999023, .green = 0.852991, .blue = 0.926007 },
	{ .red = 0.037363, .green = 0.777534, .blue = 0.975580 },
	{ .red = 0.054212, .green = 0.779731, .blue = 0.980220 },
	{ .red = 0.164103, .green = 0.794628, .blue = 0.998535 },
	{ .red = 0.355311, .green = 0.815629, .blue = 0.999512 },
	{ .red = 0.499145, .green = 0.838584, .blue = 0.998535 },
	{ .red = 0.619048, .green = 0.862027, .blue = 0.999023 },
	{ .red = 0.720147, .green = 0.883028, .blue = 0.998291 },
	{ .red = 0.804884, .green = 0.903053, .blue = 0.998779 },
	{ .red = 0.885958, .green = 0.928938, .blue = 0.999512 },
	{ .red = 0.920391, .green = 0.937241, .blue = 0.998535 },
	{ .red = 0.941880, .green = 0.937241, .blue = 0.998779 },
	{ .red = 0.964103, .green = 0.936020, .blue = 0.999023 },
	{ .red = 0.985592, .green = 0.932601, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.928449, .blue = 0.990965 },
	{ .red = 0.999023, .green = 0.921368, .blue = 0.973871 },
	{ .red = 0.998779, .green = 0.907937, .blue = 0.956532 },
	{ .red = 0.999267, .green = 0.891819, .blue = 0.939438 },
	{ .red = 0.062515, .green = 0.850061, .blue = 0.980220 },
	{ .red = 0.069109, .green = 0.852015, .blue = 0.983394 },
	{ .red = 0.122100, .green = 0.863492, .blue = 0.999267 },
	{ .red = 0.343346, .green = 0.876190, .blue = 0.998535 },
	{ .red = 0.488889, .green = 0.891331, .blue = 0.998779 },
	{ .red = 0.606838, .green = 0.906227, .blue = 0.999267 },
	{ .red = 0.704029, .green = 0.918926, .blue = 0.998779 },
	{ .red = 0.783150, .green = 0.930159, .blue = 0.999023 },
	{ .red = 0.848352, .green = 0.940171, .blue = 0.999023 },
	{ .red = 0.903785, .green = 0.950427, .blue = 0.999023 },
	{ .red = 0.950916, .green = 0.964591, .blue = 0.999023 },
	{ .red = 0.967766, .green = 0.963858, .blue = 0.999267 },
	{ .red = 0.985592, .green = 0.961661, .blue = 0.999267 },
	{ .red = 0.999023, .green = 0.957265, .blue = 0.994628 },
	{ .red = 0.999023, .green = 0.949939, .blue = 0.979731 },
	{ .red = 0.999023, .green = 0.936752, .blue = 0.965079 },
	{ .red = 0.999512, .green = 0.921368, .blue = 0.949695 },
	{ .red = 0.090354, .green = 0.919414, .blue = 0.983883 },
	{ .red = 0.094017, .green = 0.920879, .blue = 0.985836 },
	{ .red = 0.107204, .green = 0.926252, .blue = 0.993162 },
	{ .red = 0.335775, .green = 0.937485, .blue = 0.998535 },
	{ .red = 0.486447, .green = 0.945543, .blue = 0.998535 },
	{ .red = 0.604884, .green = 0.953114, .blue = 0.998779 },
	{ .red = 0.699878, .green = 0.959463, .blue = 0.999023 },
	{ .red = 0.776313, .green = 0.964347, .blue = 0.998779 },
	{ .red = 0.836386, .green = 0.968987, .blue = 0.999512 },
	{ .red = 0.886447, .green = 0.971917, .blue = 0.998535 },
	{ .red = 0.926740, .green = 0.975092, .blue = 0.998779 },
	{ .red = 0.962637, .green = 0.979487, .blue = 0.999512 },
	{ .red = 0.986081, .green = 0.983394, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.980220, .blue = 0.996581 },
	{ .red = 0.998535, .green = 0.971673, .blue = 0.983883 },
	{ .red = 0.998535, .green = 0.958486, .blue = 0.970940 },
	{ .red = 0.998779, .green = 0.943834, .blue = 0.957021 },
	{ .red = 0.089133, .green = 0.989499, .blue = 0.989499 },
	{ .red = 0.090110, .green = 0.990720, .blue = 0.990965 },
	{ .red = 0.094261, .green = 0.995360, .blue = 0.995849 },
	{ .red = 0.334310, .green = 0.998779, .blue = 0.998291 },
	{ .red = 0.499389, .green = 0.998779, .blue = 0.997314 },
	{ .red = 0.621490, .green = 0.999023, .blue = 0.997070 },
	{ .red = 0.715995, .green = 0.999023, .blue = 0.997314 },
	{ .red = 0.791941, .green = 0.998046, .blue = 0.996825 },
	{ .red = 0.848107, .green = 0.998535, .blue = 0.997558 },
	{ .red = 0.891087, .green = 0.999023, .blue = 0.998779 },
	{ .red = 0.927473, .green = 0.998779, .blue = 0.998779 },
	{ .red = 0.955800, .green = 0.998535, .blue = 0.998779 },
	{ .red = 0.978022, .green = 0.998779, .blue = 0.999267 },
	{ .red = 0.999267, .green = 0.998046, .blue = 0.998291 },
	{ .red = 0.999756, .green = 0.985836, .blue = 0.986569 },
	{ .red = 0.998779, .green = 0.973382, .blue = 0.974359 },
	{ .red = 0.998779, .green = 0.959707, .blue = 0.960928 },
	{ .red = 0.135287, .green = 0.989011, .blue = 0.933822 },
	{ .red = 0.137241, .green = 0.989988, .blue = 0.934554 },
	{ .red = 0.165812, .green = 0.998535, .blue = 0.942613 },
	{ .red = 0.344567, .green = 0.999023, .blue = 0.946032 },
	{ .red = 0.478388, .green = 0.998535, .blue = 0.949939 },
	{ .red = 0.585104, .green = 0.999512, .blue = 0.955800 },
	{ .red = 0.674725, .green = 0.999512, .blue = 0.960684 },
	{ .red = 0.750427, .green = 0.998291, .blue = 0.964591 },
	{ .red = 0.807326, .green = 0.999023, .blue = 0.969231 },
	{ .red = 0.854457, .green = 0.999023, .blue = 0.972650 },
	{ .red = 0.892063, .green = 0.999023, .blue = 0.975336 },
	{ .red = 0.925275, .green = 0.998046, .blue = 0.976557 },
	{ .red = 0.948962, .green = 0.999512, .blue = 0.977534 },
	{ .red = 0.975336, .green = 0.999756, .blue = 0.977534 },
	{ .red = 0.998779, .green = 0.996581, .blue = 0.957998 },
	{ .red = 0.999267, .green = 0.979731, .blue = 0.964835 },
	{ .red = 0.999023, .green = 0.971673, .blue = 0.960928 },
	{ .red = 0.059341, .green = 0.997070, .blue = 0.891331 },
	{ .red = 0.062271, .green = 0.998046, .blue = 0.891819 },
	{ .red = 0.207814, .green = 0.999267, .blue = 0.895238 },
	{ .red = 0.337241, .green = 0.999512, .blue = 0.900611 },
	{ .red = 0.450305, .green = 0.999267, .blue = 0.906960 },
	{ .red = 0.547253, .green = 0.999512, .blue = 0.915018 },
	{ .red = 0.634432, .green = 0.998291, .blue = 0.922100 },
	{ .red = 0.705495, .green = 0.998535, .blue = 0.929915 },
	{ .red = 0.764103, .green = 0.999267, .blue = 0.936996 },
	{ .red = 0.813431, .green = 0.999512, .blue = 0.942613 },
	{ .red = 0.857143, .green = 0.998535, .blue = 0.947253 },
	{ .red = 0.892063, .green = 0.999023, .blue = 0.950916 },
	{ .red = 0.924298, .green = 0.998535, .blue = 0.954090 },
	{ .red = 0.953602, .green = 0.998779, .blue = 0.957509 },
	{ .red = 0.975336, .green = 0.999512, .blue = 0.953358 },
	{ .red = 0.998046, .green = 0.995849, .blue = 0.916972 },
	{ .red = 0.998779, .green = 0.972405, .blue = 0.930403 },
	{ .red = 0.126252, .green = 0.993651, .blue = 0.845421 },
	{ .red = 0.152381, .green = 0.995360, .blue = 0.847375 },
	{ .red = 0.226618, .green = 0.999023, .blue = 0.852991 },
	{ .red = 0.327473, .green = 0.999756, .blue = 0.859096 },
	{ .red = 0.426374, .green = 0.999267, .blue = 0.866667 },
	{ .red = 0.515018, .green = 0.999512, .blue = 0.875946 },
	{ .red = 0.595360, .green = 0.999267, .blue = 0.885470 },
	{ .red = 0.666178, .green = 0.999023, .blue = 0.894750 },
	{ .red = 0.726496, .green = 0.999267, .blue = 0.903541 },
	{ .red = 0.778999, .green = 0.998779, .blue = 0.911600 },
	{ .red = 0.822955, .green = 0.999512, .blue = 0.918437 },
	{ .red = 0.863248, .green = 0.998779, .blue = 0.924542 },
	{ .red = 0.897924, .green = 0.998779, .blue = 0.929670 },
	{ .red = 0.930159, .green = 0.998535, .blue = 0.935531 },
	{ .red = 0.960195, .green = 0.998779, .blue = 0.943590 },
	{ .red = 0.969719, .green = 0.998779, .blue = 0.916239 },
	{ .red = 0.998291, .green = 0.996093, .blue = 0.875214 },
	{ .red = 0.064957, .green = 0.155800, .blue = 0.999512 },
	{ .red = 0.093040, .green = 0.117949, .blue = 0.999267 },
	{ .red = 0.162393, .green = 0.059585, .blue = 0.994872 },
	{ .red = 0.245177, .green = 0.088156, .blue = 0.998046 },
	{ .red = 0.328694, .green = 0.111355, .blue = 0.999512 },
	{ .red = 0.411233, .green = 0.124298, .blue = 0.998535 },
	{ .red = 0.492063, .green = 0.131380, .blue = 0.998779 },
	{ .red = 0.568742, .green = 0.127228, .blue = 0.998291 },
	{ .red = 0.641758, .green = 0.119170, .blue = 0.998779 },
	{ .red = 0.710134, .green = 0.102808, .blue = 0.999512 },
	{ .red = 0.772650, .green = 0.078144, .blue = 0.998291 },
	{ .red = 0.823687, .green = 0.038828, .blue = 0.987302 },
	{ .red = 0.868132, .green = 0.026374, .blue = 0.972894 },
	{ .red = 0.927473, .green = 0.017582, .blue = 0.978999 },
	{ .red = 0.976313, .green = 0.024664, .blue = 0.976068 },
	{ .red = 0.985348, .green = 0.037118, .blue = 0.920391 },
	{ .red = 0.983883, .green = 0.051038, .blue = 0.863004 },
	{ .red = 0.068620, .green = 0.163370, .blue = 0.999267 },
	{ .red = 0.094994, .green = 0.128205, .blue = 0.999267 },
	{ .red = 0.163126, .green = 0.075702, .blue = 0.998535 },
	{ .red = 0.244689, .green = 0.099878, .blue = 0.998535 },
	{ .red = 0.327717, .green = 0.120635, .blue = 0.999267 },
	{ .red = 0.409768, .green = 0.132357, .blue = 0.998291 },
	{ .red = 0.490842, .green = 0.139683, .blue = 0.999023 },
	{ .red = 0.567521, .green = 0.136508, .blue = 0.998535 },
	{ .red = 0.640049, .green = 0.128938, .blue = 0.998535 },
	{ .red = 0.708913, .green = 0.114042, .blue = 0.999512 },
	{ .red = 0.772161, .green = 0.092796, .blue = 0.998779 },
	{ .red = 0.831746, .green = 0.055922, .blue = 0.998535 },
	{ .red = 0.875458, .green = 0.046642, .blue = 0.981929 },
	{ .red = 0.932601, .green = 0.046398, .blue = 0.984860 },
	{ .red = 0.989744, .green = 0.028816, .blue = 0.990232 },
	{ .red = 0.994628, .green = 0.089133, .blue = 0.928694 },
	{ .red = 0.999267, .green = 0.116484, .blue = 0.876190 },
	{ .red = 0.092552, .green = 0.216606, .blue = 0.999267 },
	{ .red = 0.113309, .green = 0.199756, .blue = 0.999267 },
	{ .red = 0.174115, .green = 0.180220, .blue = 0.998779 },
	{ .red = 0.253480, .green = 0.193651, .blue = 0.998291 },
	{ .red = 0.336752, .green = 0.209035, .blue = 0.999267 },
	{ .red = 0.420024, .green = 0.222222, .blue = 0.999023 },
	{ .red = 0.501832, .green = 0.232234, .blue = 0.999023 },
	{ .red = 0.579976, .green = 0.237118, .blue = 0.998535 },
	{ .red = 0.653968, .green = 0.238339, .blue = 0.999267 },
	{ .red = 0.722344, .green = 0.237363, .blue = 0.998291 },
	{ .red = 0.786569, .green = 0.233211, .blue = 0.999023 },
	{ .red = 0.845665, .green = 0.227595, .blue = 0.998535 },
	{ .red = 0.902808, .green = 0.222955, .blue = 0.999512 },
	{ .red = 0.955800, .green = 0.222466, .blue = 0.998779 },
	{ .red = 0.998046, .green = 0.221734, .blue = 0.989988 },
	{ .red = 0.999756, .green = 0.229548, .blue = 0.928449 },
	{ .red = 0.999267, .green = 0.232967, .blue = 0.874237 },
	{ .red = 0.130891, .green = 0.296459, .blue = 0.999267 },
	{ .red = 0.175336, .green = 0.327473, .blue = 0.999267 },
	{ .red = 0.214652, .green = 0.311111, .blue = 0.998046 },
	{ .red = 0.286203, .green = 0.319414, .blue = 0.998779 },
	{ .red = 0.365324, .green = 0.330403, .blue = 0.998779 },
	{ .red = 0.447131, .green = 0.341392, .blue = 0.999267 },
	{ .red = 0.527717, .green = 0.350183, .blue = 0.999023 },
	{ .red = 0.605617, .green = 0.357265, .blue = 0.998779 },
	{ .red = 0.678877, .green = 0.362149, .blue = 0.998779 },
	{ .red = 0.747009, .green = 0.364591, .blue = 0.999023 },
	{ .red = 0.809035, .green = 0.364835, .blue = 0.998291 },
	{ .red = 0.866911, .green = 0.363126, .blue = 0.999023 },
	{ .red = 0.920635, .green = 0.360195, .blue = 0.999267 },
	{ .red = 0.970940, .green = 0.358730, .blue = 0.999023 },
	{ .red = 0.999023, .green = 0.357753, .blue = 0.978266 },
	{ .red = 0.999023, .green = 0.354823, .blue = 0.922344 },
	{ .red = 0.999756, .green = 0.348718, .blue = 0.873993 },
	{ .red = 0.087668, .green = 0.297192, .blue = 0.996337 },
	{ .red = 0.211477, .green = 0.399023, .blue = 0.998535 },
	{ .red = 0.287912, .green = 0.438339, .blue = 0.998779 },
	{ .red = 0.343346, .green = 0.441514, .blue = 0.999512 },
	{ .red = 0.413675, .green = 0.450061, .blue = 0.999512 },
	{ .red = 0.488645, .green = 0.459096, .blue = 0.999267 },
	{ .red = 0.564835, .green = 0.467888, .blue = 0.998535 },
	{ .red = 0.639560, .green = 0.475458, .blue = 0.999267 },
	{ .red = 0.709646, .green = 0.481807, .blue = 0.998779 },
	{ .red = 0.774603, .green = 0.485714, .blue = 0.998779 },
	{ .red = 0.834188, .green = 0.488156, .blue = 0.999023 },
	{ .red = 0.887912, .green = 0.487668, .blue = 0.998535 },
	{ .red = 0.937729, .green = 0.484737, .blue = 0.998779 },
	{ .red = 0.984371, .green = 0.482051, .blue = 0.998779 },
	{ .red = 0.999023, .green = 0.480342, .blue = 0.968498 },
	{ .red = 0.999267, .green = 0.472283, .blue = 0.920635 },
	{ .red = 0.998046, .green = 0.461050, .blue = 0.876190 },
	{ .red = 0.054701, .green = 0.358974, .blue = 0.994628 },
	{ .red = 0.147497, .green = 0.392918, .blue = 0.998046 },
	{ .red = 0.382906, .green = 0.557998, .blue = 0.998779 },
	{ .red = 0.422222, .green = 0.557021, .blue = 0.999023 },
	{ .red = 0.479121, .green = 0.563614, .blue = 0.998535 },
	{ .red = 0.543834, .green = 0.571429, .blue = 0.999023 },
	{ .red = 0.610989, .green = 0.578999, .blue = 0.998779 },
	{ .red = 0.678144, .green = 0.586325, .blue = 0.998779 },
	{ .red = 0.742125, .green = 0.592430, .blue = 0.998779 },
	{ .red = 0.801709, .green = 0.596825, .blue = 0.999023 },
	{ .red = 0.855678, .green = 0.599267, .blue = 0.998046 },
	{ .red = 0.905250, .green = 0.599267, .blue = 0.998291 },
	{ .red = 0.950916, .green = 0.596337, .blue = 0.999023 },
	{ .red = 0.991941, .green = 0.592186, .blue = 0.997802 },
	{ .red = 0.999267, .green = 0.589499, .blue = 0.964835 },
	{ .red = 0.998779, .green = 0.580220, .blue = 0.924054 },
	{ .red = 0.999267, .green = 0.565568, .blue = 0.886691 },
	{ .red = 0.025397, .green = 0.424908, .blue = 0.960195 },
	{ .red = 0.112088, .green = 0.448840, .blue = 0.999267 },
	{ .red = 0.284737, .green = 0.521612, .blue = 0.998779 },
	{ .red = 0.524054, .green = 0.670818, .blue = 0.999023 },
	{ .red = 0.556044, .green = 0.666422, .blue = 0.998046 },
	{ .red = 0.607326, .green = 0.672039, .blue = 0.997802 },
	{ .red = 0.662515, .green = 0.678144, .blue = 0.998291 },
	{ .red = 0.719170, .green = 0.684005, .blue = 0.998535 },
	{ .red = 0.774603, .green = 0.689133, .blue = 0.999023 },
	{ .red = 0.826374, .green = 0.693040, .blue = 0.998046 },
	{ .red = 0.874481, .green = 0.694994, .blue = 0.998535 },
	{ .red = 0.918681, .green = 0.694750, .blue = 0.999023 },
	{ .red = 0.958974, .green = 0.691819, .blue = 0.999023 },
	{ .red = 0.995604, .green = 0.686447, .blue = 0.998046 },
	{ .red = 0.999756, .green = 0.683516, .blue = 0.967033 },
	{ .red = 0.998779, .green = 0.674237, .blue = 0.932845 },
	{ .red = 0.998535, .green = 0.658120, .blue = 0.899878 },
	{ .red = 0.030037, .green = 0.506227, .blue = 0.965324 },
	{ .red = 0.082540, .green = 0.520391, .blue = 0.997314 },
	{ .red = 0.260806, .green = 0.567521, .blue = 0.999023 },
	{ .red = 0.425397, .green = 0.638584, .blue = 0.998779 },
	{ .red = 0.642979, .green = 0.759707, .blue = 0.998046 },
	{ .red = 0.672283, .green = 0.757753, .blue = 0.999512 },
	{ .red = 0.715263, .green = 0.761905, .blue = 0.999023 },
	{ .red = 0.760440, .green = 0.766056, .blue = 0.998779 },
	{ .red = 0.805617, .green = 0.769963, .blue = 0.998779 },
	{ .red = 0.849328, .green = 0.772894, .blue = 0.999023 },
	{ .red = 0.890354, .green = 0.774115, .blue = 0.999023 },
	{ .red = 0.928205, .green = 0.773626, .blue = 0.999267 },
	{ .red = 0.962393, .green = 0.770452, .blue = 0.998046 },
	{ .red = 0.995604, .green = 0.764347, .blue = 0.998535 },
	{ .red = 0.998779, .green = 0.761416, .blue = 0.971184 },
	{ .red = 0.999512, .green = 0.752381, .blue = 0.944078 },
	{ .red = 0.998779, .green = 0.736264, .blue = 0.915507 },
	{ .red = 0.020269, .green = 0.586325, .blue = 0.974847 },
	{ .red = 0.053480, .green = 0.588767, .blue = 0.984615 },
	{ .red = 0.245421, .green = 0.626862, .blue = 0.998779 },
	{ .red = 0.400488, .green = 0.676190, .blue = 0.998779 },
	{ .red = 0.548474, .green = 0.733822, .blue = 0.998535 },
	{ .red = 0.725763, .green = 0.821490, .blue = 0.999267 },
	{ .red = 0.765324, .green = 0.829060, .blue = 0.998046 },
	{ .red = 0.799267, .green = 0.831990, .blue = 0.999267 },
	{ .red = 0.834676, .green = 0.834432, .blue = 0.999023 },
	{ .red = 0.870085, .green = 0.836386, .blue = 0.999023 },
	{ .red = 0.903785, .green = 0.837118, .blue = 0.999023 },
	{ .red = 0.935287, .green = 0.836142, .blue = 0.998291 },
	{ .red = 0.965079, .green = 0.833211, .blue = 0.998535 },
	{ .red = 0.994139, .green = 0.827106, .blue = 0.999267 },
	{ .red = 0.999756, .green = 0.823443, .blue = 0.978266 },
	{ .red = 0.997802, .green = 0.815873, .blue = 0.953846 },
	{ .red = 0.999512, .green = 0.799756, .blue = 0.930647 },
	{ .red = 0.043712, .green = 0.659096, .blue = 0.974603 },
	{ .red = 0.058120, .green = 0.662271, .blue = 0.983639 },
	{ .red = 0.230525, .green = 0.689621, .blue = 0.999023 },
	{ .red = 0.384127, .green = 0.725275, .blue = 0.999023 },
	{ .red = 0.521856, .green = 0.765568, .blue = 0.998291 },
	{ .red = 0.646154, .green = 0.807082, .blue = 0.998046 },
	{ .red = 0.765568, .green = 0.854457, .blue = 0.998535 },
	{ .red = 0.835165, .green = 0.883028, .blue = 0.999023 },
	{ .red = 0.861538, .green = 0.884493, .blue = 0.999267 },
	{ .red = 0.888889, .green = 0.885714, .blue = 0.999023 },
	{ .red = 0.916239, .green = 0.885958, .blue = 0.999512 },
	{ .red = 0.942613, .green = 0.884982, .blue = 0.999512 },
	{ .red = 0.967277, .green = 0.882295, .blue = 0.998779 },
	{ .red = 0.991697, .green = 0.876679, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.872772, .blue = 0.983150 },
	{ .red = 0.998535, .green = 0.865446, .blue = 0.963858 },
	{ .red = 0.999023, .green = 0.850549, .blue = 0.943346 },
	{ .red = 0.027350, .green = 0.732601, .blue = 0.982662 },
	{ .red = 0.032967, .green = 0.736264, .blue = 0.990476 },
	{ .red = 0.215629, .green = 0.753114, .blue = 0.999267 },
	{ .red = 0.371917, .green = 0.778266, .blue = 0.998779 },
	{ .red = 0.505006, .green = 0.807082, .blue = 0.998535 },
	{ .red = 0.620757, .green = 0.836630, .blue = 0.999512 },
	{ .red = 0.721368, .green = 0.863980, .blue = 0.999267 },
	{ .red = 0.809524, .green = 0.891331, .blue = 0.999023 },
	{ .red = 0.886691, .green = 0.922589, .blue = 0.998291 },
	{ .red = 0.906716, .green = 0.923321, .blue = 0.998779 },
	{ .red = 0.927717, .green = 0.923321, .blue = 0.999512 },
	{ .red = 0.948474, .green = 0.922589, .blue = 0.998535 },
	{ .red = 0.969475, .green = 0.920391, .blue = 0.999512 },
	{ .red = 0.989988, .green = 0.915751, .blue = 0.999512 },
	{ .red = 0.999267, .green = 0.911355, .blue = 0.988767 },
	{ .red = 0.999023, .green = 0.904274, .blue = 0.971917 },
	{ .red = 0.999512, .green = 0.890110, .blue = 0.954579 },
	{ .red = 0.070818, .green = 0.798779, .blue = 0.981929 },
	{ .red = 0.080342, .green = 0.800244, .blue = 0.985104 },
	{ .red = 0.203663, .green = 0.815140, .blue = 0.998046 },
	{ .red = 0.362637, .green = 0.833211, .blue = 0.999023 },
	{ .red = 0.494017, .green = 0.853480, .blue = 0.998779 },
	{ .red = 0.606593, .green = 0.873016, .blue = 0.998046 },
	{ .red = 0.700855, .green = 0.891819, .blue = 0.998535 },
	{ .red = 0.779976, .green = 0.908425, .blue = 0.999023 },
	{ .red = 0.847375, .green = 0.923810, .blue = 0.998779 },
	{ .red = 0.914286, .green = 0.945788, .blue = 0.998535 },
	{ .red = 0.938950, .green = 0.951648, .blue = 0.998779 },
	{ .red = 0.955067, .green = 0.951160, .blue = 0.999023 },
	{ .red = 0.971917, .green = 0.949451, .blue = 0.999512 },
	{ .red = 0.988767, .green = 0.946032, .blue = 0.999267 },
	{ .red = 0.999023, .green = 0.941392, .blue = 0.992430 },
	{ .red = 0.998291, .green = 0.934554, .blue = 0.977778 },
	{ .red = 0.999267, .green = 0.921368, .blue = 0.963126 },
	{ .red = 0.076435, .green = 0.865690, .blue = 0.986569 },
	{ .red = 0.085714, .green = 0.866667, .blue = 0.988523 },
	{ .red = 0.191941, .green = 0.876923, .blue = 0.998046 },
	{ .red = 0.357753, .green = 0.888889, .blue = 0.999023 },
	{ .red = 0.489133, .green = 0.901832, .blue = 0.999023 },
	{ .red = 0.599512, .green = 0.914530, .blue = 0.998779 },
	{ .red = 0.690354, .green = 0.926252, .blue = 0.999267 },
	{ .red = 0.765812, .green = 0.936020, .blue = 0.999023 },
	{ .red = 0.827595, .green = 0.944567, .blue = 0.999267 },
	{ .red = 0.879121, .green = 0.951893, .blue = 0.998535 },
	{ .red = 0.923565, .green = 0.960440, .blue = 0.999267 },
	{ .red = 0.962393, .green = 0.972650, .blue = 0.999512 },
	{ .red = 0.974847, .green = 0.971673, .blue = 0.999023 },
	{ .red = 0.988278, .green = 0.969475, .blue = 0.999023 },
	{ .red = 0.999267, .green = 0.965324, .blue = 0.995360 },
	{ .red = 0.998779, .green = 0.957998, .blue = 0.982662 },
	{ .red = 0.999023, .green = 0.945299, .blue = 0.969719 },
	{ .red = 0.078388, .green = 0.930647, .blue = 0.990720 },
	{ .red = 0.081319, .green = 0.931868, .blue = 0.992430 },
	{ .red = 0.182906, .green = 0.938217, .blue = 0.998535 },
	{ .red = 0.359463, .green = 0.944567, .blue = 0.998779 },
	{ .red = 0.492063, .green = 0.951648, .blue = 0.999267 },
	{ .red = 0.600977, .green = 0.958242, .blue = 0.999512 },
	{ .red = 0.691331, .green = 0.963614, .blue = 0.999023 },
	{ .red = 0.764347, .green = 0.968010, .blue = 0.998779 },
	{ .red = 0.823199, .green = 0.971673, .blue = 0.998535 },
	{ .red = 0.870574, .green = 0.974603, .blue = 0.998535 },
	{ .red = 0.909158, .green = 0.977045, .blue = 0.998535 },
	{ .red = 0.941148, .green = 0.979487, .blue = 0.998779 },
	{ .red = 0.970452, .green = 0.983639, .blue = 0.999267 },
	{ .red = 0.989499, .green = 0.987302, .blue = 0.999512 },
	{ .red = 0.999267, .green = 0.984127, .blue = 0.997314 },
	{ .red = 0.998779, .green = 0.976068, .blue = 0.986569 },
	{ .red = 0.998535, .green = 0.963614, .blue = 0.974603 },
	{ .red = 0.091575, .green = 0.992918, .blue = 0.992918 },
	{ .red = 0.092552, .green = 0.994139, .blue = 0.994139 },
	{ .red = 0.176557, .green = 0.998779, .blue = 0.998779 },
	{ .red = 0.374847, .green = 0.998779, .blue = 0.997802 },
	{ .red = 0.515018, .green = 0.999023, .blue = 0.997070 },
	{ .red = 0.626374, .green = 0.999023, .blue = 0.996825 },
	{ .red = 0.715263, .green = 0.998779, .blue = 0.996825 },
	{ .red = 0.786813, .green = 0.998046, .blue = 0.996337 },
	{ .red = 0.841270, .green = 0.998291, .blue = 0.997070 },
	{ .red = 0.881319, .green = 0.999512, .blue = 0.999023 },
	{ .red = 0.917949, .green = 0.998535, .blue = 0.998291 },
	{ .red = 0.945055, .green = 0.998779, .blue = 0.998779 },
	{ .red = 0.968254, .green = 0.998535, .blue = 0.998779 },
	{ .red = 0.985104, .green = 0.999267, .blue = 0.999512 },
	{ .red = 1.000000, .green = 0.999267, .blue = 0.999512 },
	{ .red = 1.000000, .green = 0.988034, .blue = 0.988523 },
	{ .red = 0.999023, .green = 0.976068, .blue = 0.977045 },
	{ .red = 0.135287, .green = 0.991453, .blue = 0.939927 },
	{ .red = 0.136996, .green = 0.992430, .blue = 0.940659 },
	{ .red = 0.225397, .green = 0.998535, .blue = 0.947497 },
	{ .red = 0.363614, .green = 0.998535, .blue = 0.949939 },
	{ .red = 0.478632, .green = 0.999267, .blue = 0.954335 },
	{ .red = 0.579487, .green = 0.999267, .blue = 0.958730 },
	{ .red = 0.664713, .green = 0.999267, .blue = 0.963126 },
	{ .red = 0.736996, .green = 0.998535, .blue = 0.966789 },
	{ .red = 0.793407, .green = 0.998779, .blue = 0.970940 },
	{ .red = 0.840781, .green = 0.998535, .blue = 0.974115 },
	{ .red = 0.876190, .green = 0.999756, .blue = 0.977289 },
	{ .red = 0.910379, .green = 0.998046, .blue = 0.978510 },
	{ .red = 0.936264, .green = 0.998046, .blue = 0.979976 },
	{ .red = 0.956044, .green = 0.999512, .blue = 0.980464 },
	{ .red = 0.978510, .green = 0.999756, .blue = 0.980464 },
	{ .red = 0.998779, .green = 0.996825, .blue = 0.962637 },
	{ .red = 0.999267, .green = 0.981441, .blue = 0.968010 },
	{ .red = 0.121368, .green = 0.994628, .blue = 0.896703 },
	{ .red = 0.153846, .green = 0.996093, .blue = 0.898413 },
	{ .red = 0.237118, .green = 0.999267, .blue = 0.903053 },
	{ .red = 0.344811, .green = 0.999267, .blue = 0.907448 },
	{ .red = 0.446154, .green = 0.999023, .blue = 0.913065 },
	{ .red = 0.536020, .green = 0.999512, .blue = 0.920147 },
	{ .red = 0.619536, .green = 0.998291, .blue = 0.926252 },
	{ .red = 0.687912, .green = 0.998779, .blue = 0.933333 },
	{ .red = 0.746520, .green = 0.998779, .blue = 0.939683 },
	{ .red = 0.794383, .green = 0.999756, .blue = 0.945299 },
	{ .red = 0.836874, .green = 0.999267, .blue = 0.949939 },
	{ .red = 0.872527, .green = 0.999267, .blue = 0.953358 },
	{ .red = 0.903053, .green = 0.999267, .blue = 0.956288 },
	{ .red = 0.931624, .green = 0.998535, .blue = 0.958730 },
	{ .red = 0.957509, .green = 0.999023, .blue = 0.961172 },
	{ .red = 0.977534, .green = 0.999756, .blue = 0.957021 },
	{ .red = 0.998535, .green = 0.996337, .blue = 0.922589 },
	{ .red = 0.068620, .green = 0.170940, .blue = 0.999023 },
	{ .red = 0.092063, .green = 0.140415, .blue = 0.999267 },
	{ .red = 0.152869, .green = 0.076923, .blue = 0.998779 },
	{ .red = 0.229304, .green = 0.097436, .blue = 0.998535 },
	{ .red = 0.307204, .green = 0.116239, .blue = 0.999023 },
	{ .red = 0.384860, .green = 0.130891, .blue = 0.999023 },
	{ .red = 0.461050, .green = 0.136020, .blue = 0.999267 },
	{ .red = 0.534554, .green = 0.136508, .blue = 0.999023 },
	{ .red = 0.604151, .green = 0.130647, .blue = 0.998291 },
	{ .red = 0.670330, .green = 0.118681, .blue = 0.999023 },
	{ .red = 0.732357, .green = 0.104274, .blue = 0.998779 },
	{ .red = 0.787790, .green = 0.079365, .blue = 0.995604 },
	{ .red = 0.841514, .green = 0.033211, .blue = 0.994383 },
	{ .red = 0.881563, .green = 0.039805, .blue = 0.978999 },
	{ .red = 0.934554, .green = 0.039560, .blue = 0.982173 },
	{ .red = 0.985104, .green = 0.027106, .blue = 0.984615 },
	{ .red = 0.985836, .green = 0.050549, .blue = 0.924542 },
	{ .red = 0.071551, .green = 0.176557, .blue = 0.998779 },
	{ .red = 0.093529, .green = 0.147497, .blue = 0.999023 },
	{ .red = 0.153114, .green = 0.088889, .blue = 0.998779 },
	{ .red = 0.229060, .green = 0.106471, .blue = 0.998779 },
	{ .red = 0.306227, .green = 0.123810, .blue = 0.999267 },
	{ .red = 0.383639, .green = 0.137241, .blue = 0.998779 },
	{ .red = 0.460317, .green = 0.145543, .blue = 0.999512 },
	{ .red = 0.534554, .green = 0.148962, .blue = 0.999512 },
	{ .red = 0.604396, .green = 0.146520, .blue = 0.998535 },
	{ .red = 0.670818, .green = 0.138706, .blue = 0.998779 },
	{ .red = 0.733089, .green = 0.128938, .blue = 0.998779 },
	{ .red = 0.791941, .green = 0.111844, .blue = 0.999756 },
	{ .red = 0.845421, .green = 0.091575, .blue = 0.997558 },
	{ .red = 0.899878, .green = 0.082295, .blue = 0.999023 },
	{ .red = 0.947253, .green = 0.084982, .blue = 0.995116 },
	{ .red = 0.994139, .green = 0.081807, .blue = 0.993407 },
	{ .red = 0.999023, .green = 0.117460, .blue = 0.935775 },
	{ .red = 0.107204, .green = 0.245177, .blue = 0.998291 },
	{ .red = 0.121612, .green = 0.229060, .blue = 0.999023 },
	{ .red = 0.170208, .green = 0.202686, .blue = 0.998779 },
	{ .red = 0.242979, .green = 0.211966, .blue = 0.998291 },
	{ .red = 0.319902, .green = 0.223932, .blue = 0.998779 },
	{ .red = 0.397558, .green = 0.234676, .blue = 0.998779 },
	{ .red = 0.474969, .green = 0.242491, .blue = 0.999756 },
	{ .red = 0.549206, .green = 0.247375, .blue = 0.999267 },
	{ .red = 0.620024, .green = 0.249817, .blue = 0.998291 },
	{ .red = 0.686447, .green = 0.248596, .blue = 0.998779 },
	{ .red = 0.748474, .green = 0.246154, .blue = 0.998779 },
	{ .red = 0.806349, .green = 0.241026, .blue = 0.999023 },
	{ .red = 0.859829, .green = 0.234188, .blue = 0.998535 },
	{ .red = 0.912332, .green = 0.230525, .blue = 0.999756 },
	{ .red = 0.961172, .green = 0.229060, .blue = 0.999023 },
	{ .red = 0.998535, .green = 0.227839, .blue = 0.989011 },
	{ .red = 0.999756, .green = 0.233700, .blue = 0.931624 },
	{ .red = 0.140415, .green = 0.307937, .blue = 0.999023 },
	{ .red = 0.183639, .green = 0.340659, .blue = 0.999512 },
	{ .red = 0.212454, .green = 0.319414, .blue = 0.998291 },
	{ .red = 0.277167, .green = 0.326252, .blue = 0.998779 },
	{ .red = 0.349939, .green = 0.335287, .blue = 0.999023 },
	{ .red = 0.425397, .green = 0.343834, .blue = 0.998046 },
	{ .red = 0.501099, .green = 0.351648, .blue = 0.998046 },
	{ .red = 0.575580, .green = 0.358486, .blue = 0.999267 },
	{ .red = 0.645177, .green = 0.362393, .blue = 0.998535 },
	{ .red = 0.711600, .green = 0.365079, .blue = 0.999512 },
	{ .red = 0.771673, .green = 0.365812, .blue = 0.998291 },
	{ .red = 0.827595, .green = 0.364347, .blue = 0.998535 },
	{ .red = 0.879365, .green = 0.360684, .blue = 0.998046 },
	{ .red = 0.929182, .green = 0.357265, .blue = 0.999512 },
	{ .red = 0.975580, .green = 0.354823, .blue = 0.999512 },
	{ .red = 0.999023, .green = 0.352625, .blue = 0.978022 },
	{ .red = 0.999023, .green = 0.348718, .blue = 0.925519 },
	{ .red = 0.088889, .green = 0.288889, .blue = 0.996825 },
	{ .red = 0.222466, .green = 0.408547, .blue = 0.999023 },
	{ .red = 0.287179, .green = 0.440537, .blue = 0.999023 },
	{ .red = 0.335531, .green = 0.440781, .blue = 1.000000 },
	{ .red = 0.399267, .green = 0.447619, .blue = 0.999023 },
	{ .red = 0.468864, .green = 0.455433, .blue = 0.998535 },
	{ .red = 0.539927, .green = 0.462759, .blue = 0.999023 },
	{ .red = 0.610012, .green = 0.469841, .blue = 0.998046 },
	{ .red = 0.677656, .green = 0.475458, .blue = 0.999023 },
	{ .red = 0.740659, .green = 0.479365, .blue = 0.999512 },
	{ .red = 0.798779, .green = 0.481807, .blue = 0.999512 },
	{ .red = 0.851526, .green = 0.481563, .blue = 0.999267 },
	{ .red = 0.900122, .green = 0.479365, .blue = 0.999023 },
	{ .red = 0.945299, .green = 0.475214, .blue = 0.999023 },
	{ .red = 0.988034, .green = 0.471551, .blue = 0.999023 },
	{ .red = 0.998535, .green = 0.468620, .blue = 0.967766 },
	{ .red = 0.999267, .green = 0.459585, .blue = 0.923321 },
	{ .red = 0.068864, .green = 0.342125, .blue = 0.990720 },
	{ .red = 0.156777, .green = 0.386081, .blue = 0.998535 },
	{ .red = 0.391941, .green = 0.562393, .blue = 0.998535 },
	{ .red = 0.414164, .green = 0.550672, .blue = 0.999267 },
	{ .red = 0.465934, .green = 0.556044, .blue = 0.998291 },
	{ .red = 0.525519, .green = 0.562393, .blue = 0.998535 },
	{ .red = 0.588278, .green = 0.569231, .blue = 0.998291 },
	{ .red = 0.651526, .green = 0.575580, .blue = 0.998535 },
	{ .red = 0.712576, .green = 0.581197, .blue = 0.998535 },
	{ .red = 0.770208, .green = 0.585592, .blue = 0.998535 },
	{ .red = 0.822955, .green = 0.588034, .blue = 0.998046 },
	{ .red = 0.872527, .green = 0.588767, .blue = 0.999267 },
	{ .red = 0.916484, .green = 0.586813, .blue = 0.998779 },
	{ .red = 0.957998, .green = 0.581929, .blue = 0.999023 },
	{ .red = 0.995360, .green = 0.577045, .blue = 0.997558 },
	{ .red = 0.998535, .green = 0.573382, .blue = 0.963370 },
	{ .red = 0.999023, .green = 0.562637, .blue = 0.925275 },
	{ .red = 0.035165, .green = 0.398291, .blue = 0.961905 },
	{ .red = 0.128938, .green = 0.430525, .blue = 0.998046 },
	{ .red = 0.298168, .green = 0.518193, .blue = 0.998291 },
	{ .red = 0.513065, .green = 0.658608, .blue = 0.998535 },
	{ .red = 0.543590, .green = 0.655433, .blue = 0.999512 },
	{ .red = 0.590965, .green = 0.660317, .blue = 0.998535 },
	{ .red = 0.642735, .green = 0.665690, .blue = 0.999023 },
	{ .red = 0.695971, .green = 0.670818, .blue = 0.998291 },
	{ .red = 0.748962, .green = 0.675702, .blue = 0.999023 },
	{ .red = 0.799267, .green = 0.679365, .blue = 0.999267 },
	{ .red = 0.845665, .green = 0.681563, .blue = 0.998046 },
	{ .red = 0.888889, .green = 0.681807, .blue = 0.998291 },
	{ .red = 0.928694, .green = 0.679853, .blue = 0.998779 },
	{ .red = 0.964835, .green = 0.674969, .blue = 0.998291 },
	{ .red = 0.997802, .green = 0.668864, .blue = 0.996337 },
	{ .red = 0.999023, .green = 0.664713, .blue = 0.964591 },
	{ .red = 0.999267, .green = 0.653968, .blue = 0.932601 },
	{ .red = 0.028571, .green = 0.478632, .blue = 0.979243 },
	{ .red = 0.116484, .green = 0.496459, .blue = 0.998291 },
	{ .red = 0.269353, .green = 0.548962, .blue = 0.997802 },
	{ .red = 0.438095, .green = 0.633944, .blue = 0.998046 },
	{ .red = 0.626129, .green = 0.743590, .blue = 0.999023 },
	{ .red = 0.657387, .green = 0.743834, .blue = 0.999512 },
	{ .red = 0.697680, .green = 0.747741, .blue = 0.998291 },
	{ .red = 0.740171, .green = 0.751404, .blue = 0.998779 },
	{ .red = 0.783639, .green = 0.755067, .blue = 0.999267 },
	{ .red = 0.825641, .green = 0.757753, .blue = 0.998779 },
	{ .red = 0.865446, .green = 0.759219, .blue = 0.998291 },
	{ .red = 0.902564, .green = 0.759219, .blue = 0.998291 },
	{ .red = 0.937485, .green = 0.757021, .blue = 0.999023 },
	{ .red = 0.969231, .green = 0.752381, .blue = 0.998535 },
	{ .red = 0.998535, .green = 0.745543, .blue = 0.997070 },
	{ .red = 0.999023, .green = 0.741392, .blue = 0.968987 },
	{ .red = 0.998535, .green = 0.731624, .blue = 0.941880 },
	{ .red = 0.041270, .green = 0.550916, .blue = 0.978266 },
	{ .red = 0.103297, .green = 0.564835, .blue = 0.998535 },
	{ .red = 0.258852, .green = 0.602198, .blue = 0.998779 },
	{ .red = 0.406838, .green = 0.658364, .blue = 0.999023 },
	{ .red = 0.557021, .green = 0.725275, .blue = 0.997558 },
	{ .red = 0.723321, .green = 0.814652, .blue = 0.999512 },
	{ .red = 0.749695, .green = 0.814408, .blue = 0.998046 },
	{ .red = 0.782173, .green = 0.817094, .blue = 0.999512 },
	{ .red = 0.816117, .green = 0.819292, .blue = 0.998291 },
	{ .red = 0.850061, .green = 0.821245, .blue = 0.998779 },
	{ .red = 0.883028, .green = 0.822222, .blue = 0.998779 },
	{ .red = 0.914286, .green = 0.821734, .blue = 0.999023 },
	{ .red = 0.943590, .green = 0.819536, .blue = 0.998779 },
	{ .red = 0.970696, .green = 0.814896, .blue = 0.998046 },
	{ .red = 0.998779, .green = 0.807570, .blue = 0.999512 },
	{ .red = 0.999267, .green = 0.803907, .blue = 0.975092 },
	{ .red = 0.999512, .green = 0.794872, .blue = 0.952869 },
	{ .red = 0.051282, .green = 0.621490, .blue = 0.980220 },
	{ .red = 0.091087, .green = 0.631013, .blue = 0.995849 },
	{ .red = 0.250061, .green = 0.658852, .blue = 0.998535 },
	{ .red = 0.391941, .green = 0.699634, .blue = 0.998535 },
	{ .red = 0.526007, .green = 0.746764, .blue = 0.998535 },
	{ .red = 0.651526, .green = 0.796093, .blue = 0.998291 },
	{ .red = 0.801954, .green = 0.870818, .blue = 0.999023 },
	{ .red = 0.820269, .green = 0.868620, .blue = 0.999512 },
	{ .red = 0.845910, .green = 0.869841, .blue = 0.998535 },
	{ .red = 0.872283, .green = 0.871062, .blue = 1.000000 },
	{ .red = 0.898657, .green = 0.871551, .blue = 0.998779 },
	{ .red = 0.924542, .green = 0.870818, .blue = 0.999023 },
	{ .red = 0.948962, .green = 0.868620, .blue = 0.999267 },
	{ .red = 0.972650, .green = 0.864713, .blue = 0.999267 },
	{ .red = 0.995849, .green = 0.857875, .blue = 0.999512 },
	{ .red = 0.999267, .green = 0.853724, .blue = 0.980952 },
	{ .red = 0.998535, .green = 0.845910, .blue = 0.961416 },
	{ .red = 0.056899, .green = 0.689866, .blue = 0.983883 },
	{ .red = 0.083516, .green = 0.694505, .blue = 0.991941 },
	{ .red = 0.242491, .green = 0.717460, .blue = 0.999267 },
	{ .red = 0.380952, .green = 0.747253, .blue = 0.999267 },
	{ .red = 0.507692, .green = 0.781197, .blue = 0.998535 },
	{ .red = 0.621978, .green = 0.816361, .blue = 0.999267 },
	{ .red = 0.723321, .green = 0.850061, .blue = 0.999267 },
	{ .red = 0.823199, .green = 0.889621, .blue = 0.998535 },
	{ .red = 0.872772, .green = 0.908913, .blue = 0.998535 },
	{ .red = 0.892308, .green = 0.909402, .blue = 0.998291 },
	{ .red = 0.913065, .green = 0.909646, .blue = 0.999756 },
	{ .red = 0.933578, .green = 0.908913, .blue = 0.999267 },
	{ .red = 0.953602, .green = 0.907204, .blue = 0.998779 },
	{ .red = 0.973138, .green = 0.903785, .blue = 0.998779 },
	{ .red = 0.993407, .green = 0.897924, .blue = 0.999512 },
	{ .red = 0.999023, .green = 0.893284, .blue = 0.985836 },
	{ .red = 0.999023, .green = 0.885958, .blue = 0.969719 },
	{ .red = 0.071062, .green = 0.754335, .blue = 0.985348 },
	{ .red = 0.081807, .green = 0.756288, .blue = 0.989255 },
	{ .red = 0.237363, .green = 0.774847, .blue = 0.998046 },
	{ .red = 0.373138, .green = 0.796581, .blue = 0.998779 },
	{ .red = 0.495971, .green = 0.821245, .blue = 0.998291 },
	{ .red = 0.603663, .green = 0.846886, .blue = 0.999512 },
	{ .red = 0.697924, .green = 0.869841, .blue = 0.998779 },
	{ .red = 0.778266, .green = 0.891819, .blue = 0.999267 },
	{ .red = 0.849817, .green = 0.913797, .blue = 0.998779 },
	{ .red = 0.911111, .green = 0.938950, .blue = 0.998535 },
	{ .red = 0.926252, .green = 0.938950, .blue = 0.998779 },
	{ .red = 0.942125, .green = 0.938217, .blue = 0.998779 },
	{ .red = 0.958486, .green = 0.936996, .blue = 0.999023 },
	{ .red = 0.974847, .green = 0.934310, .blue = 0.999023 },
	{ .red = 0.991941, .green = 0.929426, .blue = 0.999756 },
	{ .red = 0.999267, .green = 0.924786, .blue = 0.990232 },
	{ .red = 0.999512, .green = 0.917705, .blue = 0.976313 },
	{ .red = 0.089621, .green = 0.815629, .blue = 0.985836 },
	{ .red = 0.096459, .green = 0.816850, .blue = 0.988278 },
	{ .red = 0.231502, .green = 0.832967, .blue = 0.999267 },
	{ .red = 0.368010, .green = 0.847863, .blue = 0.999267 },
	{ .red = 0.488156, .green = 0.864957, .blue = 0.999267 },
	{ .red = 0.593651, .green = 0.882051, .blue = 0.998291 },
	{ .red = 0.682540, .green = 0.898413, .blue = 0.999023 },
	{ .red = 0.757753, .green = 0.912821, .blue = 0.999512 },
	{ .red = 0.821490, .green = 0.925275, .blue = 0.999023 },
	{ .red = 0.875946, .green = 0.937729, .blue = 0.999023 },
	{ .red = 0.935043, .green = 0.958486, .blue = 0.998535 },
	{ .red = 0.950916, .green = 0.960684, .blue = 0.998779 },
	{ .red = 0.963614, .green = 0.959951, .blue = 0.999267 },
	{ .red = 0.977045, .green = 0.957998, .blue = 0.999756 },
	{ .red = 0.990232, .green = 0.954579, .blue = 0.999023 },
	{ .red = 0.998779, .green = 0.949939, .blue = 0.993162 },
	{ .red = 0.999023, .green = 0.943101, .blue = 0.980952 },
	{ .red = 0.109402, .green = 0.874969, .blue = 0.986813 },
	{ .red = 0.114042, .green = 0.875946, .blue = 0.988523 },
	{ .red = 0.230281, .green = 0.889133, .blue = 0.998779 },
	{ .red = 0.367277, .green = 0.899145, .blue = 0.999267 },
	{ .red = 0.486935, .green = 0.909646, .blue = 0.998535 },
	{ .red = 0.589255, .green = 0.921123, .blue = 0.999023 },
	{ .red = 0.675214, .green = 0.931624, .blue = 0.999756 },
	{ .red = 0.748718, .green = 0.939683, .blue = 0.998535 },
	{ .red = 0.808059, .green = 0.947497, .blue = 0.999023 },
	{ .red = 0.857143, .green = 0.954090, .blue = 0.999756 },
	{ .red = 0.899389, .green = 0.959951, .blue = 0.999023 },
	{ .red = 0.936264, .green = 0.966789, .blue = 0.999512 },
	{ .red = 0.969231, .green = 0.977534, .blue = 0.999756 },
	{ .red = 0.979243, .green = 0.976313, .blue = 0.999023 },
	{ .red = 0.990232, .green = 0.974115, .blue = 0.998779 },
	{ .red = 0.999267, .green = 0.970208, .blue = 0.995849 },
	{ .red = 0.998779, .green = 0.963126, .blue = 0.984615 },
	{ .red = 0.056654, .green = 0.939438, .blue = 0.996093 },
	{ .red = 0.059585, .green = 0.940659, .blue = 0.997558 },
	{ .red = 0.231746, .green = 0.944811, .blue = 0.999023 },
	{ .red = 0.372405, .green = 0.950183, .blue = 0.999512 },
	{ .red = 0.491819, .green = 0.956044, .blue = 0.999512 },
	{ .red = 0.595116, .green = 0.960928, .blue = 0.998535 },
	{ .red = 0.678877, .green = 0.966545, .blue = 0.999267 },
	{ .red = 0.748962, .green = 0.970696, .blue = 0.999267 },
	{ .red = 0.808059, .green = 0.973138, .blue = 0.998046 },
	{ .red = 0.853480, .green = 0.976557, .blue = 0.999023 },
	{ .red = 0.891819, .green = 0.978510, .blue = 0.998779 },
	{ .red = 0.923077, .green = 0.980464, .blue = 0.998779 },
	{ .red = 0.950183, .green = 0.982418, .blue = 0.998779 },
	{ .red = 0.975092, .green = 0.986081, .blue = 0.999512 },
	{ .red = 0.991453, .green = 0.989255, .blue = 0.999512 },
	{ .red = 0.999512, .green = 0.986569, .blue = 0.997802 },
	{ .red = 0.999023, .green = 0.978510, .blue = 0.988034 },
	{ .red = 0.093284, .green = 0.995360, .blue = 0.995360 },
	{ .red = 0.094017, .green = 0.996337, .blue = 0.996337 },
	{ .red = 0.243468, .green = 0.999267, .blue = 0.998779 },
	{ .red = 0.395849, .green = 0.998779, .blue = 0.997314 },
	{ .red = 0.518926, .green = 0.999023, .blue = 0.997070 },
	{ .red = 0.621978, .green = 0.999023, .blue = 0.996581 },
	{ .red = 0.706471, .green = 0.998779, .blue = 0.996337 },
	{ .red = 0.775092, .green = 0.998291, .blue = 0.996337 },
	{ .red = 0.828083, .green = 0.998535, .blue = 0.997070 },
	{ .red = 0.868376, .green = 0.999512, .blue = 0.998535 },
	{ .red = 0.904762, .green = 0.998535, .blue = 0.998046 },
	{ .red = 0.932112, .green = 0.998779, .blue = 0.998535 },
	{ .red = 0.955067, .green = 0.998535, .blue = 0.998779 },
	{ .red = 0.973871, .green = 0.998779, .blue = 0.999023 },
	{ .red = 0.988278, .green = 0.999267, .blue = 0.999512 },
	{ .red = 1.000000, .green = 0.999756, .blue = 1.000000 },
	{ .red = 1.000000, .green = 0.989011, .blue = 0.989744 },
	{ .red = 0.132357, .green = 0.993651, .blue = 0.945299 },
	{ .red = 0.139683, .green = 0.998779, .blue = 0.949939 },
	{ .red = 0.257143, .green = 0.998535, .blue = 0.951160 },
	{ .red = 0.369963, .green = 0.998779, .blue = 0.953602 },
	{ .red = 0.473993, .green = 0.999267, .blue = 0.957265 },
	{ .red = 0.568254, .green = 0.999267, .blue = 0.960928 },
	{ .red = 0.650305, .green = 0.999023, .blue = 0.964591 },
	{ .red = 0.719658, .green = 0.998779, .blue = 0.968254 },
	{ .red = 0.777045, .green = 0.998535, .blue = 0.971673 },
	{ .red = 0.823443, .green = 0.998779, .blue = 0.974847 },
	{ .red = 0.861050, .green = 0.999023, .blue = 0.977778 },
	{ .red = 0.893284, .green = 0.998779, .blue = 0.979731 },
	{ .red = 0.920879, .green = 0.998046, .blue = 0.980952 },
	{ .red = 0.942857, .green = 0.998046, .blue = 0.981929 },
	{ .red = 0.960440, .green = 0.999267, .blue = 0.982173 },
	{ .red = 0.980220, .green = 0.999756, .blue = 0.981929 },
	{ .red = 0.998779, .green = 0.997070, .blue = 0.965568 },
	{ .red = 0.070330, .green = 0.183883, .blue = 0.997802 },
	{ .red = 0.090842, .green = 0.157753, .blue = 0.999267 },
	{ .red = 0.143590, .green = 0.090842, .blue = 0.999512 },
	{ .red = 0.214896, .green = 0.106716, .blue = 0.998535 },
	{ .red = 0.287912, .green = 0.123321, .blue = 0.999023 },
	{ .red = 0.360928, .green = 0.135043, .blue = 0.999267 },
	{ .red = 0.433211, .green = 0.142369, .blue = 0.998535 },
	{ .red = 0.503785, .green = 0.145055, .blue = 0.998779 },
	{ .red = 0.570696, .green = 0.139927, .blue = 0.998535 },
	{ .red = 0.634432, .green = 0.133089, .blue = 0.998291 },
	{ .red = 0.695482, .green = 0.121123, .blue = 0.999512 },
	{ .red = 0.751893, .green = 0.101832, .blue = 0.999512 },
	{ .red = 0.804884, .green = 0.080342, .blue = 0.998291 },
	{ .red = 0.849328, .green = 0.043223, .blue = 0.990965 },
	{ .red = 0.897436, .green = 0.040049, .blue = 0.989499 },
	{ .red = 0.939683, .green = 0.051770, .blue = 0.983883 },
	{ .red = 0.992430, .green = 0.028816, .blue = 0.991941 },
	{ .red = 0.082295, .green = 0.205372, .blue = 0.998291 },
	{ .red = 0.099634, .green = 0.184615, .blue = 0.999023 },
	{ .red = 0.148230, .green = 0.134799, .blue = 0.999023 },
	{ .red = 0.218803, .green = 0.145299, .blue = 0.999023 },
	{ .red = 0.291575, .green = 0.158242, .blue = 0.998779 },
	{ .red = 0.364835, .green = 0.167766, .blue = 0.999267 },
	{ .red = 0.437118, .green = 0.174603, .blue = 0.998535 },
	{ .red = 0.507937, .green = 0.177778, .blue = 0.998535 },
	{ .red = 0.575336, .green = 0.175336, .blue = 0.999023 },
	{ .red = 0.639316, .green = 0.170940, .blue = 0.998779 },
	{ .red = 0.699389, .green = 0.163614, .blue = 0.998779 },
	{ .red = 0.756288, .green = 0.151404, .blue = 0.999267 },
	{ .red = 0.809280, .green = 0.139683, .blue = 0.998779 },
	{ .red = 0.859585, .green = 0.121856, .blue = 0.999023 },
	{ .red = 0.909402, .green = 0.118681, .blue = 0.999512 },
	{ .red = 0.956288, .green = 0.117949, .blue = 0.999023 },
	{ .red = 0.995604, .green = 0.116972, .blue = 0.992918 },
	{ .red = 0.110379, .green = 0.256899, .blue = 0.998046 },
	{ .red = 0.132601, .green = 0.259585, .blue = 0.998291 },
	{ .red = 0.168254, .green = 0.226374, .blue = 0.999756 },
	{ .red = 0.234921, .green = 0.232967, .blue = 0.998535 },
	{ .red = 0.306716, .green = 0.242002, .blue = 0.999023 },
	{ .red = 0.379243, .green = 0.249084, .blue = 0.999267 },
	{ .red = 0.451770, .green = 0.255922, .blue = 0.998535 },
	{ .red = 0.522833, .green = 0.260317, .blue = 0.998779 },
	{ .red = 0.590476, .green = 0.261783, .blue = 0.998535 },
	{ .red = 0.654701, .green = 0.260806, .blue = 0.999023 },
	{ .red = 0.714286, .green = 0.258852, .blue = 0.998291 },
	{ .red = 0.770696, .green = 0.253968, .blue = 0.999023 },
	{ .red = 0.823443, .green = 0.248352, .blue = 0.999512 },
	{ .red = 0.872527, .green = 0.240049, .blue = 0.999267 },
	{ .red = 0.920391, .green = 0.237118, .blue = 0.999512 },
	{ .red = 0.965812, .green = 0.234921, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.232967, .blue = 0.988278 },
	{ .red = 0.133089, .green = 0.302320, .blue = 0.999023 },
	{ .red = 0.193651, .green = 0.357509, .blue = 0.998779 },
	{ .red = 0.213675, .green = 0.332601, .blue = 0.998779 },
	{ .red = 0.270574, .green = 0.335287, .blue = 0.998535 },
	{ .red = 0.337485, .green = 0.342125, .blue = 0.998535 },
	{ .red = 0.408059, .green = 0.349206, .blue = 0.999512 },
	{ .red = 0.478877, .green = 0.355067, .blue = 0.999267 },
	{ .red = 0.548718, .green = 0.360928, .blue = 0.998291 },
	{ .red = 0.615873, .green = 0.364347, .blue = 0.999023 },
	{ .red = 0.679121, .green = 0.366789, .blue = 0.999023 },
	{ .red = 0.737729, .green = 0.366789, .blue = 0.998535 },
	{ .red = 0.793407, .green = 0.366300, .blue = 0.999756 },
	{ .red = 0.842979, .green = 0.362637, .blue = 0.998291 },
	{ .red = 0.890354, .green = 0.357509, .blue = 0.998535 },
	{ .red = 0.936020, .green = 0.353846, .blue = 0.999512 },
	{ .red = 0.978999, .green = 0.350183, .blue = 0.999756 },
	{ .red = 0.998779, .green = 0.347253, .blue = 0.977778 },
	{ .red = 0.093040, .green = 0.288156, .blue = 0.998046 },
	{ .red = 0.226618, .green = 0.412210, .blue = 0.999023 },
	{ .red = 0.288400, .green = 0.444933, .blue = 0.999023 },
	{ .red = 0.329426, .green = 0.441758, .blue = 0.999756 },
	{ .red = 0.387546, .green = 0.447131, .blue = 0.998535 },
	{ .red = 0.451526, .green = 0.453480, .blue = 0.998535 },
	{ .red = 0.518437, .green = 0.459829, .blue = 0.998779 },
	{ .red = 0.584615, .green = 0.465446, .blue = 0.999023 },
	{ .red = 0.648596, .green = 0.470330, .blue = 0.998535 },
	{ .red = 0.709402, .green = 0.474237, .blue = 0.999023 },
	{ .red = 0.765812, .green = 0.476190, .blue = 0.999267 },
	{ .red = 0.817338, .green = 0.476435, .blue = 0.998535 },
	{ .red = 0.865201, .green = 0.474481, .blue = 0.998535 },
	{ .red = 0.909646, .green = 0.470085, .blue = 0.999267 },
	{ .red = 0.950672, .green = 0.465446, .blue = 0.998535 },
	{ .red = 0.990965, .green = 0.460317, .blue = 0.999267 },
	{ .red = 0.998779, .green = 0.456410, .blue = 0.968010 },
	{ .red = 0.077411, .green = 0.331380, .blue = 0.993407 },
	{ .red = 0.165812, .green = 0.384127, .blue = 0.998535 },
	{ .red = 0.389988, .green = 0.559707, .blue = 0.998535 },
	{ .red = 0.407326, .green = 0.546032, .blue = 0.998535 },
	{ .red = 0.454701, .green = 0.550427, .blue = 0.998779 },
	{ .red = 0.509646, .green = 0.555800, .blue = 0.999023 },
	{ .red = 0.567766, .green = 0.561416, .blue = 0.997802 },
	{ .red = 0.627839, .green = 0.567033, .blue = 0.999023 },
	{ .red = 0.685958, .green = 0.572161, .blue = 0.998779 },
	{ .red = 0.741148, .green = 0.575580, .blue = 0.998291 },
	{ .red = 0.793651, .green = 0.578266, .blue = 0.999512 },
	{ .red = 0.840781, .green = 0.578999, .blue = 0.998291 },
	{ .red = 0.884982, .green = 0.577289, .blue = 0.999023 },
	{ .red = 0.926007, .green = 0.573382, .blue = 0.999756 },
	{ .red = 0.963614, .green = 0.567521, .blue = 0.999267 },
	{ .red = 0.998291, .green = 0.561172, .blue = 0.997802 },
	{ .red = 0.999023, .green = 0.556532, .blue = 0.963370 },
	{ .red = 0.039560, .green = 0.384371, .blue = 0.989499 },
	{ .red = 0.142369, .green = 0.418803, .blue = 0.998535 },
	{ .red = 0.308425, .green = 0.517216, .blue = 0.998046 },
	{ .red = 0.503053, .green = 0.648596, .blue = 0.998046 },
	{ .red = 0.531868, .green = 0.645665, .blue = 0.998291 },
	{ .red = 0.575580, .green = 0.650061, .blue = 0.999023 },
	{ .red = 0.623932, .green = 0.654457, .blue = 0.998779 },
	{ .red = 0.674237, .green = 0.658852, .blue = 0.998535 },
	{ .red = 0.724542, .green = 0.663004, .blue = 0.998535 },
	{ .red = 0.773626, .green = 0.666422, .blue = 0.999512 },
	{ .red = 0.819048, .green = 0.668620, .blue = 0.998779 },
	{ .red = 0.861294, .green = 0.668864, .blue = 0.998535 },
	{ .red = 0.901099, .green = 0.667643, .blue = 0.999512 },
	{ .red = 0.937241, .green = 0.663736, .blue = 0.999267 },
	{ .red = 0.970208, .green = 0.657143, .blue = 0.998291 },
	{ .red = 0.999023, .green = 0.650549, .blue = 0.994139 },
	{ .red = 0.998291, .green = 0.645421, .blue = 0.962637 },
	{ .red = 0.046886, .green = 0.449573, .blue = 0.975336 },
	{ .red = 0.131868, .green = 0.475702, .blue = 0.999512 },
	{ .red = 0.275214, .green = 0.535287, .blue = 0.998779 },
	{ .red = 0.451770, .green = 0.634676, .blue = 0.998779 },
	{ .red = 0.612454, .green = 0.730647, .blue = 0.999267 },
	{ .red = 0.642735, .green = 0.731380, .blue = 0.998291 },
	{ .red = 0.680586, .green = 0.734799, .blue = 0.998535 },
	{ .red = 0.720879, .green = 0.737973, .blue = 0.998535 },
	{ .red = 0.762393, .green = 0.741148, .blue = 0.999023 },
	{ .red = 0.803419, .green = 0.743590, .blue = 0.999023 },
	{ .red = 0.841758, .green = 0.745055, .blue = 0.998046 },
	{ .red = 0.878388, .green = 0.745299, .blue = 0.998046 },
	{ .red = 0.913553, .green = 0.743590, .blue = 0.999756 },
	{ .red = 0.944811, .green = 0.739683, .blue = 0.999023 },
	{ .red = 0.974847, .green = 0.733333, .blue = 0.999267 },
	{ .red = 0.999267, .green = 0.726007, .blue = 0.994139 },
	{ .red = 0.998779, .green = 0.720879, .blue = 0.966545 },
	{ .red = 0.029548, .green = 0.525031, .blue = 0.994628 },
	{ .red = 0.130647, .green = 0.539683, .blue = 0.999267 },
	{ .red = 0.266667, .green = 0.581197, .blue = 0.998779 },
	{ .red = 0.411477, .green = 0.644200, .blue = 0.999023 },
	{ .red = 0.571429, .green = 0.725519, .blue = 0.999023 },
	{ .red = 0.706960, .green = 0.799756, .blue = 0.999267 },
	{ .red = 0.734066, .green = 0.800733, .blue = 0.999023 },
	{ .red = 0.765079, .green = 0.802930, .blue = 0.999023 },
	{ .red = 0.797802, .green = 0.804884, .blue = 0.998535 },
	{ .red = 0.830525, .green = 0.806593, .blue = 0.998779 },
	{ .red = 0.862759, .green = 0.807326, .blue = 0.998779 },
	{ .red = 0.894017, .green = 0.807082, .blue = 0.999756 },
	{ .red = 0.922344, .green = 0.805372, .blue = 0.998535 },
	{ .red = 0.949939, .green = 0.801709, .blue = 0.998779 },
	{ .red = 0.976068, .green = 0.795849, .blue = 0.998779 },
	{ .red = 0.999023, .green = 0.788278, .blue = 0.995849 },
	{ .red = 0.998779, .green = 0.783394, .blue = 0.972161 },
	{ .red = 0.057387, .green = 0.588523, .blue = 0.986081 },
	{ .red = 0.130891, .green = 0.603175, .blue = 0.998779 },
	{ .red = 0.261783, .green = 0.633211, .blue = 0.999023 },
	{ .red = 0.395849, .green = 0.678877, .blue = 0.999023 },
	{ .red = 0.528694, .green = 0.732112, .blue = 0.998535 },
	{ .red = 0.660073, .green = 0.790965, .blue = 0.998779 },
	{ .red = 0.783394, .green = 0.854457, .blue = 0.998779 },
	{ .red = 0.804884, .green = 0.854701, .blue = 0.999267 },
	{ .red = 0.829792, .green = 0.855922, .blue = 0.998291 },
	{ .red = 0.855433, .green = 0.856654, .blue = 0.998291 },
	{ .red = 0.881319, .green = 0.857143, .blue = 0.998535 },
	{ .red = 0.906471, .green = 0.856654, .blue = 0.998779 },
	{ .red = 0.931136, .green = 0.854945, .blue = 0.999267 },
	{ .red = 0.954579, .green = 0.851526, .blue = 0.999512 },
	{ .red = 0.976801, .green = 0.846154, .blue = 0.999023 },
	{ .red = 0.998291, .green = 0.838828, .blue = 0.998046 },
	{ .red = 0.999023, .green = 0.834188, .blue = 0.977778 },
	{ .red = 0.065201, .green = 0.652991, .blue = 0.987546 },
	{ .red = 0.130159, .green = 0.664957, .blue = 0.998779 },
	{ .red = 0.258120, .green = 0.686691, .blue = 0.998779 },
	{ .red = 0.386081, .green = 0.720391, .blue = 0.998535 },
	{ .red = 0.508913, .green = 0.759707, .blue = 0.998291 },
	{ .red = 0.622711, .green = 0.800244, .blue = 0.998779 },
	{ .red = 0.726740, .green = 0.840781, .blue = 0.999756 },
	{ .red = 0.843223, .green = 0.896947, .blue = 0.998291 },
	{ .red = 0.858364, .green = 0.895726, .blue = 0.998291 },
	{ .red = 0.877656, .green = 0.895971, .blue = 0.999023 },
	{ .red = 0.897924, .green = 0.895971, .blue = 0.999023 },
	{ .red = 0.918193, .green = 0.895482, .blue = 0.998291 },
	{ .red = 0.938217, .green = 0.893773, .blue = 0.998779 },
	{ .red = 0.957753, .green = 0.891087, .blue = 0.999023 },
	{ .red = 0.977045, .green = 0.886203, .blue = 0.999023 },
	{ .red = 0.996581, .green = 0.879365, .blue = 0.999023 },
	{ .red = 0.998535, .green = 0.874969, .blue = 0.982906 },
	{ .red = 0.066667, .green = 0.716239, .blue = 0.991453 },
	{ .red = 0.130891, .green = 0.724786, .blue = 0.998535 },
	{ .red = 0.255433, .green = 0.740659, .blue = 0.998535 },
	{ .red = 0.378755, .green = 0.765568, .blue = 0.998779 },
	{ .red = 0.494994, .green = 0.794872, .blue = 0.999756 },
	{ .red = 0.601709, .green = 0.823932, .blue = 0.998046 },
	{ .red = 0.695482, .green = 0.852747, .blue = 0.999512 },
	{ .red = 0.778510, .green = 0.879365, .blue = 0.998779 },
	{ .red = 0.863248, .green = 0.913797, .blue = 0.998046 },
	{ .red = 0.897924, .green = 0.926496, .blue = 0.998046 },
	{ .red = 0.912821, .green = 0.926252, .blue = 0.999512 },
	{ .red = 0.928938, .green = 0.925519, .blue = 0.999512 },
	{ .red = 0.945299, .green = 0.924298, .blue = 0.999756 },
	{ .red = 0.961172, .green = 0.922100, .blue = 0.998535 },
	{ .red = 0.977045, .green = 0.918193, .blue = 0.998535 },
	{ .red = 0.993895, .green = 0.912332, .blue = 0.998779 },
	{ .red = 0.999023, .green = 0.907692, .blue = 0.987546 },
	{ .red = 0.082051, .green = 0.774359, .blue = 0.990232 },
	{ .red = 0.133578, .green = 0.781929, .blue = 0.997314 },
	{ .red = 0.252747, .green = 0.794628, .blue = 0.999756 },
	{ .red = 0.373871, .green = 0.811722, .blue = 0.998535 },
	{ .red = 0.485714, .green = 0.833211, .blue = 0.999267 },
	{ .red = 0.587546, .green = 0.854701, .blue = 0.998535 },
	{ .red = 0.676190, .green = 0.875214, .blue = 0.999023 },
	{ .red = 0.752381, .green = 0.893529, .blue = 0.998779 },
	{ .red = 0.817827, .green = 0.910867, .blue = 0.999512 },
	{ .red = 0.876923, .green = 0.928938, .blue = 0.999023 },
	{ .red = 0.927228, .green = 0.949695, .blue = 0.999023 },
	{ .red = 0.938950, .green = 0.948962, .blue = 0.998535 },
	{ .red = 0.951648, .green = 0.947985, .blue = 0.999023 },
	{ .red = 0.964835, .green = 0.946520, .blue = 0.999023 },
	{ .red = 0.978266, .green = 0.943590, .blue = 0.998779 },
	{ .red = 0.992918, .green = 0.938706, .blue = 0.999512 },
	{ .red = 0.999267, .green = 0.934066, .blue = 0.991453 },
	{ .red = 0.082295, .green = 0.832967, .blue = 0.993407 },
	{ .red = 0.131380, .green = 0.839072, .blue = 0.999023 },
	{ .red = 0.254457, .green = 0.846398, .blue = 0.998291 },
	{ .red = 0.370940, .green = 0.859341, .blue = 0.999267 },
	{ .red = 0.480830, .green = 0.874237, .blue = 0.999267 },
	{ .red = 0.579976, .green = 0.888400, .blue = 0.997802 },
	{ .red = 0.664957, .green = 0.902808, .blue = 0.998046 },
	{ .red = 0.736752, .green = 0.915751, .blue = 0.998779 },
	{ .red = 0.798291, .green = 0.926740, .blue = 0.998535 },
	{ .red = 0.849817, .green = 0.936996, .blue = 0.999023 },
	{ .red = 0.895238, .green = 0.947009, .blue = 0.998779 },
	{ .red = 0.948230, .green = 0.966545, .blue = 0.998779 },
	{ .red = 0.958486, .green = 0.966545, .blue = 0.999023 },
	{ .red = 0.968742, .green = 0.965568, .blue = 0.999267 },
	{ .red = 0.979976, .green = 0.963370, .blue = 0.999512 },
	{ .red = 0.991209, .green = 0.959951, .blue = 0.998779 },
	{ .red = 0.998779, .green = 0.955556, .blue = 0.993651 },
	{ .red = 0.100855, .green = 0.887424, .blue = 0.992674 },
	{ .red = 0.133578, .green = 0.893529, .blue = 0.999023 },
	{ .red = 0.255678, .green = 0.898413, .blue = 0.998779 },
	{ .red = 0.371673, .green = 0.906960, .blue = 0.999756 },
	{ .red = 0.481319, .green = 0.915995, .blue = 0.998535 },
	{ .red = 0.577289, .green = 0.925519, .blue = 0.998535 },
	{ .red = 0.658852, .green = 0.935531, .blue = 0.999756 },
	{ .red = 0.729426, .green = 0.942857, .blue = 0.999267 },
	{ .red = 0.788034, .green = 0.949695, .blue = 0.999023 },
	{ .red = 0.837118, .green = 0.955067, .blue = 0.998779 },
	{ .red = 0.877411, .green = 0.960440, .blue = 0.999512 },
	{ .red = 0.912821, .green = 0.965079, .blue = 0.999023 },
	{ .red = 0.944567, .green = 0.970940, .blue = 0.999512 },
	{ .red = 0.973382, .green = 0.980464, .blue = 1.000000 },
	{ .red = 0.981929, .green = 0.979243, .blue = 0.999023 },
	{ .red = 0.991209, .green = 0.977045, .blue = 0.998535 },
	{ .red = 0.999023, .green = 0.973138, .blue = 0.996093 },
	{ .red = 0.094017, .green = 0.943101, .blue = 0.995604 },
	{ .red = 0.147253, .green = 0.945299, .blue = 0.997314 },
	{ .red = 0.258364, .green = 0.950183, .blue = 0.999756 },
	{ .red = 0.379243, .green = 0.953846, .blue = 0.999267 },
	{ .red = 0.487668, .green = 0.958974, .blue = 0.999023 },
	{ .red = 0.582662, .green = 0.963858, .blue = 0.999023 },
	{ .red = 0.664225, .green = 0.968254, .blue = 0.999023 },
	{ .red = 0.731868, .green = 0.972161, .blue = 0.999267 },
	{ .red = 0.788523, .green = 0.975092, .blue = 0.999023 },
	{ .red = 0.835653, .green = 0.977289, .blue = 0.998535 },
	{ .red = 0.873260, .green = 0.979731, .blue = 0.999267 },
	{ .red = 0.905739, .green = 0.981197, .blue = 0.998779 },
	{ .red = 0.932112, .green = 0.982906, .blue = 0.999023 },
	{ .red = 0.955800, .green = 0.984371, .blue = 0.998779 },
	{ .red = 0.977778, .green = 0.987546, .blue = 0.999512 },
	{ .red = 0.992430, .green = 0.990476, .blue = 0.999512 },
	{ .red = 0.999756, .green = 0.987546, .blue = 0.998046 },
	{ .red = 0.094261, .green = 0.996825, .blue = 0.996825 },
	{ .red = 0.148962, .green = 0.998779, .blue = 0.998535 },
	{ .red = 0.276679, .green = 0.999267, .blue = 0.998535 },
	{ .red = 0.403663, .green = 0.998779, .blue = 0.997070 },
	{ .red = 0.513797, .green = 0.999267, .blue = 0.996825 },
	{ .red = 0.611233, .green = 0.998779, .blue = 0.996093 },
	{ .red = 0.691575, .green = 0.998535, .blue = 0.996093 },
	{ .red = 0.756532, .green = 0.999023, .blue = 0.996825 },
	{ .red = 0.811233, .green = 0.998535, .blue = 0.996825 },
	{ .red = 0.853480, .green = 0.998779, .blue = 0.997558 },
	{ .red = 0.886935, .green = 0.999267, .blue = 0.998535 },
	{ .red = 0.917216, .green = 0.998535, .blue = 0.998291 },
	{ .red = 0.940415, .green = 0.998779, .blue = 0.998779 },
	{ .red = 0.960440, .green = 0.998535, .blue = 0.998779 },
	{ .red = 0.976557, .green = 0.998779, .blue = 0.999023 },
	{ .red = 0.989499, .green = 0.999267, .blue = 0.999512 },
	{ .red = 1.000000, .green = 0.999756, .blue = 1.000000 },
} };

#endif
