/*
   This file is part of KDE/aRts (Noatun) - xine integration
   Copyright (C) 2002 Ewald Snel <ewald@rambo.its.tudelft.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
*/

#ifndef __AUDIO_FIFO_OUT_H
#define __AUDIO_FIFO_OUT_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    int32_t	sample_rate;
    uint32_t	num_channels;
    uint32_t	bits_per_sample;
} xine_arts_audio;


ao_driver_t *init_audio_out_plugin( config_values_t *config, xine_arts_audio *audio );

int ao_fifo_arts_delay();

unsigned long ao_fifo_read( ao_driver_t *this_gen, unsigned char **buffer,
			    unsigned long samples );

void ao_fifo_flush( ao_driver_t *ao, unsigned long samples );

void ao_fifo_wait_close( ao_driver_t *this_gen );

#ifdef __cplusplus
}
#endif

#endif
