/***************************************************************************
                            KKeyChooser.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KKEYCHOOSER_H
#define KKEYCHOOSER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Configure dictionaries of key/action associations for KAccel and
 KGlobalAccel.

 The class takes care of all aspects of configuration, including
 handling key conflicts internally. Connect to the @ref -allDefault
 slot if you want to set all configurable shortcuts to their
 default values.

 @author Nicolas Hadacek <hadacek@via.ecp.fr>
 
 @version $Id: KKeyChooser.h,v 1.5 2002/04/15 21:17:11 rdale Exp $

 @short Widget for configuration of @ref KAccel and @ref KGlobalAccel.

*/

@class KActionCollection;
@class KAccel;
@class KGlobalAccel;
@class KConfigBase;
@class KShortcut;
@class QListViewItem;

@interface KKeyChooser : QWidget 

/** 
 Constructor.

*/
- initWithWidget: (QWidget *)parent type: (int)type bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts;
- initWithWidget: (QWidget *)parent ;
- initWithActionCollection: (KActionCollection*)coll parent: (QWidget *)parent bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts;
- initWithActionCollection: (KActionCollection*)coll parent: (QWidget *)parent ;
- initWithAccel: (KAccel*)actions parent: (QWidget *)parent bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts;
- initWithAccel: (KAccel*)actions parent: (QWidget *)parent ;
- initWithGlobalAccel: (KGlobalAccel*)actions parent: (QWidget *)parent;
//- initWithShortcutList: (KShortcutList*)arg1 parent: (QWidget *)parent type: (int)type bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts;
//- initWithShortcutList: (KShortcutList*)arg1 parent: (QWidget *)parent ;
- (void) dealloc;

/** 
 Insert an action collection, i.e. add all its actions to the ones
 already associated with the KKeyChooser object.
	 
*/
- (BOOL) insertActionCollection: (KActionCollection*)arg1;
- syncToConfig: (NSString *)sConfigGroup pConfig: (KConfigBase*)pConfig bClearUnset: (BOOL)bClearUnset;

/** 
 This function writes any shortcut changes back to the original
 action set(s).
	 
*/
- commitChanges;

/** 
 This commits and then saves the actions to disk.
 Any KActionCollection objects with the -xmlFile value set
 will be written to an xml file.  All other will be written
 to the application's rc file.
	 
*/
- save;

/** 
 @obsolete
	 
*/
- initWithAccel: (KAccel*)actions parent: (QWidget *)parent bCheckAgainstStdKeys: (BOOL)bCheckAgainstStdKeys bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts bAllowWinKey: (BOOL)bAllowWinKey;
- initWithAccel: (KAccel*)actions parent: (QWidget *)parent bCheckAgainstStdKeys: (BOOL)bCheckAgainstStdKeys bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts ;

/** 
 @obsolete
	 
*/
- initWithGlobalAccel: (KGlobalAccel*)actions parent: (QWidget *)parent bCheckAgainstStdKeys: (BOOL)bCheckAgainstStdKeys bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts bAllowWinKey: (BOOL)bAllowWinKey;
- initWithGlobalAccel: (KGlobalAccel*)actions parent: (QWidget *)parent bCheckAgainstStdKeys: (BOOL)bCheckAgainstStdKeys bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts ;

/** 
 Set all keys to their default values (bindings).

*/
- allDefault;

/** 
 Specifies whether to use the 3 or 4 modifier key scheme.
 This determines which default is used when the 'Default' button is
 clicked.
	 
*/
- setPreferFourModifierKeys: (BOOL)preferFourModifierKeys;

/** 
 Rebuild list entries based on underlying map.
 Use this if you changed the underlying map.
	 
*/
- listSync;
- initGUI: (int)type bAllowLetterShortcuts: (BOOL)bAllowLetterShortcuts;
- (BOOL) insertAccel: (KAccel*)arg1;
- (BOOL) insertGlobalAccel: (KGlobalAccel*)arg1;
//- (BOOL) insert: (KShortcutList*)arg1;
- buildListView: (unsigned int)iList;
- readGlobalKeys;
- updateButtons;
- fontChange: (QFont *)_font;
- setShortcut: (KShortcut*)cut;
- (BOOL) isKeyPresent: (KShortcut*)cut warnuser: (BOOL)warnuser;
- (BOOL) isKeyPresent: (KShortcut*)cut ;
//- _warning: (KKeySequence*)seq sAction: (NSString *)sAction sTitle: (NSString *)sTitle;
- virtual_hook: (int)identifier data: (void*)data;
- slotNoKey;
- slotDefaultKey;
- slotCustomKey;
- slotListItemSelected: (QListViewItem *)item;
- capturedShortcut: (KShortcut*)cut;
+ (int) Application;
+ (int) ApplicationGlobal;
+ (int) Standard;
+ (int) Global;
+ (int) NoKey;
+ (int) DefaultKey;
+ (int) CustomKey;
@end

/** Override these methods in subclasses of KKeyChooser to customise event handling behaviour */
@protocol KKeyChooserEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
