package org.kde.koala;
import org.kde.qt.*;


/** {@link KScanDialog} emits these signals */
public interface KScanDialogSignals {

/** 
 The OK button was pressed. This signal is only emitted if
 {@link KScanDialog#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The Try button was pressed. This signal is only emitted if
 {@link KScanDialog#slotTry} is not replaced.
     
*/
	void tryClicked();

/** 
 Informs you that an image has scanned. <code>id</code> is the same as in the
 <code>preview</code>() signal, if this image had been previewed before.

 Note, that those id's may not be properly implemented in the current
 libkscan.
     
*/
	void finalImage( QImage arg1, int identifier );

/** 
 The Yes button was pressed. This signal is only emitted if
 {@link KScanDialog#slotYes} is not replaced.
     
*/
	void yesClicked();

/** 
 Informs you that the image with the id <code>id</code> has been run through
 text-recognition. The text is in the String parameter. In the future,
 a compound document, using rich text will be used instead.
     
*/
	void textRecognized( String arg1, int identifier );
	void destroyed( QObject obj );

/** 
 The No button was pressed. This signal is only emitted if
 {@link KScanDialog#slotNo} is not replaced.
     
*/
	void noClicked();

/** 
 The Apply button was pressed. This signal is only emitted if
 {@link KScanDialog#slotApply} is not replaced.
     
*/
	void applyClicked();

/** 
 The Close button was pressed. This signal is only emitted if
 {@link KScanDialog#slotClose} is not replaced.
     
*/
	void closeClicked();

/** 
 Informs you that an image has been previewed.
     
*/
	void preview( QImage arg1, int identifier );

/** 
 The User3 button was pressed. This signal is only emitted if
 {@link KScanDialog#slotUser3} is not replaced.
     
*/
	void user3Clicked();

/** 
 Emitted when the margin size and/or spacing size
 have changed.

 Use {@link KScanDialog#marginHint} and  {@link KScanDialog#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/** 
 A page is about to be shown.
     
*/
	void aboutToShowPage( QWidget page );

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KScanDialog#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KScanDialog#delayedDestruct} instead.
     
*/
	void finished();

/** 
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/** 
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KScanDialog#applyClicked} instead.
     
*/
	void apply();

/** 
 The User2 button was pressed. This signal is only emitted if
 {@link KScanDialog#slotUser2} is not replaced.
     
*/
	void user2Clicked();

/** 
 The Cancel button was pressed. This signal is only emitted if
 {@link KScanDialog#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/** 
 The Default button was pressed. This signal is only emitted if
 {@link KScanDialog#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/** 
 The User1 button was pressed. This signal is only emitted if
 {@link KScanDialog#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/** 
 The background tile has changed.
     
*/
	void backgroundChanged();

/** 
 The Help button was pressed. This signal is only emitted if
 {@link KScanDialog#slotHelp} is not replaced.
     
*/
	void helpClicked();
}

