#include <qwmatrix.h>

static void pyqt_qwmatrix_free( void* ptr )
{
    delete (QWMatrix*)ptr;
}

static QWMatrix* pyqt_qwmatrix_toCpp( PyObject* obj )
{
    return (QWMatrix*)getPointer( obj, WMatrix );
}

static PyObject* pyqt_qwmatrix_toPython( const QWMatrix& ptr )
{
    return qobjectToPython( new QWMatrix( ptr ), WMatrix );
}

static PyObject* pyqt_qwmatrix_constructor( void* /* ptr */, PyObject* obj, PyObject* arg_tuple )
{
    qDebug("Matrix 1");
    if ( !obj )
        return NULL;
    qDebug("Matrix 2");
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	void* ptr = new QWMatrix;
        mapObject( obj, ptr, pyqt_qwmatrix_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    qDebug("Matrix 3");
    PyObject* _0param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_0param )  && inherits( _0param, WMatrix ) )
    {
	PyErr_Clear();
        void* ptr = new QWMatrix( *pyqt_qwmatrix_toCpp( _0param ) );
        mapObject( obj, ptr, pyqt_qwmatrix_class, Python );
        Py_INCREF( Py_None );
        return Py_None;
    }
    double _1param;
    double _2param;
    double _3param;
    double _4param;
    double _5param;
    double _6param;
    if ( PyTuple_Size( arg_tuple ) == 6 &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 0 ) ) &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 1 ) ) &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 2 ) ) &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 3 ) ) &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 4 ) ) &&
	 PyFloat_Check( PyTuple_GetItem( arg_tuple, 5 ) ) )
    // if ( PyArg_ParseTuple( arg_tuple, "dddddd", &_1param, &_2param, &_3param, &_4param, &_5param, &_6param )  )
    {
	_1param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 0 ) );
	_2param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 1 ) );
	_3param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 2 ) );
	_4param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 3 ) );
	_5param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 4 ) );	
	_6param = PyFloat_AsDouble( PyTuple_GetItem( arg_tuple, 5 ) );
	
	qDebug("Matrix 5");
	PyErr_Clear();
        void* ptr = new QWMatrix( _1param, _2param, _3param, _4param, _5param, _6param );
        mapObject( obj, ptr, pyqt_qwmatrix_class, Python );
	qDebug("Matrix 6");
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_shear( void* ptr, PyObject* obj, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    double _0param;
    double _1param;
    if ( PyArg_ParseTuple( arg_tuple, "dd", &_0param, &_1param )  )
    {
	((QWMatrix*)ptr)->shear(_0param, _1param);
        Py_INCREF( obj );
        return obj;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_invert( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
         return pyqt_qwmatrix_toPython( ((QWMatrix*)ptr)->invert() );
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_translate( void* ptr, PyObject* obj, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    double _0param;
    double _1param;
    if ( PyArg_ParseTuple( arg_tuple, "dd", &_0param, &_1param )  )
    {
	((QWMatrix*)ptr)->translate(_0param, _1param);
        Py_INCREF( obj );
        return obj;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_setMatrix( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    double _0param;
    double _1param;
    double _2param;
    double _3param;
    double _4param;
    double _5param;
    if ( PyArg_ParseTuple( arg_tuple, "dddddd", &_0param, &_1param, &_2param, &_3param, &_4param, &_5param )  )
    {
	((QWMatrix*)ptr)->setMatrix(_0param, _1param, _2param, _3param, _4param, _5param);
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_isInvertable( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	bool ok = TRUE;
	((QWMatrix*)ptr)->invert( &ok );
	return Py_BuildValue("b", (char)ok );
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_matrix( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	PyObject* l = PyList_New( 6 );
	PyList_SetItem( l, 0, PyFloat_FromDouble( ((QWMatrix*)ptr)->m11() ) );
	PyList_SetItem( l, 1, PyFloat_FromDouble( ((QWMatrix*)ptr)->m12() ) );
	PyList_SetItem( l, 2, PyFloat_FromDouble( ((QWMatrix*)ptr)->m21() ) );	
	PyList_SetItem( l, 3, PyFloat_FromDouble( ((QWMatrix*)ptr)->m22() ) );
	PyList_SetItem( l, 4, PyFloat_FromDouble( ((QWMatrix*)ptr)->dx() ) );	
	PyList_SetItem( l, 5, PyFloat_FromDouble( ((QWMatrix*)ptr)->dy() ) );
	return l;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_rotate( void* ptr, PyObject* obj, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    double _0param;
    if ( PyArg_ParseTuple( arg_tuple, "d", &_0param )  )
    {
	((QWMatrix*)ptr)->rotate(_0param);
        Py_INCREF( obj );
        return obj;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_scale( void* ptr, PyObject* obj, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    double _0param;
    double _1param;
    if ( PyArg_ParseTuple( arg_tuple, "dd", &_0param, &_1param )  )
    {
         ((QWMatrix*)ptr)->scale(_0param, _1param);
        Py_INCREF( obj );
        return obj;
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_map( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    int _0param;
    int _1param;
    if ( PyArg_ParseTuple( arg_tuple, "ii", &_0param, &_1param )  )
    {
	int a, b;
	((QWMatrix*)ptr)->map(_0param, _1param, &a, &b );
	PyObject* l = PyList_New( 2 );
	PyList_SetItem( l, 0, PyInt_FromLong( a ) );
	PyList_SetItem( l, 1, PyInt_FromLong( b ) );
	return l;
    }
    double _2param;
    double _3param;
    if ( PyArg_ParseTuple( arg_tuple, "dd", &_2param, &_3param )  )
    {
	PyErr_Clear();
	double a, b;
	((QWMatrix*)ptr)->map(_2param, _3param, &a, &b );
	PyObject* l = PyList_New( 2 );
	PyList_SetItem( l, 0, PyFloat_FromDouble( a ) );
	PyList_SetItem( l, 1, PyFloat_FromDouble( b ) );
	return l;
    }
    PyObject* _4param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_4param )  && inherits( _4param, Point ) )
    {
	PyErr_Clear();
        return pyqt_qpoint_toPython( ((QWMatrix*)ptr)->map(*pyqt_qpoint_toCpp( _4param )) );
    }
    PyObject* _5param = 0;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_5param )  && inherits( _5param, Rect ) )
    {
	PyErr_Clear();
        return pyqt_qrect_toPython( ((QWMatrix*)ptr)->map(*pyqt_qrect_toCpp( _5param )) );
    }
    PyObject* _6param = 0;
    QPointArray _6arr;
    if ( PyArg_ParseTuple( arg_tuple, "O", &_6param )  && pointArrayToCpp( _6param, &_6arr ) )
    {
	PyErr_Clear();
        return pyqt_qpointarray_toPython( ((QWMatrix*)ptr)->map( _6arr ) );
    }
    return NULL;
}

static PyObject* pyqt_qwmatrix_reset( void* ptr, PyObject* /* obj */, PyObject* arg_tuple )
{
    if ( !ptr )
        return NULL;
    if ( PyTuple_Size( arg_tuple ) == 0 )
    {
	((QWMatrix*)ptr)->reset();
        Py_INCREF( Py_None );
        return Py_None;
    }
    return NULL;
}

static PyQt_Method pyqt_qwmatrix_methods[] = {
    pyqt_qwmatrix_constructor,
    pyqt_qwmatrix_shear,
    pyqt_qwmatrix_invert,
    pyqt_qwmatrix_translate,
    pyqt_qwmatrix_setMatrix,
    pyqt_qwmatrix_isInvertable,
    pyqt_qwmatrix_matrix,
    pyqt_qwmatrix_rotate,
    pyqt_qwmatrix_scale,
    pyqt_qwmatrix_map,
    pyqt_qwmatrix_reset,
    0
};

static void pyqt_qwmatrix_init()
{
    if ( pyqt_qwmatrix_class )
        return;

    pyqt_qwmatrix_class = new PyQt_ClassInfo;
    pyqt_qwmatrix_class->freeQt = pyqt_qwmatrix_free;
    pyqt_qwmatrix_class->methods = pyqt_qwmatrix_methods;
    pyqt_qwmatrix_class->methodCount = methodCount( pyqt_qwmatrix_methods );
    pyqt_qwmatrix_class->next = 0;
    pyqt_qwmatrix_class->classid = WMatrix;
    pyqt_qwmatrix_class->classObject = PyDict_GetItemString( pyqt_qt_dict, "QWMatrix" );
    pyqt_qwmatrix_class->className = "QWMatrix";
    ASSERT( pyqt_qwmatrix_class->classObject );
}
