#!/usr/bin/python

import pyqt

#================================================================
# QSize
#================================================================

class QSize:
    def isValid( self ):
        return pyqt.gate( self, 5, 3, () )

    def boundedTo( self, arg0 ):
        return pyqt.gate( self, 5, 4, (arg0,) )

    def transpose( self ):
        pyqt.gate( self, 5, 5, () )

    def isEmpty( self ):
        return pyqt.gate( self, 5, 6, () )

    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 5, 7, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def expandedTo( self, arg0 ):
        return pyqt.gate( self, 5, 8, (arg0,) )

    def isNull( self ):
        return pyqt.gate( self, 5, 9, () )

    def __getattr__( self, name ):
        if name == "height":
            return pyqt.gate( self, 5, 0, () )
        if name == "width":
            return pyqt.gate( self, 5, 2, () )
        return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
        if name == "height":
            pyqt.gate( self, 5, 10, (value,) )
            return
        if name == "width":
            pyqt.gate( self, 5, 1, (value,) )
            return
        self.__dict__[ name ] = value

#================================================================
# QPoint
#================================================================

class QPoint:
    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 6, 0, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def isNull( self ):
        return pyqt.gate( self, 6, 6, () )

    def __getattr__( self, name ):
        if name == "manhattanLength":
            return pyqt.gate( self, 6, 5, () )
        if name == "x":
            return pyqt.gate( self, 6, 3, () )
        if name == "y":
            return pyqt.gate( self, 6, 4, () )
        return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
        if name == "x":
            pyqt.gate( self, 6, 2, (value,) )
            return
        if name == "y":
            pyqt.gate( self, 6, 1, (value,) )
            return
        self.__dict__[ name ] = value

#================================================================
# QRect
#================================================================

class QRect:
    def moveTopLeft( self, arg0 ):
        pyqt.gate( self, 7, 2, (arg0,) )

    def intersect( self, arg0 ):
        return pyqt.gate( self, 7, 7, (arg0,) )

    def isEmpty( self ):
        return pyqt.gate( self, 7, 9, () )

    def contains( self, *args ):
        return pyqt.gate( self, 7, 10, args )

    def moveBy( self, arg0, arg1 ):
        pyqt.gate( self, 7, 11, (arg0, arg1,) )

    def isNull( self ):
        return pyqt.gate( self, 7, 12, () )

    def moveBottomRight( self, arg0 ):
        pyqt.gate( self, 7, 15, (arg0,) )

    def moveCenter( self, arg0 ):
        pyqt.gate( self, 7, 21, (arg0,) )

    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 7, 22, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def normalize( self ):
        return pyqt.gate( self, 7, 24, () )

    def moveBottomLeft( self, arg0 ):
        pyqt.gate( self, 7, 29, (arg0,) )

    def unite( self, arg0 ):
        return pyqt.gate( self, 7, 33, (arg0,) )

    def intersects( self, arg0 ):
        return pyqt.gate( self, 7, 34, (arg0,) )

    def moveTopRight( self, arg0 ):
        pyqt.gate( self, 7, 36, (arg0,) )

    def isValid( self ):
        return pyqt.gate( self, 7, 37, () )

    def setBottom( self, arg0 ):
        pyqt.gate( self, 7, 38, (arg0,) )

    def __repr__( self ):
	return "QRect(%i,%i,%i,%i)" % ( self.left, self.top, self.width, self.height )
    def __str__( self ):
	return "QRect(%i,%i,%i,%i)" % ( self.left, self.top, self.width, self.height )

    def __getattr__( self, name ):
        if name == "left":
            return pyqt.gate( self, 7, 0, () )
        if name == "x":
            return pyqt.gate( self, 7, 5, () )
        if name == "y":
            return pyqt.gate( self, 7, 6, () )
        if name == "width":
            return pyqt.gate( self, 7, 30, () )
        if name == "height":
            return pyqt.gate( self, 7, 23, () )
        if name == "topRight":
            return pyqt.gate( self, 7, 14, () )
        if name == "top":
            return pyqt.gate( self, 7, 16, () )
        if name == "bottom":
            return pyqt.gate( self, 7, 17, () )
        if name == "bottomRight":
            return pyqt.gate( self, 7, 18, () )
        if name == "center":
            return pyqt.gate( self, 7, 19, () )
        if name == "bottomLeft":
            return pyqt.gate( self, 7, 20, () )
        if name == "right":
            return pyqt.gate( self, 7, 40, () )
        if name == "size":
            return pyqt.gate( self, 7, 25, () )
        if name == "topLeft":
            return pyqt.gate( self, 7, 41, () )
        if name == "rect":
            return pyqt.gate( self, 7, 26, () )
        if name == "coords":
            return pyqt.gate( self, 7, 4, () )

        return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
        if name == "left":
            pyqt.gate( self, 7, 28, (value,) )
            return
        if name == "top":
            pyqt.gate( self, 7, 35, (value,) )
            return
        if name == "x":
            pyqt.gate( self, 7, 8, (value,) )
            return
        if name == "y":
            pyqt.gate( self, 7, 27, (value,) )
            return
        if name == "size":
            pyqt.gate( self, 7, 32, (value,) )
            return
        if name == "right":
            pyqt.gate( self, 7, 13, (value,) )
            return
        if name == "width":
            pyqt.gate( self, 7, 31, (value,) )
            return
        if name == "height":
            pyqt.gate( self, 7, 39, (value,) )
            return
        if name == "rect":
            pyqt.gate( self, 7, 1, value )
            return
        if name == "coords":
            pyqt.gate( self, 7, 3, value )
            return
        self.__dict__[ name ] = value

#================================================================
# QFont
#================================================================

class QFont:
    def exactMatch( self ):
        return pyqt.gate( self, 8, 32, () )

    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 8, 33, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def isCopyOf( self, arg0 ):
        return pyqt.gate( self, 8, 39, (arg0,) )

    def __getattr__( self, name ):
        if QFont_readattr.has_key( name ):
            return pyqt.gate( self, 8, QFont_readattr[ name ], () )
        else:
            return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
        if QFont_writeattr.has_key( name ):
            pyqt.gate( self, 8, QFont_writeattr[ name ], (value,) )
        else:
            self.__dict__[ name ] = value

QFont_readattr = {  "underline":23,  "pixelSize":3,  "rawMode":26,  "italic":6,  "fixedPitch":9,  "weight":34,  "pointSizeFloat":31,  "charSet":17,  "key":27,  "family":20,  "bold":35,  "pointSize":36,  "strikeOut":37,  "styleHint":1,  "rawName":0,  }
QFont_writeattr = {  "underline":4,  "pixelSize":21,  "rawMode":18,  "italic":25,  "weight":14,  "fixedPitch":28,  "pixelSizeFloat":30,  "pointSizeFloat":10,  "charSet":24,  "family":7,  "bold":16,  "pointSize":19,  "strikeOut":13,  "styleHint":15,  "rawName":12,  }

def QFont_removeSubstitution( arg0 ):
    pyqt.static_gate( 8, 2, (arg0,) )
def QFont_encodingName( arg0 ):
    return pyqt.static_gate( 8, 5, (arg0,) )
def QFont_defaultFont():
    return pyqt.static_gate( 8, 8, () )
def QFont_substitutions():
    return pyqt.static_gate( 8, 11, () )
def QFont_substitute( arg0 ):
    return pyqt.static_gate( 8, 22, (arg0,) )
def QFont_setDefaultFont( arg0 ):
    pyqt.static_gate( 8, 29, (arg0,) )
def QFont_insertSubstitution( arg0, arg1 ):
    pyqt.static_gate( 8, 38, (arg0, arg1,) )

#================================================================
# QColor
#================================================================

class QColor:
    def light( self, arg0 ):
        return pyqt.gate( self, 9, 8, (arg0,) )

    def name( self ):
        return pyqt.gate( self, 9, 10, () )

    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 9, 12, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def dark( self, arg0 ):
        return pyqt.gate( self, 9, 17, (arg0,) )

    def isDirty( self ):
        return pyqt.gate( self, 9, 18, () )

    def isValid( self ):
        return pyqt.gate( self, 9, 21, () )

    def __getattr__( self, name ):
        if QColor_readattr.has_key( name ):
            return pyqt.gate( self, 9, QColor_readattr[ name ], () )
	if name == "hsv":
	    return pyqt.gate( self, 9, 16, () )
	if name == "rgb":
	    return pyqt.gate( self, 9, 4, () )
	return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
	if name == "rgb":
	    pyqt.gate( self, 9, 14, value )
	    return
	if name == "hsv":
	    pyqt.gate( self, 9, 5, value )
	    return
        if QColor_writeattr.has_key( name ):
            pyqt.gate( self, 9, QColor_writeattr[ name ], (value,) )
        else:
            self.__dict__[ name ] = value

QColor_readattr = {  "red":1,  "pixel":2,  "green":3,  "alloc":11,  "blue":6,  }
QColor_writeattr = {  "name":15,  }

def QColor_maxColors():
    return pyqt.static_gate( 9, 0, () )
def QColor_enterAllocContext():
    return pyqt.static_gate( 9, 7, () )
def QColor_lazyAlloc():
    return pyqt.static_gate( 9, 9, () )
def QColor_leaveAllocContext():
    pyqt.static_gate( 9, 13, () )
def QColor_setLazyAlloc( arg0 ):
    pyqt.static_gate( 9, 19, (arg0,) )
def QColor_numBitPlanes():
    return pyqt.static_gate( 9, 20, () )
def QColor_currentAllocContext():
    return pyqt.static_gate( 9, 22, () )
def QColor_destroyAllocContext( arg0 ):
    pyqt.static_gate( 9, 23, (arg0,) )

#================================================================
# QWMatrix
#================================================================

class QWMatrix:
    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 10, 0, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def shear( self, arg0, arg1 ):
        return pyqt.gate( self, 10, 1, (arg0, arg1,) )

    def translate( self, arg0, arg1 ):
        return pyqt.gate( self, 10, 3, (arg0, arg1,) )

    def rotate( self, arg0 ):
        return pyqt.gate( self, 10, 7, (arg0,) )

    def scale( self, arg0, arg1 ):
        return pyqt.gate( self, 10, 8, (arg0, arg1,) )

    def map( self, *args ):
        return pyqt.gate( self, 10, 9, args )

    def reset( self ):
        pyqt.gate( self, 10, 10, () )

    def __getattr__( self, name ):
        if QWMatrix_readattr.has_key( name ):
            return pyqt.gate( self, 10, QWMatrix_readattr[ name ], () )
	if name == "matrix":
            return pyqt.gate( self, 10, 6, () )
        return self.__dict__[ name ]

    def __setattr__( self, name, value ):
        if name == "_ptr_":
            self.__dict__[ name ] = value
            return
	if name == "matrix":
	    pyqt.gate( self, 10, 4, value )
	    return
        if QWMatrix_writeattr.has_key( name ):
            pyqt.gate( self, 10, QWMatrix_writeattr[ name ], (value,) )
        else:
            self.__dict__[ name ] = value

QWMatrix_readattr = {  "invertable":5,  "invert":2,  }

#================================================================
# misc
#================================================================

class QImage:
    def __init__( self, *args ):
        if len( args ) != 1 or type( args[0] ) != CObjectType:
            pyqt.constructor_gate( self, 11, 0, args )
        else:
            self.__dict__[ "_ptr_" ] = args[0]

    def textLanguages( self ):
        return pyqt.gate( self, 11, 1, () )

    def pixelIndex( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 2, (arg0, arg1,) )

    def isNull( self ):
        return pyqt.gate( self, 11, 5, () )

    def setText( self, arg0, arg1, arg2 ):
        pyqt.gate( self, 11, 7, (arg0, arg1, arg2,) )
    def loadFromData( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 8, (arg0, arg1,) )

    def setColor( self, arg0, arg1 ):
        pyqt.gate( self, 11, 9, (arg0, arg1,) )
    def setAlphaBuffer( self, arg0 ):
        pyqt.gate( self, 11, 10, (arg0,) )
    def setNumColors( self, arg0 ):
        pyqt.gate( self, 11, 11, (arg0,) )
    def setDotsPerMeterY( self, arg0 ):
        pyqt.gate( self, 11, 13, (arg0,) )
    def reset( self ):
        pyqt.gate( self, 11, 14, () )
    def dotsPerMeterX( self ):
        return pyqt.gate( self, 11, 16, () )

    def copy( self, *args ):
        return pyqt.gate( self, 11, 18, args )

    def createHeuristicMask( self, arg0 ):
        return pyqt.gate( self, 11, 20, (arg0,) )

    def smoothScale( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 23, (arg0, arg1,) )

    def detach( self ):
        pyqt.gate( self, 11, 25, () )
    def offset( self ):
        return pyqt.gate( self, 11, 26, () )

    def swapRGB( self ):
        return pyqt.gate( self, 11, 27, () )

    def createAlphaMask( self, arg0 ):
        return pyqt.gate( self, 11, 28, (arg0,) )

    def pixel( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 29, (arg0, arg1,) )

    def save( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 30, (arg0, arg1,) )

    def setOffset( self, arg0 ):
        pyqt.gate( self, 11, 31, (arg0,) )
    def textKeys( self ):
        return pyqt.gate( self, 11, 32, () )

    def valid( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 33, (arg0, arg1,) )

    def setPixel( self, arg0, arg1, arg2 ):
        pyqt.gate( self, 11, 35, (arg0, arg1, arg2,) )
    def create( self, *args ):
        return pyqt.gate( self, 11, 36, args )

    def setDotsPerMeterX( self, arg0 ):
        pyqt.gate( self, 11, 37, (arg0,) )
    def fill( self, arg0 ):
        pyqt.gate( self, 11, 41, (arg0,) )
    def convertBitOrder( self, arg0 ):
        return pyqt.gate( self, 11, 42, (arg0,) )

    def mirror( self, *args ):
        return pyqt.gate( self, 11, 43, args )

    def invertPixels( self, arg0 ):
        pyqt.gate( self, 11, 46, (arg0,) )
    def text( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 47, (arg0, arg1,) )

    def color( self, arg0 ):
        return pyqt.gate( self, 11, 48, (arg0,) )

    def dotsPerMeterY( self ):
        return pyqt.gate( self, 11, 50, () )

    def convertDepth( self, *args ):
        return pyqt.gate( self, 11, 51, args )

    def load( self, arg0, arg1 ):
        return pyqt.gate( self, 11, 52, (arg0, arg1,) )

    def __getattr__( self, name ):
        if QImage_readattr.has_key( name ):
            return pyqt.gate( self, 11, QImage_readattr[ name ], () )
        else:
            return self.__dict__[ name ]

QImage_readattr = {  "size":39,  "rect":15,  "allGray":6,  "width":34,  "depth":4,  "numBytes":22,  "height":45,  "numColors":24,  "grayscale":21,  "bitOrder":49,  "bytesPerLine":38,  "alphaBuffer":17,  }

def QImage_imageFormat( arg0 ):
    return pyqt.static_gate( 11, 3, (arg0,) )
def QImage_systemBitOrder():
    return pyqt.static_gate( 11, 12, () )
def QImage_inputFormatList():
    return pyqt.static_gate( 11, 19, () )
def QImage_outputFormatList():
    return pyqt.static_gate( 11, 40, () )
def QImage_systemByteOrder():
    return pyqt.static_gate( 11, 44, () )

#================================================================
# misc
#================================================================

ptr = pyqt.init()

CObjectType = type( ptr )
ptr = None
