/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1258;
import sun.io.CharToByteCp1258;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1258
extends Charset
implements HistoricallyNamedCharset {
    public String historicalName() {
        return "Cp1258";
    }

    public MS1258() {
        super("windows-1258", StandardCharsets.aliasesFor((String)"windows-1258"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1258;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1258 c2b = new CharToByteCp1258();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1258 b2c = new ByteToCharCp1258();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }
}

