/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.PolicyNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class PolicyNodeImpl
implements PolicyNode {
    private static final String ANY_POLICY = "2.5.29.32.0";
    private PolicyNodeImpl mParent;
    private HashSet mChildren;
    private String mValidPolicy;
    private HashSet mQualifierSet;
    private boolean mCriticalityIndicator;
    private HashSet mExpectedPolicySet;
    private boolean mOriginalExpectedPolicySet;
    private int mDepth;
    private boolean isImmutable = false;

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, String string, Set set, boolean bl2, Set set2, boolean bl3) {
        this.mParent = policyNodeImpl;
        this.mChildren = new HashSet();
        this.mValidPolicy = string != null ? string : "";
        this.mQualifierSet = set != null ? new HashSet(set) : new HashSet();
        this.mCriticalityIndicator = bl2;
        this.mExpectedPolicySet = set2 != null ? new HashSet(set2) : new HashSet();
        boolean bl4 = this.mOriginalExpectedPolicySet = !bl3;
        if (this.mParent != null) {
            this.mDepth = this.mParent.getDepth() + 1;
            this.mParent.addChild(this);
        } else {
            this.mDepth = 0;
        }
    }

    PolicyNodeImpl(PolicyNodeImpl policyNodeImpl, PolicyNodeImpl policyNodeImpl2) {
        this(policyNodeImpl, policyNodeImpl2.mValidPolicy, policyNodeImpl2.mQualifierSet, policyNodeImpl2.mCriticalityIndicator, policyNodeImpl2.mExpectedPolicySet, false);
    }

    public PolicyNode getParent() {
        return this.mParent;
    }

    public Iterator getChildren() {
        return Collections.unmodifiableSet(this.mChildren).iterator();
    }

    public int getDepth() {
        return this.mDepth;
    }

    public String getValidPolicy() {
        return this.mValidPolicy;
    }

    public Set getPolicyQualifiers() {
        return Collections.unmodifiableSet(this.mQualifierSet);
    }

    public Set getExpectedPolicies() {
        return Collections.unmodifiableSet(this.mExpectedPolicySet);
    }

    public boolean isCritical() {
        return this.mCriticalityIndicator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n" + this.asString());
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            stringBuffer.append((PolicyNodeImpl)iterator.next());
        }
        return stringBuffer.toString();
    }

    boolean isImmutable() {
        return this.isImmutable;
    }

    void setImmutable() {
        if (this.isImmutable) {
            return;
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            policyNodeImpl.setImmutable();
        }
        this.isImmutable = true;
    }

    private void addChild(PolicyNodeImpl policyNodeImpl) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        this.mChildren.add(policyNodeImpl);
    }

    void addExpectedPolicy(String string) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mOriginalExpectedPolicySet) {
            this.mExpectedPolicySet.clear();
            this.mOriginalExpectedPolicySet = false;
        }
        this.mExpectedPolicySet.add(string);
    }

    void prune(int n2) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        if (this.mChildren.size() == 0) {
            return;
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            policyNodeImpl.prune(n2);
            if (policyNodeImpl.mChildren.size() != 0 || n2 <= this.mDepth + 1) continue;
            iterator.remove();
        }
    }

    void deleteChild(PolicyNode policyNode) {
        if (this.isImmutable) {
            throw new IllegalStateException("PolicyNode is immutable");
        }
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
            if (!policyNodeImpl.equals(policyNode)) continue;
            iterator.remove();
        }
    }

    PolicyNodeImpl copyTree() {
        return this.copyTree(null);
    }

    private PolicyNodeImpl copyTree(PolicyNodeImpl policyNodeImpl) {
        PolicyNodeImpl policyNodeImpl2 = new PolicyNodeImpl(policyNodeImpl, this);
        Iterator iterator = this.mChildren.iterator();
        while (iterator.hasNext()) {
            PolicyNodeImpl policyNodeImpl3 = (PolicyNodeImpl)iterator.next();
            policyNodeImpl3.copyTree(policyNodeImpl2);
        }
        return policyNodeImpl2;
    }

    private Set getPolicyNodes(int n2) {
        HashSet hashSet = new HashSet();
        if (this.mDepth == n2) {
            hashSet.add(this);
        } else {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                hashSet.addAll(policyNodeImpl.getPolicyNodes(n2));
            }
        }
        return hashSet;
    }

    Set getPolicyNodesExpected(int n2, String string, boolean bl2) {
        if (string.equals(ANY_POLICY)) {
            return this.getPolicyNodes(n2);
        }
        return this.getPolicyNodesExpectedHelper(n2, string, bl2);
    }

    private Set getPolicyNodesExpectedHelper(int n2, String string, boolean bl2) {
        HashSet hashSet = new HashSet();
        if (this.mDepth < n2) {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                hashSet.addAll(policyNodeImpl.getPolicyNodesExpectedHelper(n2, string, bl2));
            }
        } else if (bl2) {
            if (this.mExpectedPolicySet.contains(ANY_POLICY)) {
                hashSet.add(this);
            }
        } else if (this.mExpectedPolicySet.contains(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    Set getPolicyNodesValid(int n2, String string) {
        HashSet hashSet = new HashSet();
        if (this.mDepth < n2) {
            Iterator iterator = this.mChildren.iterator();
            while (iterator.hasNext()) {
                PolicyNodeImpl policyNodeImpl = (PolicyNodeImpl)iterator.next();
                hashSet.addAll(policyNodeImpl.getPolicyNodesValid(n2, string));
            }
        } else if (this.mValidPolicy.equals(string)) {
            hashSet.add(this);
        }
        return hashSet;
    }

    String asString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("  children: ");
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            object = (PolicyNodeImpl)iterator.next();
            stringBuffer.append(((PolicyNodeImpl)object).getValidPolicy() + " ");
        }
        if (this.mParent == null) {
            return "ROOT\n" + stringBuffer.toString();
        }
        object = new StringBuffer("  EP: ");
        Iterator iterator2 = this.getExpectedPolicies().iterator();
        while (iterator2.hasNext()) {
            ((StringBuffer)object).append((String)iterator2.next() + " ");
        }
        return "Parent: " + this.mParent.getValidPolicy() + "  VP: " + this.getValidPolicy() + "  CRIT: " + this.isCritical() + object + "  (" + this.getDepth() + ")" + "\n" + stringBuffer;
    }
}

