/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.NodeSetDTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public abstract class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
DTMIterator,
Serializable {
    private boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    protected transient DTM m_cdtm;
    transient int m_stackFrame = -1;
    private boolean m_isTopLevel = false;
    protected transient int m_last = 0;
    public transient int m_lastFetched = -1;
    transient NodeSetDTM m_cachedNodes;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next;

    protected LocPathIterator(PrefixResolver prefixResolver) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = prefixResolver;
    }

    protected LocPathIterator(Compiler compiler, int n2, int n3) throws TransformerException {
        this(compiler, n2, n3, true);
    }

    protected LocPathIterator(Compiler compiler, int n2, int n3, boolean bl2) throws TransformerException {
        this.setLocPathIterator(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public void setEnvironment(Object object) {
    }

    public DTM getDTM(int n2) {
        return this.m_execContext.getDTM(n2);
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstance();
        int n2 = xPathContext.getCurrentNode();
        locPathIterator.setRoot(n2, xPathContext);
        return new XNodeSet(locPathIterator);
    }

    public DTMIterator asIterator(XPathContext xPathContext, int n2) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)this.m_clones.getInstance();
        locPathIterator.setRoot(n2, xPathContext);
        return locPathIterator;
    }

    public boolean isNodesetExpr() {
        return true;
    }

    public int asNode(XPathContext xPathContext) throws TransformerException {
        DTMIterator dTMIterator = this.m_clones.getInstance();
        int n2 = xPathContext.getCurrentNode();
        dTMIterator.setRoot(n2, xPathContext);
        int n3 = dTMIterator.nextNode();
        dTMIterator.detach();
        return n3;
    }

    public boolean bool(XPathContext xPathContext) throws TransformerException {
        return this.asNode(xPathContext) != -1;
    }

    public void setIsTopLevel(boolean bl2) {
        this.m_isTopLevel = bl2;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public void setRoot(int n2, Object object) {
        XPathContext xPathContext;
        this.m_context = n2;
        this.m_execContext = xPathContext = (XPathContext)object;
        this.m_cdtm = xPathContext.getDTM(n2);
        this.m_currentContextNode = n2;
        this.m_prefixResolver = xPathContext.getNamespaceContext();
        if (this.m_isTopLevel) {
            this.m_stackFrame = xPathContext.getVarStack().getStackFrame();
        }
        this.reset();
    }

    protected void setNextPosition(int n2) {
        this.m_next = n2;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void setShouldCacheNodes(boolean bl2) {
        if (bl2) {
            if (null == this.m_cachedNodes) {
                this.m_cachedNodes = new NodeSetDTM(this.getDTMManager());
            }
        } else {
            this.m_cachedNodes = null;
        }
    }

    public boolean isMutable() {
        return this.m_cachedNodes != null;
    }

    public NodeSetDTM getCachedNodes() {
        return this.m_cachedNodes;
    }

    public void setCurrentPos(int n2) {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        this.setNextPosition(n2);
        this.m_cachedNodes.setCurrentPos(n2);
    }

    public int size() {
        if (null == this.m_cachedNodes) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }

    public int item(int n2) {
        return this.m_cachedNodes.item(n2);
    }

    public void setItem(int n2, int n3) {
        this.m_cachedNodes.setElementAt(n2, n3);
    }

    public int getLength() {
        if (this.m_last > 0) {
            return this.m_last;
        }
        this.m_last = null == this.m_cachedNodes || !this.m_foundLast ? this.getLastPos(this.m_execContext) : this.m_cachedNodes.getLength();
        return this.m_last;
    }

    private void resetToCachedList() {
        int n2 = this.getCurrentPos();
        if (null == this.m_cachedNodes || n2 != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(n2);
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public int previousNode() {
        if (null == this.m_cachedNodes) {
            throw new RuntimeException("This NodeSetDTM can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    public int getRoot() {
        return this.m_context;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public void allowDetachToRelease(boolean bl2) {
        this.m_allowDetach = bl2;
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_cachedNodes = null;
            this.m_execContext = null;
            this.m_prefixResolver = null;
            this.m_cdtm = null;
            this.m_clones.freeInstance(this);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = -1;
        this.m_next = 0;
        this.m_last = 0;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)this.clone();
        locPathIterator.reset();
        return locPathIterator;
    }

    public abstract int nextNode();

    protected int returnNextNode(int n2) {
        if (-1 != n2) {
            if (null != this.m_cachedNodes) {
                this.m_cachedNodes.addElement(n2);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = n2;
        if (-1 == n2) {
            this.m_foundLast = true;
        }
        return n2;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (-1 != var1_1) ** GOTO lbl-1000
            while (-1 != (var2_2 = this.nextNode())) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if (-1 != (var2_3 = this.nextNode())) continue;
            }
        }
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public final int getContext() {
        return this.m_context;
    }

    public final int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public final void setCurrentContextNode(int n2) {
        this.m_currentContextNode = n2;
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public int getLast() {
        return this.getLength();
    }

    public void setLast(int n2) {
        this.m_last = n2;
    }

    /*
     * Unable to fully structure code
     */
    public int getLastPos(XPathContext var1_1) {
        var2_2 = null != this.m_cachedNodes ? this.m_cachedNodes.getCurrentPos() : -1;
        var3_3 = this.m_predicateIndex >= 0 ? this.getProximityPosition() : (null != this.m_cachedNodes ? this.m_cachedNodes.getCurrentPos() : this.m_next);
        try {
            block4: {
                if (0 != var3_3 || this.m_currentContextNode == -1) break block4;
                var4_4 = (LocPathIterator)this.cloneWithReset();
                ** GOTO lbl14
            }
            var4_4 = (LocPathIterator)this.clone();
            if (true) ** GOTO lbl14
        }
        catch (CloneNotSupportedException var5_5) {
            return -1;
        }
        do {
            ++var3_3;
lbl14:
            // 3 sources

        } while (-1 != (var5_6 = var4_4.nextNode()));
        if (-1 != var2_2) {
            this.m_cachedNodes.setCurrentPos(var2_2);
        }
        return var3_3;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public int getAxis() {
        return -1;
    }
}

