/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

class BasicDropTargetListener
implements DropTargetListener,
UIResource,
ActionListener {
    private Timer timer;
    private Point lastPosition;
    private Rectangle outer = new Rectangle();
    private Rectangle inner = new Rectangle();
    private int hysteresis = 10;
    private boolean canImport;
    private JComponent component;

    protected BasicDropTargetListener() {
    }

    protected void saveComponentState(JComponent jComponent) {
    }

    protected void restoreComponentState(JComponent jComponent) {
    }

    protected void restoreComponentStateForDrop(JComponent jComponent) {
    }

    protected void updateInsertionLocation(JComponent jComponent, Point point) {
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        Rectangle rectangle = jComponent.getVisibleRect();
        this.outer.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            insets.left = scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
            insets.top = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
            insets.right = scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
            insets.bottom = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
        }
        this.inner.reshape(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            Rectangle rectangle;
            int n2;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.inner.y) {
                n2 = scrollable.getScrollableUnitIncrement(this.outer, 1, 1);
                rectangle = new Rectangle(this.inner.x, this.outer.y - n2, this.inner.width, n2);
                jComponent.scrollRectToVisible(rectangle);
            } else if (point.y > this.inner.y + this.inner.height) {
                n2 = scrollable.getScrollableUnitIncrement(this.outer, 1, -1);
                rectangle = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, n2);
                jComponent.scrollRectToVisible(rectangle);
            }
            if (point.x < this.inner.x) {
                n2 = scrollable.getScrollableUnitIncrement(this.outer, 0, 1);
                rectangle = new Rectangle(this.outer.x - n2, this.inner.y, n2, this.inner.height);
                jComponent.scrollRectToVisible(rectangle);
            } else if (point.x > this.inner.x + this.inner.width) {
                n2 = scrollable.getScrollableUnitIncrement(this.outer, 0, -1);
                rectangle = new Rectangle(this.outer.x + this.outer.width, this.inner.y, n2, this.inner.height);
                jComponent.scrollRectToVisible(rectangle);
            }
        }
    }

    private void initPropertiesIfNecessary() {
        block6: {
            if (this.timer != null) break block6;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n2 = new Integer(100);
            Integer n3 = new Integer(100);
            try {
                n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n3 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(n3, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n2);
            try {
                this.hysteresis = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {}
        }
    }

    static JComponent getComponent(DropTargetEvent dropTargetEvent) {
        DropTargetContext dropTargetContext = dropTargetEvent.getDropTargetContext();
        return (JComponent)dropTargetContext.getComponent();
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.component);
        if (this.outer.contains(this.lastPosition) && !this.inner.contains(this.lastPosition)) {
            this.autoscroll(this.component, this.lastPosition);
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.component = BasicDropTargetListener.getComponent(dropTargetDragEvent);
        TransferHandler transferHandler = this.component.getTransferHandler();
        this.canImport = transferHandler.canImport(this.component, dropTargetDragEvent.getCurrentDataFlavors());
        if (this.canImport) {
            this.saveComponentState(this.component);
            this.lastPosition = dropTargetDragEvent.getLocation();
            this.updateAutoscrollRegion(this.component);
            this.initPropertiesIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.canImport) {
            Point point = dropTargetDragEvent.getLocation();
            this.updateInsertionLocation(this.component, point);
            BasicDropTargetListener basicDropTargetListener = this;
            synchronized (basicDropTargetListener) {
                if (Math.abs(point.x - this.lastPosition.x) > this.hysteresis || Math.abs(point.y - this.lastPosition.y) > this.hysteresis) {
                    if (this.timer.isRunning()) {
                        this.timer.stop();
                    }
                } else if (!this.timer.isRunning()) {
                    this.timer.start();
                }
                this.lastPosition = point;
            }
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.canImport) {
            this.restoreComponentState(this.component);
        }
        this.cleanup();
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.canImport) {
            this.restoreComponentStateForDrop(this.component);
        }
        this.cleanup();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void cleanup() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.component = null;
        this.lastPosition = null;
    }
}

