/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile
extends JarFile {
    private Certificate[] certificates;
    private HashMap signerMap = null;
    private Manifest manifest = null;

    protected CachedJarFile(File file, Certificate[] certificateArray, HashMap hashMap, Manifest manifest) throws IOException {
        super(file, false);
        this.certificates = certificateArray;
        this.signerMap = hashMap;
        this.manifest = manifest;
        super.getManifest();
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                return new JarFileEntry(zipEntry);
            }
        };
    }

    public Manifest getManifest() throws IOException {
        Manifest manifest = null;
        if (this.manifest != null) {
            manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putAll((Map<?, ?>)((Map)this.manifest.getMainAttributes().clone()));
            Map<String, Attributes> map = this.manifest.getEntries();
            if (map != null) {
                Map<String, Attributes> map2 = manifest.getEntries();
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    Attributes attributes2 = map.get(string);
                    map2.put(string, (Attributes)attributes2.clone());
                }
            }
        }
        return manifest;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            if (CachedJarFile.this.manifest != null) {
                return (Attributes)CachedJarFile.this.manifest.getAttributes(this.getName()).clone();
            }
            return null;
        }

        public Certificate[] getCertificates() {
            int[] nArray;
            Certificate[] certificateArray = null;
            if (CachedJarFile.this.signerMap != null && !CachedJarFile.this.signerMap.isEmpty() && (nArray = (int[])CachedJarFile.this.signerMap.get(this.getName())) != null) {
                certificateArray = new Certificate[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    certificateArray[n] = CachedJarFile.this.certificates[nArray[n]];
                    ++n;
                }
            }
            return certificateArray;
        }
    }
}

