/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#include <stdlib.h>

#include <kglobal.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <khelpmenu.h>
#include <kmenubar.h>
#include <kaboutdata.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <krun.h>

#include "koncd.h"
#include "tools.h"
#include "ripcd.h"
#include "imagetype.h"
#include "copycd.h"
#include "mastercd.h"
#include "audiocd.h"
#include "cddata.h"
#include "optiondialog.h"

#include "koncd.moc"

KOnCD::KOnCD(QWidget *parent, const char *name) : KOnCD_MainWindow(parent, name){
	setupMenubar();
}

KOnCD::~KOnCD(){
}

// Setup menubar
void KOnCD::setupMenubar(){

	// KOnCD-menu entries
	KPopupMenu *popupMenu1 = new KPopupMenu;
	KPopupMenu *popupMenu2 = new KPopupMenu;
	KPopupMenu *popupMenu3 = new KPopupMenu;
	KPopupMenu *popupMenu4 = new KPopupMenu;
	KPopupMenu *popupMenu5 = new KPopupMenu;

	popupMenu1->insertItem( i18n( "&Copy CD..." ), this, SLOT( slot_copyCD() ) );
	popupMenu1->insertItem( i18n( "&Master CD..." ), this, SLOT( slot_masterCD() ) );
	popupMenu1->insertItem( i18n( "&Audio CD..." ), this, SLOT( slot_audioCD() ) );
	popupMenu1->insertItem( i18n( "&Rip CD..." ), this, SLOT( slot_ripCD() ) );
	popupMenu1->insertSeparator();
	popupMenu1->insertItem( i18n( "&Quit" ), this, SLOT( slot_exitApp() ), CTRL+Key_Q );

	popupMenu2->insertItem( i18n( "&KOnCD..." ), this, SLOT( slot_setup() ), CTRL+Key_S );
	popupMenu2->insertItem( i18n( "&Audio CD..." ), this, SLOT( slot_setupRipCD() ), CTRL+Key_A );
	popupMenu2->insertItem( i18n( "&Image Type..." ), this, SLOT( slot_image_type() ), CTRL+Key_I );

	popupMenu3->insertItem( i18n( "&Load" ), ID_READER_LOAD );
	popupMenu3->insertItem( i18n( "&Eject" ), ID_READER_EJECT );
	popupMenu3->insertItem( i18n( "&Reset" ), ID_READER_RESET );

	popupMenu4->insertItem( i18n( "&Load" ), ID_WRITER_LOAD );
	popupMenu4->insertItem( i18n( "&Eject" ), ID_WRITER_EJECT );
	popupMenu4->insertItem( i18n( "&Reset" ), ID_WRITER_RESET );

	popupMenu5->insertItem( i18n( "&Reader" ), popupMenu3 );
	popupMenu5->insertItem( i18n( "&Writer" ), popupMenu4 );

	popupMenu5->insertSeparator();
	popupMenu5->insertItem( i18n( "R&eset All" ), this, SLOT( slot_resetDevices() ), CTRL+Key_E );

	// Help-menu entries
  const KAboutData *aboutData = KGlobal::instance()->aboutData();
  KHelpMenu *help_menu = new KHelpMenu( this, aboutData);
  KPopupMenu *help = help_menu->menu();

	// Insert menu
	KMenuBar *menubar = new KMenuBar( this );
	menubar->insertItem( i18n( "&KOnCD" ), popupMenu1);
	menubar->insertItem( i18n( "De&vices" ), popupMenu5);
	menubar->insertItem( i18n( "&Setup" ), popupMenu2);
	menubar->insertItem( i18n( "&Help" ), help);

	connect( popupMenu3, SIGNAL(activated(int)), this, SLOT(slot_devices(int)) );
	connect( popupMenu4, SIGNAL(activated(int)), this, SLOT(slot_devices(int)) );
}

// Devices
void KOnCD::slot_devices( int id ){
	QString reader, writer;
	KConfig *config = kapp->config();
	CDdata *CD = new CDdata;

	config->setGroup("CD-Reader");
	reader = config->readEntry("SCSI-Target").mid( 6, 1 );

	config->setGroup("CD-Writer");
	writer = config->readEntry("SCSI-Target").mid( 6, 1 );

	switch( id )
	{
	 	case 0:	CD->load( reader.toInt( 0 ) );
						break;

	 	case 1:	CD->eject( reader.toInt( 0 ) );
						break;

	 	case 2:	CD->reset( reader.toInt( 0 ) );
						break;

	 	case 3:	CD->load( writer.toInt( 0 ) );
						break;

	 	case 4:	CD->eject( writer.toInt( 0 ) );
						break;

	 	case 5:	CD->reset( writer.toInt( 0 ) );
						break;
	}
}

// 'Reset all devices' clicked
void KOnCD::slot_resetDevices(){
	QString tmp, target;
	KConfig *config = kapp->config();
	CDdata *CD = new CDdata;

	CD->reset( 7 );

	config->setGroup("CD-Writer");
	tmp = config->readEntry("SCSI-Target");
	target = tmp.mid( 6, 1 );
	CD->reset( target.toInt( 0 ) );

	config->setGroup("CD-Reader");
	tmp = config->readEntry("SCSI-Target");
	target = tmp.mid( 6, 1 );
	CD->reset( target.toInt( 0 ) );
}

// 'Setup' clicked
void KOnCD::slot_setup(){
	COptionDialog *dlg = new COptionDialog(0, "KOnCD");
	dlg->show();
}

// 'Rip CD Setup' clicked
void KOnCD::slot_setupRipCD(){
	KRun::runCommand( "kcmshell audiocd" );
}

// 'CopyCD-Button' clicked
void KOnCD::slot_copyCD(){
	CopyCD *dlg = new CopyCD(0, "KOnCD");
	dlg->show();
}

// 'MasterCD-Button' clicked
void KOnCD::slot_masterCD(){
	MasterCD *dlg = new MasterCD(0, "KOnCD");
	dlg->show();
}

// 'AudioCD-Button' clicked
void KOnCD::slot_audioCD(){
	AudioCD *dlg = new AudioCD(0, "KOnCD");
	dlg->show();
}

// 'RipCD-Button' clicked
void KOnCD::slot_ripCD(){
	RipCD *dlg = new RipCD(0, "KOnCD");
	dlg->show();
}

// 'Tools-Button' clicked
void KOnCD::slot_tools(){
	Tools *dlg = new Tools(0, "KOnCD");
	dlg->show();
}

// 'ImageType' clicked
void KOnCD::slot_image_type(){
	ImageType *dlg = new ImageType(0, "KOnCD");
	dlg->show();
}

// 'Exit-Button' clicked
void KOnCD::slot_exitApp(){
	close();
}

