/***************************************************************************
                            QIconView.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QICONVIEW_H
#define QICONVIEW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>
#include <qtobjc/QIconViewItem.h>
#include <qtobjc/QBrush.h>
#include <qtobjc/QDragObject.h>

@class QContextMenuEvent; 
@class QIMEvent; 
@class QPalette; 
@class QStyle; 
@class QTabletEvent; 

@interface QIconView : QScrollView 
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;
- (void) dealloc;
- insertIconViewItem: (QIconViewItem*)item after: (QIconViewItem*)after;
- insertIconViewItem: (QIconViewItem*)item ;
- takeItem: (QIconViewItem*)item;
- (int) index: (QIconViewItem*)item;
- (QIconViewItem*) firstItem;
- (QIconViewItem*) lastItem;
- (QIconViewItem*) currentItem;
- setCurrentItem: (QIconViewItem*)item;
- setSelected: (QIconViewItem*)item s: (BOOL)s cb: (BOOL)cb;
- setSelected: (QIconViewItem*)item s: (BOOL)s ;
- (unsigned int) count;
//- showEvent: (QShowEvent*)arg1;
- setSelectionMode: (int)m;
- (int) selectionMode;
- (QIconViewItem*) findItemAtPoint: (QPoint*)pos;
- (QIconViewItem*) findItem: (NSString *)text compare: (int)compare;
- (QIconViewItem*) findItem: (NSString *)text ;
- selectAll: (BOOL)select;
- clearSelection;
- invertSelection;
- repaintItem: (QIconViewItem*)item;
- ensureItemVisible: (QIconViewItem*)item;
- (QIconViewItem*) findFirstVisibleItem: (QRect*)r;
- (QIconViewItem*) findLastVisibleItem: (QRect*)r;
- clear;
- setGridX: (int)rx;
- setGridY: (int)ry;
- (int) gridX;
- (int) gridY;
- setSpacing: (int)sp;
- (int) spacing;
- setItemTextPos: (int)pos;
- (int) itemTextPos;
- setItemTextBackground: (QBrush *)b;
- (QBrush*) itemTextBackground;
- setArrangement: (int)am;
- (int) arrangement;
- setResizeMode: (int)am;
- (int) resizeMode;
- setMaxItemWidth: (int)w;
- (int) maxItemWidth;
- setMaxItemTextLength: (int)w;
- (int) maxItemTextLength;
- setAutoArrange: (BOOL)b;
- (BOOL) autoArrange;
- setShowToolTips: (BOOL)b;
- (BOOL) showToolTips;
- setSorting: (BOOL)sort ascending: (BOOL)ascending;
- setSorting: (BOOL)sort ;
- (BOOL) sorting;
- (BOOL) sortDirection;
- setItemsMovable: (BOOL)b;
- (BOOL) itemsMovable;
- setWordWrapIconText: (BOOL)b;
- (BOOL) wordWrapIconText;
- (BOOL) eventFilter: (QObject *)o event: (QEvent *)arg1;
- (QSize*) minimumSizeHint;
- (QSize*) sizeHint;
- sort: (BOOL)ascending;
- sort;
- setFont: (QFont *)arg1;
- setPalette: (QPalette *)arg1;
- (BOOL) isRenaming;
- arrangeItemsInGrid: (QSize *)grid update: (BOOL)update;
- arrangeItemsInGridWithSize: (QSize *)grid ;
- arrangeItemsInGrid: (BOOL)update;
- arrangeItemsInGrid;
- setContentsPos: (int)x y: (int)y;
- updateContents;
- drawContents: (QPainter *)p cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- drawRubber: (QPainter *)p;
- (QDragObject*) dragObject;
- startDrag;
- insertInGrid: (QIconViewItem*)item;
- drawBackground: (QPainter *)p r: (QRect*)r;
- emitSelectionChanged: (QIconViewItem*)i;
- emitSelectionChanged;
- emitRenamed: (QIconViewItem*)item;
- (QIconViewItem*) makeRowLayout: (QIconViewItem*)begin y: (int)y changed: (BOOL)changed;
- styleChange: (QStyle*)arg1;
- windowActivationChange: (BOOL)arg1;
- doAutoScroll;
- adjustItems;
- slotUpdate;
+ (int) Single;
+ (int) Multi;
+ (int) Extended;
+ (int) NoSelection;
+ (int) LeftToRight;
+ (int) TopToBottom;
+ (int) Fixed;
+ (int) Adjust;
+ (int) Bottom;
+ (int) Right;
@end

/** Override these methods in subclasses of QIconView to customise event handling behaviour */
@protocol QIconViewEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) e;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) e;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
