/***************************************************************************
                            PtyProcess.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef PTYPROCESS_H
#define PTYPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Synchronous communication with tty programs.

 PtyProcess provides synchronous communication with tty based programs. 
 The communications channel used is a pseudo tty (as opposed to a pipe) 
 This means that programs which require a terminal will work.
 
 @short 
 Synchronous communication with tty programs.
*/
@class QCStringList; 

@interface  PtyProcess : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- (void) dealloc;

/** 
 Forks off and execute a command. The command's standard in and output 
 are connected to the pseudo tty. They are accessible with @ref  #-readLine 
 and @ref  #-writeLine.

*/
- (int) exec: (NSString *)command args: (QCStringList*)args;

/** 
 Reads a line from the program's standard out. Depending on the @em block 
 parameter, this call blocks until a single, full line is read. 

*/
- (NSString *) readLine: (BOOL)block;

/** 
 Writes a line of text to the program's standard in.

*/
- writeLine: (NSString *)line addNewline: (BOOL)addNewline;
- writeLine: (NSString *)line ;

/** 
 Puts back a line of input.

*/
- unreadLine: (NSString *)line addNewline: (BOOL)addNewline;
- unreadLine: (NSString *)line ;

/** 
 Sets the exit string. If a line of program output matches this,
 @ref  #--waitForChild will terminate the program and return.
     
*/
- setExitString: (NSString *)exit;

/** 
 Waits for the child to exit. See also @ref  #-setExitString.
     
*/
- (int) waitForChild;

/** 
 Waits until the pty has cleared the ECHO flag. This is usefull 
 when programs write a password prompt before they disable ECHO.
 Disabling it might flush any input that was written.
     
*/
- (int) WaitSlave;

/**  Enables/disables local echo on the pseudo tty. 
*/
- (int) enableLocalEcho: (BOOL)enable;
- (int) enableLocalEcho;

/**  Enables/disables terminal output. Relevant only to some subclasses. 
*/
- setTerminal: (BOOL)terminal;

/**  Overwrites the password as soon as it is used. Relevant only to
 some subclasses. 
*/
- setErase: (BOOL)erase;

/**  Set additinal environment variables. 
*/
- setEnvironment: (QCStringList*)env;

/**  Returns the filedescriptor of the process. 
*/
- (int) fd;

/**  Returns the pid of the process. 
*/
- (int) pid;
@end

#endif
