/***************************************************************************
                            Part.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef PART_H
#define PART_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/PartBase.h>
#include <qtobjc/QObject.h>

/**

 Base class for parts.

 A "part" is a GUI component, featuring:

 See also @ref ReadOnlyPart and @ref ReadWritePart, which define the
 framework for a "viewer" part and for an "editor"-like part.
 Use Part directly only if your part doesn't fit into those.
 
 @short 
 Base class for parts.
*/

@class GUIActivateEvent;
@class PartActivateEvent;
@class PartManager;
@class PartSelectEvent;

@interface Part : QObject

/** 
  Constructor.

*/
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;

/** 
  Destructor.
     
*/
- (void) dealloc;

/** 
 Embed this part into a host widget.

 You don't need to do this if you created the widget with the
 correct parent widget - this is just a @ref -[QWidget reparent].
 Note that the @ref Part is still the holder
 of the @ref QWidget, meaning that if you delete the @ref Part,
 then the widget gets destroyed as well, and vice-versa.
 This method is not recommended since creating the widget with the correct
 parent is simpler anyway.
     
*/
- embed: (QWidget *)parentWidget;

/** 

*/
- (QWidget*) widget;

/** 

 Used by the part manager.
     
*/
- setManager: (PartManager*)manager;

/** 
 Returns the part manager handling this part, if any (0L otherwise).
     
*/
- (PartManager*) manager;

/** 

     
*/
- (Part*) hitTest: (QWidget *)widget globalPos: (QPoint*)globalPos;

/** 

*/
- setSelectable: (BOOL)selectable;

/** 
  Returns whether the part is selectable or not.
     
*/
- (BOOL) isSelectable;

/** 
 Set the main widget.

 Call this in the Part-inherited class constructor.
     
*/
- setWidget: (QWidget *)widget;

/** 

     
*/
- (BOOL) event: (QEvent *)event;

/** 
 Convenience method for @ref -[KXMLGUIFactory container].

*/
- (QWidget*) hostContainer: (NSString *)containerName;
@end

@class GUIActivateEvent; 
@class PartActivateEvent; 
@class PartManager; 
@class PartSelectEvent; 

@interface Part (PartBaseImplementation) <PartBaseInterface>
@end

/** Override these methods in subclasses of Part to customise event handling behaviour */
@protocol PartEventHandling

/** 
 Convenience method which is called when the Part received a @ref PartActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and test for the event yourself
 or even install an event filter.
     
*/
- partActivateEvent:(PartActivateEvent*) event;

/** 
 Convenience method which is called when the Part received a
 @ref PartSelectEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/
- partSelectEvent:(PartSelectEvent*) event;
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) event;

/** 
 Convenience method which is called when the Part received a
 @ref GUIActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/
- guiActivateEvent:(GUIActivateEvent*) event;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
