/***************************************************************************
                            Connection.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef CONNECTION_H
#define CONNECTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 This class provides a simple means for IPC between two applications
 via a pipe.
 It handles a queue of commands to be sent which makes it possible to
 queue data before an actual connection has been established.
     
 @short 
 This class provides a simple means for IPC between two applications
 via a pipe.
*/
@class KSocket; 
@class QByteArray; 

@interface Connection : QObject 
- init;
- (void) dealloc;
- init: (KSocket*)sock;
- init: (int)fd_in fd_out: (int)fd_out;
- connect: (QObject *)receiver slot: (NSString *)member;
- connect;
- close;
- (int) fd_from;
- (int) fd_to;
- (BOOL) inited;
- send: (int)cmd arr: (QByteArray*)arr;
- send: (int)cmd ;
- (BOOL) sendnow: (int)cmd data: (QByteArray*)data;

/** 
 Receive data

*/
- (int) read: (int*)cmd bytearray: (QByteArray*)arg1;

/** 
 Don't handle incoming data until resumed
         
*/
- suspend;

/** 
 Resume handling of incoming data
         
*/
- resume;

/** 
 Returns status of connection
         
*/
- (BOOL) suspended;
- dequeue;
@end

/** Override these methods in subclasses of Connection to customise event handling behaviour */
@protocol ConnectionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
