/***************************************************************************
                            PtyProcess.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Synchronous communication with tty programs.

 PtyProcess provides synchronous communication with tty based programs. 
 The communications channel used is a pseudo tty (as opposed to a pipe) 
 This means that programs which require a terminal will work.
 
 @short 
 Synchronous communication with tty programs.
*/
public class  PtyProcess implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected PtyProcess(Class dummy){}

	private native void newPtyProcess();
	public PtyProcess() {
		newPtyProcess();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Forks off and execute a command. The command's standard in and output 
 are connected to the pseudo tty. They are accessible with {@link #readLine} 
 and {@link #writeLine.}

*/
	public native int exec( String command, String args);

/** 
 Reads a line from the program's standard out. Depending on the <em>block</em> 
 parameter, this call blocks until a single, full line is read. 

*/
	public native String readLine( boolean block);

/** 
 Writes a line of text to the program's standard in.

*/
	public native void writeLine( String line, boolean addNewline);
	public native void writeLine( String line);

/** 
 Puts back a line of input.

*/
	public native void unreadLine( String line, boolean addNewline);
	public native void unreadLine( String line);

/** 
 Sets the exit string. If a line of program output matches this,
 {@link #waitForChild} will terminate the program and return.
     
*/
	public native void setExitString( String exit);

/** 
 Waits for the child to exit. See also {@link #setExitString.}
     
*/
	public native int waitForChild();

/** 
 Waits until the pty has cleared the ECHO flag. This is usefull 
 when programs write a password prompt before they disable ECHO.
 Disabling it might flush any input that was written.
     
*/
	public native int WaitSlave();

/**  Enables/disables local echo on the pseudo tty. 
*/
	public native int enableLocalEcho( boolean enable);
	public native int enableLocalEcho();

/**  Enables/disables terminal output. Relevant only to some subclasses. 
*/
	public native void setTerminal( boolean terminal);

/**  Overwrites the password as soon as it is used. Relevant only to
 some subclasses. 
*/
	public native void setErase( boolean erase);

/**  Set additinal environment variables. 
*/
	public native void setEnvironment( String env);

/**  Returns the filedescriptor of the process. 
*/
	public native int fd();

/**  Returns the pid of the process. 
*/
	public native int pid();
}
