/***************************************************************************
                            KURL.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Represents and parses a URL.

 A prototypical URL looks like:
 <pre>
   protocol:/user:password@hostname:port/path/to/file.ext#reference
 </pre>

 KURL has some restrictions regarding the path
 encoding. KURL works internally with the decoded path and
 and encoded query. For example,
 <pre>
 http://localhost/cgi-bin/test%20me.pl?cmd=Hello%20you
 </pre>
 would result in a decoded path "/cgi-bin/test me.pl"
 and in the encoded query "?cmd=Hello%20you".
 Since path is internally always encoded you may <em>not</em> use
 "%00" in the path, although this is OK for the query.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Represents and parses a URL.
*/
public class  KURL implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KURL(Class dummy){}

	private native void newKURL();

/** 
 Constructs an empty URL.
   
*/
	public KURL() {
		newKURL();
	}

/** 
 Destructs the KURL object.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	private native void newKURL( String url, int encoding_hint);

/** 
 Usual constructor, to construct from a string.

*/
	public KURL( String url, int encoding_hint) {
		newKURL( url, encoding_hint);
	}
	private native void newKURL( String url);
	public KURL( String url) {
		newKURL( url);
	}
//	private native void newKURL( String url, int encoding_hint);

/** 
 Constructor taking a char  <code>url</code>, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
//	public KURL( String url, int encoding_hint) {
//		newKURL( url, encoding_hint);
//	}
//	private native void newKURL( String url);
//	public KURL( String url) {
//		newKURL( url);
//	}
//	private native void newKURL( String url, int encoding_hint);

/** 
 Constructor taking a QCString <code>url</code>, which is an _encoded_ representation
 of the URL, exactly like the usual constructor. This is useful when
 then URL, in its encoded form, is strictly ascii.
   
*/
//	public KURL( String url, int encoding_hint) {
//		newKURL( url, encoding_hint);
//	}
//	private native void newKURL( String url);
//	public KURL( String url) {
//		newKURL( url);
//	}
//	private native void newKURL( KURL u);

/** 
 Copy constructor.
   
*/
//	public KURL( KURL u) {
//		newKURL( u);
//	}
	private native void newKURL( QUrlInterface u);

/** 
 Converts from a {@link QUrl}.
   
*/
	public KURL( QUrlInterface u) {
		newKURL( u);
	}
	private native void newKURL( KURL _baseurl, String _rel_url, int encoding_hint);

/** 
 Constructor allowing relative URLs.

*/
	public KURL( KURL _baseurl, String _rel_url, int encoding_hint) {
		newKURL( _baseurl, _rel_url, encoding_hint);
	}
	private native void newKURL( KURL _baseurl, String _rel_url);
	public KURL( KURL _baseurl, String _rel_url) {
		newKURL( _baseurl, _rel_url);
	}

/** 
 Returns the protocol for the URL (i.e., file, http, etc.).

*/
	public native String protocol();

/** 
 Sets the protocol for the URL (i.e., file, http, etc.)

*/
	public native void setProtocol( String _txt);

/** 
 Returns the decoded user name (login, user id, ...) included in the URL.

*/
	public native String user();

/** 
 Sets the user name (login, user id, ...) included in the URL.

 Special characters in the user name will appear encoded in the URL.

*/
	public native void setUser( String _txt);

/** 
 Test to see if this URL has a user name included in it.

*/
	public native boolean hasUser();

/** 
 Returns the decoded password (corresponding to {@link #user}) included in the URL.

*/
	public native String pass();

/** 
 Sets the password (corresponding to {@link #user}) included in the URL.

 Special characters in the password will appear encoded in the URL.

*/
	public native void setPass( String _txt);

/** 
 Test to see if this URL has a password included in it.

*/
	public native boolean hasPass();

/** 
 Returns the decoded hostname included in the URL.

*/
	public native String host();

/** 
 Sets the hostname included in the URL.

 Special characters in the hostname will appear encoded in the URL.

*/
	public native void setHost( String _txt);

/** 
 Test to see if this URL has a hostname included in it.

*/
	public native boolean hasHost();

/** 
 Returns the port number included in the URL.
 If there is no port number specified in the URL, returns 0.

*/
	public native short port();

/** 
 Sets the port number included in the URL.

*/
	public native void setPort( short _p);

/** 
 Returns the current decoded path. This does <em>not</em> include the query.
   
*/
	public native String path();

/** 

*/
	public native String path( int _trailing);

/** 
 path This is considered to be decoded. This means: %3f does not become decoded
      and the ? does not indicate the start of the query part.
      The query is not changed by this function.
   
*/
	public native void setPath( String path);

/** 
 Test to see if this URL has a path is included in it.

*/
	public native boolean hasPath();

/** 
 Resolves "." and ".." components in path.

 Some servers seem not to like the removal of extra '/'
 even though it is against the specification in RFC 2396.
   
*/
	public native void cleanPath( boolean cleanDirSeparator);
	public native void cleanPath();

/** 
 This is useful for HTTP. It looks first for '?' and decodes then.
 The encoded path is the concatenation of the current path and the query.

*/
	public native void setEncodedPathAndQuery( String _txt, int encoding_hint);
	public native void setEncodedPathAndQuery( String _txt);
	public native void setEncodedPath( String _txt, int encoding_hint);
	public native void setEncodedPath( String _txt);

/** 

*/
	public native String encodedPathAndQuery( int _trailing, boolean _no_empty_path, int encoding_hint);
	public native String encodedPathAndQuery();

/** 

 The query should start with a '?'. If it doesn't '?' is prepended.

*/
	public native void setQuery( String _txt, int encoding_hint);
	public native void setQuery( String _txt);

/** 

*/
	public native String query();

/** 
 The reference is <em>never</em> decoded automatically.
   
*/
	public native String ref();

/** 
 Sets the reference part (everything after '#').

*/
	public native void setRef( String _txt);

/** 

*/
	public native boolean hasRef();

/** 

*/
	public native String htmlRef();

/** 

*/
	public native String encodedHtmlRef();

/** 
 Sets the HTML-style reference.

*/
	public native void setHTMLRef( String _ref);

/** 

*/
	public native boolean hasHTMLRef();

/** 

*/
	public native boolean isValid();

/** 

   
*/
	public native boolean isMalformed();

/** 

*/
	public native boolean isLocalFile();

/** 
 Adds encoding information to url.
   
*/
	public native void setFileEncoding( String encoding);

/** 
 Returns encoding information from url.

*/
	public native String fileEncoding();

/** 

*/
	public native boolean hasSubURL();

/** 
 Adds to the current path.
 Assumes that the current path is a directory. <code>_txt</code> is appended to the
 current path. The function adds '/' if needed while concatenating.
 This means it does not matter whether the current path has a trailing
 '/' or not. If there is none, it becomes appended. If <code>_txt</code>
 has a leading '/' then this one is stripped.

*/
	public native void addPath( String _txt);

/** 
 Returns the value of a certain query item.

*/
	public native String queryItem( String _item);

/** 
 In comparison to {@link #addPath} this function does not assume that the current path
 is a directory. This is only assumed if the current path ends with '/'.

 Any reference is reset.

*/
	public native void setFileName( String _txt);

/** 

*/
	public native String fileName( boolean _ignore_trailing_slash_in_path);
	public native String fileName();

/** 

*/
	public native String directory( boolean _strip_trailing_slash_from_result, boolean _ignore_trailing_slash_in_path);
	public native String directory();

/** 
 Changes the directory by descending into the given directory.
 It is assumed the current URL represents a directory.
 If <code>dir</code> starts with a "/" the
 current URL will be "protocol://host/dir" otherwise <code>_dir</code> will
 be appended to the path. <code>_dir</code> can be ".."
 This function won't strip protocols. That means that when you are in
 file:/dir/dir2/my.tgz#tar:/ and you do cd("..") you will
 still be in file:/dir/dir2/my.tgz#tar:/

*/
	public native boolean cd( String _dir);

/** 

*/
	public native String url( int _trailing, int encoding_hint);
	public native String url();

/** 

*/
	public native String prettyURL( int _trailing);
	public native String prettyURL();

/** 
 Test to see if the KURL is empty.

*/
	public native boolean isEmpty();

/** 
 This function is useful to implement the "Up" button in a file manager for example.
 {@link #cd} never strips a sub-protocol. That means that if you are in
 file:/home/x.tgz#gzip:/#tar:/ and hit the up button you expect to see
 file:/home. The algorithm tries to go up on the right-most URL. If that is not
 possible it strips the right most URL. It continues stripping URLs.
   
*/
	public native KURL upURL();

/** 
 Compares this url with <code>u.</code>

*/
	public native boolean cmp( KURL u, boolean ignore_trailing);
	public native boolean cmp( KURL u);

/** 

*/
	public native boolean isParentOf( KURL u);

/** 
 Splits nested URLs like file:/home/weis/kde.tgz#gzip:/#tar:/kdebase
 A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
 http://www.kde.org and tar:/kde/README.html#ref1.
 That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
 Since HTML-style references mark
 a certain position in a document this reference is appended to every URL.
 The idea behind this is that browsers, for example, only look at the first URL while
 the rest is not of interest to them.

*/
	public static native List split( String _url);

/** 
 A convenience function.
   
*/
	public static native List split( KURL _url);

/** 
 Reverses {@link #split}. Only the first URL may have a reference. This reference
 is considered to be HTML-like and is appended at the end of the resulting
 joined URL.
   
*/
	public static native KURL join( List _list);

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters.

*/
	public static native String encode_string( String str, int encoding_hint);
	public static native String encode_string( String str);

/** 
 Convenience function.

 Convert unicoded string to local encoding and use %-style
 encoding for all common delimiters / non-ascii characters
 as well as the slash '/'.

*/
	public static native String encode_string_no_slash( String str, int encoding_hint);
	public static native String encode_string_no_slash( String str);

/** 
 Convenience function.

 Decode %-style encoding and convert from local encoding to unicode.

 Reverse of encode_string()

*/
	public static native String decode_string( String str, int encoding_hint);
	public static native String decode_string( String str);

/** 
 Convenience function.

 Returns whether '_url' is likely to be a "relative" URL instead of
 an "absolute" URL.

*/
	public static native boolean isRelativeURL( String _url);
	protected native void reset();
	protected native void parse( String _url, int encoding_hint);
	protected native void parse( String _url);
}
