/***************************************************************************
                            AlsaOut.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**


 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to a MIDI devices using ALSA.
*/
public class AlsaOut extends MidiOut  {
	protected AlsaOut(Class dummy){super((Class) null);}

	private native void newAlsaOut( int d, int client, int port, String cname, String pname);

/** 
 Constructor. After constructing a MidiOut device, you must open it
 (using {@link #openDev} ). Additionally you may want to initialize it
 (with {@link #initDev} ),
   
*/
	public AlsaOut( int d, int client, int port, String cname, String pname) {
		super((Class) null);
		newAlsaOut( d, client, port, cname, pname);
	}
	private native void newAlsaOut( int d);
	public AlsaOut( int d) {
		super((Class) null);
		newAlsaOut( d);
	}

/** 
 Destructor. It doesn't matter if you close the device ({@link #closeDev} )
 before you destruct the object because in other case, it will be closed
 here.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Opens the device. This is generally called from {@link DeviceManager} , so you
 shouldn't call this yourself (except if you created the MidiOut object
 yourself.

*/
	public native void openDev( int sqfd);

/** 
 Closes the device. It basically tells the device (the file descriptor)
 is going to be closed.

*/
	public native void closeDev();

/** 
 Initializes the device sending generic standard midi events and controllers,
 such as changing the patches of each channel to an Acoustic Piano (000),
 setting the volume to a normal value, etc.
   
*/
	public native void initDev();

/** 

 which are defined in midispec.h

*/
	public native int deviceType();

/** 
 Returns the name and type of this MIDI device.

*/
	public native String deviceName();

/** 

   
*/
	public native int rate();

/** 
 See {@link DeviceManager#noteOn}
   
*/
	public native void noteOn( String chn, String note, String vel);

/** 
 See {@link DeviceManager#noteOff}
   
*/
	public native void noteOff( String chn, String note, String vel);

/** 
 See {@link DeviceManager#keyPressure}
   
*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 See {@link DeviceManager#chnPatchChange}
   
*/
	public native void chnPatchChange( String chn, String patch);

/** 
 See {@link DeviceManager#chnPressure}
   
*/
	public native void chnPressure( String chn, String vel);

/** 
 See {@link DeviceManager#chnPitchBender}
   
*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 See {@link DeviceManager#chnController}
   
*/
	public native void chnController( String chn, String ctl, String v);

/** 
 See {@link DeviceManager#sysex}
   
*/
	public native void sysex( String data, long size);

/** 
 Mutes all notes being played on a given channel.
   
*/
	public native void channelSilence( String chn);

/** 
 Mute or "unmute" a given channel .

*/
	public native void channelMute( String chn, int a);

/** 
 Change all channel volume events multiplying it by this percentage correction
 Instead of forcing a channel to a fixed volume, this method allows to
 music to fade out even when it was being played softly.

*/
	public native void setVolumePercentage( int volper);

/** 
 Returns true if everything's ok and false if there has been any problem
   
*/
	public native int ok();
	public native void wait( double ticks);
	public native void tmrSetTempo( int v);
	public native void tmrStart( int tpcn);
	public native void tmrStart();
	public native void tmrStop();
	public native void tmrContinue();

/** 

 If i==1 syncronizes by cleaning the buffer instead of sending it (in fact,
 this is what syncronizing really means :-) )
   
*/
	public native void sync( int i);
	public native void sync();
	protected native void seqbuf_dump();
	protected native void seqbuf_clean();
	protected native void eventInit( int[] ev);
	protected native void eventSend( int[] ep);
	protected native void timerEventSend( int type);
}
