/***************************************************************************
                            kde_KShellProcess.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSHELLPROCESS
#define KDE_KSHELLPROCESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class is similar to @ref KProcess. The only difference is that
 KShellProcess runs the specified executable through a UN*X shell so
 that standard shell mechanisms like wild card matching, use of pipes
 and environment variable expansion will work.

 For example, you could run commands like the following through
 KShellProcess:

 <pre>
   ls ~/HOME/ *.lyx | sort | uniq |wc -l
 </pre>

 KShellProcess tries really hard to find a valid executable shell. Here
 is the algorithm used for finding an executable shell:

 @author Christian Czezakte <e9025461@student.tuwien.ac.at>

 @version $Id: kde_KShellProcess.h,v 1.3 2002/02/21 00:43:13 rdale Exp $

 @short A class derived from @ref KProcess to start child
   	processes through a shell.

*/

/** 
      Constructor

      By specifying the name of a shell (like "/bin/bash") you can override
      the mechanism for finding a valid shell as described in the detailed
      description of this class.
  
*/
kde_KShellProcess * kde_new_KShellProcess(char* shellname);

/** 
 Destructor.
   
*/
void kde_del_KShellProcess( kde_KShellProcess* p );

/** 
    Starts up the process. -- For a detailed description
    have a look at the "start" member function and the detailed
    description of @ref KProcess .
  
*/
int kde_KShellProcess_start(kde_KShellProcess* instPointer,int runmode, int comm);

/** 
 This function can be used to quote an argument string such that
 the shell processes it properly. This is e. g. necessary for
 user-provided file names which may contain spaces or quotes.
 It also prevents expansion of wild cards and environment variables.
   
*/
qt_QString * kde_KShellProcess_quote( qt_QString * arg);

#endif
