/***************************************************************************
                            kde_KProcIO.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROCIO
#define KDE_KPROCIO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

kde_KProcIO * kde_new_KProcIO(qt_QTextCodec* codec);

/** 
  Starts the process.

  The following problems could cause this function to
    return false:

*/
int kde_KProcIO_start(kde_KProcIO* instPointer,int runmode, int includeStderr);

/** 
 The buffer is zero terminated.
 A deep copy is made of the buffer, so you don't
 need to bother with that.  A newline ( '\n' ) is appended 
 unless you specify FALSE as the second parameter.
 FALSE is returned on an error, or else TRUE is.

*/
int kde_KProcIO_writeStdin(kde_KProcIO* instPointer,qt_QString * line, int AppendNewLine);
int kde_KProcIO_fputs(kde_KProcIO* instPointer,qt_QString * line, int AppendNewLine);

/** 
 reads a line of text (up to and including '\n')

 Use readln() in response to a readReady() signal.
 You may use it multiple times if more than one line of data is
  available.
 Be sure to use ackRead() when you have finished processing the
  readReady() signal.  This informs KProcIO that you are ready for
  another readReady() signal.

 readln() never blocks.

 autoAck==TRUE makes these functions call ackRead() for you.

*/
int kde_KProcIO_readln(kde_KProcIO* instPointer,qt_QString * line, int autoAck, int* partial);
int kde_KProcIO_fgets(kde_KProcIO* instPointer,qt_QString * line, int autoAck);

/** 
 Reset the class.  Doesn't kill the process.

*/
void kde_KProcIO_resetAll(kde_KProcIO* instPointer);

/** 
 Call this after you have finished processing a readReady()
 signal.  This call need not be made in the slot that was signalled
 by readReady().  You won't receive any more readReady() signals
 until you acknowledge with ackRead().  This prevents your slot
 from being reentered while you are still processing the current
 data.  If this doesn't matter, then call ackRead() right away in
 your readReady()-processing slot.

*/
void kde_KProcIO_ackRead(kde_KProcIO* instPointer);

/** 
  Turns readReady() signals on and off.
   You can turn this off at will and not worry about losing any data.
   (as long as you turn it back on at some point...)
   
*/
void kde_KProcIO_enableReadSignals(kde_KProcIO* instPointer,int enable);
void kde_KProcIO_controlledEmission(kde_KProcIO* instPointer);
void kde_KProcIO_received(kde_KProcIO* instPointer,kde_KProcess* proc, char* buffer, int buflen);
void kde_KProcIO_sent(kde_KProcIO* instPointer,kde_KProcess* arg1);

#endif
