/***************************************************************************
                            kde_KCModule.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCMODULE
#define KDE_KCMODULE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The base class for control center modules.

 Starting from KDE 2.0, control center modules are realized as shared
 libraries that are loaded into the control center at runtime.

 The module in principle is a simple widget displaying the
 item to be changed. The module has a very small interface.

 All the necessary glue logic and the GUI bells and whistles
 are provided by the control center and must not concern
 the module author.

 To write a config module, you have to create a library
 that contains at one factory function like this:

 <pre>
 #include <kgenericfactory.h>

 typedef KGenericFactory<YourKCModule, QWidget> YourKCModuleFactory;
 K_EXPORT_COMPONENT_FACTORY( yourLibName, YourKCModuleFactory );
 </pre>

 See kdebase/kcontrol/HOWTO for more detailed documentation.

 @author Matthias Hoelzer-Kluepfel <hoelzer@kde.org>
 
 @short 
 The base class for control center modules.
*/
#define KCMODULE_Help	1
#define KCMODULE_Default	2
#define KCMODULE_Apply	16
#define KCMODULE_Reset	4
#define KCMODULE_Cancel	8
#define KCMODULE_Ok	32
#define KCMODULE_SysDefault	64
kde_KCModule * kde_new_KCModule(qt_QWidget * parent, char* name, qt_QStringList* args);
kde_KCModule * kde_new_KCModule1(kde_KInstance* instance, qt_QWidget * parent, qt_QStringList* args);
void kde_del_KCModule( kde_KCModule* p );

/** 
 Load the configuration data into the module.

 The load method sets the user interface elements of the
 module to reflect the current settings stored in the
 configuration files.

 This method is invoked whenever the module should read its configuration
 (most of the times from a config file) and update the user interface.
 This happens when the user clicks the "Reset" button in the control
 center, to undo all of his changes and restore the currently valid
 settings. NOTE that this is not called after the modules is loaded,
 so you probably want to call this method in the constructor.
   
*/
void kde_KCModule_load(kde_KCModule* instPointer);

/** 
 Save the configuration data.

 The save method stores the config information as shown
 in the user interface in the config files.

 If necessary, this method also updates the running system,
 e.g. by restarting applications.

 save is called when the user clicks "Apply" or "Ok".
   
*/
void kde_KCModule_save(kde_KCModule* instPointer);

/** 
 Sets the configuration to sensible default values.

 This method is called when the user clicks the "Default"
 button. It should set the display to useful values.
   
*/
void kde_KCModule_defaults(kde_KCModule* instPointer);

/** 
 Set the configuration to system default values.

 This method is called when the user clicks the "System-Default"
 button. It should set the display to the system default values.

 NOTE: The default behaviour is to call defaults().
   
*/
void kde_KCModule_sysdefaults(kde_KCModule* instPointer);

/** 
 Return a quick-help text.

 This method is called when the module is docked.
 The quick-help text should contain a short description of the module and
 links to the module's help files. You can use QML formating tags in the text.

 NOTE: Please make sure the quick help text gets translated (use i18n()).
   
*/
qt_QString * kde_KCModule_quickHelp(kde_KCModule* instPointer);

/** 
 Returns a the KAboutData for this module
 This is generally only called for the KBugReport.
 Override and have it return a pointer to a constant
   
*/
kde_KAboutData* kde_KCModule_aboutData(kde_KCModule* instPointer);

/** 
 Indicate which buttons will be used.

 The return value is a value or'ed together from
 the Button enumeration type.

*/
int kde_KCModule_buttons(kde_KCModule* instPointer);

/** 
 Get the RootOnly message for this module.

 When the module must be run as root, or acts differently
 for root and a normal user, it is sometimes useful to
 customize the message that appears at the top of the module
 when used as a normal user. This function returns this
 customized message. If none has been set, a default message
 will be used.

*/
qt_QString * kde_KCModule_rootOnlyMsg(kde_KCModule* instPointer);

/** 
 Tell if KControl should show a RootOnly message when run as
 a normal user.

 In some cases, the module don't want a RootOnly message to
 appear (for example if it has already one). This function
 tells KControl if a RootOnly message should be shown

*/
int kde_KCModule_useRootOnlyMsg(kde_KCModule* instPointer);
kde_KInstance* kde_KCModule_instance(kde_KCModule* instPointer);

/** 
 Sets the buttons to display.

 Help: shows a "Help" button.
 Default: shows a "Use Defaults" button
 Apply: in kcontrol this will show an "Apply" and "Reset" button
        in kcmshell this will show an "Ok", "Apply" and "Cancel" button

 If Apply is not specified, kcmshell will show a "Close" button.

*/
void kde_KCModule_setButtons(kde_KCModule* instPointer,int btn);

/** 
 Sets the RootOnly message.

 This message will be shown at the top of the module of the
 corresponding desktop file contains the line X-KDE-RootOnly=true.
 If no message is set, a default one will be used.

*/
void kde_KCModule_setRootOnlyMsg(kde_KCModule* instPointer,qt_QString * msg);

/** 
 Change wether or not the RootOnly message should be shown.

 Following the value of @p on, the RootOnly message will be
 shown or not.

*/
void kde_KCModule_setUseRootOnlyMsg(kde_KCModule* instPointer,int on);

#endif
