/***************************************************************************
                            kde_DCOPClient.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DCOPCLIENT
#define KDE_DCOPCLIENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Inter-process communication and remote procedure calls
 for KDE applications.

 This class provides IPC and RPC for KDE applications.  Usually you
 will not have to instantiate one yourself because @ref KApplication
 contains a method to return a pointer to a DCOPClient object which
 can be used for your whole application.

 Before being able to send or receive any DCOP messages, you will have
 to attach your client object to the DCOP server, and then register
 your application with a specific name. See @ref attach()
 and @ref registerAs() for
 more information.

 Data to be sent should be serialized into a @ref QDataStream which was
 initialized with the @ref QByteArray that you actually intend to send
 the data in.  An example of how you might do this:

 <pre>
   QByteArray data;
   QDataStream arg(data, IO_WriteOnly);
   arg << QString("This is text I am serializing");
   client->send("someApp", "someObject", "someFunction", arg);
 </pre>

 @author Preston Brown <pbrown@kde.org>, Matthias Ettrich <ettrich@kde.org>
 
 @short 
 Inter-process communication and remote procedure calls
 for KDE applications.
*/

/** 
 Constructs a new DCOP client, but does not attach to any server.  
*/
kde_DCOPClient * kde_new_DCOPClient();

/** 
 Cleans up any open connections and dynamic data.
   
*/
void kde_del_DCOPClient( kde_DCOPClient* p );

/** 
 Attaches to the DCOP server.

 If the connection was already attached,
 the connection will be re-established with the current server address.

 Naturally, only attached application can use DCOP services.

 If a @ref QApplication object exists then client registers itself as
 @ref QApplication::name() + "-" + <pid>.
 If no @ref QApplication object exists the client registers itself as
 "anonymous".

 If you want to register differently, you should use @ref registerAs()
 instead.

*/
int kde_DCOPClient_attach(kde_DCOPClient* instPointer);

/** 

 Internal function for @ref KUniqueApplication to register the @ref DCOPClient
 with the application in case the application didn't exist at the
 time the @ref DCOPClient was created.
   
*/
void kde_DCOPClient_bindToApp(kde_DCOPClient* instPointer);

/** 
 Detaches from the DCOP server.
   
*/
int kde_DCOPClient_detach(kde_DCOPClient* instPointer);

/** 
 Returns whether or not the client is attached to the server.
   
*/
int kde_DCOPClient_isAttached(kde_DCOPClient* instPointer);

/** 
 Returns whether the client is attached to a server owned by
 another user.
   
*/
int kde_DCOPClient_isAttachedToForeignServer(kde_DCOPClient* instPointer);

/** 
 Returns whether the client handles incoming calls.
   
*/
int kde_DCOPClient_acceptCalls(kde_DCOPClient* instPointer);

/** 
 Specify whether the client should accept incoming calls.
 By default clients accept incoming calls, but not when connected
 to a foreign server.
   
*/
void kde_DCOPClient_setAcceptCalls(kde_DCOPClient* instPointer,int b);

/** 
 Registers at the DCOP server.

 If the application was already registered,
 the registration will be re-done with the new @ref appId.

 @p appId is a @p unique application/program id that the server
 will use to associate requests with. If there is already an application
 registered with the same name, the server will add a number to the
 id to unify it. If @p addPID is true, the PID of the current process
 will be added to id.

 Registration is necessary if you want to allow other clients to talk
 to you.  They can do so using your @p appId as first parameter
 for @ref send() or @ref call(). If you just want to talk to
  other clients, you
 do not need to register at the server. In that case @ref attach() is
 enough.
 It will implicitly register you as "anonymous".

*/
qt_QCString* kde_DCOPClient_registerAs(kde_DCOPClient* instPointer,qt_QCString* appId, int addPID);

/** 
 Returns whether or not the client is registered at the server.
   
*/
int kde_DCOPClient_isRegistered(kde_DCOPClient* instPointer);

/** 
 Returns the current app id or a null string if the application
 hasn't yet been registered.
   
*/
qt_QCString* kde_DCOPClient_appId(kde_DCOPClient* instPointer);

/** 

*/
int kde_DCOPClient_socket(kde_DCOPClient* instPointer);

/** 
 Temporarily suspends processing of DCOP events.
 This can be usefull if you need to show e.g. a dialog before
 your application is ready to accept DCOP requests. Normally the
 dialog would start an event loop and in this event loop DCOP
 requests will be handled.

 Be aware that not responding to DCOP requests may cause other
 programs that want to communicate with your application, to hang.
   
*/
void kde_DCOPClient_suspend(kde_DCOPClient* instPointer);

/** 
 Resumes the processing of DCOP events.
 See @ref suspend().
   
*/
void kde_DCOPClient_resume(kde_DCOPClient* instPointer);

/** 
 Sends a data block to the server.

*/
int kde_DCOPClient_send(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, qt_QCString* remFun, qt_QByteArray* data);

/** 
 This function acts exactly the same as the above, but the data
 parameter can be specified as a @ref QString for convenience.
   
*/
int kde_DCOPClient_send1(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, qt_QCString* remFun, qt_QString * data);

/** 
 Performs a synchronous send and receive.

  The parameters are the same as for send, with the exception of
  another @ref QByteArray being provided for results to be
  (optionally) returned in.

 A call blocks the application until the process receives the
 answer.

 If @p useEventLoop is true, a local event loop will be started after
 1/10th of a second in order to keep the user interface updated
 (by processing paint events and such) until an answer is received.

*/
int kde_DCOPClient_call(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, qt_QCString* remFun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData, int useEventLoop);

/** 
 Searches for an object which matches a criteria.

 findObject calls @p remFun in the applications and objects identified
 by @p remApp and @p remObj until @p remFun returns true. The name of
 the application and object that returned true are returned in
 @p foundApp and @p foundObj respectively.

 If @p remFun is empty a default function is called in the object
 which always returns @p true.

 A findObject blocks the application until the process receives the
 answer.

 If @p useEventLoop is true, a local event loop will be started after
 1/10th of a second in order to keep the user interface updated
 (by processing paint events and such) until an answer is received.

*/
int kde_DCOPClient_findObject(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, qt_QCString* remFun, qt_QByteArray* data, qt_QCString* foundApp, qt_QCString* foundObj, int useEventLoop);

/** 
 Emits @p signal as DCOP signal from object @p object with @p data as
 arguments.
   
*/
void kde_DCOPClient_emitDCOPSignal(kde_DCOPClient* instPointer,qt_QCString* object, qt_QCString* signal, qt_QByteArray* data);
void kde_DCOPClient_emitDCOPSignal1(kde_DCOPClient* instPointer,qt_QCString* signal, qt_QByteArray* data);

/** 
 Connects to a DCOP signal.

*/
int kde_DCOPClient_connectDCOPSignal(kde_DCOPClient* instPointer,qt_QCString* sender, qt_QCString* senderObj, qt_QCString* signal, qt_QCString* receiverObj, qt_QCString* slot, int Volatile);
int kde_DCOPClient_connectDCOPSignal1(kde_DCOPClient* instPointer,qt_QCString* sender, qt_QCString* signal, qt_QCString* receiverObj, qt_QCString* slot, int Volatile);

/** 
 Disconnects a DCOP signal.

 A special case is when both sender & signal are empty. In this
 case all connections related to @p receiverObj in the current client
 are disconnected. (Both connections from as well as to this object!)

*/
int kde_DCOPClient_disconnectDCOPSignal(kde_DCOPClient* instPointer,qt_QCString* sender, qt_QCString* senderObj, qt_QCString* signal, qt_QCString* receiverObj, qt_QCString* slot);
int kde_DCOPClient_disconnectDCOPSignal1(kde_DCOPClient* instPointer,qt_QCString* sender, qt_QCString* signal, qt_QCString* receiverObj, qt_QCString* slot);

/** 
 Reimplement this function to handle app-wide function calls unassociated w/an object.

 Note that @p fun is normalized. See @ref normalizeFunctionSignature().

 If you do not want to reimplement this function for whatever reason,
 you can also use a default object  or a @ref DCOPObjectProxy.

*/
int kde_DCOPClient_process(kde_DCOPClient* instPointer,qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** 
 Delays the reply of the current function call
 until @ref endTransaction() is called.

 This allows a server to queue requests.

 Note: Should be called from inside @ref process() only!
   
*/
//kde_DCOPClientTransaction* kde_DCOPClient_beginTransaction(kde_DCOPClient* instPointer);

/** 
 Sends the delayed reply of a function call.
   
*/
//void kde_DCOPClient_endTransaction(kde_DCOPClient* instPointer,kde_DCOPClientTransaction* arg1, qt_QCString* replyType, qt_QByteArray* replyData);

/** 
 Test whether the current function call is delayed.

 Note: Should be called from inside @ref process() only!

*/
int kde_DCOPClient_transactionId(kde_DCOPClient* instPointer);

/** 
 Checks whether @p remApp is registered with the @ref DCOPServer.

*/
int kde_DCOPClient_isApplicationRegistered(kde_DCOPClient* instPointer,qt_QCString* remApp);

/** 
 Retrieves the list of all currently registered applications
 from dcopserver.
   
*/
kde_QCStringList* kde_DCOPClient_registeredApplications(kde_DCOPClient* instPointer);

/** 
 Retrieves the list of objects of the remote application @p remApp.
   
*/
kde_QCStringList* kde_DCOPClient_remoteObjects(kde_DCOPClient* instPointer,qt_QCString* remApp, int* ok);

/** 
 Retrieves the list of interfaces of the remote object @p remObj
 of application @p remApp.
  
*/
kde_QCStringList* kde_DCOPClient_remoteInterfaces(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, int* ok);

/** 
 Retrieves the list of functions of the remote object @p remObj
 of application @p remApp
  
*/
kde_QCStringList* kde_DCOPClient_remoteFunctions(kde_DCOPClient* instPointer,qt_QCString* remApp, qt_QCString* remObj, int* ok);

/** 
 Receives a DCOPSend or DCOPCall message from the server.

   
*/
int kde_DCOPClient_receive(kde_DCOPClient* instPointer,qt_QCString* app, qt_QCString* obj, qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** 
 Receives a @p DCOPFind message from the server.

   
*/
int kde_DCOPClient_find(kde_DCOPClient* instPointer,qt_QCString* app, qt_QCString* obj, qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** 
 Returns the @p appId of the last application that talked to us.
   
*/
qt_QCString* kde_DCOPClient_senderId(kde_DCOPClient* instPointer);

/** 
 Installs object @p objId as application-wide default object.

 All app-wide messages that have not been processed by the dcopclient
 will be send further to @p objId.
    
*/
void kde_DCOPClient_setDefaultObject(kde_DCOPClient* instPointer,qt_QCString* objId);

/** 
 Returns the current default object or an empty string if no object is
 installed as default object.

 A default object receives application-wide messages that have not
 been processed by the DCOPClient itself.
     
*/
qt_QCString* kde_DCOPClient_defaultObject(kde_DCOPClient* instPointer);

/** 
 Enables / disables the @ref applicationRegistered() /
 @ref applicationRemoved() signals.
 Note that a counter is maintained about how often this method
 was called. If this method is called twice with @p enabled set to
 true, notifications will be enabled until it was called with
 @p enabled set to false as often.

 They are disabled by default.  
*/
void kde_DCOPClient_setNotifications(kde_DCOPClient* instPointer,int enabled);

/** 
 Tells the dcopserver to treat the client as daemon client, not
 as regular client.
 If the number of regular clients drops down to zero, the
 dcopserver will emit a KDE termination signal after 10
 seconds.
   
*/
void kde_DCOPClient_setDaemonMode(kde_DCOPClient* instPointer,int daemonMode);

/** 
 Sets the address of a server to use upon attaching.

 If no server address is ever specified, attach will try its best to
 find the server anyway.
   
*/
void kde_DCOPClient_setServerAddress( qt_QCString* addr);

/** 
 Normalizes the function signature @p fun.

 A normalized signature doesn't contain any unnecessary whitespace
 anymore. The remaining whitespace consists of single blanks only (0x20).

 Example for a normalized signature:
 <pre>
   "someFunction(QString,int)"
 </pre>

 When using @ref send() or @ref call(), normalization is done
 automatically for you.

   
*/
qt_QCString* kde_DCOPClient_normalizeFunctionSignature( qt_QCString* fun);

/** 
 Returns the application's main dcop client. The main client can
 be used by objects that do not have any specific access to a dcop
 client. In KDE applications, the main client usually is the same
 as KAppliction::dcopClient().
   
*/
kde_DCOPClient* kde_DCOPClient_mainClient( );

/** 
 Sets the application's main dcop client. The main client can
 be used by objects that do not have any specific access to a dcop
 client. In KDE applications, the main client usually is the same
 as KAppliction::dcopClient().
   
*/
void kde_DCOPClient_setMainClient( kde_DCOPClient* arg1);

/** 

    
*/
void kde_DCOPClient_emergencyClose( );

/** 

 Provides information about the last DCOP call for debugging purposes.
    
*/
char* kde_DCOPClient_postMortemSender( );
char* kde_DCOPClient_postMortemObject( );
char* kde_DCOPClient_postMortemFunction( );

/** 
 File with information how to reach the dcopserver.

*/
qt_QCString* kde_DCOPClient_dcopServerFile( qt_QCString* hostname);

/** 
 For backwards compatibility with KDE 2.x
    
*/
qt_QCString* kde_DCOPClient_dcopServerFileOld( qt_QCString* hostname);
void kde_DCOPClient_processSocketData(kde_DCOPClient* instPointer,int socknum);

#endif
