/* This file is part of the KDE Project
   Copyright (C) 2001 Kurt Granroth <granroth@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#include "plugin_babelfish.h"

#include <kaction.h>
#include <kinstance.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kgenericfactory.h>

#include <khtml_part.h>

typedef KGenericFactory<PluginBabelFish> BabelFishFactory;
K_EXPORT_COMPONENT_FACTORY( libbabelfishplugin, BabelFishFactory( "babelfish" ) );

PluginBabelFish::PluginBabelFish( QObject* parent, const char* name,
	                          const QStringList & )
  : Plugin( parent, name )
{
  KActionMenu *menu;
  menu = new KActionMenu( i18n("Tr&anslate Web Page"), "babelfish",
                          actionCollection(), "translatewebpage" );
  menu->setDelayed( false );

  menu->insert( new KAction( i18n("English to French"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "en_fr") );
  menu->insert( new KAction( i18n("English to German"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "en_de") );
  menu->insert( new KAction( i18n("English to Italian"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "en_it") );
  menu->insert( new KAction( i18n("English to Portuguese"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "en_pt") );
  menu->insert( new KAction( i18n("English to Spanish"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "en_es") );
  menu->insert( new KAction( i18n("French to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "fr_en") );
  menu->insert( new KAction( i18n("German to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "de_en") );
  menu->insert( new KAction( i18n("Italian to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "it_en") );
  menu->insert( new KAction( i18n("Portuguese to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "pt_en") );
  menu->insert( new KAction( i18n("Spanish to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "es_en") );
  menu->insert( new KAction( i18n("Russian to English"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "ru_en") );
  menu->insert( new KAction( i18n("German to French"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "de_fr") );
  menu->insert( new KAction( i18n("French to German"), 0,
                             this, SLOT(translateURL()),
                             actionCollection(), "fr_de") );
}

PluginBabelFish::~PluginBabelFish()
{
}

void PluginBabelFish::translateURL()
{
  // we need the sender() for the language name
  if ( !sender() )
    return;

  // The parent is assumed to be a KHTMLPart
  if ( !parent()->inherits("KHTMLPart") )
  {
    QString title = i18n( "Cannot translate source" );
    QString text = i18n( "You cannot translate anything except web pages with "
                         "this plugin, sorry." );

    KMessageBox::sorry( 0L, text, title );
    return;
  }

  // Get URL
  KHTMLPart *part = dynamic_cast<KHTMLPart *>(parent());
  if ( !part )
    return;

  QString query;
  // we check if we have text selected.  if so, we translate that.  if
  // not, we translate the url
  if ( part->hasSelection() )
    query = "text=" + KURL::encode_string( part->selectedText() );
  else
  {
    KURL url = part->url();
    query = "urltext=" + KURL::encode_string( url.url() );

    // Check syntax
    if ( url.isMalformed() )
    {
      QString title = i18n( "Malformed URL" );
      QString text = i18n( "The URL you entered is not valid, please "
                           "correct it and try again" );
      KMessageBox::sorry( 0L, text, title );
      return;
    }
  }

  // Create babelfish URL
  KURL babel( "http://babel.altavista.com/translate.dyn" );

  // Handle the language
  query += "&lp=";
  query += sender()->name();

  babel.setQuery( query );

  // Connect to the fish
  part->openURL( babel );
}

#include <plugin_babelfish.moc>
