/*************************
 Russian conversions
 (c) 1999 Jeremy Wise
 GnomeICU
**************************/

#include "common.h"
#include "gnomeicu.h"
#include "rus_conv.h"

guchar kw[] = {
               128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
               144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
               160,161,162,184,186,165,179,191,168,169,170,171,172,180,174,175,
               176,177,178,168,170,181,178,175,184,185,186,187,188,165,190,169,
               254,224,225,246,228,229,244,227,245,232,233,234,235,236,237,238,
               239,255,240,241,242,243,230,226,252,251,231,248,253,249,247,250,
               222,192,193,214,196,197,212,195,213,200,201,202,203,204,205,206,
               207,223,208,209,210,211,198,194,220,219,199,216,221,217,215,218
};

guchar wk[] = {
	       128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
               144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
               160,161,162,180,164,189,166,167,179,191,170,171,172,173,174,183,
               176,177,182,166,180,181,182,183,163,185,186,187,164,173,190,167,
               225,226,247,231,228,229,246,250,233,234,235,236,237,238,239,240,
               242,243,244,245,230,232,227,254,251,253,255,249,248,252,224,241,
               193,194,215,199,196,197,214,218,201,202,203,204,205,206,207,208,
               210,211,212,213,198,200,195,222,219,221,223,217,216,220,192,209
};

gchar l2w[] = { 128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,
               144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,
               160,165,162,163,164,188,140,167,168,138,170,141,143,173,142,175,
               176,185,178,179,180,190,156,161,184,154,186,157,159,189,158,191,
               192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
               208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
               224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
               240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,183 };


gchar wl2[] = { 128,129,39,131,34,46,124,124,136,111,169,60,166,171,174,172,
               144,96,39,34,34,42,45,45,152,40,185,62,182,187,190,188,
               160,183,162,163,164,161,124,167,168,40,170,62,110,173,40,175,
               176,43,178,179,180,117,182,255,184,177,186,60,165,189,181,191,
               192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,
               208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,
               224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,
               240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255 };

/*** Global functions ***/
void rus_conv( short to, char *t_in )
{
	static guchar *table = NULL;
	int i;

	if (t_in == NULL)
		return;

	if (toggles->russian == FALSE && toggles->latin2 == FALSE)
		return;

	switch( to )
	{
		case RUS_WIN_KOI:
			if (toggles->latin2 == TRUE)
				table = wl2;
			else
				table = wk;
			break;
		case RUS_KOI_WIN:
			if (toggles->latin2 == TRUE)
				table = l2w;
			else
				table = kw;
			break;
		default:
			g_warning( "Unknown encoding\n" );
			return;
	}

	for( i = 0; t_in[ i ] != '\0'; i++ )
	{
		t_in[ i ] &= 255;
		
		if(t_in[ i ] & 128)
		{
			t_in[ i ] = table[ t_in[ i ] & 127 ];
		}
	}
}
