# Note that this is NOT a relocatable package
%define ver      1.1.2
%define rel      1
%define prefix   /usr

Summary: Gnet, a network library
Name:      gnet
Version:   %ver
Release:   %rel
Copyright: LGPL
Group: Libraries/Network
Source0:   gnet-%{PACKAGE_VERSION}.tar.gz
URL:       http://www.gnetlibrary.org
BuildRoot: /var/tmp/gnet-%{PACKAGE_VERSION}-root
Docdir: %{prefix}/doc
Packager: Xavier Nicolovici <nicolovi@club-internet.fr>
Requires: glib >= 1.2

%description
Gnet is a simple network library.  It is writen in C, object-oriented,
and built upon GLib.  It is intended to be small, fast, easy-to-use,
and easy to port.

Features:
  * TCP "client" and "server" sockets
  * UDP and IP Multicast
  * Internet address abstraction
  * Asynchronous socket IO
  * Asynchronous DNS lookup
  * Byte packing and unpacking
  * URLs (Experimental)
  * Server and Conn objects (Experimental)

Comments and questions should be sent to gnet@gnetlibrary.org.

The Gnet homepage is at <http://www.gnetlibrary.org>.

%package devel
Summary: Header files for the Gnet library
Group: Development/Libraries

%description devel
Gnet is a simple network library.  It is writen in C, object-oriented,
and built upon GLib.
This package allows you to develop applications that use the Gnet
library.


%prep
%setup

%build
%ifarch alpha
   CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure --host=alpha-redhat-linux\
	--prefix=%{prefix} \
	--enable-debug=yes \
	--with-gnu-ld
%else
   CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix=%{prefix} \
	--enable-debug=yes \
	--with-gnu-ld 
%endif
make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%post
/sbin/ldconfig

%postun
/sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc README COPYING ChangeLog NEWS TODO AUTHORS INSTALL HACKING
%{prefix}/bin/gnet-config
%{prefix}/share/aclocal/gnet.m4
%doc doc/html
%{prefix}/lib/libgnet-1.1.so.*

%files devel
%defattr(-, root, root)
%{prefix}/include/gnet
%{prefix}/lib/*a
%{prefix}/lib/gnet
%{prefix}/lib/lib*.so

%changelog
* Thu Oct 26 2000 Benjamin Kahn <xkahn@helixcode.com>
- Added missing file in lib/gnet

* Mon Feb 28 2000 David Helder <dhelder@umich.edu>
- Updated for version 1.0

* Sat Jan 15 2000 Xavier Nicolovici <nicolovi@club-internet.fr>
- Moved lib*.so and lib*a to the devel package
- Creation of a gnet.spec.in for autoconf process

* Wed Jan 14 2000 Xavier Nicolovici <nicolovi@club-internet.fr>
- HTML documentation has been move to /usr/doc/gnet-{version}/html

* Thu Jan 13 2000 Xavier Nicolovici <nicolovi@club-internet.fr>
- First try at an RPM
