.TH "ZIP_UNCHANGE" "3" "April 23, 2006" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_unchange\fP
\- undo changes to file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
int
zip_unchange zip_t *archive int index
.SH "DESCRIPTION"
Changes to the file at position
\fIindex\fP
are reverted.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fP
is set to indicate the error.
.SH "ERRORS"
zip_unchange
fails if:
.TP 17n
[\fRZIP_ER_EXISTS\fP]
Unchanging the name would result in a duplicate name in the archive.
.TP 17n
[\fRZIP_ER_INVAL\fP]
\fIindex\fP
is not a valid file index in
\fIzip\fP.
.SH "SEE ALSO"
libzip(3),
zip_unchange_all(3),
zip_unchange_archive(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
