/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMPluginArray.h"

#include "DOMPlugin.h"
#include "DOMPluginArray.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMPlugin.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDOMPluginArray);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayTableValues[3] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMPluginArrayConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayTable = { 5, 3, JSDOMPluginArrayTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayConstructorTable = { 1, 0, JSDOMPluginArrayConstructorTableValues, 0 };
class JSDOMPluginArrayConstructor : public DOMConstructorObject {
public:
    JSDOMPluginArrayConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSDOMPluginArrayConstructor::s_info = { "PluginArrayConstructor", &DOMConstructorObject::s_info, &JSDOMPluginArrayConstructorTable, 0 };

JSDOMPluginArrayConstructor::JSDOMPluginArrayConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMPluginArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDOMPluginArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDOMPluginArrayConstructor, JSDOMWrapper>(exec, &JSDOMPluginArrayConstructorTable, this, propertyName, slot);
}

bool JSDOMPluginArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDOMPluginArrayConstructor, JSDOMWrapper>(exec, &JSDOMPluginArrayConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSDOMPluginArrayPrototypeTableValues[4] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "namedItem", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionNamedItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { "refresh", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsDOMPluginArrayPrototypeFunctionRefresh), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSDOMPluginArrayPrototypeTable = { 8, 7, JSDOMPluginArrayPrototypeTableValues, 0 };
const ClassInfo JSDOMPluginArrayPrototype::s_info = { "PluginArrayPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSDOMPluginArrayPrototypeTable, 0 };

JSObject* JSDOMPluginArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMPluginArray>(exec, globalObject);
}

bool JSDOMPluginArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, this, propertyName, slot);
}

bool JSDOMPluginArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDOMPluginArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDOMPluginArray::s_info = { "PluginArray", &JSDOMWrapper::s_info, &JSDOMPluginArrayTable, 0 };

JSDOMPluginArray::JSDOMPluginArray(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMPluginArray> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMPluginArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDOMPluginArrayPrototype(exec->globalData(), globalObject, JSDOMPluginArrayPrototype::createStructure(globalObject->globalData(), globalObject->objectPrototype()));
}

bool JSDOMPluginArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSDOMPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DOMPluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, this, propertyName, slot);
}

bool JSDOMPluginArray::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSDOMPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<DOMPluginArray*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<DOMPluginArray*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSDOMPluginArray, Base>(exec, &JSDOMPluginArrayTable, this, propertyName, descriptor);
}

bool JSDOMPluginArray::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<DOMPluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsDOMPluginArrayLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsDOMPluginArrayConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSDOMPluginArray* domObject = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    return JSDOMPluginArray::getConstructor(exec, domObject->globalObject());
}

void JSDOMPluginArray::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<DOMPluginArray*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSDOMPluginArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMPluginArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->namedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMPluginArrayPrototypeFunctionRefresh(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDOMPluginArray::s_info))
        return throwVMTypeError(exec);
    JSDOMPluginArray* castedThis = static_cast<JSDOMPluginArray*>(asObject(thisValue));
    DOMPluginArray* imp = static_cast<DOMPluginArray*>(castedThis->impl());
    bool reload(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->refresh(reload);
    return JSValue::encode(jsUndefined());
}


JSValue JSDOMPluginArray::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSDOMPluginArray* thisObj = static_cast<JSDOMPluginArray*>(asObject(slotBase));
    return toJS(exec, thisObj->globalObject(), static_cast<DOMPluginArray*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSDOMPluginArray* jsDOMPluginArray)
{
    if (jsDOMPluginArray->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMPluginArrayOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMPluginArray* jsDOMPluginArray = static_cast<JSDOMPluginArray*>(handle.get().asCell());
    if (!isObservable(jsDOMPluginArray))
        return false;
    Frame* root = jsDOMPluginArray->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSDOMPluginArrayOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMPluginArray* jsDOMPluginArray = static_cast<JSDOMPluginArray*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMPluginArray->impl(), jsDOMPluginArray);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMPluginArray* impl)
{
    return wrap<JSDOMPluginArray>(exec, globalObject, impl);
}

DOMPluginArray* toDOMPluginArray(JSC::JSValue value)
{
    return value.inherits(&JSDOMPluginArray::s_info) ? static_cast<JSDOMPluginArray*>(asObject(value))->impl() : 0;
}

}
