/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;

class RecordingFrame
extends Frame
implements WindowListener,
ActionListener {
    boolean recording;
    TextField fnameField;
    Button browseButton;
    Label statusLabel;
    Button recordButton;
    Button nextButton;
    Button closeButton;
    VncViewer viewer;

    public static boolean checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPropertyAccess("user.dir");
                securityManager.checkPropertyAccess("file.separator");
            }
            catch (SecurityException securityException) {
                System.out.println("SecurityManager restricts session recording.");
                return false;
            }
        }
        return true;
    }

    RecordingFrame(VncViewer vncViewer) {
        super("TightVNC Session Recording");
        this.viewer = vncViewer;
        String string = this.nextNewFilename(String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "vncsession.fbs");
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 4.0;
        this.fnameField = new TextField(string, 64);
        gridBagLayout.setConstraints(this.fnameField, gridBagConstraints);
        panel.add(this.fnameField);
        this.fnameField.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.browseButton = new Button("Browse");
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        panel.add(this.browseButton);
        this.browseButton.addActionListener(this);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        Label label = new Label("File name to save next recorded session in:", 1);
        gridBagLayout2.setConstraints(label, gridBagConstraints2);
        this.add(label);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(panel, gridBagConstraints2);
        this.add(panel);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(10, 0, 10, 0);
        this.statusLabel = new Label("", 1);
        gridBagLayout2.setConstraints(this.statusLabel, gridBagConstraints2);
        this.add(this.statusLabel);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.recordButton = new Button("Record");
        gridBagLayout2.setConstraints(this.recordButton, gridBagConstraints2);
        this.add(this.recordButton);
        this.recordButton.addActionListener(this);
        this.nextButton = new Button("Next file");
        gridBagLayout2.setConstraints(this.nextButton, gridBagConstraints2);
        this.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.closeButton = new Button("Close");
        gridBagLayout2.setConstraints(this.closeButton, gridBagConstraints2);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.stopRecording();
        this.pack();
        this.addWindowListener(this);
    }

    protected String nextFilename(String string) {
        int n;
        int n2 = n = string.length();
        int n3 = 1;
        if (n > 4 && string.charAt(n - 4) == '.') {
            try {
                n3 = Integer.parseInt(string.substring(n - 3, n)) + 1;
                n2 = n - 4;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        char[] cArray = new char[]{'0', '0', '0'};
        String string2 = String.valueOf(n3);
        if (string2.length() < 3) {
            string2 = String.valueOf(new String(cArray, 0, 3 - string2.length())) + string2;
        }
        return String.valueOf(string.substring(0, n2)) + '.' + string2;
    }

    protected String nextNewFilename(String string) {
        String string2 = string;
        try {
            File file;
            while ((file = new File(string2 = this.nextFilename(string2))).exists()) {
            }
        }
        catch (SecurityException securityException) {}
        return string2;
    }

    protected boolean browseFile() {
        File file = new File(this.fnameField.getText());
        FileDialog fileDialog = new FileDialog((Frame)this, "Save next session as...", 1);
        fileDialog.setDirectory(file.getParent());
        ((Component)fileDialog).setVisible(true);
        if (fileDialog.getFile() != null) {
            String string;
            String string2 = fileDialog.getDirectory();
            String string3 = System.getProperty("file.separator");
            if (string2.length() > 0 && !string3.equals(string2.substring(string2.length() - string3.length()))) {
                string2 = String.valueOf(string2) + string3;
            }
            if ((string = String.valueOf(string2) + fileDialog.getFile()).equals(this.fnameField.getText())) {
                ((TextComponent)this.fnameField).setText(string);
                return true;
            }
        }
        return false;
    }

    public void startRecording() {
        this.statusLabel.setText("Status: Recording...");
        this.statusLabel.setFont(new Font("Helvetica", 1, 12));
        this.statusLabel.setForeground(Color.red);
        this.recordButton.setLabel("Stop recording");
        this.recording = true;
        this.viewer.setRecordingStatus(this.fnameField.getText());
    }

    public void stopRecording() {
        this.statusLabel.setText("Status: Not recording.");
        this.statusLabel.setFont(new Font("Helvetica", 0, 12));
        this.statusLabel.setForeground(Color.black);
        this.recordButton.setLabel("Record");
        this.recording = false;
        this.viewer.setRecordingStatus(null);
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.browseButton) {
            if (this.browseFile() && this.recording) {
                this.startRecording();
                return;
            }
        } else {
            if (actionEvent.getSource() == this.recordButton) {
                if (!this.recording) {
                    this.startRecording();
                    return;
                }
                this.stopRecording();
                ((TextComponent)this.fnameField).setText(this.nextNewFilename(this.fnameField.getText()));
                return;
            }
            if (actionEvent.getSource() == this.nextButton) {
                ((TextComponent)this.fnameField).setText(this.nextNewFilename(this.fnameField.getText()));
                if (this.recording) {
                    this.startRecording();
                    return;
                }
            } else if (actionEvent.getSource() == this.closeButton) {
                ((Component)this).setVisible(false);
            }
        }
    }
}

