//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Collections.Generic;

    public interface ISlaveBase {
        void Exit();
        void DispatchLoop();
        void Data(QByteArray data);
        void DataReq();
        void Opened();
        void error(int _errid, string _text);
        void Connected();
        void Finished();
        void NeedSubUrlData();
        void SlaveStatus(string host, bool connected);
        void StatEntry(KIO.UDSEntry _entry);
        void ListEntries(List<KIO.UDSEntry> _entry);
        bool CanResume(long offset);
        void CanResume();
        void TotalSize(long _bytes);
        void ProcessedSize(long _bytes);
        void Position(long _pos);
        void Written(long _bytes);
        void ProcessedPercent(float percent);
        void Speed(ulong _bytes_per_second);
        void Redirection(KUrl _url);
        void ErrorPage();
        void MimeType(string _type);
        void Warning(string msg);
        void InfoMessage(string msg);
        int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption, string buttonYes, string buttonNo);
        int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption, string buttonYes);
        int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption);
        int MessageBox(KIO.SlaveBase.MessageBoxType type, string text);
        int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes, string buttonNo, string dontAskAgainName);
        int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes, string buttonNo);
        int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes);
        int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption);
        int MessageBox(string text, KIO.SlaveBase.MessageBoxType type);
        void SetMetaData(string key, string value);
        bool HasMetaData(string key);
        string MetaData(string key);
        KIO.MetaData AllMetaData();
        KConfigGroup Config();
        KRemoteEncoding RemoteEncoding();
        void SetHost(string host, ushort port, string user, string pass);
        void SetSubUrl(KUrl url);
        void OpenConnection();
        void CloseConnection();
        void Get(KUrl url);
        void Open(KUrl url, uint mode);
        void Read(long size);
        void Write(QByteArray data);
        void Seek(long offset);
        void Close();
        void Put(KUrl url, int permissions, uint flags);
        void Stat(KUrl url);
        void Mimetype(KUrl url);
        void ListDir(KUrl url);
        void Mkdir(KUrl url, int permissions);
        void Rename(KUrl src, KUrl dest, uint flags);
        void Symlink(string target, KUrl dest, uint flags);
        void Chmod(KUrl url, int permissions);
        void Chown(KUrl url, string owner, string group);
        void SetModificationTime(KUrl url, QDateTime mtime);
        void Copy(KUrl src, KUrl dest, int permissions, uint flags);
        void Del(KUrl url, bool isfile);
        void SetLinkDest(KUrl url, string target);
        void Special(QByteArray data);
        void MultiGet(QByteArray data);
        void Slave_status();
        void ReparseConfiguration();
        int ConnectTimeout();
        int ProxyConnectTimeout();
        int ResponseTimeout();
        int ReadTimeout();
        void SetTimeoutSpecialCommand(int timeout, QByteArray data);
        void SetTimeoutSpecialCommand(int timeout);
        void Dispatch(int command, QByteArray data);
        void DispatchOpenCommand(int command, QByteArray data);
        int ReadData(QByteArray buffer);
        void ListEntry(KIO.UDSEntry _entry, bool ready);
        void ConnectSlave(string path);
        void DisconnectSlave();
        bool OpenPasswordDialog(KIO.AuthInfo info, string errorMsg);
        bool OpenPasswordDialog(KIO.AuthInfo info);
        bool CheckCachedAuthentication(KIO.AuthInfo info);
        bool CacheAuthentication(KIO.AuthInfo info);
        bool RequestNetwork(string host);
        bool RequestNetwork();
        void DropNetwork(string host);
        void DropNetwork();
        int WaitForAnswer(int expected1, int expected2, QByteArray data, ref int pCmd);
        int WaitForAnswer(int expected1, int expected2, QByteArray data);
        void SendMetaData();
        void SendAndKeepMetaData();
        bool WasKilled();
        void SetKillFlag();
        void LookupHost(string host);
        int WaitForHostInfo(QHostInfo info);
    }
    /// <remarks>
    ///  There are two classes that specifies the protocol between application (job)
    ///  and kioslave. SlaveInterface is the class to use on the application end,
    ///  SlaveBase is the one to use on the slave end.
    ///  Slave implementations should simply inherit SlaveBase
    ///  A call to foo() results in a call to slotFoo() on the other end.
    ///  </remarks>        <short>    There are two classes that specifies the protocol between application (job)  and kioslave.</short>
    [SmokeClass("KIO::SlaveBase")]
    public class SlaveBase : Object, ISlaveBase {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected SlaveBase(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(SlaveBase), this);
        }
        public enum MessageBoxType {
            QuestionYesNo = 1,
            WarningYesNo = 2,
            WarningContinueCancel = 3,
            WarningYesNoCancel = 4,
            Information = 5,
            SSLMessageBox = 6,
        }
        public SlaveBase(QByteArray protocol, QByteArray pool_socket, QByteArray app_socket) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("SlaveBase###", "SlaveBase(const QByteArray&, const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), protocol, typeof(QByteArray), pool_socket, typeof(QByteArray), app_socket);
        }
        /// <remarks>
        ///  Terminate the slave by calling the destructor and then .Exit()
        ///      </remarks>        <short>   </short>
        public void Exit() {
            interceptor.Invoke("exit", "exit()", typeof(void));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        public void DispatchLoop() {
            interceptor.Invoke("dispatchLoop", "dispatchLoop()", typeof(void));
        }
        /// <remarks>
        ///  Sends data in the slave to the job (i.e. in get).
        ///  To signal end of data, simply send an empty
        ///  QByteArray().
        /// <param> name="data" the data read by the slave
        ///      </param></remarks>        <short>    Sends data in the slave to the job (i.</short>
        public void Data(QByteArray data) {
            interceptor.Invoke("data#", "data(const QByteArray&)", typeof(void), typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Asks for data from the job.
        /// </remarks>        <short>    Asks for data from the job.</short>
        ///         <see> readData</see>
        public void DataReq() {
            interceptor.Invoke("dataReq", "dataReq()", typeof(void));
        }
        /// <remarks>
        ///  open succedes
        /// </remarks>        <short>    open succedes </short>
        ///         <see> open</see>
        public void Opened() {
            interceptor.Invoke("opened", "opened()", typeof(void));
        }
        /// <remarks>
        ///  Call to signal an error.
        ///  This also finishes the job, so you must not call
        ///  finished() after calling this.
        ///  If the error code is KIO.ERR_SLAVE_DEFINED then the
        ///  _text should contain the complete translated text of
        ///  of the error message.
        ///  For all other error codes, _text should match the corresponding
        ///  error code. Usually,, _text is a file or host name, or the error which
        ///  was passed from the server.<br>
        ///  For example, for KIO.ERR_DOES_NOT_EXIST, _text may only
        ///  be the file or folder which does not exist, nothing else. Otherwise,
        ///  this would break error strings generated by KIO.BuildErrorString().<br>
        ///  If you have to add more details than what the standard error codes
        ///  provide, you'll need to use KIO.ERR_SLAVE_DEFINED.
        ///  For a complete list of what _text should contain for each error code,
        ///  look at the source of KIO.BuildErrorString().
        ///  You can add rich text markup to the message, the places where the
        ///  error message will be displayed are rich text aware.
        /// <param> name="_errid" the error code from KIO.Error
        /// </param><param> name="_text" the rich text error message
        ///      </param></remarks>        <short>    Call to signal an error.</short>
        ///         <see> Error</see>
        ///         <see> buildErrorString</see>
        public void error(int _errid, string _text) {
            interceptor.Invoke("error$$", "error(int, const QString&)", typeof(void), typeof(int), _errid, typeof(string), _text);
        }
        /// <remarks>
        ///  Call in openConnection, if you reimplement it, when you're done.
        ///      </remarks>        <short>    Call in openConnection, if you reimplement it, when you're done.</short>
        public void Connected() {
            interceptor.Invoke("connected", "connected()", typeof(void));
        }
        /// <remarks>
        ///  Call to signal successful completion of any command
        ///  besides openConnection and closeConnection. Do not
        ///  call this after calling error().
        ///      </remarks>        <short>    Call to signal successful completion of any command  besides openConnection and closeConnection.</short>
        public void Finished() {
            interceptor.Invoke("finished", "finished()", typeof(void));
        }
        /// <remarks>
        ///  Call to signal that data from the sub-URL is needed
        ///      </remarks>        <short>    Call to signal that data from the sub-URL is needed      </short>
        public void NeedSubUrlData() {
            interceptor.Invoke("needSubUrlData", "needSubUrlData()", typeof(void));
        }
        /// <remarks>
        ///  Used to report the status of the slave.
        /// <param> name="host" the slave is currently connected to. (Should be
        ///         empty if not connected)
        /// </param><param> name="connected" Whether an actual network connection exists.
        /// </param></remarks>        <short>    Used to report the status of the slave.</short>
        public void SlaveStatus(string host, bool connected) {
            interceptor.Invoke("slaveStatus$$", "slaveStatus(const QString&, bool)", typeof(void), typeof(string), host, typeof(bool), connected);
        }
        /// <remarks>
        ///  Call this from stat() to express details about an object, the
        ///  UDSEntry customarily contains the atoms describing file name, size,
        ///  mimetype, etc.
        /// <param> name="_entry" The UDSEntry containing all of the object attributes.
        ///      </param></remarks>        <short>    Call this from stat() to express details about an object, the  UDSEntry customarily contains the atoms describing file name, size,  mimetype, etc.</short>
        public void StatEntry(KIO.UDSEntry _entry) {
            interceptor.Invoke("statEntry#", "statEntry(const KIO::UDSEntry&)", typeof(void), typeof(KIO.UDSEntry), _entry);
        }
        /// <remarks>
        ///  Call this in listDir, each time you have a bunch of entries
        ///  to report.
        /// <param> name="_entry" The UDSEntry containing all of the object attributes.
        ///      </param></remarks>        <short>    Call this in listDir, each time you have a bunch of entries  to report.</short>
        public void ListEntries(List<KIO.UDSEntry> _entry) {
            interceptor.Invoke("listEntries?", "listEntries(const QList<KIO::UDSEntry>&)", typeof(void), typeof(List<KIO.UDSEntry>), _entry);
        }
        /// <remarks>
        ///  Call this at the beginning of put(), to give the size of the existing
        ///  partial file, if there is one. The <code>offset</code> argument notifies the
        ///  other job (the one that gets the data) about the offset to use.
        ///  In this case, the boolean returns whether we can indeed resume or not
        ///  (we can't if the protocol doing the get() doesn't support setting an offset)
        ///      </remarks>        <short>    Call this at the beginning of put(), to give the size of the existing  partial file, if there is one.</short>
        public bool CanResume(long offset) {
            return (bool) interceptor.Invoke("canResume$", "canResume(KIO::filesize_t)", typeof(bool), typeof(long), offset);
        }
        /// <remarks>
        ///  Call this at the beginning of get(), if the "resume" metadata was set
        ///  and resuming is implemented by this protocol.
        ///      </remarks>        <short>    Call this at the beginning of get(), if the "resume" metadata was set  and resuming is implemented by this protocol.</short>
        public void CanResume() {
            interceptor.Invoke("canResume", "canResume()", typeof(void));
        }
        /// <remarks>
        ///  Call this in get and copy, to give the total size
        ///  of the file
        ///  Call in listDir too, when you know the total number of items.
        ///      </remarks>        <short>    Call this in get and copy, to give the total size  of the file  Call in listDir too, when you know the total number of items.</short>
        public void TotalSize(long _bytes) {
            interceptor.Invoke("totalSize$", "totalSize(KIO::filesize_t)", typeof(void), typeof(long), _bytes);
        }
        /// <remarks>
        ///  Call this during get and copy, once in a while,
        ///  to give some info about the current state.
        ///  Don't emit it in listDir, listEntries speaks for itself.
        ///      </remarks>        <short>    Call this during get and copy, once in a while,  to give some info about the current state.</short>
        public void ProcessedSize(long _bytes) {
            interceptor.Invoke("processedSize$", "processedSize(KIO::filesize_t)", typeof(void), typeof(long), _bytes);
        }
        public void Position(long _pos) {
            interceptor.Invoke("position$", "position(KIO::filesize_t)", typeof(void), typeof(long), _pos);
        }
        public void Written(long _bytes) {
            interceptor.Invoke("written$", "written(KIO::filesize_t)", typeof(void), typeof(long), _bytes);
        }
        /// <remarks>
        ///  Only use this if you can't know in advance the size of the
        ///  copied data. For example, if you're doing variable bitrate
        ///  compression of the source.
        ///  STUB ! Currently unimplemented. Here now for binary compatibility.
        ///  Call this during get and copy, once in a while,
        ///  to give some info about the current state.
        ///  Don't emit it in listDir, listEntries speaks for itself.
        ///      </remarks>        <short>    Only use this if you can't know in advance the size of the  copied data.</short>
        public void ProcessedPercent(float percent) {
            interceptor.Invoke("processedPercent$", "processedPercent(float)", typeof(void), typeof(float), percent);
        }
        /// <remarks>
        ///  Call this in get and copy, to give the current transfer
        ///  speed, but only if it can't be calculated out of the size you
        ///  passed to processedSize (in most cases you don't want to call it)
        ///      </remarks>        <short>    Call this in get and copy, to give the current transfer  speed, but only if it can't be calculated out of the size you  passed to processedSize (in most cases you don't want to call it)      </short>
        public void Speed(ulong _bytes_per_second) {
            interceptor.Invoke("speed$", "speed(unsigned long)", typeof(void), typeof(ulong), _bytes_per_second);
        }
        /// <remarks>
        ///  Call this to signal a redirection
        ///  The job will take care of going to that url.
        ///      </remarks>        <short>    Call this to signal a redirection  The job will take care of going to that url.</short>
        public void Redirection(KUrl _url) {
            interceptor.Invoke("redirection#", "redirection(const KUrl&)", typeof(void), typeof(KUrl), _url);
        }
        /// <remarks>
        ///  Tell that we will only get an error page here.
        ///  This means: the data you'll get isn't the data you requested,
        ///  but an error page (usually HTML) that describes an error.
        ///      </remarks>        <short>    Tell that we will only get an error page here.</short>
        public void ErrorPage() {
            interceptor.Invoke("errorPage", "errorPage()", typeof(void));
        }
        /// <remarks>
        ///  Call this in mimetype() and in get(), when you know the mimetype.
        ///  See mimetype about other ways to implement it.
        ///      </remarks>        <short>    Call this in mimetype() and in get(), when you know the mimetype.</short>
        public void MimeType(string _type) {
            interceptor.Invoke("mimeType$", "mimeType(const QString&)", typeof(void), typeof(string), _type);
        }
        /// <remarks>
        ///  Call to signal a warning, to be displayed in a dialog box.
        ///      </remarks>        <short>    Call to signal a warning, to be displayed in a dialog box.</short>
        public void Warning(string msg) {
            interceptor.Invoke("warning$", "warning(const QString&)", typeof(void), typeof(string), msg);
        }
        /// <remarks>
        ///  Call to signal a message, to be displayed if the application wants to,
        ///  for instance in a status bar. Usual examples are "connecting to host xyz", etc.
        ///      </remarks>        <short>    Call to signal a message, to be displayed if the application wants to,  for instance in a status bar.</short>
        public void InfoMessage(string msg) {
            interceptor.Invoke("infoMessage$", "infoMessage(const QString&)", typeof(void), typeof(string), msg);
        }
        /// <remarks>
        ///  Call this to show a message box from the slave
        /// <param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
        /// </param><param> name="text" Message string. May contain newlines.
        /// </param><param> name="caption" Message box title.
        /// </param><param> name="buttonYes" The text for the first button.
        ///                   The default is i18n("&Yes").
        /// </param><param> name="buttonNo" The text for the second button.
        ///                   The default is i18n("&No").
        ///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
        ///        and for Information, none is used.
        /// </param></remarks>        <return> a button code, as defined in KMessageBox, or 0 on communication error.
        ///      </return>
        ///         <short>    Call this to show a message box from the slave </short>
        public int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption, string buttonYes, string buttonNo) {
            return (int) interceptor.Invoke("messageBox$$$$$", "messageBox(KIO::SlaveBase::MessageBoxType, const QString&, const QString&, const QString&, const QString&)", typeof(int), typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), text, typeof(string), caption, typeof(string), buttonYes, typeof(string), buttonNo);
        }
        public int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption, string buttonYes) {
            return (int) interceptor.Invoke("messageBox$$$$", "messageBox(KIO::SlaveBase::MessageBoxType, const QString&, const QString&, const QString&)", typeof(int), typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), text, typeof(string), caption, typeof(string), buttonYes);
        }
        public int MessageBox(KIO.SlaveBase.MessageBoxType type, string text, string caption) {
            return (int) interceptor.Invoke("messageBox$$$", "messageBox(KIO::SlaveBase::MessageBoxType, const QString&, const QString&)", typeof(int), typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), text, typeof(string), caption);
        }
        public int MessageBox(KIO.SlaveBase.MessageBoxType type, string text) {
            return (int) interceptor.Invoke("messageBox$$", "messageBox(KIO::SlaveBase::MessageBoxType, const QString&)", typeof(int), typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), text);
        }
        /// <remarks>
        ///  Call this to show a message box from the slave
        /// <param> name="text" Message string. May contain newlines.
        /// </param><param> name="type" type of message box: QuestionYesNo, WarningYesNo, WarningContinueCancel...
        /// </param><param> name="caption" Message box title.
        /// </param><param> name="buttonYes" The text for the first button.
        ///                   The default is i18n("&Yes").
        /// </param><param> name="buttonNo" The text for the second button.
        ///                   The default is i18n("&No").
        ///  Note: for ContinueCancel, buttonYes is the continue button and buttonNo is unused.
        ///        and for Information, none is used.
        /// </param><param> name="dontAskAgain" A checkbox is added with which further confirmation can be turned off.
        ///         If the checkbox was ticked @pdontAskAgain will be set to true, otherwise false.
        /// </param></remarks>        <return> a button code, as defined in KMessageBox, or 0 on communication error.
        ///      </return>
        ///         <short>    Call this to show a message box from the slave </short>
        public int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes, string buttonNo, string dontAskAgainName) {
            return (int) interceptor.Invoke("messageBox$$$$$$", "messageBox(const QString&, KIO::SlaveBase::MessageBoxType, const QString&, const QString&, const QString&, const QString&)", typeof(int), typeof(string), text, typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), caption, typeof(string), buttonYes, typeof(string), buttonNo, typeof(string), dontAskAgainName);
        }
        public int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes, string buttonNo) {
            return (int) interceptor.Invoke("messageBox$$$$$", "messageBox(const QString&, KIO::SlaveBase::MessageBoxType, const QString&, const QString&, const QString&)", typeof(int), typeof(string), text, typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), caption, typeof(string), buttonYes, typeof(string), buttonNo);
        }
        public int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption, string buttonYes) {
            return (int) interceptor.Invoke("messageBox$$$$", "messageBox(const QString&, KIO::SlaveBase::MessageBoxType, const QString&, const QString&)", typeof(int), typeof(string), text, typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), caption, typeof(string), buttonYes);
        }
        public int MessageBox(string text, KIO.SlaveBase.MessageBoxType type, string caption) {
            return (int) interceptor.Invoke("messageBox$$$", "messageBox(const QString&, KIO::SlaveBase::MessageBoxType, const QString&)", typeof(int), typeof(string), text, typeof(KIO.SlaveBase.MessageBoxType), type, typeof(string), caption);
        }
        public int MessageBox(string text, KIO.SlaveBase.MessageBoxType type) {
            return (int) interceptor.Invoke("messageBox$$", "messageBox(const QString&, KIO::SlaveBase::MessageBoxType)", typeof(int), typeof(string), text, typeof(KIO.SlaveBase.MessageBoxType), type);
        }
        /// <remarks>
        ///  Sets meta-data to be send to the application before the first
        ///  data() or finished() signal.
        ///      </remarks>        <short>    Sets meta-data to be send to the application before the first  data() or finished() signal.</short>
        public void SetMetaData(string key, string value) {
            interceptor.Invoke("setMetaData$$", "setMetaData(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
        }
        /// <remarks>
        ///  Queries for the existence of a certain config/meta-data entry
        ///  send by the application to the slave.
        ///      </remarks>        <short>    Queries for the existence of a certain config/meta-data entry  send by the application to the slave.</short>
        public bool HasMetaData(string key) {
            return (bool) interceptor.Invoke("hasMetaData$", "hasMetaData(const QString&) const", typeof(bool), typeof(string), key);
        }
        /// <remarks>
        ///  Queries for config/meta-data send by the application to the slave.
        ///      </remarks>        <short>    Queries for config/meta-data send by the application to the slave.</short>
        public string MetaData(string key) {
            return (string) interceptor.Invoke("metaData$", "metaData(const QString&) const", typeof(string), typeof(string), key);
        }
        /// <remarks>
        ///  Contains all metadata (but no config) sent by the application to the slave.
        ///      </remarks>        <short>   </short>
        public KIO.MetaData AllMetaData() {
            return (KIO.MetaData) interceptor.Invoke("allMetaData", "allMetaData() const", typeof(KIO.MetaData));
        }
        /// <remarks>
        ///  Returns a configuration object to query config/meta-data information
        ///  from.
        ///  The application provides the slave with all configuration information
        ///  relevant for the current protocol and host.
        ///      </remarks>        <short>    Returns a configuration object to query config/meta-data information  from.</short>
        public KConfigGroup Config() {
            return (KConfigGroup) interceptor.Invoke("config", "config()", typeof(KConfigGroup));
        }
        /// <remarks>
        ///  Returns an object that can translate remote filenames into proper
        ///  Unicode forms. This encoding can be set by the user.
        ///      </remarks>        <short>    Returns an object that can translate remote filenames into proper  Unicode forms.</short>
        public KRemoteEncoding RemoteEncoding() {
            return (KRemoteEncoding) interceptor.Invoke("remoteEncoding", "remoteEncoding()", typeof(KRemoteEncoding));
        }
        /// <remarks>
        ///  Set the host
        /// <param> name="pass"  Called directly by createSlave, this is why there is no equivalent in
        ///  SlaveInterface, unlike the other methods.
        /// </param> This method is called whenever a change in host, port or user occurs.
        ///      </remarks>        <short>    Set the host </short>
        [SmokeMethod("setHost(const QString&, unsigned short, const QString&, const QString&)")]
        public virtual void SetHost(string host, ushort port, string user, string pass) {
            interceptor.Invoke("setHost$$$$", "setHost(const QString&, unsigned short, const QString&, const QString&)", typeof(void), typeof(string), host, typeof(ushort), port, typeof(string), user, typeof(string), pass);
        }
        /// <remarks>
        ///  Prepare slave for streaming operation
        ///      </remarks>        <short>    Prepare slave for streaming operation      </short>
        [SmokeMethod("setSubUrl(const KUrl&)")]
        public virtual void SetSubUrl(KUrl url) {
            interceptor.Invoke("setSubUrl#", "setSubUrl(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Opens the connection (forced)
        ///  When this function gets called the slave is operating in
        ///  connection-oriented mode.
        ///  When a connection gets lost while the slave operates in
        ///  connection oriented mode, the slave should report
        ///  ERR_CONNECTION_BROKEN instead of reconnecting. The user is
        ///  expected to disconnect the slave in the error handler.
        ///      </remarks>        <short>    Opens the connection (forced)  When this function gets called the slave is operating in  connection-oriented mode.</short>
        [SmokeMethod("openConnection()")]
        public virtual void OpenConnection() {
            interceptor.Invoke("openConnection", "openConnection()", typeof(void));
        }
        /// <remarks>
        ///  Closes the connection (forced)
        ///  Called when the application disconnects the slave to close
        ///  any open network connections.
        ///  When the slave was operating in connection-oriented mode,
        ///  it should reset itself to connectionless (default) mode.
        ///      </remarks>        <short>    Closes the connection (forced)  Called when the application disconnects the slave to close  any open network connections.</short>
        [SmokeMethod("closeConnection()")]
        public virtual void CloseConnection() {
            interceptor.Invoke("closeConnection", "closeConnection()", typeof(void));
        }
        /// <remarks>
        ///  get, aka read.
        /// <param> name="url" the full url for this request. Host, port and user of the URL
        ///         can be assumed to be the same as in the last setHost() call.
        ///  The slave emits the data through data
        ///      </param></remarks>        <short>    get, aka read.</short>
        [SmokeMethod("get(const KUrl&)")]
        public virtual void Get(KUrl url) {
            interceptor.Invoke("get#", "get(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  open.
        /// <param> name="url" the full url for this request. Host, port and user of the URL
        ///         can be assumed to be the same as in the last setHost() call.
        /// </param><param> name="mode" see \ref QIODevice.OpenMode
        ///      </param></remarks>        <short>    open.</short>
        [SmokeMethod("open(const KUrl&, QIODevice::OpenMode)")]
        public virtual void Open(KUrl url, uint mode) {
            interceptor.Invoke("open#$", "open(const KUrl&, QIODevice::OpenMode)", typeof(void), typeof(KUrl), url, typeof(uint), mode);
        }
        [SmokeMethod("read(KIO::filesize_t)")]
        public virtual void Read(long size) {
            interceptor.Invoke("read$", "read(KIO::filesize_t)", typeof(void), typeof(long), size);
        }
        [SmokeMethod("write(const QByteArray&)")]
        public virtual void Write(QByteArray data) {
            interceptor.Invoke("write#", "write(const QByteArray&)", typeof(void), typeof(QByteArray), data);
        }
        [SmokeMethod("seek(KIO::filesize_t)")]
        public virtual void Seek(long offset) {
            interceptor.Invoke("seek$", "seek(KIO::filesize_t)", typeof(void), typeof(long), offset);
        }
        [SmokeMethod("close()")]
        public virtual void Close() {
            interceptor.Invoke("close", "close()", typeof(void));
        }
        /// <remarks>
        ///  put, i.e. write data into a file.
        /// <param> name="url" where to write the file
        /// </param><param> name="permissions" may be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" : We support Overwrite here. Hopefully, we're going to
        ///  support Resume in the future, too.
        ///  If the file indeed already exists, the slave should NOT apply the
        ///  permissions change to it.
        ///  The support for resuming using .part files is done by calling canResume().
        /// </param> IMPORTANT: Use the "modified" metadata in order to set the modification time of the file.
        /// </remarks>        <short>    put, i.</short>
        ///         <see> canResume</see>
        [SmokeMethod("put(const KUrl&, int, KIO::JobFlags)")]
        public virtual void Put(KUrl url, int permissions, uint flags) {
            interceptor.Invoke("put#$$", "put(const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), url, typeof(int), permissions, typeof(uint), flags);
        }
        /// <remarks>
        ///  Finds all details for one file or directory.
        ///  The information returned is the same as what listDir returns,
        ///  but only for one file or directory.
        ///      </remarks>        <short>    Finds all details for one file or directory.</short>
        [SmokeMethod("stat(const KUrl&)")]
        public virtual void Stat(KUrl url) {
            interceptor.Invoke("stat#", "stat(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Finds mimetype for one file or directory.
        ///  This method should either emit 'mimeType' or it
        ///  should send a block of data big enough to be able
        ///  to determine the mimetype.
        ///  If the slave doesn't reimplement it, a get will
        ///  be issued, i.e. the whole file will be downloaded before
        ///  determining the mimetype on it - this is obviously not a
        ///  good thing in most cases.
        ///      </remarks>        <short>    Finds mimetype for one file or directory.</short>
        [SmokeMethod("mimetype(const KUrl&)")]
        public virtual void Mimetype(KUrl url) {
            interceptor.Invoke("mimetype#", "mimetype(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Lists the contents of <code>url.</code>
        ///  The slave should emit ERR_CANNOT_ENTER_DIRECTORY if it doesn't exist,
        ///  if we don't have enough permissions, or if it is a file
        ///  It should also emit totalFiles as soon as it knows how many
        ///  files it will list.
        ///      </remarks>        <short>    Lists the contents of <code>url.</code></short>
        [SmokeMethod("listDir(const KUrl&)")]
        public virtual void ListDir(KUrl url) {
            interceptor.Invoke("listDir#", "listDir(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Create a directory
        /// <param> name="url" path to the directory to create
        /// </param><param> name="permissions" the permissions to set after creating the directory
        ///  (-1 if no permissions to be set)
        ///  The slave emits ERR_COULD_NOT_MKDIR if failure.
        ///      </param></remarks>        <short>    Create a directory </short>
        [SmokeMethod("mkdir(const KUrl&, int)")]
        public virtual void Mkdir(KUrl url, int permissions) {
            interceptor.Invoke("mkdir#$", "mkdir(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
        }
        /// <remarks>
        ///  Rename <code>oldname</code> into <code>newname.</code>
        ///  If the slave returns an error ERR_UNSUPPORTED_ACTION, the job will
        ///  ask for copy + del instead.
        ///  Important: the slave must implement the logic "if the destination already
        ///  exists, error ERR_DIR_ALREADY_EXIST or ERR_FILE_ALREADY_EXIST".
        ///  For performance reasons no stat is done in the destination before hand,
        ///  the slave must do it.
        /// <param> name="src" where to move the file from
        /// </param><param> name="dest" where to move the file to
        /// </param><param> name="flags" : We support Overwrite here
        ///      </param></remarks>        <short>    Rename <code>oldname</code> into <code>newname.</code></short>
        [SmokeMethod("rename(const KUrl&, const KUrl&, KIO::JobFlags)")]
        public virtual void Rename(KUrl src, KUrl dest, uint flags) {
            interceptor.Invoke("rename##$", "rename(const KUrl&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(uint), flags);
        }
        /// <remarks>
        ///  Creates a symbolic link named <code>dest</code>, pointing to <code>target</code>, which
        ///  may be a relative or an absolute path.
        /// <param> name="target" The string that will become the "target" of the link (can be relative)
        /// </param><param> name="dest" The symlink to create.
        /// </param><param> name="flags" : We support Overwrite here
        ///      </param></remarks>        <short>    Creates a symbolic link named <code>dest</code>, pointing to <code>target</code>, which  may be a relative or an absolute path.</short>
        [SmokeMethod("symlink(const QString&, const KUrl&, KIO::JobFlags)")]
        public virtual void Symlink(string target, KUrl dest, uint flags) {
            interceptor.Invoke("symlink$#$", "symlink(const QString&, const KUrl&, KIO::JobFlags)", typeof(void), typeof(string), target, typeof(KUrl), dest, typeof(uint), flags);
        }
        /// <remarks>
        ///  Change permissions on <code>url</code>
        ///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHMOD
        ///      </remarks>        <short>    Change permissions on <code>url</code>  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHMOD      </short>
        [SmokeMethod("chmod(const KUrl&, int)")]
        public virtual void Chmod(KUrl url, int permissions) {
            interceptor.Invoke("chmod#$", "chmod(const KUrl&, int)", typeof(void), typeof(KUrl), url, typeof(int), permissions);
        }
        /// <remarks>
        ///  Change ownership of <code>url</code>
        ///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN
        ///      </remarks>        <short>    Change ownership of <code>url</code>  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_CHOWN      </short>
        [SmokeMethod("chown(const KUrl&, const QString&, const QString&)")]
        public virtual void Chown(KUrl url, string owner, string group) {
            interceptor.Invoke("chown#$$", "chown(const KUrl&, const QString&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), owner, typeof(string), group);
        }
        /// <remarks>
        ///  Sets the modification time for @url
        ///  For instance this is what CopyJob uses to set mtime on dirs at the end of a copy.
        ///  It could also be used to set the mtime on any file, in theory.
        ///  The usual implementation on unix is to call utime(path, &myutimbuf).
        ///  The slave emits ERR_DOES_NOT_EXIST or ERR_CANNOT_SETTIME
        ///      </remarks>        <short>    Sets the modification time for @url  For instance this is what CopyJob uses to set mtime on dirs at the end of a copy.</short>
        [SmokeMethod("setModificationTime(const KUrl&, const QDateTime&)")]
        public virtual void SetModificationTime(KUrl url, QDateTime mtime) {
            interceptor.Invoke("setModificationTime##", "setModificationTime(const KUrl&, const QDateTime&)", typeof(void), typeof(KUrl), url, typeof(QDateTime), mtime);
        }
        /// <remarks>
        ///  Copy <code>src</code> into <code>dest.</code>
        ///  If the slave returns an error ERR_UNSUPPORTED_ACTION, the job will
        ///  ask for get + put instead.
        /// <param> name="src" where to copy the file from (decoded)
        /// </param><param> name="dest" where to copy the file to (decoded)
        /// </param><param> name="permissions" may be -1. In this case no special permission mode is set.
        /// </param><param> name="flags" : We support Overwrite here
        /// </param> Don't forget to set the modification time of <code>dest</code> to be the modification time of <code>src.</code>
        ///      </remarks>        <short>    Copy <code>src</code> into <code>dest.</code></short>
        [SmokeMethod("copy(const KUrl&, const KUrl&, int, KIO::JobFlags)")]
        public virtual void Copy(KUrl src, KUrl dest, int permissions, uint flags) {
            interceptor.Invoke("copy##$$", "copy(const KUrl&, const KUrl&, int, KIO::JobFlags)", typeof(void), typeof(KUrl), src, typeof(KUrl), dest, typeof(int), permissions, typeof(uint), flags);
        }
        /// <remarks>
        ///  Delete a file or directory.
        /// <param> name="url" file/directory to delete
        /// </param><param> name="isfile" if true, a file should be deleted.
        ///                if false, a directory should be deleted.
        ///      </param></remarks>        <short>    Delete a file or directory.</short>
        [SmokeMethod("del(const KUrl&, bool)")]
        public virtual void Del(KUrl url, bool isfile) {
            interceptor.Invoke("del#$", "del(const KUrl&, bool)", typeof(void), typeof(KUrl), url, typeof(bool), isfile);
        }
        /// <remarks>
        ///  Change the destination of a symlink
        /// <param> name="url" the url of the symlink to modify
        /// </param><param> name="target" the new destination (target) of the symlink
        ///      </param></remarks>        <short>    Change the destination of a symlink </short>
        [SmokeMethod("setLinkDest(const KUrl&, const QString&)")]
        public virtual void SetLinkDest(KUrl url, string target) {
            interceptor.Invoke("setLinkDest#$", "setLinkDest(const KUrl&, const QString&)", typeof(void), typeof(KUrl), url, typeof(string), target);
        }
        /// <remarks>
        ///  Used for any command that is specific to this slave (protocol)
        ///  Examples are : HTTP POST, mount and unmount (kio_file)
        /// <param> name="data" packed data; the meaning is completely dependent on the
        ///         slave, but usually starts with an int for the command number.
        ///  Document your slave's commands, at least in its header file.
        ///      </param></remarks>        <short>    Used for any command that is specific to this slave (protocol)  Examples are : HTTP POST, mount and unmount (kio_file) </short>
        [SmokeMethod("special(const QByteArray&)")]
        public virtual void Special(QByteArray data) {
            interceptor.Invoke("special#", "special(const QByteArray&)", typeof(void), typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Used for multiple get. Currently only used foir HTTP pielining
        ///  support.
        /// <param> name="data" packed data; Contains number of URLs to fetch, and for
        ///  each URL the URL itself and its associated MetaData.
        ///      </param></remarks>        <short>    Used for multiple get.</short>
        [SmokeMethod("multiGet(const QByteArray&)")]
        public virtual void MultiGet(QByteArray data) {
            interceptor.Invoke("multiGet#", "multiGet(const QByteArray&)", typeof(void), typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Called to get the status of the slave. Slave should respond
        ///  by calling slaveStatus(...)
        ///      </remarks>        <short>    Called to get the status of the slave.</short>
        [SmokeMethod("slave_status()")]
        public virtual void Slave_status() {
            interceptor.Invoke("slave_status", "slave_status()", typeof(void));
        }
        /// <remarks>
        ///  Called by the scheduler to tell the slave that the configuration
        ///  changed (i.e. proxy settings) .
        ///      </remarks>        <short>    Called by the scheduler to tell the slave that the configuration  changed (i.</short>
        [SmokeMethod("reparseConfiguration()")]
        public virtual void ReparseConfiguration() {
            interceptor.Invoke("reparseConfiguration", "reparseConfiguration()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> timeout value for connecting to remote host.
        ///      </return>
        ///         <short>   </short>
        public int ConnectTimeout() {
            return (int) interceptor.Invoke("connectTimeout", "connectTimeout()", typeof(int));
        }
        /// <remarks>
        /// </remarks>        <return> timeout value for connecting to proxy in secs.
        ///      </return>
        ///         <short>   </short>
        public int ProxyConnectTimeout() {
            return (int) interceptor.Invoke("proxyConnectTimeout", "proxyConnectTimeout()", typeof(int));
        }
        /// <remarks>
        /// </remarks>        <return> timeout value for read from first data from
        ///  remote host in seconds.
        ///      </return>
        ///         <short>   </short>
        public int ResponseTimeout() {
            return (int) interceptor.Invoke("responseTimeout", "responseTimeout()", typeof(int));
        }
        /// <remarks>
        /// </remarks>        <return> timeout value for read from subsequent data from
        ///  remote host in secs.
        ///      </return>
        ///         <short>   </short>
        public int ReadTimeout() {
            return (int) interceptor.Invoke("readTimeout", "readTimeout()", typeof(int));
        }
        /// <remarks>
        ///  This function sets a timeout of <code>timeout</code> seconds and calls
        ///  special(data) when the timeout occurs as if it was called by the
        ///  application.
        ///  A timeout can only occur when the slave is waiting for a command
        ///  from the application.
        ///  Specifying a negative timeout cancels a pending timeout.
        ///  Only one timeout at a time is supported, setting a timeout
        ///  cancels any pending timeout.
        ///      </remarks>        <short>    This function sets a timeout of <code>timeout</code> seconds and calls  special(data) when the timeout occurs as if it was called by the  application.</short>
        public void SetTimeoutSpecialCommand(int timeout, QByteArray data) {
            interceptor.Invoke("setTimeoutSpecialCommand$#", "setTimeoutSpecialCommand(int, const QByteArray&)", typeof(void), typeof(int), timeout, typeof(QByteArray), data);
        }
        public void SetTimeoutSpecialCommand(int timeout) {
            interceptor.Invoke("setTimeoutSpecialCommand$", "setTimeoutSpecialCommand(int)", typeof(void), typeof(int), timeout);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("dispatch(int, const QByteArray&)")]
        public virtual void Dispatch(int command, QByteArray data) {
            interceptor.Invoke("dispatch$#", "dispatch(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("dispatchOpenCommand(int, const QByteArray&)")]
        public virtual void DispatchOpenCommand(int command, QByteArray data) {
            interceptor.Invoke("dispatchOpenCommand$#", "dispatchOpenCommand(int, const QByteArray&)", typeof(void), typeof(int), command, typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Read data sent by the job, after a dataReq
        /// <param> name="buffer" buffer where data is stored
        /// </param></remarks>        <return> 0 on end of data,
        ///          > 0 bytes read
        ///          < 0 error
        /// </return>
        ///         <short>    Read data sent by the job, after a dataReq </short>
        public int ReadData(QByteArray buffer) {
            return (int) interceptor.Invoke("readData#", "readData(QByteArray&)", typeof(int), typeof(QByteArray), buffer);
        }
        /// <remarks>
        ///  internal function to be called by the slave.
        ///  It collects entries and emits them via listEntries
        ///  when enough of them are there or a certain time
        ///  frame exceeded (to make sure the app gets some
        ///  items in time but not too many items one by one
        ///  as this will cause a drastic performance penalty)
        /// <param> name="_entry" The UDSEntry containing all of the object attributes.
        /// </param><param> name="ready" set to true after emitting all items. <code>_entry</code> is not
        ///         used in this case
        ///      </param></remarks>        <short>    internal function to be called by the slave.</short>
        public void ListEntry(KIO.UDSEntry _entry, bool ready) {
            interceptor.Invoke("listEntry#$", "listEntry(const KIO::UDSEntry&, bool)", typeof(void), typeof(KIO.UDSEntry), _entry, typeof(bool), ready);
        }
        /// <remarks>
        ///  internal function to connect a slave to/ disconnect from
        ///  either the slave pool or the application
        ///      </remarks>        <short>    internal function to connect a slave to/ disconnect from  either the slave pool or the application      </short>
        public void ConnectSlave(string path) {
            interceptor.Invoke("connectSlave$", "connectSlave(const QString&)", typeof(void), typeof(string), path);
        }
        public void DisconnectSlave() {
            interceptor.Invoke("disconnectSlave", "disconnectSlave()", typeof(void));
        }
        /// <remarks>
        ///  Prompt the user for Authorization info (login & password).
        ///  Use this function to request authorization information from
        ///  the end user. You can also pass an error message which explains
        ///  why a previous authorization attempt failed. Here is a very
        ///  simple example:
        ///  <pre>
        ///  KIO.AuthInfo authInfo;
        ///  if ( openPasswordDialog( authInfo ) )
        ///  {
        ///     kDebug() << QLatin1String("User: ")
        ///               << authInfo.username << endl;
        ///     kDebug() << QLatin1String("Password: ")
        ///               << QLatin1String("Not displayed here!") << endl;
        ///  }
        ///  </pre>
        ///  You can also preset some values like the username, caption or
        ///  comment as follows:
        ///  <pre>
        ///  KIO.AuthInfo authInfo;
        ///  authInfo.caption= "Acme Password Dialog";
        ///  authInfo.username= "Wile E. Coyote";
        ///  string errorMsg = "You entered an incorrect password.";
        ///  if ( openPasswordDialog( authInfo, errorMsg ) )
        ///  {
        ///     kDebug() << QLatin1String("User: ")
        ///               << authInfo.username << endl;
        ///     kDebug() << QLatin1String("Password: ")
        ///               << QLatin1String("Not displayed here!") << endl;
        ///  }
        ///  </pre>
        ///  <b>Note:<> You should consider using checkCachedAuthentication() to
        ///  see if the password is available in kpasswdserver before calling
        ///  this function.
        ///  <b>Note:<> A call to this function can fail and return <code>false</code>,
        ///  if the UIServer could not be started for whatever reason.
        /// <param> name="info" See AuthInfo.
        /// </param><param> name="errorMsg" Error message to show
        /// </param></remarks>        <return> <code>true</code> if user clicks on "OK", <code>false</code> otherwsie.
        ///      </return>
        ///         <short>    Prompt the user for Authorization info (login & password).</short>
        ///         <see> checkCachedAuthentication</see>
        public bool OpenPasswordDialog(KIO.AuthInfo info, string errorMsg) {
            return (bool) interceptor.Invoke("openPasswordDialog#$", "openPasswordDialog(KIO::AuthInfo&, const QString&)", typeof(bool), typeof(KIO.AuthInfo), info, typeof(string), errorMsg);
        }
        public bool OpenPasswordDialog(KIO.AuthInfo info) {
            return (bool) interceptor.Invoke("openPasswordDialog#", "openPasswordDialog(KIO::AuthInfo&)", typeof(bool), typeof(KIO.AuthInfo), info);
        }
        /// <remarks>
        ///  Checks for cached authentication based on parameters
        ///  given by <code>info.</code>
        ///  Use this function to check if any cached password exists
        ///  for the URL given by <code>info.</code>  If <code>AuthInfo</code>.RealmValue
        ///  and/or <code>AuthInfo</code>.VerifyPath flag is specified, then
        ///  they will also be factored in determining the presence
        ///  of a cached password.  Note that <code>Auth</code>.Url is a required
        ///  parameter when attempting to check for cached authorization
        ///  info. Here is a simple example:
        ///  <pre>
        ///  AuthInfo info;
        ///  info.url = KUrl("http://www.foobar.org/foo/bar");
        ///  info.username = "somename";
        ///  info.verifyPath = true;
        ///  if ( !checkCachedAuthentication( info ) )
        ///  {
        ///     if ( !openPasswordDialog(info) )
        ///      ....
        ///  }
        ///  </pre>
        /// <param> name="info" See AuthInfo.
        /// </param></remarks>        <return> <code>true</code> if cached Authorization is found, false otherwise.
        ///      </return>
        ///         <short>    Checks for cached authentication based on parameters  given by <code>info.</code></short>
        public bool CheckCachedAuthentication(KIO.AuthInfo info) {
            return (bool) interceptor.Invoke("checkCachedAuthentication#", "checkCachedAuthentication(KIO::AuthInfo&)", typeof(bool), typeof(KIO.AuthInfo), info);
        }
        /// <remarks>
        ///  Explicitly store authentication information. openPasswordDialog already
        ///  stores password information automatically, you only need to call
        ///  this function if you want to store authentication information that
        ///  is different from the information returned by openPasswordDialog.
        ///      </remarks>        <short>    Explicitly store authentication information.</short>
        public bool CacheAuthentication(KIO.AuthInfo info) {
            return (bool) interceptor.Invoke("cacheAuthentication#", "cacheAuthentication(const KIO::AuthInfo&)", typeof(bool), typeof(KIO.AuthInfo), info);
        }
        /// <remarks>
        ///  Used by the slave to check if it can connect
        ///  to a given host. This should be called where the slave is ready
        ///  to do a .Connect() on a socket. For each call to
        ///  requestNetwork must exist a matching call to
        ///  dropNetwork, or the system will stay online until
        ///  KNetMgr gets closed (or the SlaveBase gets destructed)!
        ///  If KNetMgr is not running, then this is a no-op and returns true
        /// <param> name="host" tells the netmgr the host the slave wants to connect
        ///              to. As this could also be a proxy, we can't just take
        ///              the host currenctly connected to (but that's the default
        ///              value)
        /// </param></remarks>        <return> true in theorie, the host is reachable
        ///          false the system is offline and the host is in a remote network.
        ///      </return>
        ///         <short>    Used by the slave to check if it can connect  to a given host.</short>
        public bool RequestNetwork(string host) {
            return (bool) interceptor.Invoke("requestNetwork$", "requestNetwork(const QString&)", typeof(bool), typeof(string), host);
        }
        public bool RequestNetwork() {
            return (bool) interceptor.Invoke("requestNetwork", "requestNetwork()", typeof(bool));
        }
        /// <remarks>
        ///  Used by the slave to withdraw a connection requested by
        ///  requestNetwork. This function cancels the last call to
        ///  requestNetwork. If a client uses more than one internet
        ///  connection, it must use dropNetwork(host) to
        ///  stop each request.
        ///  If KNetMgr is not running, then this is a no-op.
        /// <param> name="host" the host passed to requestNetwork
        /// </param> A slave should call this function every time it disconnect from a host.
        ///  </remarks>        <short>    Used by the slave to withdraw a connection requested by  requestNetwork.</short>
        public void DropNetwork(string host) {
            interceptor.Invoke("dropNetwork$", "dropNetwork(const QString&)", typeof(void), typeof(string), host);
        }
        public void DropNetwork() {
            interceptor.Invoke("dropNetwork", "dropNetwork()", typeof(void));
        }
        /// <remarks>
        ///  Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code>
        /// </remarks>        <return> the result from readData, as well as the cmd in *pCmd if set, and the data in <code>data</code>
        ///      </return>
        ///         <short>    Wait for an answer to our request, until we get <code>expected1</code> or <code>expected2</code> </short>
        public int WaitForAnswer(int expected1, int expected2, QByteArray data, ref int pCmd) {
            StackItem[] stack = new StackItem[5];
            stack[1].s_int = expected1;
            stack[2].s_int = expected2;
#if DEBUG
            stack[3].s_class = (IntPtr) DebugGCHandle.Alloc(data);
#else
            stack[3].s_class = (IntPtr) GCHandle.Alloc(data);
#endif
            stack[4].s_int = pCmd;
            interceptor.Invoke("waitForAnswer$$#$", "waitForAnswer(int, int, QByteArray&, int*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[3].s_class);
#else
            ((GCHandle) stack[3].s_class).SynchronizedFree();
#endif
            pCmd = stack[4].s_int;
            return stack[0].s_int;
        }
        public int WaitForAnswer(int expected1, int expected2, QByteArray data) {
            return (int) interceptor.Invoke("waitForAnswer$$#", "waitForAnswer(int, int, QByteArray&)", typeof(int), typeof(int), expected1, typeof(int), expected2, typeof(QByteArray), data);
        }
        /// <remarks>
        ///  Internal function to transmit meta data to the application.
        ///  m_outgoingMetaData will be cleared; this means that if the slave is for
        ///  example put on hold and picked up by a different KIO.Job later the new
        ///  job will not see the metadata sent before.
        ///  See kio/DESIGN.krun for an overview of the state
        ///  progression of a job/slave.
        ///  @warning calling this method may seriously interfere with the operation
        ///  of KIO which relies on the presence of some metadata at some points in time.
        ///  You should not use it if you are not familiar with KIO and not before
        ///  the slave is connected to the last job before returning to idle state.
        ///      </remarks>        <short>    Internal function to transmit meta data to the application.</short>
        public void SendMetaData() {
            interceptor.Invoke("sendMetaData", "sendMetaData()", typeof(void));
        }
        /// <remarks>
        ///  Internal function to transmit meta data to the application.
        ///  Like sendMetaData() but m_outgoingMetaData will not be cleared.
        ///  This method is mainly useful in code that runs before the slave is connected
        ///  to its final job.
        ///      </remarks>        <short>    Internal function to transmit meta data to the application.</short>
        public void SendAndKeepMetaData() {
            interceptor.Invoke("sendAndKeepMetaData", "sendAndKeepMetaData()", typeof(void));
        }
        /// <remarks> If your ioslave was killed by a signal, wasKilled() returns true.
        ///      Check it regularly in lengthy functions (e.g. in get();) and return
        ///      as fast as possible from this function if wasKilled() returns true.
        ///      This will ensure that your slave destructor will be called correctly.
        ///      </remarks>        <short>   If your ioslave was killed by a signal, wasKilled() returns true.</short>
        public bool WasKilled() {
            return (bool) interceptor.Invoke("wasKilled", "wasKilled() const", typeof(bool));
        }
        /// <remarks> Internally used.
        ///      </remarks>        <short>   Internally used.</short>
        public void SetKillFlag() {
            interceptor.Invoke("setKillFlag", "setKillFlag()", typeof(void));
        }
        /// <remarks> Internally used
        ///     </remarks>        <short>   Internally used </short>
        public void LookupHost(string host) {
            interceptor.Invoke("lookupHost$", "lookupHost(const QString&)", typeof(void), typeof(string), host);
        }
        /// <remarks> Internally used
        ///     </remarks>        <short>   Internally used </short>
        public int WaitForHostInfo(QHostInfo info) {
            return (int) interceptor.Invoke("waitForHostInfo#", "waitForHostInfo(QHostInfo&)", typeof(int), typeof(QHostInfo), info);
        }
    }
}
