/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.gnu.pilotlink.MidiRecord;
import org.gnu.pilotlink.PilotLink;
import org.gnu.pilotlink.PilotLinkException;
import org.gnu.pilotlink.SysInfo;
import org.gnu.pilotlink.User;

public class MidiMgr {
    public static final int LIST = 1;
    public static final int INSTALL = 2;
    public static final int NOTHING = 0;
    public static final int DELETE = 3;
    public static final int FETCH = 4;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        String string = "/dev/usb/tts/1";
        String string2 = "MIDI Ring Tones";
        int n = 0;
        String string3 = "";
        String string4 = "";
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-p")) {
                    string = stringArray[i + 1];
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-l") || stringArray[i].equals("--list")) {
                    n = 1;
                } else if (stringArray[i].equals("-i") || stringArray[i].equals("--install")) {
                    n = 2;
                    string3 = stringArray[i + 1];
                    if (!string3.endsWith(".mid")) {
                        System.out.println("File to install must be a .mid-File!");
                        System.exit(1);
                    }
                    if (!((File)(object2 = new File(string3))).exists()) {
                        System.out.println("File to install must exist! " + string3 + " not found!");
                        System.exit(1);
                    }
                    string4 = stringArray[i + 2];
                } else if (stringArray[i].equals("-d") || stringArray[i].equals("--delete")) {
                    n = 3;
                    string3 = stringArray[i + 1];
                } else {
                    if (!stringArray[i].equals("-f") && !stringArray[i].equals("--fetch")) continue;
                    n = 4;
                    string3 = stringArray[i + 1];
                }
                break;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        if (n == 0) {
            System.out.println("USAGE: java MidiMgr CMD ARG\nwhere CMD:\n-p PORT: Pilot-Port (default /dev/usb/tts/1)\n-db NAME: Palm-DB to use (default 'MIDI Ring Tones')\n-l|--list : list all Midi-Files\n-d|--delete NAME: Delete File by name or id\n-i|--install FILE NAME: Install Midi-File FILE as NAME");
            System.exit(1);
        }
        File file = new File(string);
        System.out.println("looking for file " + string);
        if (!file.exists()) {
            System.out.println("File does not exist... DevFS? Waiting for port to appear");
            while (!file.exists()) {
                System.out.print(".");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        object2 = null;
        try {
            object2 = new PilotLink(string);
            if (!((PilotLink)object2).isConnected()) {
                System.out.println("Something went wrong. Check output!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            object = ((PilotLink)object2).getUserInfo();
            System.out.println("User: " + ((User)object).getName());
            System.out.println("Last Synchronization Date: " + ((User)object).getLastSyncDate());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            object = ((PilotLink)object2).getSysInfo();
            System.out.println("Product ID: '" + ((SysInfo)object).getProdID() + "'");
            System.out.println("Rom Version: " + ((SysInfo)object).getRomVersion());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            int n2 = ((PilotLink)object2).openDB(string2);
            if (n2 < 0) {
                System.out.println("ERROR! " + n2);
                System.exit(1);
            }
            block11 : switch (n) {
                case 1: {
                    int n3 = ((PilotLink)object2).getRecordCount(n2);
                    for (int i = 0; i < n3; ++i) {
                        MidiRecord midiRecord = new MidiRecord(((PilotLink)object2).getRecordByIndex(n2, i));
                        System.out.println(i + ": " + midiRecord.getId() + " " + midiRecord.getName() + " size: " + midiRecord.getSize());
                    }
                    break;
                }
                case 2: {
                    File file2 = new File(string3);
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        long l = file2.length();
                        byte[] byArray = new byte[(int)l];
                        ((InputStream)fileInputStream).read(byArray);
                        MidiRecord midiRecord = new MidiRecord();
                        midiRecord.setName(string4);
                        midiRecord.setMidi(byArray);
                        ((InputStream)fileInputStream).close();
                        ((PilotLink)object2).writeNewRecord(n2, midiRecord);
                        System.out.println("File Installed as " + string4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    MidiRecord midiRecord = null;
                    try {
                        int n4 = Integer.parseInt(string3);
                        midiRecord = new MidiRecord(((PilotLink)object2).getRecordByIndex(n2, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("No Number! Looking for file...");
                        int n5 = ((PilotLink)object2).getRecordCount(n2);
                        for (int i = 0; i < n5 && !(midiRecord = new MidiRecord(((PilotLink)object2).getRecordByIndex(n2, i))).getName().equals(string3); ++i) {
                        }
                    }
                    if (midiRecord != null) {
                        File file3 = new File(midiRecord.getName() + ".mid");
                        try {
                            file3.createNewFile();
                            FileOutputStream fileOutputStream = new FileOutputStream(file3);
                            ((OutputStream)fileOutputStream).write(midiRecord.getMidi());
                            ((OutputStream)fileOutputStream).close();
                            System.out.println("File " + file3.getName() + " stored successfully!");
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        break;
                    }
                    System.out.println("Not found!");
                    break;
                }
                case 3: {
                    MidiRecord midiRecord = null;
                    try {
                        int n6 = Integer.parseInt(string3);
                        ((PilotLink)object2).deleteRecordById(n2, n6);
                        System.out.println("Index " + n6 + " deleted.");
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("No Number! Looking for file...");
                        int n7 = ((PilotLink)object2).getRecordCount(n2);
                        for (int i = 0; i < n7; ++i) {
                            midiRecord = new MidiRecord(((PilotLink)object2).getRecordByIndex(n2, i));
                            if (!midiRecord.getName().equals(string3)) continue;
                            ((PilotLink)object2).deleteRecordById(n2, midiRecord.getId());
                            break block11;
                        }
                        break;
                    }
                }
            }
            ((PilotLink)object2).closeDB(n2);
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            ((PilotLink)object2).endSync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((PilotLink)object2).close();
        System.exit(0);
    }

    public static void hexdump(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            String string = "";
            String string2 = "" + Integer.toHexString(n);
            while (string2.length() < 4) {
                string2 = "0" + string2;
            }
            System.out.print(string2 + ":  ");
            for (int i = 0; i < 16 && n < byArray.length; ++i, ++n) {
                string2 = Integer.toHexString(byArray[n]);
                if (byArray[n] < 0) {
                    string2 = string2.substring(string2.length() - 2);
                }
                while (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                System.out.print(string2 + " ");
                string = byArray[n] >= 48 && byArray[n] <= 122 || byArray[n] == 32 ? string + (char)byArray[n] : (byArray[n] == 252 ? string + "\ufffd" : (byArray[n] == 246 ? string + "\ufffd" : (byArray[n] == -3 ? string + "\ufffd" : string + ".")));
            }
            System.out.println("   " + string);
        }
    }
}

