'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbPtrActionY __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbPtrActionY \- Returns the high_YYY and low_YYY fields of act converted to a 
signed int
.SH SYNOPSIS
.HP
.B int XkbPtrActionY
.BI "(\^XkbPtrAction " "act" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- act
action from which to extract Y
.SH DESCRIPTION
.LP
Actions associated with the XkbPtrAction structure move the pointer when keys 
are pressed and released.

If the MouseKeys control is not enabled, KeyPress and KeyRelease events are 
treated as though the action is XkbSA_NoAction.

If the MouseKeys control is enabled, a server action of type XkbSA_MovePtr 
instructs the server to generate core pointer MotionNotify events rather than 
the usual KeyPress event, and the corresponding KeyRelease event disables any 
mouse keys timers that were created as a result of handling the XkbSA_MovePtr 
action.

The 
.I type 
field of the XkbPtrAction structure is always XkbSA_MovePtr.

The 
.I flags 
field is a bitwise inclusive OR of the masks shown in Table 1.

.TS
c s
l l
l lw(4i).
Table 1 Pointer Action Types
_
Action Type	Meaning
_
XkbSA_NoAcceleration	T{
If not set, and the MouseKeysAccel control is enabled, the KeyPress initiates a 
mouse keys timer for this key; every time the timer expires, the cursor moves.
T}
XkbSA_MoveAbsoluteX	T{
If set, the X portion of the structure specifies the new pointer X coordinate. 
Otherwise, the X portion is added to the current pointer X coordinate to 
determine the new pointer X coordinate.
T}
XkbSA_MoveAbsoluteY	T{
If set, the Y portion of the structure specifies the new pointer Y coordinate. 
Otherwise, the Y portion is added to the current pointer Y coordinate to 
determine the new pointer Y coordinate.
T}
.TE

Each of the X and Y coordinantes of the XkbPtrAction structure is composed of 
two signed 16-bit values, that is, the X coordinate is composed of 
.I high_XXX 
and 
.I low_XXX, 
and similarly for the Y coordinate. Xkb provides the following macros, to 
convert between a signed integer and two signed 16-bit values in XkbPtrAction 
structures.
.SH STRUCTURES
.LP
.nf

    typedef struct _XkbPtrAction {
        unsigned char    type;         /\(** XkbSA_MovePtr */
        unsigned char    flags;        /\(** determines type of pointer motion */
        unsigned char    high_XXX;     /\(** x coordinate, high bits*/
        unsigned char    low_XXX;      /\(** y coordinate, low bits */
        unsigned char    high_YYY;     /\(** x coordinate, high bits */
        unsigned char    low_YYY;      /\(** y coordinate, low bits */
    } XkbPtrAction;

.fi    
