/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.TimeLimitIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.impl.AbstractQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SailQuery
extends AbstractQuery {
    private final ParsedQuery parsedQuery;
    private final SailRepositoryConnection con;

    protected SailQuery(ParsedQuery parsedQuery, SailRepositoryConnection con) {
        this.parsedQuery = parsedQuery;
        this.con = con;
    }

    public ParsedQuery getParsedQuery() {
        return this.parsedQuery;
    }

    protected SailRepositoryConnection getConnection() {
        return this.con;
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> enforceMaxQueryTime(CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingsIter) {
        if (this.maxQueryTime > 0) {
            bindingsIter = new QueryInterruptIteration(bindingsIter, 1000L * (long)this.maxQueryTime);
        }
        return bindingsIter;
    }

    public Dataset getActiveDataset() {
        if (this.dataset != null) {
            return this.dataset;
        }
        return this.parsedQuery.getDataset();
    }

    public String toString() {
        return this.parsedQuery.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class QueryInterruptIteration
    extends TimeLimitIteration<BindingSet, QueryEvaluationException> {
        public QueryInterruptIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> iter, long timeLimit) {
            super(iter, timeLimit);
        }

        @Override
        protected void throwInterruptedException() throws QueryEvaluationException {
            throw new QueryInterruptedException("Query evaluation took too long");
        }
    }
}

