/*
 * image.c
 *
 * Copyright (C) 1993-1998 Evan Harris
 *
 * This code is heavily derived from cjpeg.c, part of release 6 of the
 * Independent JPEG Group's software.
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

/* 	$Id: image.c,v 1.4 1998/10/01 02:55:38 evan Exp $	 */

#ifndef lint
static char vcid[] = "$Id: image.c,v 1.4 1998/10/01 02:55:38 evan Exp $";
#endif /* lint */

#include "seejpeg.h"
#include <cdjpeg.h>
#include <setjmp.h>



int
read_image_file(char* filename)
{
    struct jpeg_compress_struct cinfo;
    cjpeg_source_ptr src_mgr;
    struct jpeg_error_mgr jerr;
    FILE* input_file;
    int num_scanlines, total_scanlines;
    
    JSAMPARRAY cmap_row;
    char* type;
    int i, c, components, translate;

    cinfo.err = jpeg_std_error(&jerr);
    jpeg_create_compress(&cinfo);
    cinfo.in_color_space = JCS_RGB; /* arbitrary guess */
    jpeg_set_defaults(&cinfo);

    input_file = fopen(filename, "rb");
    if (input_file == NULL)
    {
	fprintf(stderr, "can't open %s\n", filename);
	return 0;
    }
    if ((c = getc(input_file)) == EOF)
    {
	error_exit("Empty input file");
    }
    if (ungetc(c, input_file) == EOF)
    {
	error_exit("ungetc() failed");
    }

    switch (c)
    {
	case 'G':
	    type = "GIF";
	    src_mgr = jinit_read_gif(&cinfo);
	    break;
	    
	case 'P':
	    type = "PPM";
	    src_mgr = jinit_read_ppm(&cinfo);
	    break;

	case 'B':
	    type = "BMP";
	    src_mgr = jinit_read_bmp(&cinfo);
	    break;

#if 0
	case 'R':
	    type = "RLE";
	    jinit_read_rle(&cinfo);
	    break;
#endif

	case 0x00:
	    type = "TARGA";
	    src_mgr = jinit_read_targa(&cinfo);
	    break;

	default:
	    fclose(input_file);
	    return read_JPEG_file(filename);
	    break;
    }

    if (opt_verbose)
    {
	printf("Type   : %s\n", type);
    }

    src_mgr->input_file = input_file;
    (*src_mgr->start_input)(&cinfo, src_mgr);

    components = cinfo.input_components;
    if (c == 'G' && components == 3) /* GIF */
    {
	components = 1;
	translate = 1;
	translate_init();

	cmap_row = (*cinfo.mem->alloc_sarray)
	    ((j_common_ptr) &cinfo, JPOOL_IMAGE, cinfo.image_width, 1);

    }
    else
    {
	translate = 0;
    }

    display_init(cinfo.image_width, cinfo.image_height, components);
  
    if (components == 1 && !translate)
    {
	display_set_greyscale_palette();
    }

    /* This is required for interlaced GIFs (at least). */
    (*cinfo.mem->realize_virt_arrays)(&cinfo);

    total_scanlines = 0;
    while (total_scanlines < cinfo.image_height)
    {
	num_scanlines = (*src_mgr->get_pixel_rows) (&cinfo, src_mgr);
	total_scanlines += num_scanlines;
	if (translate)
	{
	    for (i = 0; i < num_scanlines; i++)
	    {
		translate_row(cinfo.image_width, &src_mgr->buffer[i],
			      cmap_row);
		display_rows(1, cmap_row, cinfo.image_width, components);
	    }
	}
	else
	{
	    display_rows(num_scanlines, src_mgr->buffer, cinfo.image_width,
			 components);
	}
    }

    (*src_mgr->finish_input)(&cinfo, src_mgr);

    fclose(input_file);

    scroll_until_end();
  
    return 1;
}
