/*
 * TargetParamTable MIB
 * 
 * This file was generated by mib2c and is intended for use as a mib module
 * for the ucd-snmp snmpd agent. Edited by Michael Baer 
 * 
 * last changed 2/2/99.
 */

#include <net-snmp/net-snmp-config.h>
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <stdlib.h>
#include <ctype.h>
#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "snmpTargetParamsEntry.h"

#define snmpTargetParamsOIDLen 11       /*This is base+column, 
                                         * i.e. everything but index */

oid             snmpTargetParamsOID[snmpTargetParamsOIDLen] =
    { 1, 3, 6, 1, 6, 3, 12, 1, 3, 1, 0 };

static struct targetParamTable_struct *aPTable = NULL;


/*
 * Utility routines 
 */


/*
 * TargetParamTable_create creates and returns a pointer
 * to a targetParamTable_struct with default values set 
 */
struct targetParamTable_struct
               *
snmpTargetParamTable_create(void)
{
    struct targetParamTable_struct *newEntry;

    newEntry = (struct targetParamTable_struct *)
        malloc(sizeof(struct targetParamTable_struct));

    newEntry->paramName = NULL;
    newEntry->mpModel = -1;

    newEntry->secModel = -1;
    newEntry->secName = NULL;
    newEntry->secLevel = -1;

    newEntry->storageType = SNMP_STORAGE_NONVOLATILE;
    newEntry->rowStatus = SNMP_ROW_NONEXISTENT;
    newEntry->next = NULL;
    return newEntry;
}


/*
 * TargetParamTable_dispose frees the space allocated to a
 * targetParamTable_struct 
 */
void
snmpTargetParamTable_dispose(struct targetParamTable_struct *reaped)
{
    free(reaped->paramName);
    free(reaped->secName);

    free(reaped);
}                               /* snmpTargetParamTable_dispose  */


/*
 * snmpTargetParamTable_addToList adds a targetParamTable_struct 
 * to a list passed in. The list is assumed to be in a sorted order,
 * low to high and this procedure inserts a new struct in the proper 
 * location. Sorting uses OID values based on paramName. A new equal value 
 * overwrites a current one. 
 */
void
snmpTargetParamTable_addToList(struct targetParamTable_struct *newEntry,
                               struct targetParamTable_struct **listPtr)
{
    static struct targetParamTable_struct *curr_struct, *prev_struct;
    int             i;
    size_t          newOIDLen = 0, currOIDLen = 0;
    oid             newOID[128], currOID[128];

    /*
     * if the list is empty, add the new entry to the top 
     */
    if ((prev_struct = curr_struct = *listPtr) == 0) {
        *listPtr = newEntry;
        return;
    } else {
        /*
         * get the 'OID' value of the new entry 
         */
        newOIDLen = strlen(newEntry->paramName);
        for (i = 0; i < (int) newOIDLen; i++) {
            newOID[i] = newEntry->paramName[i];
        }

        /*
         * search through the list for an equal or greater OID value 
         */
        while (curr_struct != NULL) {
            currOIDLen = strlen(curr_struct->paramName);
            for (i = 0; i < (int) currOIDLen; i++) {
                currOID[i] = curr_struct->paramName[i];
            }

            i = snmp_oid_compare(newOID, newOIDLen, currOID, currOIDLen);
            if (i == 0) {       /* Exact match, overwrite with new struct */
                newEntry->next = curr_struct->next;
                /*
                 * if curr_struct is the top of the list 
                 */
                if (*listPtr == curr_struct)
                    *listPtr = newEntry;
                else
                    prev_struct->next = newEntry;
                snmpTargetParamTable_dispose(curr_struct);
                return;
            } else if (i < 0) { /* Found a greater OID, insert struct in front of it. */
                newEntry->next = curr_struct;
                /*
                 * if curr_struct is the top of the list 
                 */
                if (*listPtr == curr_struct)
                    *listPtr = newEntry;
                else
                    prev_struct->next = newEntry;
                return;
            }
            prev_struct = curr_struct;
            curr_struct = curr_struct->next;
        }
    }
    /*
     * if we're here, no larger OID was ever found, insert on end of list 
     */
    prev_struct->next = newEntry;
}                               /* snmpTargeParamTable_addToList  */

void
snmpTargetParamTable_add(struct targetParamTable_struct *newEntry)
{
    snmpTargetParamTable_addToList(newEntry, &aPTable);
}

/*
 * snmpTargetParamTable_remFromList removes a targetParamTable_struct 
 * from the list passed in 
 */
void
snmpTargetParamTable_remFromList(struct targetParamTable_struct *oldEntry,
                                 struct targetParamTable_struct **listPtr)
{
    struct targetParamTable_struct *tptr;

    if ((tptr = *listPtr) == NULL)
        return;
    else if (tptr == oldEntry) {
        *listPtr = (*listPtr)->next;
        snmpTargetParamTable_dispose(tptr);
        return;
    } else {
        while (tptr->next != NULL) {
            if (tptr->next == oldEntry) {
                tptr->next = tptr->next->next;
                snmpTargetParamTable_dispose(oldEntry);
                return;
            }
            tptr = tptr->next;
        }
    }
}                               /* snmpTargetParamTable_remFromList  */


/*
 * lookup OID in the link list of Table Entries 
 */
struct targetParamTable_struct *
search_snmpTargetParamsTable(oid * baseName,
                             size_t baseNameLen,
                             oid * name, size_t * length, int exact)
{
    static struct targetParamTable_struct *temp_struct;
    int             i;
    size_t          myOIDLen = 0;
    oid             newNum[128];

    /*
     * lookup entry in p / * Get Current MIB ID 
     */
    memcpy(newNum, baseName, baseNameLen * sizeof(oid));

    for (temp_struct = aPTable; temp_struct != NULL;
         temp_struct = temp_struct->next) {
        for (i = 0; i < (int) strlen(temp_struct->paramName); i++) {
            newNum[baseNameLen + i] = temp_struct->paramName[i];
        }
        myOIDLen = baseNameLen + strlen(temp_struct->paramName);
        i = snmp_oid_compare(name, *length, newNum, myOIDLen);
        /*
         * Assumes that the linked list sorted by OID, low to high 
         */
        if ((i == 0 && exact != 0) || (i < 0 && exact == 0)) {
            if (exact == 0) {
                memcpy(name, newNum, myOIDLen * sizeof(oid));
                *length = myOIDLen;
            }
            return temp_struct;
        }
    }
    return NULL;
}                               /* search_snmpTargetParamsTable */


/*
 * snmpTargetParams_rowStatusCheck is boolean funciton that  checks 
 * the status of a row's values in order to determine whether
 * the row should be notReady or notInService  
 */
int
snmpTargetParams_rowStatusCheck(struct targetParamTable_struct *entry)
{
    if ((entry->mpModel < 0) || (entry->secModel < 0) ||
        (entry->secLevel < 0) || (entry->secName == NULL))
        return 0;
    else
        return 1;
}                               /* snmtpTargetParamTable_rowStatusCheck */


/*
 * initialization routines 
 */


/*
 * this variable defines function callbacks and type return information 
 * for the snmpTargetAddrEntry mib 
 */

struct variable2 snmpTargetParamsEntry_variables[] = {
    {SNMPTARGETPARAMSMPMODEL, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSMPMODELCOLUMN}},
    {SNMPTARGETPARAMSSECURITYMODEL, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSSECURITYMODELCOLUMN}},
    {SNMPTARGETPARAMSSECURITYNAME, ASN_OCTET_STR, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSSECURITYNAMECOLUMN}},
    {SNMPTARGETPARAMSSECURITYLEVEL, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSSECURITYLEVELCOLUMN}},
    {SNMPTARGETPARAMSSTORAGETYPE, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSSTORAGETYPECOLUMN}},
    {SNMPTARGETPARAMSROWSTATUS, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_snmpTargetParamsEntry, 1, {SNMPTARGETPARAMSROWSTATUSCOLUMN}}
};

/*
 * now load this mib into the agents mib table 
 */
oid             snmpTargetParamsEntry_variables_oid[] =
    { 1, 3, 6, 1, 6, 3, 12, 1, 3, 1 };


void
init_snmpTargetParamsEntry(void)
{
    aPTable = NULL;

    REGISTER_MIB("target/snmpTargetParamsEntry",
                 snmpTargetParamsEntry_variables, variable2,
                 snmpTargetParamsEntry_variables_oid);

    snmpd_register_config_handler("targetParams",
                                  snmpd_parse_config_targetParams,
                                  (void (*)(void))0, NULL);

    /*
     * we need to be called back later 
     */
    snmp_register_callback(SNMP_CALLBACK_LIBRARY, SNMP_CALLBACK_STORE_DATA,
                           store_snmpTargetParamsEntry, NULL);
}                               /*  init_snmpTargetParmsEntry  */


int
snmpTargetParams_addParamName(struct targetParamTable_struct *entry,
                              char *cptr)
{
    size_t          len;
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no param name in config string\n"));
        return (0);
    } else {
        len = strlen(cptr);
        /*
         * spec check for string 1-32 
         */
        if (len < 1 || len > 32) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "ERROR snmpTargetParamsEntry: param name out of range in config string\n"));
            return (0);
        }
        entry->paramName = (char *) malloc(len + 1);
        strncpy(entry->paramName, cptr, len);
        entry->paramName[len] = '\0';
    }
    return (1);
}


int
snmpTargetParams_addMPModel(struct targetParamTable_struct *entry,
                            char *cptr)
{
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no mp model in config string\n"));
        return (0);
    } else if (!(isdigit(*cptr))) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: mp model is not digit in config string\n"));
        return (0);
    }
    /*
     * spec check MP Model >= 0 
     */
    else if ((entry->mpModel = (int) strtol(cptr, (char **) NULL, 0)) < 0) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: mp model out of range in config string\n"));
        return (0);
    }
    return (1);
}                               /* snmpTargetParams_addMPModel  */


int
snmpTargetParams_addSecModel(struct targetParamTable_struct *entry,
                             char *cptr)
{
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no sec model in config string\n"));
        return (0);
    } else if (!(isdigit(*cptr))) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: security model is not digit in config string\n"));
        return (0);
    }
    /*
     * spec check Sec. Model > 0 
     */
    else if ((entry->secModel =
              (int) strtol(cptr, (char **) NULL, 0)) <= 0) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: security model out of range in config string\n"));
        return (0);
    }
    return (1);
}                               /*  snmpTargetParams_addSecModel  */


int
snmpTargetParams_addSecName(struct targetParamTable_struct *entry,
                            char *cptr)
{
    size_t          len;
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no security name in config string\n"));
        return (0);
    } else {
        len = strlen(cptr);
        entry->secName = (char *) malloc(len + 1);
        strncpy(entry->secName, cptr, len);
        entry->secName[len] = '\0';
    }
    return (1);
}                               /* snmpTargetParams_addSecName  */


int
snmpTargetParams_addSecLevel(struct targetParamTable_struct *entry,
                             char *cptr)
{
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no security level in config string\n"));
        return (0);
    } else if (!(isdigit(*cptr))) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: security level is not digit in config string\n"));
        return (0);
    }
    /*
     * no spec range check, but noAuthNoPriv is 1 so... 
     */
    else if ((entry->secLevel =
              (int) strtol(cptr, (char **) NULL, 0)) <= 0) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: security level is not greater than 0 in config string\n"));
        return (0);
    }
    return (1);
}                               /*  snmpTargetParams_addSecLevel  */


int
snmpTargetParams_addStorageType(struct targetParamTable_struct *entry,
                                char *cptr)
{
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no storage type in config string\n"));
        return (0);
    } else if (!(isdigit(*cptr))) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: storage type is not digit in config string\n"));
        return (0);
    }
    /*
     * check that storage type is a possible value 
     */
    else if (((entry->storageType = (int) strtol(cptr, (char **) NULL, 0))
              != SNMP_STORAGE_OTHER) &&
             (entry->storageType != SNMP_STORAGE_VOLATILE) &&
             (entry->storageType != SNMP_STORAGE_NONVOLATILE) &&
             (entry->storageType != SNMP_STORAGE_PERMANENT) &&
             (entry->storageType != SNMP_STORAGE_READONLY)) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: storage type is not a valid value of"));
        DEBUGMSG(("snmpTargetParamsEntry",
                  " other(%d), volatile(%d), nonvolatile(%d), permanent(%d), or ",
                  SNMP_STORAGE_OTHER, SNMP_STORAGE_VOLATILE,
                  SNMP_STORAGE_NONVOLATILE, SNMP_STORAGE_PERMANENT));
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "readonly(%d) in config string.\n",
                    SNMP_STORAGE_READONLY));

        return (0);
    }
    return (1);
}                               /* snmpTargetParams_addStorageType  */


int
snmpTargetParams_addRowStatus(struct targetParamTable_struct *entry,
                              char *cptr)
{
    if (cptr == NULL) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: no row status in config string\n"));
        return (0);
    } else if (!(isdigit(*cptr))) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargeParamsEntry: row status is not digit in config string\n"));
        return (0);
    }
    /*
     * check that row status is a valid value 
     */
    else if (((entry->rowStatus = (int) strtol(cptr, (char **) NULL, 0))
              != SNMP_ROW_ACTIVE) &&
             (entry->rowStatus != SNMP_ROW_NOTINSERVICE) &&
             (entry->rowStatus != SNMP_ROW_NOTREADY)) {
        DEBUGMSGTL(("snmpTargetParamsEntry",
                    "ERROR snmpTargetParamsEntry: Row Status is not a valid value of "));
        DEBUGMSG(("snmpTargetParamsEntry",
                  "active(%d), notinservice(%d), or notready(%d) in config string.\n",
                  SNMP_ROW_ACTIVE, SNMP_ROW_NOTINSERVICE,
                  SNMP_ROW_NOTREADY));

        return (0);
    }
    return (1);
}                               /* snmpTargetParams_addRowStatus  */

/*
 * timestamp the current entry's modification time 
 */
void
update_timestamp(struct targetParamTable_struct *temp_struct)
{
    temp_struct->updateTime = time(NULL);
}

void
snmpd_parse_config_targetParams(const char *token, char *char_ptr)
{
    char           *cptr = char_ptr, buff[1024];
    struct targetParamTable_struct *newEntry;

    newEntry = snmpTargetParamTable_create();

    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addParamName(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addMPModel(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addSecModel(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addSecName(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addSecLevel(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addStorageType(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    cptr = copy_nword(cptr, buff, sizeof(buff));
    if (snmpTargetParams_addRowStatus(newEntry, buff) == 0) {
        snmpTargetParamTable_dispose(newEntry);
        return;
    }
    DEBUGMSGTL(("snmpTargetParamsEntry",
                "snmp_parse_config_targetParams, read: %s %d %d %s %d %d %d\n",
                newEntry->paramName, newEntry->mpModel, newEntry->secModel,
                newEntry->secName, newEntry->secLevel, newEntry->storageType,
                newEntry->rowStatus));

    update_timestamp(newEntry);
    snmpTargetParamTable_addToList(newEntry, &aPTable);
}                               /* snmpd_parse_config_target */


/*
 * shutdown routines 
 */


/*
 * store_snmpTargetParamsEntry handles the presistent storage proccess 
 * for this MIB table. It writes out all the non-volatile rows 
 * to permanent storage on a shutdown  
 */
int
store_snmpTargetParamsEntry(int majorID, int minorID, void *serverarg,
                            void *clientarg)
{
    struct targetParamTable_struct *curr_struct;
    char            line[1024];

    strcpy(line, "");
    if ((curr_struct = aPTable) != NULL) {
        while (curr_struct != NULL) {
            if ((curr_struct->storageType == SNMP_STORAGE_NONVOLATILE ||
                 curr_struct->storageType == SNMP_STORAGE_PERMANENT)
                &&
                (curr_struct->rowStatus == SNMP_ROW_ACTIVE ||
                 curr_struct->rowStatus == SNMP_ROW_NOTINSERVICE)) {
                snprintf(line, sizeof(line),
                        "targetParams %s %i %i %s %i %i %i\n",
                        curr_struct->paramName, curr_struct->mpModel,
                        curr_struct->secModel, curr_struct->secName,
                        curr_struct->secLevel, curr_struct->storageType,
                        curr_struct->rowStatus);
                line[ sizeof(line)-1 ] = 0;

                /*
                 * store to file 
                 */
                snmpd_store_config(line);
            }
            curr_struct = curr_struct->next;
        }
    }
    return SNMPERR_SUCCESS;
}                               /*  store_snmpTargetParmsEntry  */


/*
 * MIB table access routines 
 */


u_char         *
var_snmpTargetParamsEntry(struct variable * vp,
                          oid * name,
                          size_t * length,
                          int exact,
                          size_t * var_len, WriteMethod ** write_method)
{
    /*
     * variables we may use later 
     */
    static long     long_ret;
    static unsigned char string[1500];
    struct targetParamTable_struct *temp_struct;

    switch (vp->magic) {
    case SNMPTARGETPARAMSMPMODEL:
        *write_method = write_snmpTargetParamsMPModel;
        break;
    case SNMPTARGETPARAMSSECURITYMODEL:
        *write_method = write_snmpTargetParamsSecModel;
        break;
    case SNMPTARGETPARAMSSECURITYNAME:
        *write_method = write_snmpTargetParamsSecName;
        break;
    case SNMPTARGETPARAMSSECURITYLEVEL:
        *write_method = write_snmpTargetParamsSecLevel;
        break;
    case SNMPTARGETPARAMSSTORAGETYPE:
        *write_method = write_snmpTargetParamsStorageType;
        break;
    case SNMPTARGETPARAMSROWSTATUS:
        *write_method = write_snmpTargetParamsRowStatus;
        break;
    default:
        *write_method = NULL;
    }

    *var_len = sizeof(long_ret);        /* assume an integer and change later if not */

    /*
     * look for OID in current table 
     */
    if ((temp_struct = search_snmpTargetParamsTable(vp->name, vp->namelen,
                                                    name, length,
                                                    exact)) == NULL) {
        return NULL;
    }

    /*
     * We found what we were looking for, either the next OID or the exact OID 
     */
    /*
     * this is where we do the value assignments for the mib results. 
     */
    switch (vp->magic) {

    case SNMPTARGETPARAMSMPMODEL:
        /*
         * if unset value, (i.e. new row) 
         */
        if (temp_struct->mpModel == -1)
            return NULL;
        long_ret = temp_struct->mpModel;
        return (unsigned char *) &long_ret;

    case SNMPTARGETPARAMSSECURITYMODEL:
        /*
         * if unset value, (i.e. new row) 
         */
        if (temp_struct->secModel == -1)
            return NULL;
        long_ret = temp_struct->secModel;
        return (unsigned char *) &long_ret;

    case SNMPTARGETPARAMSSECURITYNAME:
        /*
         * if unset value, (i.e. new row) 
         */
        if (temp_struct->secName == NULL)
            return NULL;
        /*
         * including null character. 
         */
        memcpy(string, temp_struct->secName, strlen(temp_struct->secName));
        string[strlen(temp_struct->secName)] = '\0';
        *var_len = strlen(temp_struct->secName);
        return (unsigned char *) string;

    case SNMPTARGETPARAMSSECURITYLEVEL:
        /*
         * if unset value, (i.e. new row) 
         */
        if (temp_struct->secLevel == -1)
            return NULL;
        long_ret = temp_struct->secLevel;
        return (unsigned char *) &long_ret;

    case SNMPTARGETPARAMSSTORAGETYPE:
        long_ret = temp_struct->storageType;
        return (unsigned char *) &long_ret;

    case SNMPTARGETPARAMSROWSTATUS:
        long_ret = temp_struct->rowStatus;
        return (unsigned char *) &long_ret;

    default:
        DEBUGMSGTL(("snmpd",
                    "unknown sub-id %d in var_snmpTargetParamsEntry\n",
                    vp->magic));
    }
    return NULL;
}                               /* var_snmpTargetParamsEntry */

/*
 * Assign a value to the mpModel variable.  
 */
int
write_snmpTargetParamsMPModel(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    long            long_ret = *((long *) var_val);
    static long     old_mp;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_INTEGER) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsMPModel: not ASN_INTEGER\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != sizeof(long)) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsMPModel: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
        if (long_ret < 0) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsMPModel: MP Model out of range\n"));
            return SNMP_ERR_INCONSISTENTVALUE;
        }
    } else if (action == RESERVE2) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSMPMODELCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params == NULL) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsMPModel: BAD OID\n"));
            return SNMP_ERR_INCONSISTENTNAME;
        } else {
            /*
             * Row exists, check if it is changeable.  
             */
            if (params->storageType == SNMP_STORAGE_READONLY) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamMPModel: row is read only\n"));
                return SNMP_ERR_NOTWRITABLE;
            }
            /*
             * Check if row is active.  
             */
            if (params->rowStatus == SNMP_ROW_ACTIVE) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamsMPModel: this change not allowed in active row.\n"));
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            old_mp = params->mpModel;
            params->mpModel = long_ret;

            if (params->rowStatus == SNMP_ROW_NOTREADY &&
                snmpTargetParams_rowStatusCheck(params)) {
                params->rowStatus = SNMP_ROW_NOTINSERVICE;
            }
        }
    } else if (action == COMMIT) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSMPMODELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            update_timestamp(params);
        }
    } else if (action == FREE || action == UNDO) {
        /*
         * Try to undo the SET here (abnormal usage of FREE clause)  
         */
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSMPMODELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            if (params->storageType != SNMP_STORAGE_READONLY
                && params->rowStatus != SNMP_ROW_ACTIVE) {
                params->mpModel = old_mp;
                if (params->rowStatus == SNMP_ROW_NOTINSERVICE &&
                    !snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            }
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* write_snmpTargetParamsMPModel */

/*
 * Assign a value to the secModel variable.  
 */
int
write_snmpTargetParamsSecModel(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            long_ret = *((long *) var_val);
    static long     old_sec;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_INTEGER) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecModel: not ASN_INTEGER\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != sizeof(long)) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecModel: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
        if (long_ret <= 0) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecModel: secModel out of range\n"));
            return SNMP_ERR_WRONGVALUE;
        }
        if (find_sec_mod(long_ret) == NULL && long_ret >= 3) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecModel: secModel %ld unsupported\n",
                        long_ret));
            return SNMP_ERR_INCONSISTENTVALUE;
        }

    } else if (action == RESERVE2) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYMODELCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params == NULL) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecModel: BAD OID\n"));
            return SNMP_ERR_INCONSISTENTNAME;
        } else {
            /*
             * Row exists, check if it is changeable.  
             */
            if (params->storageType == SNMP_STORAGE_READONLY) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamSecModel: row is read only\n"));
                return SNMP_ERR_NOTWRITABLE;
            }
            /*
             * Check if row is active.  
             */
            if (params->rowStatus == SNMP_ROW_ACTIVE) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamsSecModel: this change not allowed in active row.\n"));
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            old_sec = params->secModel;
            params->secModel = long_ret;

            if (params->rowStatus == SNMP_ROW_NOTREADY &&
                snmpTargetParams_rowStatusCheck(params)) {
                params->rowStatus = SNMP_ROW_NOTINSERVICE;
            }
        }
    } else if (action == COMMIT) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYMODELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            update_timestamp(params);
        }
    } else if (action == FREE || action == UNDO) {
        /*
         * Try to undo the SET here (abnormal usage of FREE clause)  
         */
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYMODELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            if (params->storageType != SNMP_STORAGE_READONLY
                && params->rowStatus != SNMP_ROW_ACTIVE) {
                params->secModel = old_sec;
                if (params->rowStatus == SNMP_ROW_NOTINSERVICE &&
                    !snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            }
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* write_snmpTargetParamsSecModel */

/*
 * Assign a value to the SecLevel variable.  
 */
int
write_snmpTargetParamsSecLevel(int action,
                               u_char * var_val,
                               u_char var_val_type,
                               size_t var_val_len,
                               u_char * statP, oid * name, size_t name_len)
{
    long            long_ret = *((long *) var_val);
    static long     old_level;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_INTEGER) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecLevel: not ASN_INTEGER\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != sizeof(long)) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecLevel: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
        if (long_ret <= 0 || long_ret > 3) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecLevel: security level is not noAuthNoPriv(1), authNopriv(2) or authPriv(3)\n"));
            return SNMP_ERR_WRONGVALUE;
        }
    } else if (action == RESERVE2) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYLEVELCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params == NULL) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecLevel: BAD OID\n"));
            return SNMP_ERR_INCONSISTENTNAME;
        } else {
            /*
             * Row exists, check if it is changeable.  
             */
            if (params->storageType == SNMP_STORAGE_READONLY) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamSecLevel: row is read only\n"));
                return SNMP_ERR_NOTWRITABLE;
            }
            /*
             * Check if row is active.  
             */
            if (params->rowStatus == SNMP_ROW_ACTIVE) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamsSecLevel: this change not allowed in active row.\n"));
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            old_level = params->secLevel;
            params->secLevel = long_ret;

            if (params->rowStatus == SNMP_ROW_NOTREADY &&
                snmpTargetParams_rowStatusCheck(params)) {
                params->rowStatus = SNMP_ROW_NOTINSERVICE;
            }
        }
    } else if (action == COMMIT) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYLEVELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            update_timestamp(params);
        }
    } else if (action == FREE || action == UNDO) {
        /*
         * Try to undo the SET here (abnormal usage of FREE clause)  
         */
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYLEVELCOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            if (params->storageType != SNMP_STORAGE_READONLY
                && params->rowStatus != SNMP_ROW_ACTIVE) {
                params->secLevel = old_level;
                if (params->rowStatus == SNMP_ROW_NOTINSERVICE &&
                    !snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            }
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* write_snmpTargetParamsSecLevel */

/*
 * Assign a value to the storageType variable.  
 */
int
write_snmpTargetParamsStorageType(int action,
                                  u_char * var_val,
                                  u_char var_val_type,
                                  size_t var_val_len,
                                  u_char * statP,
                                  oid * name, size_t name_len)
{
    long            long_ret = *((long *) var_val);
    static long     old_st;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_INTEGER) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsStorageType: not ASN_INTEGER\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != sizeof(long)) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsStorageType: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
        if (long_ret != SNMP_STORAGE_OTHER &&
            long_ret != SNMP_STORAGE_VOLATILE &&
            long_ret != SNMP_STORAGE_NONVOLATILE) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsStorageType: attempted storage type not a valid"));
            DEBUGMSG(("snmpTargetParamsEntry",
                      " value of other(%d), volatile(%d), or nonvolatile(%d)\n",
                      SNMP_STORAGE_OTHER, SNMP_STORAGE_VOLATILE,
                      SNMP_STORAGE_NONVOLATILE));
            return SNMP_ERR_WRONGVALUE;
        }
    } else if (action == RESERVE2) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSTORAGETYPECOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params == NULL) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsStorageType: BAD OID\n"));
            return SNMP_ERR_INCONSISTENTNAME;
        } else {
            /*
             * Row exists, check if it is changeable.  
             */
            if (params->storageType == SNMP_STORAGE_READONLY ||
                params->storageType == SNMP_STORAGE_PERMANENT) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamsStorageType: row has unchangeable storage status: %d\n",
                            params->storageType));
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            old_st = params->storageType;
            params->storageType = long_ret;
        }
    } else if (action == FREE || action == UNDO) {
        /*
         * Try to undo the SET here (abnormal usage of FREE clause)  
         */
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSTORAGETYPECOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            if (params->storageType != SNMP_STORAGE_READONLY
                && params->storageType != SNMP_STORAGE_PERMANENT) {
                params->storageType = old_st;
            }
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* write_snmpTargetParamsStorageType */

/*
 * Assign a value to the secName variable.  
 */
int
write_snmpTargetParamsSecName(int action,
                              u_char * var_val,
                              u_char var_val_type,
                              size_t var_val_len,
                              u_char * statP, oid * name, size_t name_len)
{
    static char    *old_name;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_OCTET_STR) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecName: not ASN_OCTET_STR\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len > 255 || var_val_len < 0) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecName: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
    } else if (action == RESERVE2) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYNAMECOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params == NULL) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsSecName: BAD OID\n"));
            return SNMP_ERR_INCONSISTENTNAME;
        } else {
            /*
             * Row exists, check if it is changeable.  
             */
            if (params->storageType == SNMP_STORAGE_READONLY) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamSecName: row is read only\n"));
                return SNMP_ERR_NOTWRITABLE;
            }
            /*
             * Check if row is active.  
             */
            if (params->rowStatus == SNMP_ROW_ACTIVE) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "write to snmpTargetParamsSecName: this change not allowed in active row.\n"));
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            old_name = params->secName;
            params->secName = (char *) malloc(var_val_len + 1);
            if (params->secName == NULL) {
                return SNMP_ERR_RESOURCEUNAVAILABLE;
            }
            memcpy(params->secName, var_val, var_val_len);
            params->secName[var_val_len] = '\0';

            if (params->rowStatus == SNMP_ROW_NOTREADY &&
                snmpTargetParams_rowStatusCheck(params)) {
                params->rowStatus = SNMP_ROW_NOTINSERVICE;
            }
        }
    } else if (action == COMMIT) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYNAMECOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            update_timestamp(params);
            SNMP_FREE(old_name);
            old_name = NULL;
        }
    } else if (action == FREE || action == UNDO) {
        /*
         * Try to undo the SET here (abnormal usage of FREE clause)  
         */
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSSECURITYNAMECOLUMN;
        if ((params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                                   snmpTargetParamsOIDLen,
                                                   name, &name_len,
                                                   1)) != NULL) {
            if (params->storageType != SNMP_STORAGE_READONLY
                && params->rowStatus != SNMP_ROW_ACTIVE) {
                SNMP_FREE(params->secName);
                params->secName = old_name;
                if (params->rowStatus == SNMP_ROW_NOTINSERVICE &&
                    !snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            }
        }
    }

    return SNMP_ERR_NOERROR;
}                               /* write_snmpTargetParamsSecName */

/*
 * snmpTargeParams_createNewRow is called from write_snmpTargetParamsRowStatus
 * when a new row is required. It creates a new row with 
 * the index of the passed in 'name' (i.e. full index OID) and
 * adds it to the linked list. 'name' should be the full OID of the new index. 
 * It passes back 0 if unsuccessfull.
 */
int
snmpTargetParams_createNewRow(oid * name, size_t name_len)
{
    int             pNameLen, i;
    struct targetParamTable_struct *temp_struct;

    /*
     * setup a new snmpTargetParamTable structure and add it to the list 
     */
    pNameLen = name_len - snmpTargetParamsOIDLen;
    if (pNameLen > 0) {
        temp_struct = snmpTargetParamTable_create();
        temp_struct->paramName = (char *) malloc(pNameLen + 1);

        for (i = 0; i < pNameLen; i++) {
            temp_struct->paramName[i] =
                (char) name[i + snmpTargetParamsOIDLen];
        }

        temp_struct->paramName[pNameLen] = '\0';
        temp_struct->rowStatus = SNMP_ROW_NOTREADY;

        update_timestamp(temp_struct);
        snmpTargetParamTable_addToList(temp_struct, &aPTable);

        return 1;
    }

    return 0;
}                               /* snmpTargetParams_createNewRow */

/*
 * Assign a value to the Row Status variable 
 */
int
write_snmpTargetParamsRowStatus(int action,
                                u_char * var_val,
                                u_char var_val_type,
                                size_t var_val_len,
                                u_char * statP,
                                oid * name, size_t name_len)
{
    static long     value;
    struct targetParamTable_struct *params = NULL;

    if (action == RESERVE1) {
        if (var_val_type != ASN_INTEGER) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsRowStatus not ASN_INTEGER\n"));
            return SNMP_ERR_WRONGTYPE;
        }
        if (var_val_len != sizeof(long)) {
            DEBUGMSGTL(("snmpTargetParamsEntry",
                        "write to snmpTargetParamsRowStatus: bad length\n"));
            return SNMP_ERR_WRONGLENGTH;
        }
        value = *((long *) var_val);
        if (value == SNMP_ROW_NOTREADY || value < 1 || value > 6) {
            return SNMP_ERR_WRONGVALUE;
        }

        /*
         * Check index value is reasonable.  
         */

        if (name_len < snmpTargetParamsOIDLen + 1 ||
            name_len > snmpTargetParamsOIDLen + 32) {
            DEBUGMSGTL(("snmpTargetParamsEntry", "bad index length %d\n",
                        (int)(name_len - snmpTargetParamsOIDLen)));
            return SNMP_ERR_NOCREATION;
        }

        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSROWSTATUSCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params != NULL) {
            if (value == SNMP_ROW_CREATEANDGO
                || value == SNMP_ROW_CREATEANDWAIT) {
                value = SNMP_ROW_NOTREADY;
                return SNMP_ERR_INCONSISTENTVALUE;
            }
            if (params->storageType == SNMP_STORAGE_READONLY) {
                DEBUGMSGTL(("snmpTargetParamsEntry",
                            "row is read only\n"));
                return SNMP_ERR_NOTWRITABLE;
            }
            if (params->storageType == SNMP_STORAGE_PERMANENT) {
                if (value == SNMP_ROW_DESTROY) {
                    DEBUGMSGTL(("snmpTargetParamsEntry",
                                "unable to destroy permanent row\n"));
                    return SNMP_ERR_INCONSISTENTVALUE;
                }
            }
        } else {
            if (value == SNMP_ROW_ACTIVE || value == SNMP_ROW_NOTINSERVICE) {
                return SNMP_ERR_INCONSISTENTVALUE;
            }
            if (value == SNMP_ROW_CREATEANDGO
                || value == SNMP_ROW_CREATEANDWAIT) {
                if (snmpTargetParams_createNewRow(name, name_len) == 0) {
                    DEBUGMSGTL(("snmpTargetParamsEntry",
                                "couldn't malloc() new row\n"));
                    return SNMP_ERR_RESOURCEUNAVAILABLE;
                }
            }
        }
    } else if (action == ACTION) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSROWSTATUSCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params != NULL) {
            if (value == SNMP_ROW_CREATEANDGO) {
                /*
                 * Check whether all the required objects have been set.  
                 */
                if (snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_ACTIVE;
                } else {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            } else if (value == SNMP_ROW_CREATEANDWAIT) {
                /*
                 * Check whether all the required objects have been set.  
                 */
                if (snmpTargetParams_rowStatusCheck(params)) {
                    params->rowStatus = SNMP_ROW_NOTINSERVICE;
                } else {
                    params->rowStatus = SNMP_ROW_NOTREADY;
                }
            } else if (value == SNMP_ROW_ACTIVE) {
                if (params->rowStatus == SNMP_ROW_NOTINSERVICE) {
                    params->rowStatus = SNMP_ROW_ACTIVE;
                } else if (params->rowStatus == SNMP_ROW_NOTREADY) {
                    return SNMP_ERR_INCONSISTENTVALUE;
                }
            } else if (value == SNMP_ROW_NOTINSERVICE) {
                if (params->rowStatus == SNMP_ROW_ACTIVE) {
                    params->rowStatus = SNMP_ROW_NOTINSERVICE;
                } else if (params->rowStatus == SNMP_ROW_NOTREADY) {
                    return SNMP_ERR_INCONSISTENTVALUE;
                }
            }
        }
    } else if (action == COMMIT) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSROWSTATUSCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (params != NULL) {
            if (value == SNMP_ROW_DESTROY) {
                snmpTargetParamTable_remFromList(params, &aPTable);
            }
            if (value == SNMP_ROW_ACTIVE || value == SNMP_ROW_NOTINSERVICE) {
                update_timestamp(params);
            }
        }
    } else if (action == UNDO || action == FREE) {
        snmpTargetParamsOID[snmpTargetParamsOIDLen - 1] =
            SNMPTARGETPARAMSROWSTATUSCOLUMN;
        params = search_snmpTargetParamsTable(snmpTargetParamsOID,
                                              snmpTargetParamsOIDLen,
                                              name, &name_len, 1);
        if (value == SNMP_ROW_CREATEANDGO
            || value == SNMP_ROW_CREATEANDWAIT) {
            if (params != NULL) {
                snmpTargetParamTable_remFromList(params, &aPTable);
            }
        }
    }
    return SNMP_ERR_NOERROR;
}

struct targetParamTable_struct *
get_paramEntry(char *name)
{
    static struct targetParamTable_struct *ptr;
    for (ptr = aPTable; ptr; ptr = ptr->next) {
        if (strcmp(ptr->paramName, name) == 0) {
            return ptr;
        }
    }
    return NULL;
}
