/* @(#)strnlen.c	1.1 10/04/26 Copyright 2010 J. Schilling */
/*
 *	strnlen() to be used if missing in libc
 *
 *	Copyright (c) 2010 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#include <schily/standard.h>
#include <schily/unistd.h>
#include <schily/schily.h>

#ifndef	HAVE_STRNLEN

EXPORT size_t
strnlen(s, len)
	register const char	*s;
	register size_t		len;
{
	register const char	*rs = s;

	if (++len == 0) {	/* unsigned overflow */
		while (len-- > 0 && *rs++ != '\0')
			;
		if (len == 0)
			return (rs - s);
		return (--rs - s);
	} else {
		while (--len > 0 && *rs++ != '\0')
			;
		if (len == 0)
			return (rs - s);
		return (--rs - s);
	}
}

#endif
