/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.modify.remove;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.webclient.repository.modify.remove.RemovalSpecification;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class ClearController
extends SimpleFormController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) {
        this.logger.info("Clearing data...");
        String actionResult = "repository.modify.remove.clear.success";
        RemovalSpecification toRemove = (RemovalSpecification)command;
        HTTPRepository repo = (HTTPRepository)request.getSession().getAttribute("openrdf-repository");
        RepositoryConnection conn = null;
        try {
            conn = repo.getConnection();
            conn.clear(toRemove.getContexts());
            conn.commit();
            this.logger.info("Clear committed.");
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to clear repository", (Throwable)e);
            actionResult = "repository.modify.remove.clear.failure";
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ModelAndView(this.getSuccessView(), "actionResult", (Object)actionResult);
    }
}

