iconName = 'core'
labelText = 'KBugReport'

##~ if we wanted to, we could define the name of a KDE class used for lookup of
##~ the documentation url.  The 'labelText' string above already 
##~ specifies what we want.
##~ docItemName = 'KBugReport'

from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KAboutDialog, KPushButton, KBugReport, KTextEdit


helpText = ("KDE provides a way to report bugs from applications.  This dialog"
            "is typically available from the application 'Help' menu.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Bug Report Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showBugDialog)


    def showBugDialog(self):
        dlg = KBugReport(self)
        dlg.exec_loop()
