/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.components;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.image.VolatileImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class LevelIndicator
extends JComponent {
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final Dimension PREFERRED_SIZE = new Dimension(40, 20);
    private Color maximumColor = Color.RED;
    private Color minimumColor = Color.GREEN;
    private Color peakColor = null;
    private Dimension canvasDimension = null;
    private Insets canvasInsets = NULL_INSETS;
    private boolean autoRepaint = true;
    private boolean followPeak;
    private int peakMarkSize = 8;
    private long max = 0L;
    private long min = 0L;
    private long peak = Long.MIN_VALUE;
    private long val = this.min;

    public LevelIndicator() {
        this.setPreferredSize(PREFERRED_SIZE);
        this.setMinimumSize(PREFERRED_SIZE);
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void setFollowPeak(boolean markPeaks) {
        this.followPeak = markPeaks;
    }

    public boolean isFollowPeak() {
        return this.followPeak;
    }

    public void setMaximum(long max) {
        this.max = max;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public long getMaximum() {
        return this.max;
    }

    public void setMaximumColor(Color maximumColor) {
        this.maximumColor = maximumColor;
    }

    public Color getMaximumColor() {
        return this.maximumColor;
    }

    public void setMinimum(long min) {
        this.min = min;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public long getMinimum() {
        return this.min;
    }

    public void setMinimumColor(Color minimumColor) {
        this.minimumColor = minimumColor;
    }

    public Color getMinimumColor() {
        return this.minimumColor;
    }

    public void setPeak() {
        this.peak = this.val;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public void setPeak(long value) {
        if (this.peak <= this.max) {
            this.peak = value;
            if (this.autoRepaint) {
                this.repaint();
            }
        }
    }

    public long getPeak() {
        return this.peak;
    }

    public void setPeakMarkSize(int peakMarkSize) {
        this.peakMarkSize = peakMarkSize;
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public int getPeakMarkSize() {
        return this.peakMarkSize;
    }

    public void setValue(long value) {
        this.val = Math.max(Math.min(value, this.max), 0L);
        if (this.followPeak && this.val > this.peak) {
            this.peak = this.val;
        }
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    public long getValue() {
        return this.val;
    }

    public void doLayout() {
        super.doLayout();
        this.canvasInsets = this.getInsets();
        this.canvasDimension = new Dimension(this.getBounds().width - (this.canvasInsets.left + this.canvasInsets.right), this.getBounds().height - (this.canvasInsets.top + this.canvasInsets.bottom));
    }

    public void paintComponent(Graphics g) {
        if (this.canvasDimension == null) {
            return;
        }
        if (this.canvasDimension.getHeight() < 0.0 || this.canvasDimension.getWidth() < 0.0) {
            return;
        }
        try {
            VolatileImage img = this.createVolatileImage(this.getBounds().width - (this.canvasInsets.left + this.canvasInsets.right), this.getBounds().height - (this.canvasInsets.top + this.canvasInsets.bottom), new ImageCapabilities(true));
            Graphics2D gr = img.createGraphics();
            this.renderLevel(gr, img);
            this.renderPeak(gr);
            gr.dispose();
            g.drawImage(img, this.canvasInsets.left, this.canvasInsets.top, this);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public void unsetPeak() {
        this.peak = Integer.MIN_VALUE;
        this.repaint();
    }

    private Color getColorAt(VolatileImage img, int x, int y) {
        if (x <= 0 || y < 0 || x > img.getWidth() || y > img.getHeight()) {
            return null;
        }
        int RGB = img.getSnapshot().getRGB(x - 1, 0);
        int red = (RGB & 0xFF0000) >> 16;
        int green = (RGB & 0xFF00) >> 8;
        int blue = RGB & 0xFF;
        return new Color(red, green, blue);
    }

    private int getPosition(long value) {
        float ratio = (float)value / (float)(this.max - this.min);
        return Math.round((float)((double)ratio * this.canvasDimension.getWidth()));
    }

    private void renderLevel(Graphics2D gr, VolatileImage img) {
        gr.setPaint(new GradientPaint(0.0f, 0.0f, this.minimumColor, this.canvasDimension.width, 0.0f, this.maximumColor));
        gr.fillRect(0, 0, this.canvasDimension.width, this.canvasDimension.height);
        if (this.peak > Integer.MIN_VALUE) {
            this.peakColor = this.getColorAt(img, this.getPosition(this.peak), 0);
        }
        int position = this.getPosition(this.val);
        gr.setPaint(this.getBackground());
        gr.fillRect(position, 0, this.canvasDimension.width - position + 1, this.canvasDimension.height);
    }

    private void renderPeak(Graphics2D gr) {
        if (this.peakColor == null) {
            return;
        }
        int position = this.getPosition(this.peak);
        int decrement = 0;
        int left = 0;
        int right = 0;
        do {
            left = Math.round((float)position - (float)(this.peakMarkSize - decrement) / 2.0f);
            right = Math.round((float)left + (float)(this.peakMarkSize - decrement) / 2.0f);
            if (left < 0) {
                right += Math.abs(left);
                left = 0;
            }
            if ((double)right > this.canvasDimension.getWidth()) {
                left = (int)((double)left - ((double)right - this.canvasDimension.getWidth()));
                right = (int)this.canvasDimension.getWidth();
            }
            ++decrement;
        } while ((left < 0 || (double)right > this.canvasDimension.getWidth()) && left != right);
        gr.setPaint(this.peakColor);
        gr.fillRect(left, 0, right - left + 1, this.canvasDimension.height);
    }
}

