/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import java.awt.Image;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnapshotDescriptor<X extends Snapshot>
extends DataSourceDescriptor<X> {
    public SnapshotDescriptor(X snapshot, Image icon) {
        super(snapshot, SnapshotDescriptor.resolveName(snapshot), ((Snapshot)snapshot).getFile().getAbsolutePath(), icon, 0x7FFFFFFE, 0);
    }

    private static String resolveName(Snapshot snapshot) {
        String timeStamp;
        String persistedName = snapshot.getStorage().getCustomProperty("prop_name");
        if (persistedName != null) {
            return persistedName;
        }
        File file = snapshot.getFile();
        if (file == null) {
            return snapshot.toString();
        }
        String fileName = file.getName();
        SnapshotCategory category = snapshot.getCategory();
        String name = "[" + category.getPrefix() + "] " + fileName;
        if (category.isSnapshot(file) && (timeStamp = category.getTimeStamp(fileName)) != null) {
            name = "[" + category.getPrefix() + "] " + timeStamp;
        }
        return name;
    }

    @Override
    public boolean supportsRename() {
        return true;
    }
}

