/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapdump.impl;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceWindowManager;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.heapdump.HeapDumpSupport;
import com.sun.tools.visualvm.heapdump.impl.HeapDumpImpl;
import com.sun.tools.visualvm.tools.sa.SaModel;
import com.sun.tools.visualvm.tools.sa.SaModelFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HeapDumpProvider {
    private static final Logger LOGGER = Logger.getLogger(HeapDumpProvider.class.getName());

    public void createHeapDump(final Application application, final boolean openView) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle pHandleF;
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                if (!jvm.isTakeHeapDumpSupported()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Cannot_take_heap_dump") + DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName());
                        }
                    });
                    return;
                }
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HeapDumpProvider.class, (String)"LBL_Creating_Heap_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        File file = jvm.takeHeapDump();
                        if (file != null && file.isFile()) {
                            final HeapDumpImpl heapDump = new HeapDumpImpl(jvm.takeHeapDump(), (DataSource)application);
                            application.getRepository().addDataSource((DataSource)heapDump);
                            if (openView) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)heapDump);
                                    }
                                });
                            }
                        } else {
                            HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)application);
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "createHeapDump-Application", ex);
                        HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)application);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void createHeapDump(final CoreDump coreDump, final boolean openView) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(HeapDumpProvider.class, (String)"LBL_Creating_Heap_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    File snapshotDir = coreDump.getStorage().getDirectory();
                    String name = HeapDumpSupport.getInstance().getCategory().createFileName();
                    File dumpFile = new File(snapshotDir, name);
                    SaModel saAget = SaModelFactory.getSAAgentFor((DataSource)coreDump);
                    try {
                        if (saAget.takeHeapDump(dumpFile.getAbsolutePath())) {
                            final HeapDumpImpl heapDump = new HeapDumpImpl(dumpFile, (DataSource)coreDump);
                            coreDump.getRepository().addDataSource((DataSource)heapDump);
                            if (openView) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)heapDump);
                                    }
                                });
                            }
                        } else {
                            HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)coreDump);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, "createHeapDump-CoreDump", ex);
                        HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)coreDump);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof HeapDumpImpl) {
            return;
        }
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            File[] files = snapshotFile.listFiles(HeapDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<HeapDumpImpl> heapDumps = new HashSet<HeapDumpImpl>();
            for (File file : files) {
                heapDumps.add(new HeapDumpImpl(file, (DataSource)snapshot));
            }
            snapshot.getRepository().addDataSources(heapDumps);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            File[] files = storage.getDirectory().listFiles(HeapDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<HeapDumpImpl> heapDumps = new HashSet<HeapDumpImpl>();
            for (File file : files) {
                heapDumps.add(new HeapDumpImpl(file, (DataSource)application));
            }
            application.getRepository().addDataSources(heapDumps);
        }
    }

    private void notifyHeapDumpFailed(DataSource dataSource) {
        final String displayName = DataSourceDescriptorFactory.getDescriptor((DataSource)dataSource).getName();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Cannot_take_heap_dump") + displayName);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        for (Application application : applications) {
                            HeapDumpProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            HeapDumpProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

