/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IDEUtils {
    private static final String CREATE_NEW_CONFIGURATION_HINT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_CreateNewConfigurationHint");
    private static final String SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationLabelText");
    private static final String SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_SelectSettingsConfigurationDialogCaption");
    private static final String INVALID_PLATFORM_PROJECT_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProjectMsg");
    private static final String INVALID_PLATFORM_PROFILER_MSG = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidPlatformProfilerMsg");
    private static final String INVALID_TARGET_JVM_EXEFILE_ERROR = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_InvalidTargetJVMExeFileError");
    private static final String ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ErrorConvertingProfilingSettingsMessage");
    private static final String LIST_ACCESS_NAME = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_ListAccessName");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(IDEUtils.class, (String)"IDEUtils_OkButtonText");
    public static final String SETTINGS_DIR = "org-netbeans-modules-profiler";
    private static final RequestProcessor profilerRequestProcessor = new RequestProcessor("Profiler Request Processor", 1);
    private static final ErrorManager profilerErrorManager = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler");

    public static String getAntProfilerStartArgument15(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk15");
    }

    public static String getAntProfilerStartArgument16(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk16");
    }

    public static String getAntProfilerStartArgument17(int port, int architecture) {
        return IDEUtils.getAntProfilerStartArgument(port, architecture, "jdk17");
    }

    public static String getHelpDir() {
        Iterator suffixesIterator = NbBundle.getLocalizingSuffixes();
        File localizedHelpDir = null;
        while (suffixesIterator.hasNext() && localizedHelpDir == null) {
            localizedHelpDir = InstalledFileLocator.getDefault().locate("docs/profiler" + suffixesIterator.next(), "org.netbeans.modules.profiler", false);
        }
        if (localizedHelpDir == null) {
            return null;
        }
        return localizedHelpDir.getPath();
    }

    public static String getLibsDir() {
        File dir = InstalledFileLocator.getDefault().locate("lib/jfluid-server.jar", "org.netbeans.lib.profiler", false);
        if (dir == null) {
            return null;
        }
        return dir.getParentFile().getPath();
    }

    public static Component getMainWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    public static RequestProcessor getProfilerRequestProcessor() {
        return profilerRequestProcessor;
    }

    public static FileObject getProjectSettingsFolder(boolean create) throws IOException {
        return IDEUtils.getSettingsFolder(true);
    }

    public static String getServicesDir() {
        File dir = InstalledFileLocator.getDefault().locate("config/Services/filters-default.xml", "org.netbeans.modules.profiler", true);
        if (dir == null) {
            return null;
        }
        return dir.getParentFile().getPath();
    }

    public static FileObject getSettingsFolder(boolean create) throws IOException {
        FileObject folder = Repository.getDefault().getDefaultFileSystem().findResource("Services");
        FileObject settingsFolder = folder.getFileObject(SETTINGS_DIR, null);
        if (settingsFolder == null && create) {
            settingsFolder = folder.createFolder(SETTINGS_DIR);
        }
        return settingsFolder;
    }

    public static TopComponent getTopComponent(Component temp) {
        while (!(temp instanceof TopComponent)) {
            if ((temp = temp.getParent()) != null) continue;
            return null;
        }
        return (TopComponent)temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertPropertiesToXML(FileObject propertiesFO, FileObject xmlFO) {
        FileLock propertiesFOLock = null;
        FileLock xmlFOLock = null;
        try {
            propertiesFOLock = propertiesFO.lock();
            InputStream fis = propertiesFO.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(fis);
            Properties properties = new Properties();
            properties.load(bis);
            bis.close();
            fis.close();
            xmlFOLock = xmlFO.lock();
            OutputStream fos = xmlFO.getOutputStream(xmlFOLock);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            properties.storeToXML(bos, "");
            bos.close();
            fos.close();
            propertiesFO.delete(propertiesFOLock);
        }
        catch (Exception e) {
            ProfilerLogger.log((Exception)e);
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(ERROR_CONVERTING_PROFILING_SETTINGS_MESSAGE, FileUtil.toFile((FileObject)propertiesFO).getPath(), FileUtil.toFile((FileObject)xmlFO).getPath(), e.getMessage()), 2));
        }
        finally {
            if (propertiesFOLock != null) {
                propertiesFOLock.releaseLock();
            }
            if (xmlFOLock != null) {
                xmlFOLock.releaseLock();
            }
        }
    }

    public static Properties duplicateProperties(Properties props) {
        Properties ret = new Properties();
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ret.setProperty(key, props.getProperty(key));
        }
        return ret;
    }

    public static ProgressHandle indeterminateProgress(String title, final int timeout) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)title);
        IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

            public void run() {
                ph.setInitialDelay(timeout);
                ph.start();
            }
        });
        return ph;
    }

    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e) {
                profilerErrorManager.notify((Throwable)e);
            }
            catch (InterruptedException e) {
                profilerErrorManager.notify((Throwable)e);
            }
        }
    }

    public static void runInProfilerRequestProcessor(Runnable r) {
        profilerRequestProcessor.post(r);
    }

    public static ProfilingSettings selectSettings(int type, ProfilingSettings[] availableSettings, ProfilingSettings settingsToSelect) {
        int selectedIndex;
        Object[] settings = new Object[availableSettings.length + 1];
        for (int i = 0; i < availableSettings.length; ++i) {
            settings[i] = availableSettings[i];
        }
        settings[availableSettings.length] = CREATE_NEW_CONFIGURATION_HINT;
        JLabel label = new JLabel(SELECT_SETTINGS_CONFIGURATION_LABEL_TEXT);
        final JButton okButton = new JButton(OK_BUTTON_TEXT);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(450, 250));
        panel.setBorder(new EmptyBorder(12, 12, 12, 12));
        panel.setLayout(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        final JList<Object> list = new JList<Object>(settings);
        label.setLabelFor(list);
        list.getAccessibleContext().setAccessibleName(LIST_ACCESS_NAME);
        list.setSelectionMode(0);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(list.getSelectedIndex() != -1);
            }
        });
        if (settingsToSelect != null) {
            list.setSelectedValue(settingsToSelect, true);
        } else {
            list.setSelectedIndex(0);
        }
        panel.add((Component)new JScrollPane(list), "Center");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SELECT_SETTINGS_CONFIGURATION_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog(dd);
        d.setVisible(true);
        if (dd.getValue() == okButton && (selectedIndex = list.getSelectedIndex()) != -1) {
            if (selectedIndex < settings.length - 1) {
                ProfilingSettings selectedSettings = (ProfilingSettings)settings[selectedIndex];
                selectedSettings.setProfilingType(type);
                return selectedSettings;
            }
            ProfilingSettings newSettings = ProfilingSettingsManager.getDefault().createNewSettings(type, availableSettings);
            if (newSettings == null) {
                return null;
            }
            newSettings.setProfilingType(type);
            return newSettings;
        }
        return null;
    }

    private static String getAntProfilerStartArgument(int port, int architecture, String jdkVersion) {
        String ld = IDEUtils.getLibsDir();
        return "-agentpath:" + Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)jdkVersion, (int)architecture) + "=" + ld + "," + port + "," + System.getProperty("profiler.agent.connect.timeout", "10");
    }

    private static ArrayList getSettings(int mask) {
        ProfilingSettings[] projectSettings;
        ArrayList<ProfilingSettings> matching = new ArrayList<ProfilingSettings>();
        for (ProfilingSettings settings : projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings().getProfilingSettings()) {
            if (!IDEUtils.matchesMask(settings, mask)) continue;
            matching.add(settings);
        }
        return matching;
    }

    private static String forwardSlashes(String text) {
        return text.replaceAll("\\\\", "/");
    }

    private static boolean matchesMask(ProfilingSettings settings, int mask) {
        return Utils.isCPUSettings(settings);
    }
}

