/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.wizards.panels.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.common.integration.IntegrationProvider;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StepsPanelComponent
extends JPanel {
    private final ResourceBundle messages = ResourceBundle.getBundle("org/netbeans/modules/profiler/ui/wizards/panels/components/StepsPanelComponent");
    private final String STEP = this.messages.getString("STEP");
    private final String WARNINGS = this.messages.getString("WARNINGS");
    private final String NOTES = this.messages.getString("NOTES");
    private final String WARNING = this.messages.getString("WARNING");
    private final String NOTE = this.messages.getString("NOTE");
    private final String EMPTY_HINT = "<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n";
    private final int LOCATION_TOP = 1;
    private final int LOCATION_MIDDLE = 2;
    private final int LOCATION_BOTTOM = 3;
    private boolean warningsFirst = true;
    private boolean isLabelHidden = false;
    private double lastLabelHeight = -1.0;
    private HTMLTextArea areaSteps;
    private JLabel label;
    private HTMLLabel labelHints;
    private JScrollPane stepsScroller;
    private IntegrationProvider.IntegrationHints steps;

    public StepsPanelComponent() {
        this.initComponents();
    }

    private void initComponents() {
        this.stepsScroller = new JScrollPane();
        this.areaSteps = new HTMLTextArea();
        this.label = new JLabel();
        this.labelHints = new HTMLLabel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 100));
        this.setPreferredSize(new Dimension(400, 200));
        this.setRequestFocusEnabled(false);
        this.setLayout(new BorderLayout());
        this.stepsScroller.setMaximumSize(new Dimension(800, 600));
        this.stepsScroller.setMinimumSize(new Dimension(300, 100));
        this.stepsScroller.setPreferredSize(new Dimension(380, 100));
        this.stepsScroller.setViewportView((Component)this.areaSteps);
        this.add((Component)this.stepsScroller, "Center");
        this.label.setLabelFor((Component)this.areaSteps);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.label.text"));
        this.label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.label, "North");
        this.labelHints.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.labelHints.setText(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.labelHints.text"));
        this.labelHints.setMaximumSize(new Dimension(300, 100));
        this.labelHints.setMinimumSize(new Dimension(300, 0));
        this.labelHints.setPreferredSize(new Dimension(300, 60));
        Color panelBackground = UIManager.getColor("Panel.background");
        Color hintBackground = UIUtils.getSafeColor((int)(panelBackground.getRed() - 10), (int)(panelBackground.getGreen() - 10), (int)(panelBackground.getBlue() - 10));
        this.labelHints.setDisabledTextColor(Color.darkGray);
        this.labelHints.setBackground(hintBackground);
        this.add((Component)this.labelHints, "South");
        this.labelHints.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StepsPanelComponent.class, (String)"StepsPanelComponent.labelHints.AccessibleContext.accessibleName"));
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        Mnemonics.setLocalizedText((JLabel)this.label, (String)title);
    }

    public IntegrationProvider.IntegrationHints getSteps() {
        return this.steps;
    }

    public void setSteps(IntegrationProvider.IntegrationHints steps) {
        this.steps = steps;
        if (steps == null) {
            this.areaSteps.setText("");
            return;
        }
        StringBuffer hintText = new StringBuffer();
        if (steps.isWarningsFirst()) {
            this.appendWarnings(hintText);
        }
        this.appendSteps(hintText);
        if (!steps.isWarningsFirst()) {
            this.appendWarnings(hintText);
        }
        this.appendHints(hintText);
        hintText.append("<br>");
        this.areaSteps.setText(hintText.toString());
        this.areaSteps.setCaretPosition(0);
    }

    private void appendHints(StringBuffer hintText) {
        if (this.steps.getHints().size() > 0) {
            this.exportAsHtmlList(this.steps.getHints(), this.NOTE, true, hintText);
        }
    }

    private void appendWarnings(StringBuffer hintText) {
        boolean isLast;
        boolean bl = isLast = !this.steps.isWarningsFirst() && this.steps.getHints().size() == 0;
        if (this.steps.getWarnings().size() > 0) {
            this.exportAsHtmlList(this.steps.getWarnings(), this.WARNING, "#594FBF", isLast, hintText);
        }
    }

    private void appendSteps(StringBuffer buffer) {
        boolean isLast = this.steps.isWarningsFirst() && this.steps.getHints().size() == 0 || this.steps.getHints().size() == 0 && this.steps.getWarnings().size() == 0;
        this.exportAsHtmlList(this.steps.getSteps(), this.STEP, isLast, buffer);
    }

    private void exportAsHtmlList(List listToExport, String prefix, boolean isLast, StringBuffer buffer) {
        this.exportAsHtmlList(listToExport, prefix, null, isLast, buffer);
    }

    private void exportAsHtmlList(List listToExport, String prefix, String color, boolean isLast, StringBuffer buffer) {
        int stepCounter = 1;
        Iterator it = listToExport.iterator();
        while (it.hasNext()) {
            buffer.append("<p>").append("<b>").append(MessageFormat.format(prefix, new Integer(stepCounter++))).append("</b>").append(" ");
            StringBuffer innerMessage = new StringBuffer();
            innerMessage.append(it.next()).append("</p>");
            if (color != null) {
                buffer.append("<span style='color:").append(color).append("'>").append(innerMessage).append("</span>");
                continue;
            }
            buffer.append(innerMessage);
        }
        if (!isLast) {
            buffer.append("<br><hr>");
        }
    }

    public String getHintText() {
        return this.labelHints.getText();
    }

    public void setHintText(String hintText) {
        this.labelHints.setText(hintText);
        if (hintText == null || hintText.length() == 0 || this.labelHints.getText().equals("<html>\n  <head>\n    \n  </head>\n  <body>\n  </body>\n</html>\n")) {
            this.labelHints.setVisible(false);
        } else {
            this.labelHints.setVisible(true);
        }
        this.revalidate();
    }
}

