/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats.drilldown;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.marking.HierarchicalMark;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public class DrillDown
implements IDrillDown,
CCTResultsFilter.Evaluator {
    private final List ddPath = new ArrayList(5);
    private final Map netTimeMap = new HashMap();
    private final Map timeMap = new HashMap();
    private final ProfilerClient client;
    private final Set listeners = Collections.synchronizedSet(new HashSet());
    private final boolean secondTime;
    private final boolean validFlag;
    private HierarchicalMark currentMark;
    private HierarchicalMark root;
    private boolean isSelf = false;

    public DrillDown(ProfilerClient client, HierarchicalMark markRoot, boolean secondTimeStamp) {
        this.root = markRoot;
        this.secondTime = secondTimeStamp;
        this.client = client;
        this.reset();
        this.validFlag = !markRoot.getChildren().isEmpty();
    }

    public DrillDown(ProfilerClient client, HierarchicalMark markRoot) {
        this(client, markRoot, false);
    }

    public boolean isCurrent(Mark mark) {
        return this.getCurrentMark().equals((Object)mark);
    }

    public Mark getCurrentMark() {
        return this.currentMark != null ? this.currentMark : Mark.DEFAULT;
    }

    public long getCurrentTime(boolean net) {
        return this.getMarkTime((Mark)this.currentMark, net);
    }

    public List getDrillDownPath() {
        ArrayList<Mark> rslt = new ArrayList<Mark>(this.ddPath);
        if (this.isSelf) {
            rslt.add(new Mark("SELF", "Self"));
        }
        return rslt;
    }

    public boolean isInSelf() {
        return this.isSelf;
    }

    public long getMarkTime(Mark mark, boolean net) {
        TimeTouple time = (TimeTouple)(net ? this.netTimeMap : this.timeMap).get(mark);
        return time != null ? (this.secondTime ? time.time1 : time.time0) : 0L;
    }

    public List getSubmarks() {
        if (this.isSelf) {
            return Arrays.asList(this.currentMark);
        }
        ArrayList<HierarchicalMark> rslt = new ArrayList<HierarchicalMark>(this.currentMark.getChildren());
        rslt.add(this.currentMark);
        return rslt;
    }

    public Mark getTopMark() {
        return this.root;
    }

    public long getTopTime(boolean net) {
        return this.getMarkTime((Mark)this.root, net);
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void addListener(DrillDownListener drillDownListener) {
        this.listeners.add(drillDownListener);
    }

    public boolean canDrilldown(Mark mark) {
        if (mark == null) {
            return false;
        }
        if (this.isSelf) {
            return false;
        }
        if (this.isCurrent(mark) && mark instanceof HierarchicalMark) {
            return ((HierarchicalMark)mark).getChildren().size() > 1;
        }
        return true;
    }

    public void drilldown(Mark mark) {
        if (!this.canDrilldown(mark)) {
            return;
        }
        if (mark.equals((Object)this.currentMark)) {
            this.isSelf = true;
            this.fireDrillDownChange();
        } else {
            this.isSelf = false;
            for (HierarchicalMark child : this.currentMark.getChildren()) {
                if (!child.equals((Object)mark)) continue;
                if (!this.canDrilldown(mark)) break;
                this.currentMark = child;
                this.ddPath.add(this.currentMark);
                this.fireDrillDownChange();
                break;
            }
        }
    }

    public void drillup() {
        if (this.ddPath.size() == 1) {
            return;
        }
        this.ddPath.remove(this.ddPath.size() - 1);
        this.currentMark = (HierarchicalMark)this.ddPath.get(this.ddPath.size() - 1);
        this.fireDrillDownChange();
    }

    public void drillup(Mark mark) {
        if (!this.ddPath.contains(mark)) {
            return;
        }
        this.isSelf = false;
        for (int i = this.ddPath.size() - 1; i >= 0; --i) {
            if (this.ddPath.get(i).equals(mark)) {
                this.currentMark = (HierarchicalMark)this.ddPath.get(i);
                this.fireDrillDownChange();
                break;
            }
            this.ddPath.remove(this.ddPath.size() - 1);
        }
    }

    public boolean evaluate(Mark categoryMark) {
        if (this.currentMark == null || this.currentMark.isRoot() && !this.isSelf) {
            return true;
        }
        if (this.currentMark.isDefault && categoryMark.isDefault) {
            return true;
        }
        return this.isSelf ? categoryMark.equals((Object)this.currentMark) : categoryMark.getLabels().contains(this.currentMark.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.client.getTimeCollector() == null) {
            return;
        }
        this.clearTimeMaps();
        this.client.getTimeCollector().beginTrans(false);
        try {
            this.getTime(this.root);
        }
        finally {
            this.client.getTimeCollector().endTrans();
        }
        this.fireDataChange();
    }

    public void removeListener(DrillDownListener drillDownListener) {
        this.listeners.remove(drillDownListener);
    }

    public void reset() {
        this.ddPath.clear();
        this.ddPath.add(this.root);
        this.currentMark = this.root;
        this.isSelf = false;
        this.fireDrillDownChange();
    }

    private TimeTouple getTime(HierarchicalMark mark) {
        int markId = MarkingEngine.getDefault().getMarkId((Mark)mark);
        if (markId == -1) {
            this.netTimeMap.put(mark, TimeTouple.ZERO);
            this.timeMap.put(mark, TimeTouple.ZERO);
            return TimeTouple.ZERO;
        }
        long tmpTime0 = this.client.getTimeCollector().getNetTime0((Mark)mark);
        long tmpTime1 = this.client.getTimeCollector().getNetTime1((Mark)mark);
        long netTime0 = tmpTime0;
        long netTime1 = tmpTime1;
        Iterator iter = mark.getChildren().iterator();
        while (iter.hasNext()) {
            TimeTouple subtime = this.getTime((HierarchicalMark)iter.next());
            tmpTime0 += subtime.time0;
            tmpTime1 += subtime.time1;
        }
        TimeTouple netTime = new TimeTouple(netTime0, netTime1);
        TimeTouple accTime = new TimeTouple(tmpTime0, tmpTime1);
        this.netTimeMap.put(mark, netTime);
        this.timeMap.put(mark, accTime);
        return accTime;
    }

    private void clearTimeMaps() {
        this.netTimeMap.clear();
        this.timeMap.clear();
    }

    private void fireDataChange() {
        HashSet tmpListeners = new HashSet(this.listeners);
        Iterator iter = tmpListeners.iterator();
        while (iter.hasNext()) {
            ((DrillDownListener)iter.next()).dataChanged();
        }
    }

    private void fireDrillDownChange() {
        HashSet tmpListeners = new HashSet(this.listeners);
        Iterator iter = tmpListeners.iterator();
        while (iter.hasNext()) {
            ((DrillDownListener)iter.next()).drillDownPathChanged(this.getDrillDownPath());
        }
    }

    private static class TimeTouple {
        public static final TimeTouple ZERO = new TimeTouple(0L, 0L);
        final long time0;
        final long time1;

        public TimeTouple(long time0, long time1) {
            this.time0 = time0;
            this.time1 = time1;
        }
    }
}

