/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.openide.util.NbBundle;

public class ObjectNode
extends InstanceNode {
    private static final String LOOP_TO_STRING = NbBundle.getMessage(ObjectNode.class, (String)"ObjectNode_LoopToString");

    public ObjectNode(Instance instance, String name, HeapWalkerNode parent) {
        super(instance, name, parent);
    }

    public ObjectNode(Instance instance, String name, HeapWalkerNode parent, int mode) {
        super(instance, name, parent, mode);
    }

    public boolean isArray() {
        return false;
    }

    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] children;
                block7: {
                    ArrayList fieldValues;
                    block6: {
                        children = null;
                        fieldValues = new ArrayList();
                        if (ObjectNode.this.getMode() != 1) break block6;
                        fieldValues.addAll(ObjectNode.this.getInstance().getFieldValues());
                        fieldValues.addAll(ObjectNode.this.getInstance().getStaticFieldValues());
                        if (fieldValues.size() == 0) {
                            children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoFieldsNode(ObjectNode.this)};
                        } else {
                            children = new HeapWalkerNode[fieldValues.size()];
                            for (int i = 0; i < children.length; ++i) {
                                children[i] = HeapWalkerNodeFactory.createFieldNode((FieldValue)fieldValues.get(i), ObjectNode.this);
                            }
                        }
                        break block7;
                    }
                    if (ObjectNode.this.getMode() != 2) break block7;
                    fieldValues.addAll(ObjectNode.this.getInstance().getReferences());
                    if (fieldValues.size() == 0) {
                        children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(ObjectNode.this)};
                    } else {
                        children = new HeapWalkerNode[fieldValues.size()];
                        for (int i = 0; i < children.length; ++i) {
                            children[i] = HeapWalkerNodeFactory.createReferenceNode((Value)fieldValues.get(i), ObjectNode.this);
                        }
                    }
                }
                return children;
            }
        };
    }

    protected Icon computeIcon() {
        ImageIcon icon = BrowserUtils.ICON_INSTANCE;
        if (this.getMode() == 2 && this.getInstance().isGCRoot()) {
            icon = BrowserUtils.createGCRootIcon(icon);
        }
        return this.processLoopIcon(icon);
    }

    protected String computeName() {
        GCRoot gcRoot;
        HeapWalkerNode root;
        if (this.getMode() == 2 && this.getInstance().isGCRoot() && (root = BrowserUtils.getRoot(this)) instanceof org.netbeans.modules.profiler.heapwalk.model.RootNode && (gcRoot = ((org.netbeans.modules.profiler.heapwalk.model.RootNode)((Object)root)).getGCRoot(this.getInstance())) != null) {
            return super.computeName() + " (" + gcRoot.getKind() + ")";
        }
        return super.computeName();
    }

    public static abstract class RootNode
    extends ObjectNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(Instance instance, String name, HeapWalkerNode parent) {
            super(instance, name, parent);
        }

        public RootNode(Instance instance, String name, HeapWalkerNode parent, int mode) {
            super(instance, name, parent, mode);
        }

        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private String ownerArrayType;
        private int itemIndex;

        public ArrayItem(int itemIndex, Instance instance, HeapWalkerNode parent) {
            this(itemIndex, instance, parent, parent == null ? 1 : parent.getMode());
        }

        public ArrayItem(int itemIndex, Instance instance, HeapWalkerNode parent, int mode) {
            super(instance, null, parent, mode);
            this.itemIndex = itemIndex;
            this.ownerArrayType = parent.getType();
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        protected String computeName() {
            GCRoot gcRoot;
            HeapWalkerNode root;
            String name = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                name = name + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            if (this.getMode() == 2 && this.getInstance().isGCRoot() && (root = BrowserUtils.getRoot(this)) instanceof RootNode && (gcRoot = ((RootNode)root).getGCRoot(this.getInstance())) != null) {
                name = name + " (" + gcRoot.getKind() + ")";
            }
            return name;
        }

        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.ownerArrayType) + ">";
            }
            return super.computeType();
        }
    }
}

