/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import javax.swing.Icon;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;

public abstract class AbstractHeapWalkerNode
implements HeapWalkerNode {
    private HeapWalkerNode parent;
    private Icon icon;
    private String name;
    private String type;
    private String value;
    private HeapWalkerNode[] children;
    private int mode = 1;

    public AbstractHeapWalkerNode(HeapWalkerNode parent) {
        this(parent, parent == null ? 1 : parent.getMode());
    }

    public AbstractHeapWalkerNode(HeapWalkerNode parent, int mode) {
        this.parent = parent;
        this.mode = mode;
    }

    public HeapWalkerNode getChild(int i) {
        return this.getChildren()[i];
    }

    public HeapWalkerNode[] getChildren() {
        if (this.children == null) {
            this.children = this.computeChildren();
        }
        return this.children;
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.computeIcon();
        }
        return this.icon;
    }

    public int getIndexOfChild(Object object) {
        for (int i = 0; i < this.getChildren().length; ++i) {
            if (this.getChildren()[i] != object) continue;
            return i;
        }
        return -1;
    }

    public boolean isLeaf() {
        return this.getNChildren() == 0;
    }

    public int getMode() {
        return this.mode;
    }

    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.getChildren().length;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.computeName();
        }
        return this.name;
    }

    public HeapWalkerNode getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public String getSimpleType() {
        return BrowserUtils.getSimpleType(this.getType());
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.computeType();
        }
        return this.type;
    }

    public String getValue() {
        if (this.value == null) {
            this.value = this.computeValue();
        }
        return this.value;
    }

    public boolean currentlyHasChildren() {
        return this.children != null;
    }

    public String toString() {
        return this.getName();
    }

    protected abstract Icon computeIcon();

    protected abstract String computeName();

    protected abstract String computeType();

    protected abstract String computeValue();

    protected void setChildren(HeapWalkerNode[] children) {
        this.changeChildren(children);
    }

    protected HeapWalkerNode[] computeChildren() {
        return new HeapWalkerNode[0];
    }

    void changeChildren(HeapWalkerNode[] children) {
        this.children = children;
    }
}

