/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Array
extends Oop {
    private static long headerSize;
    private static CIntField length;

    Array(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    private static void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("arrayOopDesc");
        length = new CIntField(type.getCIntegerField("_length"), 0L);
        headerSize = type.getSize();
    }

    public long getLength() {
        return length.getValue(this);
    }

    public long getObjectSize() {
        ArrayKlass klass = (ArrayKlass)this.getKlass();
        long s = this.getLength() << klass.getLog2ElementSize();
        s += klass.getArrayHeaderInBytes();
        s = Oop.alignObjectSize(s);
        return s;
    }

    public static long baseOffsetInBytes(BasicType type) {
        if (Universe.elementTypeShouldBeAligned(type)) {
            return VM.getVM().isLP64() ? Array.alignObjectSize(headerSize) : VM.getVM().alignUp(headerSize, 8L);
        }
        return headerSize;
    }

    public boolean isArray() {
        return true;
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doCInt(length, true);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                Array.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

