/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.Color;
import org.netbeans.lib.profiler.ui.charts.AbstractSynchronousXYChartModel;

public class DynamicSynchronousXYChartModel
extends AbstractSynchronousXYChartModel {
    protected long[] maxYValues;
    protected long[] minYValues;
    protected Color[] seriesColors;
    protected String[] seriesNames;
    protected long[] xValues;
    protected long[][] yValues;
    protected int itemCount = 0;
    protected int seriesCount = 0;
    protected long maxXValue = 0L;
    protected long minXValue = 0L;
    private int arrayBufferSize = 100;
    private int currentArraySize;

    public void setArrayBufferSize(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
        this.checkArraySize();
    }

    public int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public long getMaxDisplayYValue(int seriesIndex) {
        return this.getMaxYValue(seriesIndex);
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int seriesIndex) {
        return this.maxYValues[seriesIndex];
    }

    public long getMinDisplayYValue(int seriesIndex) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int seriesIndex) {
        return this.minYValues[seriesIndex];
    }

    public Color getSeriesColor(int seriesIndex) {
        return this.seriesColors[seriesIndex];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int seriesIndex) {
        return this.seriesNames[seriesIndex];
    }

    public long getXValue(int itemIndex) {
        return this.xValues[itemIndex];
    }

    public long getYValue(int itemIndex, int seriesIndex) {
        return this.yValues[itemIndex][seriesIndex];
    }

    public void addItemValues(long xValue, long[] yValues) {
        this.checkArraySize();
        if (this.itemCount == 0) {
            this.minXValue = xValue;
            this.maxXValue = xValue;
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = yValues[i];
                this.maxYValues[i] = yValues[i];
            }
        } else {
            if (this.xValues[this.itemCount - 1] >= xValue) {
                throw new RuntimeException("New x-value not greater than previous x-value.");
            }
            this.maxXValue = xValue;
            for (int i = 0; i < this.seriesCount; ++i) {
                this.minYValues[i] = Math.min(this.minYValues[i], yValues[i]);
                this.maxYValues[i] = Math.max(this.maxYValues[i], yValues[i]);
            }
        }
        this.xValues[this.itemCount] = xValue;
        this.yValues[this.itemCount] = yValues;
        ++this.itemCount;
        this.fireChartDataChanged();
    }

    public void setupModel(String[] seriesNames, Color[] seriesColors) {
        this.seriesNames = seriesNames;
        this.seriesColors = seriesColors;
        if (seriesNames.length != seriesColors.length) {
            this.seriesCount = 0;
            throw new RuntimeException("Counts of series names and series colors don't match.");
        }
        this.seriesCount = seriesNames.length;
        this.itemCount = 0;
        this.currentArraySize = this.arrayBufferSize;
        this.xValues = new long[this.arrayBufferSize];
        this.yValues = new long[this.arrayBufferSize][];
        this.minXValue = 0L;
        this.maxXValue = 0L;
        this.minYValues = new long[this.seriesCount];
        this.maxYValues = new long[this.seriesCount];
    }

    private void checkArraySize() {
        if (this.currentArraySize == this.itemCount) {
            this.xValues = DynamicSynchronousXYChartModel.extendArray(this.xValues, this.arrayBufferSize);
            this.yValues = DynamicSynchronousXYChartModel.extendArray(this.yValues, this.arrayBufferSize);
            this.minYValues = DynamicSynchronousXYChartModel.extendArray(this.minYValues, this.arrayBufferSize);
            this.maxYValues = DynamicSynchronousXYChartModel.extendArray(this.maxYValues, this.arrayBufferSize);
            this.currentArraySize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }

    private static long[][] extendArray(long[][] array, int extraLength) {
        int originalLength = array.length;
        long[][] newArray = new long[originalLength + extraLength][];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

